"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProxyReporter = void 0;
class ProxyReporter {
    constructor(real) {
        this.real = real;
    }
    start() {
        this.real().start();
    }
    end(wrong) {
        this.real().end(wrong);
    }
    get verbosity() {
        return this.real().verbosity;
    }
    targetStart(name) {
        this.real().targetStart(name);
    }
    targetSkip(name) {
        this.real().targetSkip(name);
    }
    targetEnd(name) {
        this.real().targetEnd(name);
    }
    targetHalt(name) {
        this.real().targetHalt(name);
    }
    targetUnHalt(name) {
        this.real().targetUnHalt(name);
    }
    systemError(e) {
        this.real().systemError(e);
    }
    targetError(name, e) {
        this.real().targetError(name, e);
    }
    redirectStdout(line) {
        this.real().redirectStdout(line);
    }
    redirectStderr(line) {
        this.real().redirectStderr(line);
    }
    actions(lines, style) {
        this.real().actions(lines, style);
    }
    debug(...line) {
        this.real().debug(...line);
    }
    info(...line) {
        this.real().info(...line);
    }
    echo(...line) {
        this.real().echo(...line);
    }
    warn(...line) {
        this.real().warn(...line);
    }
    note(...line) {
        this.real().note(...line);
    }
    success(...line) {
        this.real().success(...line);
    }
    fail(...line) {
        this.real().fail(...line);
    }
    error(...line) {
        this.real().error(...line);
    }
    fatal(...line) {
        this.real().fatal(...line);
    }
}
exports.ProxyReporter = ProxyReporter;
