"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SimpleArray = SimpleArray;
exports.ExtCountArray = ExtCountArray;
function SimpleArray(n, r) {
    return {
        read: (view, ...ar) => {
            const conditionCount = view.next(n);
            return view.array(conditionCount, r, ...ar);
        },
        write: (frag, t, ...aw) => {
            frag.push(n, t.length);
            frag.array(r, t, ...aw);
        }
    };
}
function ExtCountArray(r) {
    return {
        read: (view, n, ...ar) => {
            return view.array(n, r, ...ar);
        },
        write: (frag, t, n, ...aw) => {
            frag.arrayN(r, n, t, ...aw);
        }
    };
}
//# sourceMappingURL=simple-array.js.map