import { WriteTimeIVD } from "@ot-builder/var-store";
import { OtVar } from "@ot-builder/variance";
import { CffWriteContext } from "../../context/write";
import { Mir } from "./mir";
export declare class CffDrawCallRawT<X> {
    readonly args: readonly X[];
    readonly operator: number;
    readonly flags?: number[] | undefined;
    constructor(args: readonly X[], operator: number, flags?: number[] | undefined);
}
export declare class CffBlendPrimitive {
    readonly ivd: WriteTimeIVD;
    readonly origin: number;
    readonly deltas: number[];
    constructor(ivd: WriteTimeIVD, origin: number, deltas: number[]);
    isZero(): boolean;
}
export declare class CffDrawCallRaw extends CffDrawCallRawT<OtVar.Value> {
}
export declare class CffDrawCall extends CffDrawCallRawT<number | CffBlendPrimitive> {
    readonly ivd: WriteTimeIVD | null;
    stackRidge: number;
    stackRise: number;
    constructor(ivd: WriteTimeIVD | null, args: readonly (number | CffBlendPrimitive)[], operator: number, flags?: number[]);
    get masterCount(): number;
    private static seqFromRawSeqImpl;
    private static intermediateSeqFromRawSeqImpl;
    private static convertCallArgs;
    static charStringSeqFromRawSeq(ctx: CffWriteContext, from: CffDrawCallRawT<OtVar.Value>[]): CffDrawCall[];
    static dictStringSeqFromRawSeq(ctx: CffWriteContext, from: CffDrawCallRawT<OtVar.Value>[]): CffDrawCall[];
    private toMirImpl;
    static charStringSeqToMir(ctx: CffWriteContext, dcSeq: Iterable<CffDrawCall>): Mir[];
    static dictSeqToMir(ctx: CffWriteContext, dcSeq: Iterable<CffDrawCall>): Mir[];
}
//# sourceMappingURL=draw-call.d.ts.map