"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WriteBlob = exports.ReadBlob = void 0;
const bin_util_1 = require("@ot-builder/bin-util");
exports.ReadBlob = (0, bin_util_1.Read)(view => {
    const nEntries = view.uint32();
    const map = new Map();
    for (let id = 0; id < nEntries; id++) {
        const nameSize = view.uint32();
        const dataSize = view.uint32();
        const pNameStr = view.ptr32().bytes(nameSize).toString("utf-8");
        const pData = view.ptr32().bytes(dataSize);
        map.set(pNameStr, pData);
    }
    return map;
});
exports.WriteBlob = (0, bin_util_1.Write)((fr, blob) => {
    fr.uint32(blob.size);
    for (const [name, data] of blob) {
        const bName = Buffer.from(name, "utf-8");
        const frName = new bin_util_1.Frag().bytes(bName);
        const frData = new bin_util_1.Frag().bytes(data);
        fr.uint32(bName.byteLength) // nameSize
            .uint32(data.byteLength) // dataSize
            .ptr32(frName) // nameStr
            .ptr32(frData); // data
    }
});
//# sourceMappingURL=blob.js.map