"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.writeHMetrics = writeHMetrics;
exports.writeVMetrics = writeVMetrics;
const bin_util_1 = require("@ot-builder/bin-util");
const ImpLib = require("@ot-builder/common-impl");
const io_bin_metric_1 = require("@ot-builder/io-bin-metric");
const ot_glyphs_1 = require("@ot-builder/ot-glyphs");
function writeHMetrics(sink, writeMetricVariance, hhea, statHmtx, gOrd, designSpace) {
    if (!hhea || !statHmtx)
        return;
    sink.add(ot_glyphs_1.MetricBasic.TagHmtx, bin_util_1.Frag.pack(bin_util_1.Frag.from(io_bin_metric_1.MetricBasicIo, statHmtx.hmtx, hhea, gOrd)));
    if (designSpace && writeMetricVariance && statHmtx.hvar) {
        const hvarEmpty = new ImpLib.State(true);
        const buf = bin_util_1.Frag.packFrom(io_bin_metric_1.MetricVarianceIo, statHmtx.hvar, designSpace, hvarEmpty);
        if (!hvarEmpty.get())
            sink.add(ot_glyphs_1.MetricVariance.TagHvar, buf);
    }
}
function writeVMetrics(sink, writeMetricVariance, vhea, statVmtx, gOrd, designSpace) {
    if (!vhea || !statVmtx)
        return;
    sink.add(ot_glyphs_1.MetricBasic.TagVmtx, bin_util_1.Frag.pack(bin_util_1.Frag.from(io_bin_metric_1.MetricBasicIo, statVmtx.vmtx, vhea, gOrd)));
    sink.add(ot_glyphs_1.Vorg.Tag, bin_util_1.Frag.pack(bin_util_1.Frag.from(io_bin_metric_1.VorgIo, statVmtx.vorg)));
    if (designSpace && writeMetricVariance && statVmtx.vvar) {
        const vvarEmpty = new ImpLib.State(true);
        const buf = bin_util_1.Frag.packFrom(io_bin_metric_1.MetricVarianceIo, statVmtx.vvar, designSpace, vvarEmpty);
        if (!vvarEmpty.get())
            sink.add(ot_glyphs_1.MetricVariance.TagVvar, buf);
    }
}
//# sourceMappingURL=write.js.map