"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LigGlyph = void 0;
const bin_util_1 = require("@ot-builder/bin-util");
const lig_caret_value_1 = require("./lig-caret-value");
exports.LigGlyph = {
    ...(0, bin_util_1.Read)((view, ivs) => {
        const caretCount = view.uint16();
        const carets = view.array(caretCount, { ...(0, bin_util_1.Read)((view, ivs) => view.ptr16().next(lig_caret_value_1.CaretValue)) }, ivs);
        return carets;
    }),
    ...(0, bin_util_1.Write)((frag, carets, ivs) => {
        frag.uint16(carets.length);
        for (const caret of carets) {
            frag.ptr16New().push(lig_caret_value_1.CaretValue, caret, ivs);
        }
    })
};
//# sourceMappingURL=lig-glyph.js.map