"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.VorgIo = void 0;
const bin_util_1 = require("@ot-builder/bin-util");
const errors_1 = require("@ot-builder/errors");
const ot_glyphs_1 = require("@ot-builder/ot-glyphs");
exports.VorgIo = {
    ...(0, bin_util_1.Read)(view => {
        const vorg = new ot_glyphs_1.Vorg.Table();
        const majorVersion = view.uint16();
        const minorVersion = view.uint16();
        errors_1.Assert.SubVersionSupported("VORG", majorVersion, minorVersion, [1, 0]);
        vorg.defaultVertOriginY = view.int16();
        const numVertOriginYMetrics = view.uint16();
        for (const [p] of view.repeat(numVertOriginYMetrics)) {
            const gid = p.uint16();
            const y = p.int16();
            vorg.vertOriginYMetrics[gid] = y;
        }
        return vorg;
    }),
    ...(0, bin_util_1.Write)((frag, vorg) => {
        frag.uint16(1).uint16(0);
        frag.int16(vorg.defaultVertOriginY);
        // collect entries and write
        const entries = [];
        for (let gid = 0; gid < vorg.vertOriginYMetrics.length; gid++) {
            const entry = vorg.vertOriginYMetrics[gid];
            if (entry != null)
                entries.push([gid, entry]);
        }
        frag.uint16(entries.length);
        for (const [gid, y] of entries)
            frag.uint16(gid).int16(y);
    })
};
//# sourceMappingURL=vorg.js.map