import { Data } from "@ot-builder/prelude";
export interface DicingStore<X, Y, D> {
    get(x: X, y: Y): Data.Maybe<D>;
    getByClass(cx: number, cy: number): Data.Maybe<D>;
    getXClassDef(): X[][];
    getYClassDef(): Y[][];
    entries(): IterableIterator<[X, Y, Data.Maybe<D>]>;
    set(x: Iterable<X>, y: Iterable<Y>, v: D): void;
    setIfAbsent(x: Iterable<X>, y: Iterable<Y>, v: D): void;
    update(mdfX: Iterable<X>, mdfY: Iterable<Y>, fn: (original: Data.Maybe<D>) => Data.Maybe<D>): void;
    toRep(): DicingStoreRep<X, Y, D>;
}
export declare namespace DicingStore {
    function create<X, Y, D>(rep?: Data.Maybe<DicingStoreRep<X, Y, D>>): DicingStore<X, Y, D>;
}
export interface DicingStoreRep<X, Y, D> {
    xClasses: X[][];
    yClasses: Y[][];
    data: Data.Maybe<D>[][];
}
export declare class DicingStoreImpl<X, Y, D> implements DicingStore<X, Y, D> {
    private clsDefX;
    private coClsDefX;
    private clsDefY;
    private coClsDefY;
    private dataMatrix;
    static FromRep<X, Y, D>(rep?: Data.Maybe<DicingStoreRep<X, Y, D>>): DicingStoreImpl<X, Y, D>;
    toRep(): DicingStoreRep<X, Y, D>;
    private getData;
    private putData;
    private diceOneDimension;
    update(mdfX: Iterable<X>, mdfY: Iterable<Y>, fn: (original: Data.Maybe<D>) => Data.Maybe<D>): void;
    get(x: X, y: Y): Data.Maybe<D>;
    getByClass(cx: number, cy: number): Data.Maybe<D>;
    private getClassDefImpl;
    getXClassDef(): X[][];
    getYClassDef(): Y[][];
    entries(): IterableIterator<[X, Y, Data.Maybe<D>]>;
    set(x: Iterable<X>, y: Iterable<Y>, v: D): void;
    setIfAbsent(x: Iterable<X>, y: Iterable<Y>, v: D): void;
}
//# sourceMappingURL=index.d.ts.map