import { OtGlyph } from "@ot-builder/ot-glyphs";
import { CaseType, Data } from "@ot-builder/prelude";
import * as Primitive from "@ot-builder/primitive";
import { OtVar } from "@ot-builder/variance";
import * as LayoutCommon from "../common";
import * as GeneralLookup from "./general/lookup";
import { Gpos as LookupType } from "./general/lookup-type";
import * as GsubGpos from "./table-shared";
export * as FeatureParams from "./feature-params";
export { Gpos as LookupType } from "./general/lookup-type";
export declare const Tag = "GPOS";
export declare class Table implements GsubGpos.TableT<Lookup> {
    scripts: Map<Primitive.Tag, Script>;
    features: Feature[];
    lookups: Lookup[];
    featureVariations: Data.Maybe<FeatureVariation[]>;
    constructor(scripts?: Map<Primitive.Tag, Script>, features?: Feature[], lookups?: Lookup[], featureVariations?: Data.Maybe<FeatureVariation[]>);
}
export type Feature = GsubGpos.FeatureT<Lookup>;
export type Language = GsubGpos.LanguageT<Lookup>;
export type Script = GsubGpos.ScriptT<Lookup>;
export type AxisRangeCondition = GsubGpos.AxisRangeCondition;
export type FeatureVariationCondition = GsubGpos.AxisRangeCondition;
export type FeatureVariation = GsubGpos.FeatureVariationT<Lookup>;
export type SingleProp = GeneralLookup.GposSinglePropT<OtGlyph, OtVar.Value>;
export type Single = CaseType<typeof LookupType.Single, SingleProp>;
export declare const Single: import("@ot-builder/prelude").CaseClassType<typeof LookupType.Single, SingleProp, [props?: SingleProp | undefined]>;
export type PairProp = GeneralLookup.GposPairPropT<OtGlyph, OtVar.Value>;
export type Pair = CaseType<typeof LookupType.Pair, PairProp>;
export declare const Pair: import("@ot-builder/prelude").CaseClassType<typeof LookupType.Pair, PairProp, [props?: PairProp | undefined]>;
export type CursiveProp = GeneralLookup.GposCursivePropT<OtGlyph, OtVar.Value>;
export type Cursive = CaseType<typeof LookupType.Cursive, CursiveProp>;
export declare const Cursive: import("@ot-builder/prelude").CaseClassType<typeof LookupType.Cursive, CursiveProp, [props?: CursiveProp | undefined]>;
export type MarkToBaseProp = GeneralLookup.GposMarkToBasePropT<OtGlyph, OtVar.Value>;
export type MarkToBase = CaseType<typeof LookupType.MarkToBase, MarkToBaseProp>;
export declare const MarkToBase: import("@ot-builder/prelude").CaseClassType<typeof LookupType.MarkToBase, MarkToBaseProp, [props?: MarkToBaseProp | undefined]>;
export type MarkToLigatureProp = GeneralLookup.GposMarkToLigaturePropT<OtGlyph, OtVar.Value>;
export type MarkToLigature = CaseType<typeof LookupType.MarkToLigature, MarkToLigatureProp>;
export declare const MarkToLigature: import("@ot-builder/prelude").CaseClassType<typeof LookupType.MarkToLigature, MarkToLigatureProp, [props?: MarkToLigatureProp | undefined]>;
export type MarkToMarkProp = GeneralLookup.GposMarkToMarkPropT<OtGlyph, OtVar.Value>;
export type MarkToMark = CaseType<typeof LookupType.MarkToMark, MarkToMarkProp>;
export declare const MarkToMark: import("@ot-builder/prelude").CaseClassType<typeof LookupType.MarkToMark, MarkToMarkProp, [props?: MarkToMarkProp | undefined]>;
export type ChainingProp = GeneralLookup.ForwardChainingPropT<OtGlyph, OtVar.Value, Lookup>;
export type Chaining = CaseType<typeof LookupType.Chaining, ChainingProp>;
export declare const Chaining: import("@ot-builder/prelude").CaseClassType<typeof LookupType.Chaining, ChainingProp, [props?: ChainingProp | undefined]>;
export type Lookup = Single | Pair | Cursive | MarkToBase | MarkToMark | MarkToLigature | Chaining;
export type Coverage = LayoutCommon.Coverage.T<OtGlyph>;
export type ClassDef = LayoutCommon.ClassDef.T<OtGlyph>;
export type Adjustment = LayoutCommon.Adjust.T<OtVar.Value>;
export type AdjustmentPair = LayoutCommon.Adjust.PairT<OtVar.Value>;
export type Anchor = LayoutCommon.Anchor.T<OtVar.Value>;
export type CursiveAnchorPair = LayoutCommon.CursiveAnchorPair.T<OtVar.Value>;
export type MarkRecord = GeneralLookup.GposMarkRecordT<OtVar.Value>;
export type BaseRecord = GeneralLookup.GposBaseRecordT<OtVar.Value>;
export type LigatureBaseRecord = GeneralLookup.GposLigatureBaseRecordT<OtVar.Value>;
export type ChainingApplication<E> = GsubGpos.ChainingApplication<E>;
export type ChainingRule<E> = GsubGpos.ChainingRule<E>;
export type ChainingClassRule = GsubGpos.ChainingClassRule<Lookup>;
export declare const ZeroAdjustment: Adjustment;
export declare const ZeroAdjustmentPair: AdjustmentPair;
//# sourceMappingURL=table-gpos.d.ts.map