"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CaseCreator = CaseCreator;
exports.FallbackPropCreator = FallbackPropCreator;
function CaseCreator(typeTag, fn) {
    const CtorImpl = CaseCtorImpl(typeTag, fn);
    return Object.assign(CtorImpl, { Type: typeTag });
}
function CaseCtorImpl(typeTag, fn) {
    return function (...args) {
        initialize(this, typeTag, fn(...args));
    };
}
function initialize(obj, tag, props) {
    obj.type = tag;
    Object.assign(obj, props);
}
function FallbackPropCreator(fn) {
    return (props) => props || fn();
}
//# sourceMappingURL=index.js.map