import { BinaryView, Frag, Ranged, Read, Sized, Write } from "@ot-builder/bin-util";
export declare class Fixed implements Sized, Read<number, []>, Write<number, []>, Ranged {
    private readonly signed;
    private readonly shiftBits;
    private readonly exponent;
    private readonly mask;
    readonly size: number;
    readonly min: number;
    readonly max: number;
    constructor(signed: boolean, integerBits: number, fractionBits: number);
    private clearMostSigBit;
    private fromUInt;
    private toUInt;
    from(x: number): number;
    read(bp: BinaryView): number;
    write(bb: Frag, n: number): void;
}
export type UInt8 = number;
export type UInt16 = number;
export type UInt24 = number;
export type UInt32 = number;
export type Int8 = number;
export type Int16 = number;
export type Int24 = number;
export type Int32 = number;
export declare const UInt8: Fixed;
export declare const UInt16: Fixed;
export declare const UInt24: Fixed;
export declare const UInt32: Fixed;
export declare const Int8: Fixed;
export declare const Int16: Fixed;
export declare const Int24: Fixed;
export declare const Int32: Fixed;
export declare const UIntN: Fixed[];
export declare const IntN: Fixed[];
export type GID = UInt16;
export type F16D16 = number;
export type F24D6 = number;
export type F2D14 = number;
export declare const F16D16: Fixed;
export declare const F24D6: Fixed;
export declare const F2D14: Fixed;
//# sourceMappingURL=fixed.d.ts.map