import { MetricBasic, MetricVariance, OtGlyph, Vorg } from "@ot-builder/ot-glyphs";
import { Fvar, MetricHead } from "@ot-builder/ot-metadata";
import { Data } from "@ot-builder/prelude";
import { OtVar } from "@ot-builder/variance";
export declare class VmtxStat implements OtGlyph.Stat.Sink {
    private vhea;
    private readonly outer?;
    vmtx: MetricBasic.Table;
    vvar: Data.Maybe<MetricVariance.Table>;
    vorg: Vorg.Table;
    minTopSideBearing: number;
    minBottomSideBearing: number;
    yMaxExtent: number;
    yMaxAdvance: number;
    constructor(vhea: MetricHead.Table, fvar?: Data.Maybe<Fvar.Table>, outer?: Data.Maybe<OtGlyph.Stat.Sink>);
    setNumGlyphs(count: number): void;
    setMetric(gid: number, horizontal: OtGlyph.Metric, vertical: OtGlyph.Metric, extent: OtGlyph.Stat.BoundingBox): void;
    simpleGlyphStat(st: OtGlyph.Stat.SimpleGlyphStat): void;
    complexGlyphStat(st: OtGlyph.Stat.ComplexGlyphStat): void;
    instructionsStat(size: number): void;
    private statVorgFreq;
    settle(): void;
}
export declare class VmtxCoStat implements OtGlyph.CoStat.Source {
    private vmtx;
    private vvar?;
    private vorg?;
    private outer?;
    constructor(vmtx: MetricBasic.Table, vvar?: Data.Maybe<MetricVariance.Table>, vorg?: Data.Maybe<Vorg.Table>, outer?: Data.Maybe<OtGlyph.CoStat.Source>);
    getHMetric(gid: number, extent: Data.Maybe<OtGlyph.Stat.BoundingBox>): Data.Maybe<import("@ot-builder/ot-glyphs/lib/general-glyph/metric").T<OtVar.Value>>;
    getVMetric(gid: number, extent: Data.Maybe<OtGlyph.Stat.BoundingBox>): {
        start: OtVar.Value;
        end: OtVar.Value;
    };
}
//# sourceMappingURL=vmtx.d.ts.map