"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getOverlaps = void 0;
const fn_1 = require("../../fn");
const point_1 = require("../../point/point");
function getSquaredLineLength(v) {
    var x = v.d.x - v.a.x, y = v.d.y - v.a.y;
    return x * x + y * y;
}
function getOverlaps(v1, v2) {
    let straight1 = v1.isStraight(), straight2 = v2.isStraight(), straightBoth = straight1 && straight2;
    const flip = getSquaredLineLength(v1) < getSquaredLineLength(v2);
    const l1 = flip ? v2 : v1, l2 = flip ? v1 : v2;
    if (point_1.Point2.pointLineDist(l1.a, l1.d, l2.a) < fn_1.GEOMETRIC_EPSILON &&
        point_1.Point2.pointLineDist(l1.a, l1.d, l2.d) < fn_1.GEOMETRIC_EPSILON) {
        if (!straightBoth &&
            point_1.Point2.pointLineDist(l1.a, l1.d, l1.b) < fn_1.GEOMETRIC_EPSILON &&
            point_1.Point2.pointLineDist(l1.a, l1.d, l1.c) < fn_1.GEOMETRIC_EPSILON &&
            point_1.Point2.pointLineDist(l1.a, l1.d, l2.b) < fn_1.GEOMETRIC_EPSILON &&
            point_1.Point2.pointLineDist(l1.a, l1.d, l2.c) < fn_1.GEOMETRIC_EPSILON) {
            straight1 = straight2 = straightBoth = true;
        }
    }
    else if (straightBoth) {
        return null;
    }
    if (straight1 !== straight2) {
        return null;
    }
    let v = [v1, v2], pairs = [];
    for (var i = 0; i < 4 && pairs.length < 2; i++) {
        const i1 = i & 1, i2 = i1 ^ 1, t1 = i >> 1, t2 = v[i1].getTOf(point_1.Point2.from(t1 ? v[i2].d : v[i2].a));
        if (t2 != null) {
            const pair = i1 ? [t1, t2] : [t2, t1];
            if (!pairs.length ||
                (Math.abs(pair[0] - pairs[0][0]) > fn_1.CURVE_TIME_EPSILON &&
                    Math.abs(pair[1] - pairs[0][1]) > fn_1.CURVE_TIME_EPSILON)) {
                pairs.push(pair);
            }
        }
        if (i > 2 && !pairs.length)
            break;
    }
    if (pairs.length !== 2) {
        pairs = null;
    }
    else if (!straightBoth) {
        var o1 = v1.sliceRatio(pairs[0][0], pairs[1][0]), o2 = v2.sliceRatio(pairs[0][1], pairs[1][1]);
        if (Math.abs(o2.b.x - o1.b.x) > fn_1.GEOMETRIC_EPSILON ||
            Math.abs(o2.b.y - o1.b.y) > fn_1.GEOMETRIC_EPSILON ||
            Math.abs(o2.c.x - o1.c.x) > fn_1.GEOMETRIC_EPSILON ||
            Math.abs(o2.c.y - o1.c.y) > fn_1.GEOMETRIC_EPSILON)
            pairs = null;
    }
    return pairs;
}
exports.getOverlaps = getOverlaps;
