"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.hashFile = hashFile;
exports.hashSmallFile = hashSmallFile;
const tslib_1 = require("tslib");
const crypto = tslib_1.__importStar(require("crypto"));
const fs = tslib_1.__importStar(require("fs-extra"));
const path = tslib_1.__importStar(require("path"));
const piscina_1 = tslib_1.__importDefault(require("piscina"));
const threadHasherPool = new piscina_1.default({ filename: path.resolve(__dirname, "worker.js") });
async function hashFile(path) {
    return await threadHasherPool.run(path);
}
async function hashSmallFile(path) {
    return new Promise((resolve, reject) => {
        let sum = crypto.createHash("sha1");
        let fileStream = fs.createReadStream(path);
        fileStream.on("error", function (err) {
            return reject(err);
        });
        fileStream.on("data", function (chunk) {
            try {
                sum.update(chunk);
            }
            catch (ex) {
                return reject(ex);
            }
        });
        fileStream.on("end", function () {
            return resolve(sum.digest("hex"));
        });
    });
}
