"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RedirectReporter = void 0;
const tslib_1 = require("tslib");
const Util = tslib_1.__importStar(require("util"));
const console_styles_1 = require("./console-styles");
class RedirectReporter {
    constructor(verbosity) {
        this.verbosity = verbosity;
    }
    start() { }
    end(wrong) { }
    targetStart(id) {
        this.info("Target Start", id);
    }
    targetSkip(id) {
        this.info("Target Skipped", id);
    }
    targetEnd(id) {
        this.info("Target Finished", id);
    }
    targetHalt(id) { }
    targetUnHalt(id) { }
    systemError(e) {
        this.error("System Error", e);
    }
    targetError(name, e) {
        this.error("Target Error", e);
    }
    redirectStdout(line) {
        process.stdout.write(line);
    }
    redirectStderr(line) {
        process.stderr.write(line);
    }
    static unescapeActionTerm(x) {
        if (x instanceof console_styles_1.HighlightedRun)
            return String(x.text);
        else
            return Util.inspect(x);
    }
    actions(lines, style) {
        if (this.verbosity < 6)
            return;
        for (const line of lines) {
            console.log("[ACTION]", ...line.map(RedirectReporter.unescapeActionTerm));
        }
    }
    debug(...line) {
        if (this.verbosity < 8)
            return;
        console.log("[DEBUG]", ...line);
    }
    info(...line) {
        if (this.verbosity < 7)
            return;
        console.log("[INFO]", ...line);
    }
    echo(...line) {
        if (this.verbosity < 5)
            return;
        console.log("[ECHO]", ...line);
    }
    note(...line) {
        if (this.verbosity < 5)
            return;
        console.log("[NOTE]", ...line);
    }
    warn(...line) {
        if (this.verbosity < 4)
            return;
        console.log("[WARNING]", ...line);
    }
    success(...line) {
        if (this.verbosity < 3)
            return;
        console.log("[SUCCESS]", ...line);
    }
    fail(...line) {
        if (this.verbosity < 3)
            return;
        console.log("[FAIL]", ...line);
    }
    error(...line) {
        if (this.verbosity < 2)
            return;
        console.log("[ERROR]", ...line);
    }
    fatal(...line) {
        if (this.verbosity < 1)
            return;
        console.log("[FATAL]", ...line);
    }
}
exports.RedirectReporter = RedirectReporter;
