# README

The `count-deps` executable is used in the test-suite to detect when
the number of dependencies of certain modules change ([this blog
post](https://blog.shaynefletcher.org/2020/10/ghc-lib-parser-module-count.html)
gives one example of where and why this can be useful).

More generally it's useful for obtaining insight into a modules'
dependency graph. As used in the tests it produces (1) a count of a
modules' dependencies together with the list of depended upon modules
. However, it can also (2), print a modules' dependency graph in dot
language syntax suitable for rendering with "graphviz" (open source
graph visualization software).

## Installing graphviz

To render graphs generated by `count-deps`, first visit [the graphviz
downloads page](https://graphviz.org/download/) to download and
install graphviz on your system.

## `count-deps` usage examples:

  - `make`:

    1. ``inplace/bin/count-deps `inplace/bin/ghc-stage2 --print-libdir` "GHC.Parser"``
    2. ``inplace/bin/count-deps `inplace/bin/ghc-stage2 --print-libdir` "GHC.Parser" --dot``

  - `hadrian`:

    1. ``_build/stage1/bin/count-deps `_build/stage1/bin/ghc --print-libdir` "GHC.Parser"``
    2. ``_build/stage1/bin/count-deps `_build/stage1/bin/ghc --print-libdir` "GHC.Parser" --dot``

## Rendering dependency graphs

To render a graph obtained using a type 2 command:

  - Copy the output to a file ('`deps.dot`' say)
  - Render it with a command like (preprocess with `tred` to remove
    edges implied by transitivity)

    ```bash
    tred deps.dot > deps-tred.dot&& dot -Tpdf -o deps.pdf deps-tred.dot
    ```
