// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package identitytoolkit

import (
	"bytes"
	"context"
	"fmt"
	"io"
	"math"
	"net/http"
	"net/url"
	"time"

	identitytoolkitpb "cloud.google.com/go/identitytoolkit/apiv2/identitytoolkitpb"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/googleapi"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	httptransport "google.golang.org/api/transport/http"
	"google.golang.org/grpc"
	"google.golang.org/protobuf/encoding/protojson"
)

var newAuthenticationClientHook clientHook

// AuthenticationCallOptions contains the retry settings for each method of AuthenticationClient.
type AuthenticationCallOptions struct {
	FinalizeMfaSignIn []gax.CallOption
	StartMfaSignIn    []gax.CallOption
}

func defaultAuthenticationGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("identitytoolkit.googleapis.com:443"),
		internaloption.WithDefaultEndpointTemplate("identitytoolkit.UNIVERSE_DOMAIN:443"),
		internaloption.WithDefaultMTLSEndpoint("identitytoolkit.mtls.googleapis.com:443"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://identitytoolkit.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultAuthenticationCallOptions() *AuthenticationCallOptions {
	return &AuthenticationCallOptions{
		FinalizeMfaSignIn: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		StartMfaSignIn: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
	}
}

func defaultAuthenticationRESTCallOptions() *AuthenticationCallOptions {
	return &AuthenticationCallOptions{
		FinalizeMfaSignIn: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		StartMfaSignIn: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
	}
}

// internalAuthenticationClient is an interface that defines the methods available from Identity Toolkit API.
type internalAuthenticationClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	FinalizeMfaSignIn(context.Context, *identitytoolkitpb.FinalizeMfaSignInRequest, ...gax.CallOption) (*identitytoolkitpb.FinalizeMfaSignInResponse, error)
	StartMfaSignIn(context.Context, *identitytoolkitpb.StartMfaSignInRequest, ...gax.CallOption) (*identitytoolkitpb.StartMfaSignInResponse, error)
}

// AuthenticationClient is a client for interacting with Identity Toolkit API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// Authentication for Identity Toolkit
type AuthenticationClient struct {
	// The internal transport-dependent client.
	internalClient internalAuthenticationClient

	// The call options for this service.
	CallOptions *AuthenticationCallOptions
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *AuthenticationClient) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *AuthenticationClient) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *AuthenticationClient) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// FinalizeMfaSignIn verifies the MFA challenge and performs sign-in
func (c *AuthenticationClient) FinalizeMfaSignIn(ctx context.Context, req *identitytoolkitpb.FinalizeMfaSignInRequest, opts ...gax.CallOption) (*identitytoolkitpb.FinalizeMfaSignInResponse, error) {
	return c.internalClient.FinalizeMfaSignIn(ctx, req, opts...)
}

// StartMfaSignIn sends the MFA challenge
func (c *AuthenticationClient) StartMfaSignIn(ctx context.Context, req *identitytoolkitpb.StartMfaSignInRequest, opts ...gax.CallOption) (*identitytoolkitpb.StartMfaSignInResponse, error) {
	return c.internalClient.StartMfaSignIn(ctx, req, opts...)
}

// authenticationGRPCClient is a client for interacting with Identity Toolkit API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type authenticationGRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// Points back to the CallOptions field of the containing AuthenticationClient
	CallOptions **AuthenticationCallOptions

	// The gRPC API client.
	authenticationClient identitytoolkitpb.AuthenticationServiceClient

	// The x-goog-* metadata to be sent with each request.
	xGoogHeaders []string
}

// NewAuthenticationClient creates a new authentication service client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// Authentication for Identity Toolkit
func NewAuthenticationClient(ctx context.Context, opts ...option.ClientOption) (*AuthenticationClient, error) {
	clientOpts := defaultAuthenticationGRPCClientOptions()
	if newAuthenticationClientHook != nil {
		hookOpts, err := newAuthenticationClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := AuthenticationClient{CallOptions: defaultAuthenticationCallOptions()}

	c := &authenticationGRPCClient{
		connPool:             connPool,
		authenticationClient: identitytoolkitpb.NewAuthenticationServiceClient(connPool),
		CallOptions:          &client.CallOptions,
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *authenticationGRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *authenticationGRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *authenticationGRPCClient) Close() error {
	return c.connPool.Close()
}

// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type authenticationRESTClient struct {
	// The http endpoint to connect to.
	endpoint string

	// The http client.
	httpClient *http.Client

	// The x-goog-* headers to be sent with each request.
	xGoogHeaders []string

	// Points back to the CallOptions field of the containing AuthenticationClient
	CallOptions **AuthenticationCallOptions
}

// NewAuthenticationRESTClient creates a new authentication service rest client.
//
// Authentication for Identity Toolkit
func NewAuthenticationRESTClient(ctx context.Context, opts ...option.ClientOption) (*AuthenticationClient, error) {
	clientOpts := append(defaultAuthenticationRESTClientOptions(), opts...)
	httpClient, endpoint, err := httptransport.NewClient(ctx, clientOpts...)
	if err != nil {
		return nil, err
	}

	callOpts := defaultAuthenticationRESTCallOptions()
	c := &authenticationRESTClient{
		endpoint:    endpoint,
		httpClient:  httpClient,
		CallOptions: &callOpts,
	}
	c.setGoogleClientInfo()

	return &AuthenticationClient{internalClient: c, CallOptions: callOpts}, nil
}

func defaultAuthenticationRESTClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("https://identitytoolkit.googleapis.com"),
		internaloption.WithDefaultEndpointTemplate("https://identitytoolkit.UNIVERSE_DOMAIN"),
		internaloption.WithDefaultMTLSEndpoint("https://identitytoolkit.mtls.googleapis.com"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://identitytoolkit.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
	}
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *authenticationRESTClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "rest", "UNKNOWN")
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *authenticationRESTClient) Close() error {
	// Replace httpClient with nil to force cleanup.
	c.httpClient = nil
	return nil
}

// Connection returns a connection to the API service.
//
// Deprecated: This method always returns nil.
func (c *authenticationRESTClient) Connection() *grpc.ClientConn {
	return nil
}
func (c *authenticationGRPCClient) FinalizeMfaSignIn(ctx context.Context, req *identitytoolkitpb.FinalizeMfaSignInRequest, opts ...gax.CallOption) (*identitytoolkitpb.FinalizeMfaSignInResponse, error) {
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, c.xGoogHeaders...)
	opts = append((*c.CallOptions).FinalizeMfaSignIn[0:len((*c.CallOptions).FinalizeMfaSignIn):len((*c.CallOptions).FinalizeMfaSignIn)], opts...)
	var resp *identitytoolkitpb.FinalizeMfaSignInResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.authenticationClient.FinalizeMfaSignIn(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *authenticationGRPCClient) StartMfaSignIn(ctx context.Context, req *identitytoolkitpb.StartMfaSignInRequest, opts ...gax.CallOption) (*identitytoolkitpb.StartMfaSignInResponse, error) {
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, c.xGoogHeaders...)
	opts = append((*c.CallOptions).StartMfaSignIn[0:len((*c.CallOptions).StartMfaSignIn):len((*c.CallOptions).StartMfaSignIn)], opts...)
	var resp *identitytoolkitpb.StartMfaSignInResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.authenticationClient.StartMfaSignIn(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

// FinalizeMfaSignIn verifies the MFA challenge and performs sign-in
func (c *authenticationRESTClient) FinalizeMfaSignIn(ctx context.Context, req *identitytoolkitpb.FinalizeMfaSignInRequest, opts ...gax.CallOption) (*identitytoolkitpb.FinalizeMfaSignInResponse, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v2/accounts/mfaSignIn:finalize")

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := append(c.xGoogHeaders, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).FinalizeMfaSignIn[0:len((*c.CallOptions).FinalizeMfaSignIn):len((*c.CallOptions).FinalizeMfaSignIn)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &identitytoolkitpb.FinalizeMfaSignInResponse{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// StartMfaSignIn sends the MFA challenge
func (c *authenticationRESTClient) StartMfaSignIn(ctx context.Context, req *identitytoolkitpb.StartMfaSignInRequest, opts ...gax.CallOption) (*identitytoolkitpb.StartMfaSignInResponse, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v2/accounts/mfaSignIn:start")

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := append(c.xGoogHeaders, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).StartMfaSignIn[0:len((*c.CallOptions).StartMfaSignIn):len((*c.CallOptions).StartMfaSignIn)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &identitytoolkitpb.StartMfaSignInResponse{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}
