; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple=arm -mattr=+vfp4d16sp,-fullfp16 -stop-after=finalize-isel | FileCheck %s --check-prefixes=CHECK-CVT
; RUN: llc < %s -mtriple=arm -mattr=+vfp4d16sp,+fullfp16 -stop-after=finalize-isel | FileCheck %s --check-prefixes=CHECK-FP16

; Check that the output instructions have the same fast math flags as the input
; fadd, even when f16 is legalized to f32.
; FIXME: We don't get fast math flags on VCVTBSH because the outermost node in
; the isel pattern is COPY_TO_REGCLASS and the fast math flags end up there.

define half @normal_fadd(half %x, half %y) {
  ; CHECK-CVT-LABEL: name: normal_fadd
  ; CHECK-CVT: bb.0.entry:
  ; CHECK-CVT-NEXT:   liveins: $r0, $r1
  ; CHECK-CVT-NEXT: {{  $}}
  ; CHECK-CVT-NEXT:   [[COPY:%[0-9]+]]:gpr = COPY $r1
  ; CHECK-CVT-NEXT:   [[COPY1:%[0-9]+]]:gpr = COPY $r0
  ; CHECK-CVT-NEXT:   [[COPY2:%[0-9]+]]:spr = COPY [[COPY1]]
  ; CHECK-CVT-NEXT:   [[COPY3:%[0-9]+]]:spr = COPY [[COPY]]
  ; CHECK-CVT-NEXT:   [[VCVTBHS:%[0-9]+]]:spr = nofpexcept VCVTBHS killed [[COPY3]], 14 /* CC::al */, $noreg, implicit $fpscr
  ; CHECK-CVT-NEXT:   [[VCVTBHS1:%[0-9]+]]:spr = nofpexcept VCVTBHS killed [[COPY2]], 14 /* CC::al */, $noreg, implicit $fpscr
  ; CHECK-CVT-NEXT:   [[VADDS:%[0-9]+]]:spr = nofpexcept VADDS killed [[VCVTBHS1]], killed [[VCVTBHS]], 14 /* CC::al */, $noreg, implicit $fpscr
  ; CHECK-CVT-NEXT:   [[DEF:%[0-9]+]]:spr = IMPLICIT_DEF
  ; CHECK-CVT-NEXT:   [[VCVTBSH:%[0-9]+]]:spr = nofpexcept VCVTBSH [[DEF]], killed [[VADDS]], 14 /* CC::al */, $noreg, implicit $fpscr
  ; CHECK-CVT-NEXT:   [[COPY4:%[0-9]+]]:gpr = COPY killed [[VCVTBSH]]
  ; CHECK-CVT-NEXT:   $r0 = COPY [[COPY4]]
  ; CHECK-CVT-NEXT:   MOVPCLR 14 /* CC::al */, $noreg, implicit $r0
  ;
  ; CHECK-FP16-LABEL: name: normal_fadd
  ; CHECK-FP16: bb.0.entry:
  ; CHECK-FP16-NEXT:   liveins: $r0, $r1
  ; CHECK-FP16-NEXT: {{  $}}
  ; CHECK-FP16-NEXT:   [[COPY:%[0-9]+]]:rgpr = COPY $r1
  ; CHECK-FP16-NEXT:   [[COPY1:%[0-9]+]]:rgpr = COPY $r0
  ; CHECK-FP16-NEXT:   [[VMOVHR:%[0-9]+]]:hpr = VMOVHR [[COPY]], 14, $noreg
  ; CHECK-FP16-NEXT:   [[VMOVHR1:%[0-9]+]]:hpr = VMOVHR [[COPY1]], 14, $noreg
  ; CHECK-FP16-NEXT:   [[VADDH:%[0-9]+]]:hpr = nofpexcept VADDH killed [[VMOVHR1]], killed [[VMOVHR]], 14, $noreg, implicit $fpscr
  ; CHECK-FP16-NEXT:   $r0 = COPY [[VADDH]]
  ; CHECK-FP16-NEXT:   MOVPCLR 14 /* CC::al */, $noreg, implicit $r0
entry:
  %add = fadd half %x, %y
  ret half %add
}

define half @fast_fadd(half %x, half %y) {
  ; CHECK-CVT-LABEL: name: fast_fadd
  ; CHECK-CVT: bb.0.entry:
  ; CHECK-CVT-NEXT:   liveins: $r0, $r1
  ; CHECK-CVT-NEXT: {{  $}}
  ; CHECK-CVT-NEXT:   [[COPY:%[0-9]+]]:gpr = COPY $r1
  ; CHECK-CVT-NEXT:   [[COPY1:%[0-9]+]]:gpr = COPY $r0
  ; CHECK-CVT-NEXT:   [[COPY2:%[0-9]+]]:spr = COPY [[COPY1]]
  ; CHECK-CVT-NEXT:   [[COPY3:%[0-9]+]]:spr = COPY [[COPY]]
  ; CHECK-CVT-NEXT:   [[VCVTBHS:%[0-9]+]]:spr = nnan ninf nsz arcp contract afn reassoc nofpexcept VCVTBHS killed [[COPY3]], 14 /* CC::al */, $noreg, implicit $fpscr
  ; CHECK-CVT-NEXT:   [[VCVTBHS1:%[0-9]+]]:spr = nnan ninf nsz arcp contract afn reassoc nofpexcept VCVTBHS killed [[COPY2]], 14 /* CC::al */, $noreg, implicit $fpscr
  ; CHECK-CVT-NEXT:   [[VADDS:%[0-9]+]]:spr = nnan ninf nsz arcp contract afn reassoc nofpexcept VADDS killed [[VCVTBHS1]], killed [[VCVTBHS]], 14 /* CC::al */, $noreg, implicit $fpscr
  ; CHECK-CVT-NEXT:   [[DEF:%[0-9]+]]:spr = IMPLICIT_DEF
  ; CHECK-CVT-NEXT:   [[VCVTBSH:%[0-9]+]]:spr = nofpexcept VCVTBSH [[DEF]], killed [[VADDS]], 14 /* CC::al */, $noreg, implicit $fpscr
  ; CHECK-CVT-NEXT:   [[COPY4:%[0-9]+]]:gpr = COPY killed [[VCVTBSH]]
  ; CHECK-CVT-NEXT:   $r0 = COPY [[COPY4]]
  ; CHECK-CVT-NEXT:   MOVPCLR 14 /* CC::al */, $noreg, implicit $r0
  ;
  ; CHECK-FP16-LABEL: name: fast_fadd
  ; CHECK-FP16: bb.0.entry:
  ; CHECK-FP16-NEXT:   liveins: $r0, $r1
  ; CHECK-FP16-NEXT: {{  $}}
  ; CHECK-FP16-NEXT:   [[COPY:%[0-9]+]]:rgpr = COPY $r1
  ; CHECK-FP16-NEXT:   [[COPY1:%[0-9]+]]:rgpr = COPY $r0
  ; CHECK-FP16-NEXT:   [[VMOVHR:%[0-9]+]]:hpr = VMOVHR [[COPY]], 14, $noreg
  ; CHECK-FP16-NEXT:   [[VMOVHR1:%[0-9]+]]:hpr = VMOVHR [[COPY1]], 14, $noreg
  ; CHECK-FP16-NEXT:   [[VADDH:%[0-9]+]]:hpr = nnan ninf nsz arcp contract afn reassoc nofpexcept VADDH killed [[VMOVHR1]], killed [[VMOVHR]], 14, $noreg, implicit $fpscr
  ; CHECK-FP16-NEXT:   $r0 = COPY [[VADDH]]
  ; CHECK-FP16-NEXT:   MOVPCLR 14 /* CC::al */, $noreg, implicit $r0
entry:
  %add = fadd fast half %x, %y
  ret half %add
}

define half @ninf_fadd(half %x, half %y) {
  ; CHECK-CVT-LABEL: name: ninf_fadd
  ; CHECK-CVT: bb.0.entry:
  ; CHECK-CVT-NEXT:   liveins: $r0, $r1
  ; CHECK-CVT-NEXT: {{  $}}
  ; CHECK-CVT-NEXT:   [[COPY:%[0-9]+]]:gpr = COPY $r1
  ; CHECK-CVT-NEXT:   [[COPY1:%[0-9]+]]:gpr = COPY $r0
  ; CHECK-CVT-NEXT:   [[COPY2:%[0-9]+]]:spr = COPY [[COPY1]]
  ; CHECK-CVT-NEXT:   [[COPY3:%[0-9]+]]:spr = COPY [[COPY]]
  ; CHECK-CVT-NEXT:   [[VCVTBHS:%[0-9]+]]:spr = ninf nofpexcept VCVTBHS killed [[COPY3]], 14 /* CC::al */, $noreg, implicit $fpscr
  ; CHECK-CVT-NEXT:   [[VCVTBHS1:%[0-9]+]]:spr = ninf nofpexcept VCVTBHS killed [[COPY2]], 14 /* CC::al */, $noreg, implicit $fpscr
  ; CHECK-CVT-NEXT:   [[VADDS:%[0-9]+]]:spr = ninf nofpexcept VADDS killed [[VCVTBHS1]], killed [[VCVTBHS]], 14 /* CC::al */, $noreg, implicit $fpscr
  ; CHECK-CVT-NEXT:   [[DEF:%[0-9]+]]:spr = IMPLICIT_DEF
  ; CHECK-CVT-NEXT:   [[VCVTBSH:%[0-9]+]]:spr = nofpexcept VCVTBSH [[DEF]], killed [[VADDS]], 14 /* CC::al */, $noreg, implicit $fpscr
  ; CHECK-CVT-NEXT:   [[COPY4:%[0-9]+]]:gpr = COPY killed [[VCVTBSH]]
  ; CHECK-CVT-NEXT:   $r0 = COPY [[COPY4]]
  ; CHECK-CVT-NEXT:   MOVPCLR 14 /* CC::al */, $noreg, implicit $r0
  ;
  ; CHECK-FP16-LABEL: name: ninf_fadd
  ; CHECK-FP16: bb.0.entry:
  ; CHECK-FP16-NEXT:   liveins: $r0, $r1
  ; CHECK-FP16-NEXT: {{  $}}
  ; CHECK-FP16-NEXT:   [[COPY:%[0-9]+]]:rgpr = COPY $r1
  ; CHECK-FP16-NEXT:   [[COPY1:%[0-9]+]]:rgpr = COPY $r0
  ; CHECK-FP16-NEXT:   [[VMOVHR:%[0-9]+]]:hpr = VMOVHR [[COPY]], 14, $noreg
  ; CHECK-FP16-NEXT:   [[VMOVHR1:%[0-9]+]]:hpr = VMOVHR [[COPY1]], 14, $noreg
  ; CHECK-FP16-NEXT:   [[VADDH:%[0-9]+]]:hpr = ninf nofpexcept VADDH killed [[VMOVHR1]], killed [[VMOVHR]], 14, $noreg, implicit $fpscr
  ; CHECK-FP16-NEXT:   $r0 = COPY [[VADDH]]
  ; CHECK-FP16-NEXT:   MOVPCLR 14 /* CC::al */, $noreg, implicit $r0
entry:
  %add = fadd ninf half %x, %y
  ret half %add
}

; Check that when we have the right fast math flags the converts in between the
; two fadds are removed.

define half @normal_fadd_sequence(half %x, half %y, half %z) {
  ; CHECK-CVT-LABEL: name: normal_fadd_sequence
  ; CHECK-CVT: bb.0.entry:
  ; CHECK-CVT-NEXT:   liveins: $r0, $r1, $r2
  ; CHECK-CVT-NEXT: {{  $}}
  ; CHECK-CVT-NEXT:   [[COPY:%[0-9]+]]:gpr = COPY $r2
  ; CHECK-CVT-NEXT:   [[COPY1:%[0-9]+]]:gpr = COPY $r1
  ; CHECK-CVT-NEXT:   [[COPY2:%[0-9]+]]:gpr = COPY $r0
  ; CHECK-CVT-NEXT:   [[COPY3:%[0-9]+]]:spr = COPY [[COPY2]]
  ; CHECK-CVT-NEXT:   [[COPY4:%[0-9]+]]:spr = COPY [[COPY1]]
  ; CHECK-CVT-NEXT:   [[VCVTBHS:%[0-9]+]]:spr = nofpexcept VCVTBHS killed [[COPY4]], 14 /* CC::al */, $noreg, implicit $fpscr
  ; CHECK-CVT-NEXT:   [[VCVTBHS1:%[0-9]+]]:spr = nofpexcept VCVTBHS killed [[COPY3]], 14 /* CC::al */, $noreg, implicit $fpscr
  ; CHECK-CVT-NEXT:   [[VADDS:%[0-9]+]]:spr = nofpexcept VADDS killed [[VCVTBHS1]], killed [[VCVTBHS]], 14 /* CC::al */, $noreg, implicit $fpscr
  ; CHECK-CVT-NEXT:   [[COPY5:%[0-9]+]]:spr = COPY [[COPY]]
  ; CHECK-CVT-NEXT:   [[VCVTBHS2:%[0-9]+]]:spr = nofpexcept VCVTBHS killed [[COPY5]], 14 /* CC::al */, $noreg, implicit $fpscr
  ; CHECK-CVT-NEXT:   [[DEF:%[0-9]+]]:spr = IMPLICIT_DEF
  ; CHECK-CVT-NEXT:   [[VCVTBSH:%[0-9]+]]:spr = nofpexcept VCVTBSH [[DEF]], killed [[VADDS]], 14 /* CC::al */, $noreg, implicit $fpscr
  ; CHECK-CVT-NEXT:   [[COPY6:%[0-9]+]]:gpr = COPY killed [[VCVTBSH]]
  ; CHECK-CVT-NEXT:   [[COPY7:%[0-9]+]]:spr = COPY killed [[COPY6]]
  ; CHECK-CVT-NEXT:   [[VCVTBHS3:%[0-9]+]]:spr = nofpexcept VCVTBHS killed [[COPY7]], 14 /* CC::al */, $noreg, implicit $fpscr
  ; CHECK-CVT-NEXT:   [[VADDS1:%[0-9]+]]:spr = nofpexcept VADDS killed [[VCVTBHS3]], killed [[VCVTBHS2]], 14 /* CC::al */, $noreg, implicit $fpscr
  ; CHECK-CVT-NEXT:   [[DEF1:%[0-9]+]]:spr = IMPLICIT_DEF
  ; CHECK-CVT-NEXT:   [[VCVTBSH1:%[0-9]+]]:spr = nofpexcept VCVTBSH [[DEF1]], killed [[VADDS1]], 14 /* CC::al */, $noreg, implicit $fpscr
  ; CHECK-CVT-NEXT:   [[COPY8:%[0-9]+]]:gpr = COPY killed [[VCVTBSH1]]
  ; CHECK-CVT-NEXT:   $r0 = COPY [[COPY8]]
  ; CHECK-CVT-NEXT:   MOVPCLR 14 /* CC::al */, $noreg, implicit $r0
  ;
  ; CHECK-FP16-LABEL: name: normal_fadd_sequence
  ; CHECK-FP16: bb.0.entry:
  ; CHECK-FP16-NEXT:   liveins: $r0, $r1, $r2
  ; CHECK-FP16-NEXT: {{  $}}
  ; CHECK-FP16-NEXT:   [[COPY:%[0-9]+]]:rgpr = COPY $r2
  ; CHECK-FP16-NEXT:   [[COPY1:%[0-9]+]]:rgpr = COPY $r1
  ; CHECK-FP16-NEXT:   [[COPY2:%[0-9]+]]:rgpr = COPY $r0
  ; CHECK-FP16-NEXT:   [[VMOVHR:%[0-9]+]]:hpr = VMOVHR [[COPY1]], 14, $noreg
  ; CHECK-FP16-NEXT:   [[VMOVHR1:%[0-9]+]]:hpr = VMOVHR [[COPY2]], 14, $noreg
  ; CHECK-FP16-NEXT:   [[VADDH:%[0-9]+]]:hpr = nofpexcept VADDH killed [[VMOVHR1]], killed [[VMOVHR]], 14, $noreg, implicit $fpscr
  ; CHECK-FP16-NEXT:   [[VMOVHR2:%[0-9]+]]:hpr = VMOVHR [[COPY]], 14, $noreg
  ; CHECK-FP16-NEXT:   [[VADDH1:%[0-9]+]]:hpr = nofpexcept VADDH killed [[VADDH]], killed [[VMOVHR2]], 14, $noreg, implicit $fpscr
  ; CHECK-FP16-NEXT:   $r0 = COPY [[VADDH1]]
  ; CHECK-FP16-NEXT:   MOVPCLR 14 /* CC::al */, $noreg, implicit $r0
entry:
  %add1 = fadd half %x, %y
  %add2 = fadd half %add1, %z
  ret half %add2
}

define half @nnan_ninf_contract_fadd_sequence(half %x, half %y, half %z) {
  ; CHECK-CVT-LABEL: name: nnan_ninf_contract_fadd_sequence
  ; CHECK-CVT: bb.0.entry:
  ; CHECK-CVT-NEXT:   liveins: $r0, $r1, $r2
  ; CHECK-CVT-NEXT: {{  $}}
  ; CHECK-CVT-NEXT:   [[COPY:%[0-9]+]]:gpr = COPY $r2
  ; CHECK-CVT-NEXT:   [[COPY1:%[0-9]+]]:gpr = COPY $r1
  ; CHECK-CVT-NEXT:   [[COPY2:%[0-9]+]]:gpr = COPY $r0
  ; CHECK-CVT-NEXT:   [[COPY3:%[0-9]+]]:spr = COPY [[COPY2]]
  ; CHECK-CVT-NEXT:   [[COPY4:%[0-9]+]]:spr = COPY [[COPY1]]
  ; CHECK-CVT-NEXT:   [[VCVTBHS:%[0-9]+]]:spr = nnan ninf contract nofpexcept VCVTBHS killed [[COPY4]], 14 /* CC::al */, $noreg, implicit $fpscr
  ; CHECK-CVT-NEXT:   [[VCVTBHS1:%[0-9]+]]:spr = nnan ninf contract nofpexcept VCVTBHS killed [[COPY3]], 14 /* CC::al */, $noreg, implicit $fpscr
  ; CHECK-CVT-NEXT:   [[VADDS:%[0-9]+]]:spr = nnan ninf contract nofpexcept VADDS killed [[VCVTBHS1]], killed [[VCVTBHS]], 14 /* CC::al */, $noreg, implicit $fpscr
  ; CHECK-CVT-NEXT:   [[COPY5:%[0-9]+]]:spr = COPY [[COPY]]
  ; CHECK-CVT-NEXT:   [[VCVTBHS2:%[0-9]+]]:spr = nnan ninf contract nofpexcept VCVTBHS killed [[COPY5]], 14 /* CC::al */, $noreg, implicit $fpscr
  ; CHECK-CVT-NEXT:   [[VADDS1:%[0-9]+]]:spr = nnan ninf contract nofpexcept VADDS killed [[VADDS]], killed [[VCVTBHS2]], 14 /* CC::al */, $noreg, implicit $fpscr
  ; CHECK-CVT-NEXT:   [[DEF:%[0-9]+]]:spr = IMPLICIT_DEF
  ; CHECK-CVT-NEXT:   [[VCVTBSH:%[0-9]+]]:spr = nofpexcept VCVTBSH [[DEF]], killed [[VADDS1]], 14 /* CC::al */, $noreg, implicit $fpscr
  ; CHECK-CVT-NEXT:   [[COPY6:%[0-9]+]]:gpr = COPY killed [[VCVTBSH]]
  ; CHECK-CVT-NEXT:   $r0 = COPY [[COPY6]]
  ; CHECK-CVT-NEXT:   MOVPCLR 14 /* CC::al */, $noreg, implicit $r0
  ;
  ; CHECK-FP16-LABEL: name: nnan_ninf_contract_fadd_sequence
  ; CHECK-FP16: bb.0.entry:
  ; CHECK-FP16-NEXT:   liveins: $r0, $r1, $r2
  ; CHECK-FP16-NEXT: {{  $}}
  ; CHECK-FP16-NEXT:   [[COPY:%[0-9]+]]:rgpr = COPY $r2
  ; CHECK-FP16-NEXT:   [[COPY1:%[0-9]+]]:rgpr = COPY $r1
  ; CHECK-FP16-NEXT:   [[COPY2:%[0-9]+]]:rgpr = COPY $r0
  ; CHECK-FP16-NEXT:   [[VMOVHR:%[0-9]+]]:hpr = VMOVHR [[COPY1]], 14, $noreg
  ; CHECK-FP16-NEXT:   [[VMOVHR1:%[0-9]+]]:hpr = VMOVHR [[COPY2]], 14, $noreg
  ; CHECK-FP16-NEXT:   [[VADDH:%[0-9]+]]:hpr = nnan ninf contract nofpexcept VADDH killed [[VMOVHR1]], killed [[VMOVHR]], 14, $noreg, implicit $fpscr
  ; CHECK-FP16-NEXT:   [[VMOVHR2:%[0-9]+]]:hpr = VMOVHR [[COPY]], 14, $noreg
  ; CHECK-FP16-NEXT:   [[VADDH1:%[0-9]+]]:hpr = nnan ninf contract nofpexcept VADDH killed [[VADDH]], killed [[VMOVHR2]], 14, $noreg, implicit $fpscr
  ; CHECK-FP16-NEXT:   $r0 = COPY [[VADDH1]]
  ; CHECK-FP16-NEXT:   MOVPCLR 14 /* CC::al */, $noreg, implicit $r0
entry:
  %add1 = fadd nnan ninf contract half %x, %y
  %add2 = fadd nnan ninf contract half %add1, %z
  ret half %add2
}

define half @ninf_fadd_sequence(half %x, half %y, half %z) {
  ; CHECK-CVT-LABEL: name: ninf_fadd_sequence
  ; CHECK-CVT: bb.0.entry:
  ; CHECK-CVT-NEXT:   liveins: $r0, $r1, $r2
  ; CHECK-CVT-NEXT: {{  $}}
  ; CHECK-CVT-NEXT:   [[COPY:%[0-9]+]]:gpr = COPY $r2
  ; CHECK-CVT-NEXT:   [[COPY1:%[0-9]+]]:gpr = COPY $r1
  ; CHECK-CVT-NEXT:   [[COPY2:%[0-9]+]]:gpr = COPY $r0
  ; CHECK-CVT-NEXT:   [[COPY3:%[0-9]+]]:spr = COPY [[COPY2]]
  ; CHECK-CVT-NEXT:   [[COPY4:%[0-9]+]]:spr = COPY [[COPY1]]
  ; CHECK-CVT-NEXT:   [[VCVTBHS:%[0-9]+]]:spr = ninf nofpexcept VCVTBHS killed [[COPY4]], 14 /* CC::al */, $noreg, implicit $fpscr
  ; CHECK-CVT-NEXT:   [[VCVTBHS1:%[0-9]+]]:spr = ninf nofpexcept VCVTBHS killed [[COPY3]], 14 /* CC::al */, $noreg, implicit $fpscr
  ; CHECK-CVT-NEXT:   [[VADDS:%[0-9]+]]:spr = ninf nofpexcept VADDS killed [[VCVTBHS1]], killed [[VCVTBHS]], 14 /* CC::al */, $noreg, implicit $fpscr
  ; CHECK-CVT-NEXT:   [[COPY5:%[0-9]+]]:spr = COPY [[COPY]]
  ; CHECK-CVT-NEXT:   [[VCVTBHS2:%[0-9]+]]:spr = ninf nofpexcept VCVTBHS killed [[COPY5]], 14 /* CC::al */, $noreg, implicit $fpscr
  ; CHECK-CVT-NEXT:   [[DEF:%[0-9]+]]:spr = IMPLICIT_DEF
  ; CHECK-CVT-NEXT:   [[VCVTBSH:%[0-9]+]]:spr = nofpexcept VCVTBSH [[DEF]], killed [[VADDS]], 14 /* CC::al */, $noreg, implicit $fpscr
  ; CHECK-CVT-NEXT:   [[COPY6:%[0-9]+]]:gpr = COPY killed [[VCVTBSH]]
  ; CHECK-CVT-NEXT:   [[COPY7:%[0-9]+]]:spr = COPY killed [[COPY6]]
  ; CHECK-CVT-NEXT:   [[VCVTBHS3:%[0-9]+]]:spr = ninf nofpexcept VCVTBHS killed [[COPY7]], 14 /* CC::al */, $noreg, implicit $fpscr
  ; CHECK-CVT-NEXT:   [[VADDS1:%[0-9]+]]:spr = ninf nofpexcept VADDS killed [[VCVTBHS3]], killed [[VCVTBHS2]], 14 /* CC::al */, $noreg, implicit $fpscr
  ; CHECK-CVT-NEXT:   [[DEF1:%[0-9]+]]:spr = IMPLICIT_DEF
  ; CHECK-CVT-NEXT:   [[VCVTBSH1:%[0-9]+]]:spr = nofpexcept VCVTBSH [[DEF1]], killed [[VADDS1]], 14 /* CC::al */, $noreg, implicit $fpscr
  ; CHECK-CVT-NEXT:   [[COPY8:%[0-9]+]]:gpr = COPY killed [[VCVTBSH1]]
  ; CHECK-CVT-NEXT:   $r0 = COPY [[COPY8]]
  ; CHECK-CVT-NEXT:   MOVPCLR 14 /* CC::al */, $noreg, implicit $r0
  ;
  ; CHECK-FP16-LABEL: name: ninf_fadd_sequence
  ; CHECK-FP16: bb.0.entry:
  ; CHECK-FP16-NEXT:   liveins: $r0, $r1, $r2
  ; CHECK-FP16-NEXT: {{  $}}
  ; CHECK-FP16-NEXT:   [[COPY:%[0-9]+]]:rgpr = COPY $r2
  ; CHECK-FP16-NEXT:   [[COPY1:%[0-9]+]]:rgpr = COPY $r1
  ; CHECK-FP16-NEXT:   [[COPY2:%[0-9]+]]:rgpr = COPY $r0
  ; CHECK-FP16-NEXT:   [[VMOVHR:%[0-9]+]]:hpr = VMOVHR [[COPY1]], 14, $noreg
  ; CHECK-FP16-NEXT:   [[VMOVHR1:%[0-9]+]]:hpr = VMOVHR [[COPY2]], 14, $noreg
  ; CHECK-FP16-NEXT:   [[VADDH:%[0-9]+]]:hpr = ninf nofpexcept VADDH killed [[VMOVHR1]], killed [[VMOVHR]], 14, $noreg, implicit $fpscr
  ; CHECK-FP16-NEXT:   [[VMOVHR2:%[0-9]+]]:hpr = VMOVHR [[COPY]], 14, $noreg
  ; CHECK-FP16-NEXT:   [[VADDH1:%[0-9]+]]:hpr = ninf nofpexcept VADDH killed [[VADDH]], killed [[VMOVHR2]], 14, $noreg, implicit $fpscr
  ; CHECK-FP16-NEXT:   $r0 = COPY [[VADDH1]]
  ; CHECK-FP16-NEXT:   MOVPCLR 14 /* CC::al */, $noreg, implicit $r0
entry:
  %add1 = fadd ninf half %x, %y
  %add2 = fadd ninf half %add1, %z
  ret half %add2
}
