; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -mtriple=thumbv7-gnu-linux < %s | FileCheck -check-prefix=GNU %s
; RUN: llc -mtriple=armv7-linux-gnueabi -mcpu=cortex-a8 < %s | FileCheck -check-prefix=GNUEABI %s
; RUN: llc -mtriple=armv7-apple-ios6 -mcpu=cortex-a8 < %s | FileCheck -check-prefixes=IOS,IOS-NO-STRET %s
; RUN: llc -mtriple=armv7-apple-ios7 -mcpu=cortex-a8 < %s | FileCheck -check-prefixes=IOS,IOS-WITH-STRET %s
; RUN: llc -mtriple=thumbv7k-apple-watchos2.0 < %s | FileCheck -check-prefix=WATCHABI %s

define { half, half } @test_sincos_f16(half %a) {
; GNU-LABEL: test_sincos_f16:
; GNU:       @ %bb.0:
; GNU-NEXT:    push {r4, lr}
; GNU-NEXT:    sub sp, #8
; GNU-NEXT:    bl __gnu_h2f_ieee
; GNU-NEXT:    add r1, sp, #4
; GNU-NEXT:    mov r2, sp
; GNU-NEXT:    bl sincosf
; GNU-NEXT:    ldr r0, [sp, #4]
; GNU-NEXT:    bl __gnu_f2h_ieee
; GNU-NEXT:    mov r4, r0
; GNU-NEXT:    ldr r0, [sp]
; GNU-NEXT:    bl __gnu_f2h_ieee
; GNU-NEXT:    mov r1, r0
; GNU-NEXT:    mov r0, r4
; GNU-NEXT:    add sp, #8
; GNU-NEXT:    pop {r4, pc}
;
; GNUEABI-LABEL: test_sincos_f16:
; GNUEABI:       @ %bb.0:
; GNUEABI-NEXT:    .save {r4, lr}
; GNUEABI-NEXT:    push {r4, lr}
; GNUEABI-NEXT:    .pad #8
; GNUEABI-NEXT:    sub sp, sp, #8
; GNUEABI-NEXT:    bl __gnu_h2f_ieee
; GNUEABI-NEXT:    add r1, sp, #4
; GNUEABI-NEXT:    mov r2, sp
; GNUEABI-NEXT:    bl sincosf
; GNUEABI-NEXT:    ldr r0, [sp, #4]
; GNUEABI-NEXT:    bl __gnu_f2h_ieee
; GNUEABI-NEXT:    mov r4, r0
; GNUEABI-NEXT:    ldr r0, [sp]
; GNUEABI-NEXT:    bl __gnu_f2h_ieee
; GNUEABI-NEXT:    mov r1, r0
; GNUEABI-NEXT:    mov r0, r4
; GNUEABI-NEXT:    add sp, sp, #8
; GNUEABI-NEXT:    pop {r4, pc}
;
; IOS-NO-STRET-LABEL: test_sincos_f16:
; IOS-NO-STRET:       @ %bb.0:
; IOS-NO-STRET-NEXT:    push {r4, r5, lr}
; IOS-NO-STRET-NEXT:    bl ___extendhfsf2
; IOS-NO-STRET-NEXT:    mov r4, r0
; IOS-NO-STRET-NEXT:    bl _sinf
; IOS-NO-STRET-NEXT:    bl ___truncsfhf2
; IOS-NO-STRET-NEXT:    mov r5, r0
; IOS-NO-STRET-NEXT:    mov r0, r4
; IOS-NO-STRET-NEXT:    bl _cosf
; IOS-NO-STRET-NEXT:    bl ___truncsfhf2
; IOS-NO-STRET-NEXT:    mov r1, r0
; IOS-NO-STRET-NEXT:    mov r0, r5
; IOS-NO-STRET-NEXT:    pop {r4, r5, pc}
;
; IOS-WITH-STRET-LABEL: test_sincos_f16:
; IOS-WITH-STRET:       @ %bb.0:
; IOS-WITH-STRET-NEXT:    push {r4, r5, lr}
; IOS-WITH-STRET-NEXT:    sub sp, sp, #8
; IOS-WITH-STRET-NEXT:    bl ___extendhfsf2
; IOS-WITH-STRET-NEXT:    mov r1, r0
; IOS-WITH-STRET-NEXT:    mov r0, sp
; IOS-WITH-STRET-NEXT:    bl ___sincosf_stret
; IOS-WITH-STRET-NEXT:    ldm sp, {r0, r4}
; IOS-WITH-STRET-NEXT:    bl ___truncsfhf2
; IOS-WITH-STRET-NEXT:    mov r5, r0
; IOS-WITH-STRET-NEXT:    mov r0, r4
; IOS-WITH-STRET-NEXT:    bl ___truncsfhf2
; IOS-WITH-STRET-NEXT:    mov r1, r0
; IOS-WITH-STRET-NEXT:    mov r0, r5
; IOS-WITH-STRET-NEXT:    add sp, sp, #8
; IOS-WITH-STRET-NEXT:    pop {r4, r5, pc}
;
; WATCHABI-LABEL: test_sincos_f16:
; WATCHABI:         .cfi_startproc
; WATCHABI-NEXT:  @ %bb.0:
; WATCHABI-NEXT:    push {r7, lr}
; WATCHABI-NEXT:    .cfi_def_cfa_offset 8
; WATCHABI-NEXT:    .cfi_offset lr, -4
; WATCHABI-NEXT:    .cfi_offset r7, -8
; WATCHABI-NEXT:    sub sp, #8
; WATCHABI-NEXT:    .cfi_def_cfa_offset 16
; WATCHABI-NEXT:    vcvtb.f32.f16 s0, s0
; WATCHABI-NEXT:    bl ___sincosf_stret
; WATCHABI-NEXT:    vcvtb.f16.f32 s0, s0
; WATCHABI-NEXT:    vcvtb.f16.f32 s1, s1
; WATCHABI-NEXT:    add sp, #8
; WATCHABI-NEXT:    pop {r7, pc}
; WATCHABI-NEXT:    .cfi_endproc
  %result = call { half, half } @llvm.sincos.f16(half %a)
  ret { half, half } %result
}

define half @test_sincos_f16_only_use_sin(half %a) {
; GNU-LABEL: test_sincos_f16_only_use_sin:
; GNU:       @ %bb.0:
; GNU-NEXT:    push {r7, lr}
; GNU-NEXT:    sub sp, #8
; GNU-NEXT:    bl __gnu_h2f_ieee
; GNU-NEXT:    add r1, sp, #4
; GNU-NEXT:    mov r2, sp
; GNU-NEXT:    bl sincosf
; GNU-NEXT:    ldr r0, [sp, #4]
; GNU-NEXT:    bl __gnu_f2h_ieee
; GNU-NEXT:    add sp, #8
; GNU-NEXT:    pop {r7, pc}
;
; GNUEABI-LABEL: test_sincos_f16_only_use_sin:
; GNUEABI:       @ %bb.0:
; GNUEABI-NEXT:    .save {r11, lr}
; GNUEABI-NEXT:    push {r11, lr}
; GNUEABI-NEXT:    .pad #8
; GNUEABI-NEXT:    sub sp, sp, #8
; GNUEABI-NEXT:    bl __gnu_h2f_ieee
; GNUEABI-NEXT:    add r1, sp, #4
; GNUEABI-NEXT:    mov r2, sp
; GNUEABI-NEXT:    bl sincosf
; GNUEABI-NEXT:    ldr r0, [sp, #4]
; GNUEABI-NEXT:    bl __gnu_f2h_ieee
; GNUEABI-NEXT:    add sp, sp, #8
; GNUEABI-NEXT:    pop {r11, pc}
;
; IOS-NO-STRET-LABEL: test_sincos_f16_only_use_sin:
; IOS-NO-STRET:       @ %bb.0:
; IOS-NO-STRET-NEXT:    push {lr}
; IOS-NO-STRET-NEXT:    bl ___extendhfsf2
; IOS-NO-STRET-NEXT:    bl _sinf
; IOS-NO-STRET-NEXT:    bl ___truncsfhf2
; IOS-NO-STRET-NEXT:    pop {lr}
; IOS-NO-STRET-NEXT:    bx lr
;
; IOS-WITH-STRET-LABEL: test_sincos_f16_only_use_sin:
; IOS-WITH-STRET:       @ %bb.0:
; IOS-WITH-STRET-NEXT:    push {lr}
; IOS-WITH-STRET-NEXT:    sub sp, sp, #8
; IOS-WITH-STRET-NEXT:    bl ___extendhfsf2
; IOS-WITH-STRET-NEXT:    mov r1, r0
; IOS-WITH-STRET-NEXT:    mov r0, sp
; IOS-WITH-STRET-NEXT:    bl ___sincosf_stret
; IOS-WITH-STRET-NEXT:    ldr r0, [sp]
; IOS-WITH-STRET-NEXT:    bl ___truncsfhf2
; IOS-WITH-STRET-NEXT:    add sp, sp, #8
; IOS-WITH-STRET-NEXT:    pop {lr}
; IOS-WITH-STRET-NEXT:    bx lr
;
; WATCHABI-LABEL: test_sincos_f16_only_use_sin:
; WATCHABI:         .cfi_startproc
; WATCHABI-NEXT:  @ %bb.0:
; WATCHABI-NEXT:    push {r7, lr}
; WATCHABI-NEXT:    .cfi_def_cfa_offset 8
; WATCHABI-NEXT:    .cfi_offset lr, -4
; WATCHABI-NEXT:    .cfi_offset r7, -8
; WATCHABI-NEXT:    sub sp, #8
; WATCHABI-NEXT:    .cfi_def_cfa_offset 16
; WATCHABI-NEXT:    vcvtb.f32.f16 s0, s0
; WATCHABI-NEXT:    bl ___sincosf_stret
; WATCHABI-NEXT:    vcvtb.f16.f32 s0, s0
; WATCHABI-NEXT:    add sp, #8
; WATCHABI-NEXT:    pop {r7, pc}
; WATCHABI-NEXT:    .cfi_endproc
  %result = call { half, half } @llvm.sincos.f16(half %a)
  %result.0 = extractvalue { half, half } %result, 0
  ret half %result.0
}

define half @test_sincos_f16_only_use_cos(half %a) {
; GNU-LABEL: test_sincos_f16_only_use_cos:
; GNU:       @ %bb.0:
; GNU-NEXT:    push {r7, lr}
; GNU-NEXT:    sub sp, #8
; GNU-NEXT:    bl __gnu_h2f_ieee
; GNU-NEXT:    add r1, sp, #4
; GNU-NEXT:    mov r2, sp
; GNU-NEXT:    bl sincosf
; GNU-NEXT:    ldr r0, [sp]
; GNU-NEXT:    bl __gnu_f2h_ieee
; GNU-NEXT:    add sp, #8
; GNU-NEXT:    pop {r7, pc}
;
; GNUEABI-LABEL: test_sincos_f16_only_use_cos:
; GNUEABI:       @ %bb.0:
; GNUEABI-NEXT:    .save {r11, lr}
; GNUEABI-NEXT:    push {r11, lr}
; GNUEABI-NEXT:    .pad #8
; GNUEABI-NEXT:    sub sp, sp, #8
; GNUEABI-NEXT:    bl __gnu_h2f_ieee
; GNUEABI-NEXT:    add r1, sp, #4
; GNUEABI-NEXT:    mov r2, sp
; GNUEABI-NEXT:    bl sincosf
; GNUEABI-NEXT:    ldr r0, [sp]
; GNUEABI-NEXT:    bl __gnu_f2h_ieee
; GNUEABI-NEXT:    add sp, sp, #8
; GNUEABI-NEXT:    pop {r11, pc}
;
; IOS-NO-STRET-LABEL: test_sincos_f16_only_use_cos:
; IOS-NO-STRET:       @ %bb.0:
; IOS-NO-STRET-NEXT:    push {lr}
; IOS-NO-STRET-NEXT:    bl ___extendhfsf2
; IOS-NO-STRET-NEXT:    bl _cosf
; IOS-NO-STRET-NEXT:    bl ___truncsfhf2
; IOS-NO-STRET-NEXT:    pop {lr}
; IOS-NO-STRET-NEXT:    bx lr
;
; IOS-WITH-STRET-LABEL: test_sincos_f16_only_use_cos:
; IOS-WITH-STRET:       @ %bb.0:
; IOS-WITH-STRET-NEXT:    push {lr}
; IOS-WITH-STRET-NEXT:    sub sp, sp, #8
; IOS-WITH-STRET-NEXT:    bl ___extendhfsf2
; IOS-WITH-STRET-NEXT:    mov r1, r0
; IOS-WITH-STRET-NEXT:    mov r0, sp
; IOS-WITH-STRET-NEXT:    bl ___sincosf_stret
; IOS-WITH-STRET-NEXT:    ldr r0, [sp, #4]
; IOS-WITH-STRET-NEXT:    bl ___truncsfhf2
; IOS-WITH-STRET-NEXT:    add sp, sp, #8
; IOS-WITH-STRET-NEXT:    pop {lr}
; IOS-WITH-STRET-NEXT:    bx lr
;
; WATCHABI-LABEL: test_sincos_f16_only_use_cos:
; WATCHABI:         .cfi_startproc
; WATCHABI-NEXT:  @ %bb.0:
; WATCHABI-NEXT:    push {r7, lr}
; WATCHABI-NEXT:    .cfi_def_cfa_offset 8
; WATCHABI-NEXT:    .cfi_offset lr, -4
; WATCHABI-NEXT:    .cfi_offset r7, -8
; WATCHABI-NEXT:    sub sp, #8
; WATCHABI-NEXT:    .cfi_def_cfa_offset 16
; WATCHABI-NEXT:    vcvtb.f32.f16 s0, s0
; WATCHABI-NEXT:    bl ___sincosf_stret
; WATCHABI-NEXT:    vcvtb.f16.f32 s0, s1
; WATCHABI-NEXT:    add sp, #8
; WATCHABI-NEXT:    pop {r7, pc}
; WATCHABI-NEXT:    .cfi_endproc
  %result = call { half, half } @llvm.sincos.f16(half %a)
  %result.1 = extractvalue { half, half } %result, 1
  ret half %result.1
}

define { <2 x half>, <2 x half> } @test_sincos_v2f16(<2 x half> %a) {
; GNU-LABEL: test_sincos_v2f16:
; GNU:       @ %bb.0:
; GNU-NEXT:    push {r4, lr}
; GNU-NEXT:    vpush {d8}
; GNU-NEXT:    sub sp, #24
; GNU-NEXT:    mov r4, r0
; GNU-NEXT:    mov r0, r1
; GNU-NEXT:    bl __gnu_h2f_ieee
; GNU-NEXT:    add r1, sp, #12
; GNU-NEXT:    add r2, sp, #8
; GNU-NEXT:    bl sincosf
; GNU-NEXT:    mov r0, r4
; GNU-NEXT:    bl __gnu_h2f_ieee
; GNU-NEXT:    add r1, sp, #4
; GNU-NEXT:    mov r2, sp
; GNU-NEXT:    bl sincosf
; GNU-NEXT:    ldr r0, [sp, #12]
; GNU-NEXT:    bl __gnu_f2h_ieee
; GNU-NEXT:    ldr r1, [sp, #4]
; GNU-NEXT:    strh.w r0, [sp, #22]
; GNU-NEXT:    mov r0, r1
; GNU-NEXT:    bl __gnu_f2h_ieee
; GNU-NEXT:    strh.w r0, [sp, #20]
; GNU-NEXT:    add r0, sp, #20
; GNU-NEXT:    vld1.32 {d8[0]}, [r0:32]
; GNU-NEXT:    ldr r0, [sp, #8]
; GNU-NEXT:    bl __gnu_f2h_ieee
; GNU-NEXT:    ldr r1, [sp]
; GNU-NEXT:    strh.w r0, [sp, #18]
; GNU-NEXT:    mov r0, r1
; GNU-NEXT:    bl __gnu_f2h_ieee
; GNU-NEXT:    strh.w r0, [sp, #16]
; GNU-NEXT:    add r0, sp, #16
; GNU-NEXT:    vmovl.u16 q9, d8
; GNU-NEXT:    vld1.32 {d16[0]}, [r0:32]
; GNU-NEXT:    vmovl.u16 q8, d16
; GNU-NEXT:    vmov.32 r0, d18[0]
; GNU-NEXT:    vmov.32 r1, d18[1]
; GNU-NEXT:    vmov.32 r2, d16[0]
; GNU-NEXT:    vmov.32 r3, d16[1]
; GNU-NEXT:    add sp, #24
; GNU-NEXT:    vpop {d8}
; GNU-NEXT:    pop {r4, pc}
;
; GNUEABI-LABEL: test_sincos_v2f16:
; GNUEABI:       @ %bb.0:
; GNUEABI-NEXT:    .save {r4, lr}
; GNUEABI-NEXT:    push {r4, lr}
; GNUEABI-NEXT:    .vsave {d8}
; GNUEABI-NEXT:    vpush {d8}
; GNUEABI-NEXT:    .pad #24
; GNUEABI-NEXT:    sub sp, sp, #24
; GNUEABI-NEXT:    mov r4, r0
; GNUEABI-NEXT:    mov r0, r1
; GNUEABI-NEXT:    bl __gnu_h2f_ieee
; GNUEABI-NEXT:    add r1, sp, #12
; GNUEABI-NEXT:    add r2, sp, #8
; GNUEABI-NEXT:    bl sincosf
; GNUEABI-NEXT:    mov r0, r4
; GNUEABI-NEXT:    bl __gnu_h2f_ieee
; GNUEABI-NEXT:    add r1, sp, #4
; GNUEABI-NEXT:    mov r2, sp
; GNUEABI-NEXT:    bl sincosf
; GNUEABI-NEXT:    ldr r0, [sp, #12]
; GNUEABI-NEXT:    bl __gnu_f2h_ieee
; GNUEABI-NEXT:    ldr r1, [sp, #4]
; GNUEABI-NEXT:    strh r0, [sp, #22]
; GNUEABI-NEXT:    mov r0, r1
; GNUEABI-NEXT:    bl __gnu_f2h_ieee
; GNUEABI-NEXT:    strh r0, [sp, #20]
; GNUEABI-NEXT:    add r0, sp, #20
; GNUEABI-NEXT:    vld1.32 {d8[0]}, [r0:32]
; GNUEABI-NEXT:    ldr r0, [sp, #8]
; GNUEABI-NEXT:    bl __gnu_f2h_ieee
; GNUEABI-NEXT:    ldr r1, [sp]
; GNUEABI-NEXT:    strh r0, [sp, #18]
; GNUEABI-NEXT:    mov r0, r1
; GNUEABI-NEXT:    bl __gnu_f2h_ieee
; GNUEABI-NEXT:    strh r0, [sp, #16]
; GNUEABI-NEXT:    add r0, sp, #16
; GNUEABI-NEXT:    vmovl.u16 q9, d8
; GNUEABI-NEXT:    vld1.32 {d16[0]}, [r0:32]
; GNUEABI-NEXT:    vmovl.u16 q8, d16
; GNUEABI-NEXT:    vmov.32 r0, d18[0]
; GNUEABI-NEXT:    vmov.32 r1, d18[1]
; GNUEABI-NEXT:    vmov.32 r2, d16[0]
; GNUEABI-NEXT:    vmov.32 r3, d16[1]
; GNUEABI-NEXT:    add sp, sp, #24
; GNUEABI-NEXT:    vpop {d8}
; GNUEABI-NEXT:    pop {r4, pc}
;
; IOS-NO-STRET-LABEL: test_sincos_v2f16:
; IOS-NO-STRET:       @ %bb.0:
; IOS-NO-STRET-NEXT:    push {r4, r5, lr}
; IOS-NO-STRET-NEXT:    vpush {d8}
; IOS-NO-STRET-NEXT:    sub sp, sp, #8
; IOS-NO-STRET-NEXT:    mov r5, r0
; IOS-NO-STRET-NEXT:    mov r0, r1
; IOS-NO-STRET-NEXT:    bl ___extendhfsf2
; IOS-NO-STRET-NEXT:    mov r4, r0
; IOS-NO-STRET-NEXT:    bl _sinf
; IOS-NO-STRET-NEXT:    bl ___truncsfhf2
; IOS-NO-STRET-NEXT:    strh r0, [sp, #6]
; IOS-NO-STRET-NEXT:    mov r0, r5
; IOS-NO-STRET-NEXT:    bl ___extendhfsf2
; IOS-NO-STRET-NEXT:    mov r5, r0
; IOS-NO-STRET-NEXT:    bl _sinf
; IOS-NO-STRET-NEXT:    bl ___truncsfhf2
; IOS-NO-STRET-NEXT:    strh r0, [sp, #4]
; IOS-NO-STRET-NEXT:    add r0, sp, #4
; IOS-NO-STRET-NEXT:    vld1.32 {d8[0]}, [r0:32]
; IOS-NO-STRET-NEXT:    mov r0, r4
; IOS-NO-STRET-NEXT:    bl _cosf
; IOS-NO-STRET-NEXT:    bl ___truncsfhf2
; IOS-NO-STRET-NEXT:    strh r0, [sp, #2]
; IOS-NO-STRET-NEXT:    mov r0, r5
; IOS-NO-STRET-NEXT:    bl _cosf
; IOS-NO-STRET-NEXT:    bl ___truncsfhf2
; IOS-NO-STRET-NEXT:    strh r0, [sp]
; IOS-NO-STRET-NEXT:    mov r0, sp
; IOS-NO-STRET-NEXT:    vld1.32 {d16[0]}, [r0:32]
; IOS-NO-STRET-NEXT:    vmovl.u16 q9, d8
; IOS-NO-STRET-NEXT:    vmovl.u16 q8, d16
; IOS-NO-STRET-NEXT:    vmov.32 r0, d18[0]
; IOS-NO-STRET-NEXT:    vmov.32 r1, d18[1]
; IOS-NO-STRET-NEXT:    vmov.32 r2, d16[0]
; IOS-NO-STRET-NEXT:    vmov.32 r3, d16[1]
; IOS-NO-STRET-NEXT:    add sp, sp, #8
; IOS-NO-STRET-NEXT:    vpop {d8}
; IOS-NO-STRET-NEXT:    pop {r4, r5, pc}
;
; IOS-WITH-STRET-LABEL: test_sincos_v2f16:
; IOS-WITH-STRET:       @ %bb.0:
; IOS-WITH-STRET-NEXT:    push {r4, r5, lr}
; IOS-WITH-STRET-NEXT:    vpush {d8}
; IOS-WITH-STRET-NEXT:    sub sp, sp, #24
; IOS-WITH-STRET-NEXT:    mov r4, r0
; IOS-WITH-STRET-NEXT:    mov r0, r1
; IOS-WITH-STRET-NEXT:    bl ___extendhfsf2
; IOS-WITH-STRET-NEXT:    mov r1, r0
; IOS-WITH-STRET-NEXT:    add r0, sp, #8
; IOS-WITH-STRET-NEXT:    bl ___sincosf_stret
; IOS-WITH-STRET-NEXT:    mov r0, r4
; IOS-WITH-STRET-NEXT:    bl ___extendhfsf2
; IOS-WITH-STRET-NEXT:    mov r1, r0
; IOS-WITH-STRET-NEXT:    mov r0, sp
; IOS-WITH-STRET-NEXT:    bl ___sincosf_stret
; IOS-WITH-STRET-NEXT:    ldr r0, [sp, #8]
; IOS-WITH-STRET-NEXT:    ldr r4, [sp, #12]
; IOS-WITH-STRET-NEXT:    bl ___truncsfhf2
; IOS-WITH-STRET-NEXT:    ldm sp, {r1, r5}
; IOS-WITH-STRET-NEXT:    strh r0, [sp, #22]
; IOS-WITH-STRET-NEXT:    mov r0, r1
; IOS-WITH-STRET-NEXT:    bl ___truncsfhf2
; IOS-WITH-STRET-NEXT:    strh r0, [sp, #20]
; IOS-WITH-STRET-NEXT:    add r0, sp, #20
; IOS-WITH-STRET-NEXT:    vld1.32 {d8[0]}, [r0:32]
; IOS-WITH-STRET-NEXT:    mov r0, r4
; IOS-WITH-STRET-NEXT:    bl ___truncsfhf2
; IOS-WITH-STRET-NEXT:    strh r0, [sp, #18]
; IOS-WITH-STRET-NEXT:    mov r0, r5
; IOS-WITH-STRET-NEXT:    bl ___truncsfhf2
; IOS-WITH-STRET-NEXT:    strh r0, [sp, #16]
; IOS-WITH-STRET-NEXT:    add r0, sp, #16
; IOS-WITH-STRET-NEXT:    vmovl.u16 q9, d8
; IOS-WITH-STRET-NEXT:    vld1.32 {d16[0]}, [r0:32]
; IOS-WITH-STRET-NEXT:    vmovl.u16 q8, d16
; IOS-WITH-STRET-NEXT:    vmov.32 r0, d18[0]
; IOS-WITH-STRET-NEXT:    vmov.32 r1, d18[1]
; IOS-WITH-STRET-NEXT:    vmov.32 r2, d16[0]
; IOS-WITH-STRET-NEXT:    vmov.32 r3, d16[1]
; IOS-WITH-STRET-NEXT:    add sp, sp, #24
; IOS-WITH-STRET-NEXT:    vpop {d8}
; IOS-WITH-STRET-NEXT:    pop {r4, r5, pc}
;
; WATCHABI-LABEL: test_sincos_v2f16:
; WATCHABI:         .cfi_startproc
; WATCHABI-NEXT:  @ %bb.0:
; WATCHABI-NEXT:    push {r7, lr}
; WATCHABI-NEXT:    .cfi_def_cfa_offset 8
; WATCHABI-NEXT:    .cfi_offset lr, -4
; WATCHABI-NEXT:    .cfi_offset r7, -8
; WATCHABI-NEXT:    vpush {d10}
; WATCHABI-NEXT:    .cfi_def_cfa_offset 16
; WATCHABI-NEXT:    vpush {d8}
; WATCHABI-NEXT:    .cfi_def_cfa_offset 24
; WATCHABI-NEXT:    .cfi_offset d10, -16
; WATCHABI-NEXT:    .cfi_offset d8, -24
; WATCHABI-NEXT:    sub sp, #8
; WATCHABI-NEXT:    .cfi_def_cfa_offset 32
; WATCHABI-NEXT:    vmov.f32 s16, s0
; WATCHABI-NEXT:    vcvtb.f32.f16 s0, s1
; WATCHABI-NEXT:    bl ___sincosf_stret
; WATCHABI-NEXT:    vcvtb.f16.f32 s0, s0
; WATCHABI-NEXT:    vcvtb.f32.f16 s4, s16
; WATCHABI-NEXT:    vmov r0, s0
; WATCHABI-NEXT:    vmov.f32 s0, s4
; WATCHABI-NEXT:    vmov.f32 s20, s1
; WATCHABI-NEXT:    strh.w r0, [sp, #6]
; WATCHABI-NEXT:    bl ___sincosf_stret
; WATCHABI-NEXT:    vcvtb.f16.f32 s0, s0
; WATCHABI-NEXT:    vmov r0, s0
; WATCHABI-NEXT:    vcvtb.f16.f32 s0, s20
; WATCHABI-NEXT:    strh.w r0, [sp, #4]
; WATCHABI-NEXT:    add r0, sp, #4
; WATCHABI-NEXT:    vld1.32 {d16[0]}, [r0:32]
; WATCHABI-NEXT:    vmov r0, s0
; WATCHABI-NEXT:    vcvtb.f16.f32 s0, s1
; WATCHABI-NEXT:    strh.w r0, [sp, #2]
; WATCHABI-NEXT:    vmov r0, s0
; WATCHABI-NEXT:    vmovl.u16 q0, d16
; WATCHABI-NEXT:    strh.w r0, [sp]
; WATCHABI-NEXT:    mov r0, sp
; WATCHABI-NEXT:    vld1.32 {d18[0]}, [r0:32]
; WATCHABI-NEXT:    vmovl.u16 q1, d18
; WATCHABI-NEXT:    vmov.f32 s2, s4
; WATCHABI-NEXT:    vmov.f32 s3, s5
; WATCHABI-NEXT:    add sp, #8
; WATCHABI-NEXT:    vpop {d8}
; WATCHABI-NEXT:    vpop {d10}
; WATCHABI-NEXT:    pop {r7, pc}
; WATCHABI-NEXT:    .cfi_endproc
  %result = call { <2 x half>, <2 x half> } @llvm.sincos.v2f16(<2 x half> %a)
  ret { <2 x half>, <2 x half> } %result
}

define { float, float } @test_sincos_f32(float %a) {
; GNU-LABEL: test_sincos_f32:
; GNU:       @ %bb.0:
; GNU-NEXT:    push {r7, lr}
; GNU-NEXT:    sub sp, #8
; GNU-NEXT:    add r1, sp, #4
; GNU-NEXT:    mov r2, sp
; GNU-NEXT:    bl sincosf
; GNU-NEXT:    ldrd r1, r0, [sp], #8
; GNU-NEXT:    pop {r7, pc}
;
; GNUEABI-LABEL: test_sincos_f32:
; GNUEABI:       @ %bb.0:
; GNUEABI-NEXT:    .save {r11, lr}
; GNUEABI-NEXT:    push {r11, lr}
; GNUEABI-NEXT:    .pad #8
; GNUEABI-NEXT:    sub sp, sp, #8
; GNUEABI-NEXT:    add r1, sp, #4
; GNUEABI-NEXT:    mov r2, sp
; GNUEABI-NEXT:    bl sincosf
; GNUEABI-NEXT:    ldr r0, [sp, #4]
; GNUEABI-NEXT:    ldr r1, [sp], #8
; GNUEABI-NEXT:    pop {r11, pc}
;
; IOS-NO-STRET-LABEL: test_sincos_f32:
; IOS-NO-STRET:       @ %bb.0:
; IOS-NO-STRET-NEXT:    push {r4, r5, lr}
; IOS-NO-STRET-NEXT:    mov r4, r0
; IOS-NO-STRET-NEXT:    bl _sinf
; IOS-NO-STRET-NEXT:    mov r5, r0
; IOS-NO-STRET-NEXT:    mov r0, r4
; IOS-NO-STRET-NEXT:    bl _cosf
; IOS-NO-STRET-NEXT:    mov r1, r0
; IOS-NO-STRET-NEXT:    mov r0, r5
; IOS-NO-STRET-NEXT:    pop {r4, r5, pc}
;
; IOS-WITH-STRET-LABEL: test_sincos_f32:
; IOS-WITH-STRET:       @ %bb.0:
; IOS-WITH-STRET-NEXT:    push {lr}
; IOS-WITH-STRET-NEXT:    sub sp, sp, #8
; IOS-WITH-STRET-NEXT:    mov r1, r0
; IOS-WITH-STRET-NEXT:    mov r0, sp
; IOS-WITH-STRET-NEXT:    bl ___sincosf_stret
; IOS-WITH-STRET-NEXT:    pop {r0, r1}
; IOS-WITH-STRET-NEXT:    pop {lr}
; IOS-WITH-STRET-NEXT:    bx lr
;
; WATCHABI-LABEL: test_sincos_f32:
; WATCHABI:         .cfi_startproc
; WATCHABI-NEXT:  @ %bb.0:
; WATCHABI-NEXT:    push {r7, lr}
; WATCHABI-NEXT:    .cfi_def_cfa_offset 8
; WATCHABI-NEXT:    .cfi_offset lr, -4
; WATCHABI-NEXT:    .cfi_offset r7, -8
; WATCHABI-NEXT:    sub sp, #8
; WATCHABI-NEXT:    .cfi_def_cfa_offset 16
; WATCHABI-NEXT:    bl ___sincosf_stret
; WATCHABI-NEXT:    add sp, #8
; WATCHABI-NEXT:    pop {r7, pc}
; WATCHABI-NEXT:    .cfi_endproc
  %result = call { float, float } @llvm.sincos.f32(float %a)
  ret { float, float } %result
}

define { <2 x float>, <2 x float> } @test_sincos_v2f32(<2 x float> %a) {
; GNU-LABEL: test_sincos_v2f32:
; GNU:       @ %bb.0:
; GNU-NEXT:    push {r7, lr}
; GNU-NEXT:    vpush {d8}
; GNU-NEXT:    sub sp, #16
; GNU-NEXT:    vmov d8, r0, r1
; GNU-NEXT:    add r1, sp, #4
; GNU-NEXT:    mov r2, sp
; GNU-NEXT:    vmov r0, s17
; GNU-NEXT:    bl sincosf
; GNU-NEXT:    vmov r0, s16
; GNU-NEXT:    add r1, sp, #12
; GNU-NEXT:    add r2, sp, #8
; GNU-NEXT:    bl sincosf
; GNU-NEXT:    vldr s1, [sp, #4]
; GNU-NEXT:    vldr s3, [sp]
; GNU-NEXT:    vldr s0, [sp, #12]
; GNU-NEXT:    vldr s2, [sp, #8]
; GNU-NEXT:    vmov r0, r1, d0
; GNU-NEXT:    vmov r2, r3, d1
; GNU-NEXT:    add sp, #16
; GNU-NEXT:    vpop {d8}
; GNU-NEXT:    pop {r7, pc}
;
; GNUEABI-LABEL: test_sincos_v2f32:
; GNUEABI:       @ %bb.0:
; GNUEABI-NEXT:    .save {r11, lr}
; GNUEABI-NEXT:    push {r11, lr}
; GNUEABI-NEXT:    .vsave {d8}
; GNUEABI-NEXT:    vpush {d8}
; GNUEABI-NEXT:    .pad #16
; GNUEABI-NEXT:    sub sp, sp, #16
; GNUEABI-NEXT:    vmov d8, r0, r1
; GNUEABI-NEXT:    add r1, sp, #4
; GNUEABI-NEXT:    mov r2, sp
; GNUEABI-NEXT:    vmov r0, s17
; GNUEABI-NEXT:    bl sincosf
; GNUEABI-NEXT:    vmov r0, s16
; GNUEABI-NEXT:    add r1, sp, #12
; GNUEABI-NEXT:    add r2, sp, #8
; GNUEABI-NEXT:    bl sincosf
; GNUEABI-NEXT:    vldr s1, [sp, #4]
; GNUEABI-NEXT:    vldr s3, [sp]
; GNUEABI-NEXT:    vldr s0, [sp, #12]
; GNUEABI-NEXT:    vldr s2, [sp, #8]
; GNUEABI-NEXT:    vmov r0, r1, d0
; GNUEABI-NEXT:    vmov r2, r3, d1
; GNUEABI-NEXT:    add sp, sp, #16
; GNUEABI-NEXT:    vpop {d8}
; GNUEABI-NEXT:    pop {r11, pc}
;
; IOS-NO-STRET-LABEL: test_sincos_v2f32:
; IOS-NO-STRET:       @ %bb.0:
; IOS-NO-STRET-NEXT:    push {r4, r5, r6, r7, lr}
; IOS-NO-STRET-NEXT:    vpush {d8}
; IOS-NO-STRET-NEXT:    vmov d8, r0, r1
; IOS-NO-STRET-NEXT:    vmov r4, s17
; IOS-NO-STRET-NEXT:    mov r0, r4
; IOS-NO-STRET-NEXT:    bl _sinf
; IOS-NO-STRET-NEXT:    mov r5, r0
; IOS-NO-STRET-NEXT:    mov r0, r4
; IOS-NO-STRET-NEXT:    bl _cosf
; IOS-NO-STRET-NEXT:    vmov r6, s16
; IOS-NO-STRET-NEXT:    mov r4, r0
; IOS-NO-STRET-NEXT:    mov r0, r6
; IOS-NO-STRET-NEXT:    bl _sinf
; IOS-NO-STRET-NEXT:    mov r7, r0
; IOS-NO-STRET-NEXT:    mov r0, r6
; IOS-NO-STRET-NEXT:    bl _cosf
; IOS-NO-STRET-NEXT:    mov r2, r0
; IOS-NO-STRET-NEXT:    mov r0, r7
; IOS-NO-STRET-NEXT:    mov r1, r5
; IOS-NO-STRET-NEXT:    mov r3, r4
; IOS-NO-STRET-NEXT:    vpop {d8}
; IOS-NO-STRET-NEXT:    pop {r4, r5, r6, r7, pc}
;
; IOS-WITH-STRET-LABEL: test_sincos_v2f32:
; IOS-WITH-STRET:       @ %bb.0:
; IOS-WITH-STRET-NEXT:    push {lr}
; IOS-WITH-STRET-NEXT:    vpush {d8}
; IOS-WITH-STRET-NEXT:    sub sp, sp, #16
; IOS-WITH-STRET-NEXT:    vmov d8, r0, r1
; IOS-WITH-STRET-NEXT:    mov r0, sp
; IOS-WITH-STRET-NEXT:    vmov r1, s17
; IOS-WITH-STRET-NEXT:    bl ___sincosf_stret
; IOS-WITH-STRET-NEXT:    vmov r1, s16
; IOS-WITH-STRET-NEXT:    add r0, sp, #8
; IOS-WITH-STRET-NEXT:    bl ___sincosf_stret
; IOS-WITH-STRET-NEXT:    vldr s1, [sp]
; IOS-WITH-STRET-NEXT:    vldr s3, [sp, #4]
; IOS-WITH-STRET-NEXT:    vldr s0, [sp, #8]
; IOS-WITH-STRET-NEXT:    vldr s2, [sp, #12]
; IOS-WITH-STRET-NEXT:    vmov r0, r1, d0
; IOS-WITH-STRET-NEXT:    vmov r2, r3, d1
; IOS-WITH-STRET-NEXT:    add sp, sp, #16
; IOS-WITH-STRET-NEXT:    vpop {d8}
; IOS-WITH-STRET-NEXT:    pop {lr}
; IOS-WITH-STRET-NEXT:    bx lr
;
; WATCHABI-LABEL: test_sincos_v2f32:
; WATCHABI:         .cfi_startproc
; WATCHABI-NEXT:  @ %bb.0:
; WATCHABI-NEXT:    push {r7, lr}
; WATCHABI-NEXT:    .cfi_def_cfa_offset 8
; WATCHABI-NEXT:    .cfi_offset lr, -4
; WATCHABI-NEXT:    .cfi_offset r7, -8
; WATCHABI-NEXT:    vpush {d8, d9, d10}
; WATCHABI-NEXT:    .cfi_def_cfa_offset 32
; WATCHABI-NEXT:    .cfi_offset d10, -16
; WATCHABI-NEXT:    .cfi_offset d9, -24
; WATCHABI-NEXT:    .cfi_offset d8, -32
; WATCHABI-NEXT:    vmov.f64 d8, d0
; WATCHABI-NEXT:    vmov.f32 s0, s17
; WATCHABI-NEXT:    bl ___sincosf_stret
; WATCHABI-NEXT:    vmov.f32 s19, s0
; WATCHABI-NEXT:    vmov.f32 s0, s16
; WATCHABI-NEXT:    vmov.f32 s21, s1
; WATCHABI-NEXT:    bl ___sincosf_stret
; WATCHABI-NEXT:    vmov.f32 s20, s1
; WATCHABI-NEXT:    vmov.f32 s18, s0
; WATCHABI-NEXT:    vmov.f64 d1, d10
; WATCHABI-NEXT:    vmov.f64 d0, d9
; WATCHABI-NEXT:    vpop {d8, d9, d10}
; WATCHABI-NEXT:    pop {r7, pc}
; WATCHABI-NEXT:    .cfi_endproc
  %result = call { <2 x float>, <2 x float> } @llvm.sincos.v2f32(<2 x float> %a)
  ret { <2 x float>, <2 x float> } %result
}

define { double, double } @test_sincos_f64(double %a) {
; GNU-LABEL: test_sincos_f64:
; GNU:       @ %bb.0:
; GNU-NEXT:    push {r7, lr}
; GNU-NEXT:    sub sp, #16
; GNU-NEXT:    add r2, sp, #8
; GNU-NEXT:    mov r3, sp
; GNU-NEXT:    bl sincos
; GNU-NEXT:    ldrd r0, r1, [sp, #8]
; GNU-NEXT:    ldrd r2, r3, [sp], #16
; GNU-NEXT:    pop {r7, pc}
;
; GNUEABI-LABEL: test_sincos_f64:
; GNUEABI:       @ %bb.0:
; GNUEABI-NEXT:    .save {r11, lr}
; GNUEABI-NEXT:    push {r11, lr}
; GNUEABI-NEXT:    .pad #16
; GNUEABI-NEXT:    sub sp, sp, #16
; GNUEABI-NEXT:    add r2, sp, #8
; GNUEABI-NEXT:    mov r3, sp
; GNUEABI-NEXT:    bl sincos
; GNUEABI-NEXT:    ldm sp, {r2, r3}
; GNUEABI-NEXT:    ldr r0, [sp, #8]
; GNUEABI-NEXT:    ldr r1, [sp, #12]
; GNUEABI-NEXT:    add sp, sp, #16
; GNUEABI-NEXT:    pop {r11, pc}
;
; IOS-NO-STRET-LABEL: test_sincos_f64:
; IOS-NO-STRET:       @ %bb.0:
; IOS-NO-STRET-NEXT:    push {r4, r5, r6, r7, lr}
; IOS-NO-STRET-NEXT:    mov r4, r1
; IOS-NO-STRET-NEXT:    mov r5, r0
; IOS-NO-STRET-NEXT:    bl _sin
; IOS-NO-STRET-NEXT:    mov r6, r0
; IOS-NO-STRET-NEXT:    mov r7, r1
; IOS-NO-STRET-NEXT:    mov r0, r5
; IOS-NO-STRET-NEXT:    mov r1, r4
; IOS-NO-STRET-NEXT:    bl _cos
; IOS-NO-STRET-NEXT:    mov r2, r0
; IOS-NO-STRET-NEXT:    mov r3, r1
; IOS-NO-STRET-NEXT:    mov r0, r6
; IOS-NO-STRET-NEXT:    mov r1, r7
; IOS-NO-STRET-NEXT:    pop {r4, r5, r6, r7, pc}
;
; IOS-WITH-STRET-LABEL: test_sincos_f64:
; IOS-WITH-STRET:       @ %bb.0:
; IOS-WITH-STRET-NEXT:    push {lr}
; IOS-WITH-STRET-NEXT:    sub sp, sp, #16
; IOS-WITH-STRET-NEXT:    mov r2, r1
; IOS-WITH-STRET-NEXT:    mov r1, r0
; IOS-WITH-STRET-NEXT:    mov r0, sp
; IOS-WITH-STRET-NEXT:    bl ___sincos_stret
; IOS-WITH-STRET-NEXT:    vldr d16, [sp, #8]
; IOS-WITH-STRET-NEXT:    ldm sp, {r0, r1}
; IOS-WITH-STRET-NEXT:    vmov r2, r3, d16
; IOS-WITH-STRET-NEXT:    add sp, sp, #16
; IOS-WITH-STRET-NEXT:    pop {lr}
; IOS-WITH-STRET-NEXT:    bx lr
;
; WATCHABI-LABEL: test_sincos_f64:
; WATCHABI:         .cfi_startproc
; WATCHABI-NEXT:  @ %bb.0:
; WATCHABI-NEXT:    push {r7, lr}
; WATCHABI-NEXT:    .cfi_def_cfa_offset 8
; WATCHABI-NEXT:    .cfi_offset lr, -4
; WATCHABI-NEXT:    .cfi_offset r7, -8
; WATCHABI-NEXT:    sub sp, #8
; WATCHABI-NEXT:    .cfi_def_cfa_offset 16
; WATCHABI-NEXT:    bl ___sincos_stret
; WATCHABI-NEXT:    add sp, #8
; WATCHABI-NEXT:    pop {r7, pc}
; WATCHABI-NEXT:    .cfi_endproc
  %result = call { double, double } @llvm.sincos.f64(double %a)
  ret { double, double } %result
}

define { <2 x double>, <2 x double> } @test_sincos_v2f64(<2 x double> %a) {
; GNU-LABEL: test_sincos_v2f64:
; GNU:       @ %bb.0:
; GNU-NEXT:    push {r4, lr}
; GNU-NEXT:    sub sp, #32
; GNU-NEXT:    mov r1, r3
; GNU-NEXT:    mov r12, r2
; GNU-NEXT:    add r2, sp, #24
; GNU-NEXT:    add r3, sp, #16
; GNU-NEXT:    mov r4, r0
; GNU-NEXT:    mov r0, r12
; GNU-NEXT:    bl sincos
; GNU-NEXT:    ldrd r0, r1, [sp, #40]
; GNU-NEXT:    add r2, sp, #8
; GNU-NEXT:    mov r3, sp
; GNU-NEXT:    bl sincos
; GNU-NEXT:    vldr d19, [sp, #8]
; GNU-NEXT:    vldr d18, [sp, #24]
; GNU-NEXT:    vldr d17, [sp]
; GNU-NEXT:    vldr d16, [sp, #16]
; GNU-NEXT:    vst1.64 {d18, d19}, [r4]!
; GNU-NEXT:    vst1.64 {d16, d17}, [r4]
; GNU-NEXT:    add sp, #32
; GNU-NEXT:    pop {r4, pc}
;
; GNUEABI-LABEL: test_sincos_v2f64:
; GNUEABI:       @ %bb.0:
; GNUEABI-NEXT:    .save {r4, lr}
; GNUEABI-NEXT:    push {r4, lr}
; GNUEABI-NEXT:    .pad #32
; GNUEABI-NEXT:    sub sp, sp, #32
; GNUEABI-NEXT:    mov r1, r3
; GNUEABI-NEXT:    mov r12, r2
; GNUEABI-NEXT:    add r2, sp, #24
; GNUEABI-NEXT:    add r3, sp, #16
; GNUEABI-NEXT:    mov r4, r0
; GNUEABI-NEXT:    mov r0, r12
; GNUEABI-NEXT:    bl sincos
; GNUEABI-NEXT:    ldr r0, [sp, #40]
; GNUEABI-NEXT:    add r2, sp, #8
; GNUEABI-NEXT:    ldr r1, [sp, #44]
; GNUEABI-NEXT:    mov r3, sp
; GNUEABI-NEXT:    bl sincos
; GNUEABI-NEXT:    vldr d19, [sp, #8]
; GNUEABI-NEXT:    vldr d18, [sp, #24]
; GNUEABI-NEXT:    vldr d17, [sp]
; GNUEABI-NEXT:    vldr d16, [sp, #16]
; GNUEABI-NEXT:    vst1.64 {d18, d19}, [r4]!
; GNUEABI-NEXT:    vst1.64 {d16, d17}, [r4]
; GNUEABI-NEXT:    add sp, sp, #32
; GNUEABI-NEXT:    pop {r4, pc}
;
; IOS-NO-STRET-LABEL: test_sincos_v2f64:
; IOS-NO-STRET:       @ %bb.0:
; IOS-NO-STRET-NEXT:    push {r4, r5, r6, r7, r8, r10, r11, lr}
; IOS-NO-STRET-NEXT:    vpush {d8, d9, d10, d11}
; IOS-NO-STRET-NEXT:    ldr r8, [sp, #64]
; IOS-NO-STRET-NEXT:    mov r7, r1
; IOS-NO-STRET-NEXT:    mov r4, r0
; IOS-NO-STRET-NEXT:    mov r0, r3
; IOS-NO-STRET-NEXT:    mov r6, r3
; IOS-NO-STRET-NEXT:    mov r10, r2
; IOS-NO-STRET-NEXT:    mov r1, r8
; IOS-NO-STRET-NEXT:    bl _sin
; IOS-NO-STRET-NEXT:    mov r11, r0
; IOS-NO-STRET-NEXT:    mov r5, r1
; IOS-NO-STRET-NEXT:    mov r0, r6
; IOS-NO-STRET-NEXT:    mov r1, r8
; IOS-NO-STRET-NEXT:    bl _cos
; IOS-NO-STRET-NEXT:    vmov d9, r0, r1
; IOS-NO-STRET-NEXT:    mov r0, r7
; IOS-NO-STRET-NEXT:    mov r1, r10
; IOS-NO-STRET-NEXT:    vmov d11, r11, r5
; IOS-NO-STRET-NEXT:    bl _sin
; IOS-NO-STRET-NEXT:    vmov d10, r0, r1
; IOS-NO-STRET-NEXT:    mov r0, r7
; IOS-NO-STRET-NEXT:    mov r1, r10
; IOS-NO-STRET-NEXT:    bl _cos
; IOS-NO-STRET-NEXT:    vmov d8, r0, r1
; IOS-NO-STRET-NEXT:    vst1.32 {d10, d11}, [r4]!
; IOS-NO-STRET-NEXT:    vst1.32 {d8, d9}, [r4]
; IOS-NO-STRET-NEXT:    vpop {d8, d9, d10, d11}
; IOS-NO-STRET-NEXT:    pop {r4, r5, r6, r7, r8, r10, r11, pc}
;
; IOS-WITH-STRET-LABEL: test_sincos_v2f64:
; IOS-WITH-STRET:       @ %bb.0:
; IOS-WITH-STRET-NEXT:    push {r4, r5, r6, lr}
; IOS-WITH-STRET-NEXT:    sub sp, sp, #32
; IOS-WITH-STRET-NEXT:    mov r4, r2
; IOS-WITH-STRET-NEXT:    ldr r2, [sp, #48]
; IOS-WITH-STRET-NEXT:    mov r6, r0
; IOS-WITH-STRET-NEXT:    add r0, sp, #16
; IOS-WITH-STRET-NEXT:    mov r5, r1
; IOS-WITH-STRET-NEXT:    mov r1, r3
; IOS-WITH-STRET-NEXT:    bl ___sincos_stret
; IOS-WITH-STRET-NEXT:    mov r0, sp
; IOS-WITH-STRET-NEXT:    mov r1, r5
; IOS-WITH-STRET-NEXT:    mov r2, r4
; IOS-WITH-STRET-NEXT:    bl ___sincos_stret
; IOS-WITH-STRET-NEXT:    vldr d17, [sp, #16]
; IOS-WITH-STRET-NEXT:    vldr d16, [sp]
; IOS-WITH-STRET-NEXT:    vldr d19, [sp, #24]
; IOS-WITH-STRET-NEXT:    vldr d18, [sp, #8]
; IOS-WITH-STRET-NEXT:    vst1.32 {d16, d17}, [r6]!
; IOS-WITH-STRET-NEXT:    vst1.32 {d18, d19}, [r6]
; IOS-WITH-STRET-NEXT:    add sp, sp, #32
; IOS-WITH-STRET-NEXT:    pop {r4, r5, r6, pc}
;
; WATCHABI-LABEL: test_sincos_v2f64:
; WATCHABI:         .cfi_startproc
; WATCHABI-NEXT:  @ %bb.0:
; WATCHABI-NEXT:    push {r7, lr}
; WATCHABI-NEXT:    .cfi_def_cfa_offset 8
; WATCHABI-NEXT:    .cfi_offset lr, -4
; WATCHABI-NEXT:    .cfi_offset r7, -8
; WATCHABI-NEXT:    vpush {d8, d9, d10, d11, d12, d13}
; WATCHABI-NEXT:    .cfi_def_cfa_offset 56
; WATCHABI-NEXT:    .cfi_offset d13, -16
; WATCHABI-NEXT:    .cfi_offset d12, -24
; WATCHABI-NEXT:    .cfi_offset d11, -32
; WATCHABI-NEXT:    .cfi_offset d10, -40
; WATCHABI-NEXT:    .cfi_offset d9, -48
; WATCHABI-NEXT:    .cfi_offset d8, -56
; WATCHABI-NEXT:    sub sp, #8
; WATCHABI-NEXT:    .cfi_def_cfa_offset 64
; WATCHABI-NEXT:    vorr q4, q0, q0
; WATCHABI-NEXT:    vorr d0, d9, d9
; WATCHABI-NEXT:    bl ___sincos_stret
; WATCHABI-NEXT:    vorr d11, d0, d0
; WATCHABI-NEXT:    vorr d0, d8, d8
; WATCHABI-NEXT:    vorr d13, d1, d1
; WATCHABI-NEXT:    bl ___sincos_stret
; WATCHABI-NEXT:    vorr d12, d1, d1
; WATCHABI-NEXT:    vorr d10, d0, d0
; WATCHABI-NEXT:    vorr q1, q6, q6
; WATCHABI-NEXT:    vorr q0, q5, q5
; WATCHABI-NEXT:    add sp, #8
; WATCHABI-NEXT:    vpop {d8, d9, d10, d11, d12, d13}
; WATCHABI-NEXT:    pop {r7, pc}
; WATCHABI-NEXT:    .cfi_endproc
  %result = call { <2 x double>, <2 x double> } @llvm.sincos.v2f64(<2 x double> %a)
  ret { <2 x double>, <2 x double> } %result
}

define { fp128, fp128 } @test_sincos_f128(fp128 %a) {
; GNU-LABEL: test_sincos_f128:
; GNU:       @ %bb.0:
; GNU-NEXT:    push {r4, r5, r7, lr}
; GNU-NEXT:    sub sp, #40
; GNU-NEXT:    mov r12, r3
; GNU-NEXT:    ldr r3, [sp, #56]
; GNU-NEXT:    add.w lr, sp, #8
; GNU-NEXT:    mov r4, r0
; GNU-NEXT:    add r0, sp, #24
; GNU-NEXT:    strd r0, lr, [sp]
; GNU-NEXT:    mov r0, r1
; GNU-NEXT:    mov r1, r2
; GNU-NEXT:    mov r2, r12
; GNU-NEXT:    bl sincosl
; GNU-NEXT:    ldrd r2, r3, [sp, #16]
; GNU-NEXT:    ldrd r12, r1, [sp, #8]
; GNU-NEXT:    str r3, [r4, #28]
; GNU-NEXT:    ldrd r3, r5, [sp, #32]
; GNU-NEXT:    ldrd lr, r0, [sp, #24]
; GNU-NEXT:    strd r1, r2, [r4, #20]
; GNU-NEXT:    add.w r1, r4, #8
; GNU-NEXT:    stm.w r1, {r3, r5, r12}
; GNU-NEXT:    strd lr, r0, [r4]
; GNU-NEXT:    add sp, #40
; GNU-NEXT:    pop {r4, r5, r7, pc}
;
; GNUEABI-LABEL: test_sincos_f128:
; GNUEABI:       @ %bb.0:
; GNUEABI-NEXT:    .save {r4, r5, r11, lr}
; GNUEABI-NEXT:    push {r4, r5, r11, lr}
; GNUEABI-NEXT:    .pad #40
; GNUEABI-NEXT:    sub sp, sp, #40
; GNUEABI-NEXT:    mov r12, r3
; GNUEABI-NEXT:    ldr r3, [sp, #56]
; GNUEABI-NEXT:    mov r4, r0
; GNUEABI-NEXT:    add r0, sp, #24
; GNUEABI-NEXT:    add r5, sp, #8
; GNUEABI-NEXT:    stm sp, {r0, r5}
; GNUEABI-NEXT:    mov r0, r1
; GNUEABI-NEXT:    mov r1, r2
; GNUEABI-NEXT:    mov r2, r12
; GNUEABI-NEXT:    bl sincosl
; GNUEABI-NEXT:    add r3, sp, #12
; GNUEABI-NEXT:    ldr r12, [sp, #8]
; GNUEABI-NEXT:    ldm r3, {r1, r2, r3}
; GNUEABI-NEXT:    str r3, [r4, #28]
; GNUEABI-NEXT:    ldr r0, [sp, #32]
; GNUEABI-NEXT:    ldr lr, [sp, #24]
; GNUEABI-NEXT:    ldr r5, [sp, #28]
; GNUEABI-NEXT:    ldr r3, [sp, #36]
; GNUEABI-NEXT:    str r2, [r4, #24]
; GNUEABI-NEXT:    str r1, [r4, #20]
; GNUEABI-NEXT:    add r1, r4, #8
; GNUEABI-NEXT:    stm r1, {r0, r3, r12}
; GNUEABI-NEXT:    str r5, [r4, #4]
; GNUEABI-NEXT:    str lr, [r4]
; GNUEABI-NEXT:    add sp, sp, #40
; GNUEABI-NEXT:    pop {r4, r5, r11, pc}
;
; IOS-LABEL: test_sincos_f128:
; IOS:       @ %bb.0:
; IOS-NEXT:    push {r4, r5, r6, r7, r8, lr}
; IOS-NEXT:    ldr r8, [sp, #24]
; IOS-NEXT:    mov r4, r0
; IOS-NEXT:    mov r5, r3
; IOS-NEXT:    mov r6, r2
; IOS-NEXT:    mov r7, r1
; IOS-NEXT:    mov r0, r1
; IOS-NEXT:    mov r1, r2
; IOS-NEXT:    mov r2, r3
; IOS-NEXT:    mov r3, r8
; IOS-NEXT:    bl _cosl
; IOS-NEXT:    add r9, r4, #16
; IOS-NEXT:    stm r9, {r0, r1, r2, r3}
; IOS-NEXT:    mov r0, r7
; IOS-NEXT:    mov r1, r6
; IOS-NEXT:    mov r2, r5
; IOS-NEXT:    mov r3, r8
; IOS-NEXT:    bl _sinl
; IOS-NEXT:    stm r4, {r0, r1, r2, r3}
; IOS-NEXT:    pop {r4, r5, r6, r7, r8, pc}
;
; WATCHABI-LABEL: test_sincos_f128:
; WATCHABI:         .cfi_startproc
; WATCHABI-NEXT:  @ %bb.0:
; WATCHABI-NEXT:    push.w {r4, r5, r6, r7, r8, lr}
; WATCHABI-NEXT:    .cfi_def_cfa_offset 24
; WATCHABI-NEXT:    .cfi_offset lr, -4
; WATCHABI-NEXT:    .cfi_offset r7, -8
; WATCHABI-NEXT:    .cfi_offset r6, -12
; WATCHABI-NEXT:    .cfi_offset r5, -16
; WATCHABI-NEXT:    .cfi_offset r4, -20
; WATCHABI-NEXT:    .cfi_offset r8, -24
; WATCHABI-NEXT:    sub sp, #8
; WATCHABI-NEXT:    .cfi_def_cfa_offset 32
; WATCHABI-NEXT:    ldr.w r8, [sp, #32]
; WATCHABI-NEXT:    mov r4, r0
; WATCHABI-NEXT:    mov r5, r3
; WATCHABI-NEXT:    mov r6, r2
; WATCHABI-NEXT:    mov r7, r1
; WATCHABI-NEXT:    mov r0, r1
; WATCHABI-NEXT:    mov r1, r2
; WATCHABI-NEXT:    mov r2, r3
; WATCHABI-NEXT:    mov r3, r8
; WATCHABI-NEXT:    bl _cosl
; WATCHABI-NEXT:    add.w r9, r4, #16
; WATCHABI-NEXT:    stm.w r9, {r0, r1, r2, r3}
; WATCHABI-NEXT:    mov r0, r7
; WATCHABI-NEXT:    mov r1, r6
; WATCHABI-NEXT:    mov r2, r5
; WATCHABI-NEXT:    mov r3, r8
; WATCHABI-NEXT:    bl _sinl
; WATCHABI-NEXT:    stm r4!, {r0, r1, r2, r3}
; WATCHABI-NEXT:    add sp, #8
; WATCHABI-NEXT:    pop.w {r4, r5, r6, r7, r8, pc}
; WATCHABI-NEXT:    .cfi_endproc
  %result = call { fp128, fp128 } @llvm.sincos.f16(fp128 %a)
  ret { fp128, fp128 } %result
}
