; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple armv8-none-eabihf -mattr=+neon,+fp-armv8 -enable-no-nans-fp-math | FileCheck %s

; scalars

define float @fparmv8_vminnm_o(float %a, float %b) {
; CHECK-LABEL: fparmv8_vminnm_o:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vminnm.f32 s0, s0, s1
; CHECK-NEXT:    bx lr
  %cmp = fcmp fast olt float %a, %b
  %cond = select nsz i1 %cmp, float %a, float %b
  ret float %cond
}

define double @fparmv8_vminnm_ole(double %a, double %b) {
; CHECK-LABEL: fparmv8_vminnm_ole:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vminnm.f64 d0, d0, d1
; CHECK-NEXT:    bx lr
  %cmp = fcmp fast ole double %a, %b
  %cond = select nsz i1 %cmp, double %a, double %b
  ret double %cond
}

define float @fparmv8_vminnm_o_rev(float %a, float %b) {
; CHECK-LABEL: fparmv8_vminnm_o_rev:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vminnm.f32 s0, s0, s1
; CHECK-NEXT:    bx lr
  %cmp = fcmp fast ogt float %a, %b
  %cond = select nsz i1 %cmp, float %b, float %a
  ret float %cond
}

define double @fparmv8_vminnm_oge_rev(double %a, double %b) {
; CHECK-LABEL: fparmv8_vminnm_oge_rev:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vminnm.f64 d0, d0, d1
; CHECK-NEXT:    bx lr
  %cmp = fcmp fast oge double %a, %b
  %cond = select nsz i1 %cmp, double %b, double %a
  ret double %cond
}

define float @fparmv8_vminnm_u(float %a, float %b) {
; CHECK-LABEL: fparmv8_vminnm_u:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vminnm.f32 s0, s0, s1
; CHECK-NEXT:    bx lr
  %cmp = fcmp fast ult float %a, %b
  %cond = select nsz i1 %cmp, float %a, float %b
  ret float %cond
}

define float @fparmv8_vminnm_ule(float %a, float %b) {
; CHECK-LABEL: fparmv8_vminnm_ule:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vminnm.f32 s0, s0, s1
; CHECK-NEXT:    bx lr
  %cmp = fcmp fast ule float %a, %b
  %cond = select nsz i1 %cmp, float %a, float %b
  ret float %cond
}

define float @fparmv8_vminnm_u_rev(float %a, float %b) {
; CHECK-LABEL: fparmv8_vminnm_u_rev:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vminnm.f32 s0, s0, s1
; CHECK-NEXT:    bx lr
  %cmp = fcmp fast ugt float %a, %b
  %cond = select nsz i1 %cmp, float %b, float %a
  ret float %cond
}

define double @fparmv8_vminnm_uge_rev(double %a, double %b) {
; CHECK-LABEL: fparmv8_vminnm_uge_rev:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vminnm.f64 d0, d0, d1
; CHECK-NEXT:    bx lr
  %cmp = fcmp fast uge double %a, %b
  %cond = select nsz i1 %cmp, double %b, double %a
  ret double %cond
}

define float @fparmv8_vmaxnm_o(float %a, float %b) {
; CHECK-LABEL: fparmv8_vmaxnm_o:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmaxnm.f32 s0, s0, s1
; CHECK-NEXT:    bx lr
  %cmp = fcmp fast ogt float %a, %b
  %cond = select nsz i1 %cmp, float %a, float %b
  ret float %cond
}

define float @fparmv8_vmaxnm_oge(float %a, float %b) {
; CHECK-LABEL: fparmv8_vmaxnm_oge:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmaxnm.f32 s0, s0, s1
; CHECK-NEXT:    bx lr
  %cmp = fcmp fast oge float %a, %b
  %cond = select nsz i1 %cmp, float %a, float %b
  ret float %cond
}

define float @fparmv8_vmaxnm_o_rev(float %a, float %b) {
; CHECK-LABEL: fparmv8_vmaxnm_o_rev:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmaxnm.f32 s0, s0, s1
; CHECK-NEXT:    bx lr
  %cmp = fcmp fast olt float %a, %b
  %cond = select nsz i1 %cmp, float %b, float %a
  ret float %cond
}

define float @fparmv8_vmaxnm_ole_rev(float %a, float %b) {
; CHECK-LABEL: fparmv8_vmaxnm_ole_rev:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmaxnm.f32 s0, s0, s1
; CHECK-NEXT:    bx lr
  %cmp = fcmp fast ole float %a, %b
  %cond = select nsz i1 %cmp, float %b, float %a
  ret float %cond
}

define float @fparmv8_vmaxnm_u(float %a, float %b) {
; CHECK-LABEL: fparmv8_vmaxnm_u:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmaxnm.f32 s0, s0, s1
; CHECK-NEXT:    bx lr
  %cmp = fcmp fast ugt float %a, %b
  %cond = select nsz i1 %cmp, float %a, float %b
  ret float %cond
}

define float @fparmv8_vmaxnm_uge(float %a, float %b) {
; CHECK-LABEL: fparmv8_vmaxnm_uge:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmaxnm.f32 s0, s0, s1
; CHECK-NEXT:    bx lr
  %cmp = fcmp fast uge float %a, %b
  %cond = select nsz i1 %cmp, float %a, float %b
  ret float %cond
}

define float @fparmv8_vmaxnm_u_rev(float %a, float %b) {
; CHECK-LABEL: fparmv8_vmaxnm_u_rev:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmaxnm.f32 s0, s0, s1
; CHECK-NEXT:    bx lr
  %cmp = fcmp fast ult float %a, %b
  %cond = select nsz i1 %cmp, float %b, float %a
  ret float %cond
}

define double @fparmv8_vmaxnm_ule_rev(double %a, double %b) {
; CHECK-LABEL: fparmv8_vmaxnm_ule_rev:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmaxnm.f64 d0, d0, d1
; CHECK-NEXT:    bx lr
  %cmp = fcmp fast ule double %a, %b
  %cond = select nsz i1 %cmp, double %b, double %a
  ret double %cond
}

; known non-NaNs

define float @fparmv8_vminnm_NNNo(float %a) {
; CHECK-LABEL: fparmv8_vminnm_NNNo:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmov.f32 s2, #1.200000e+01
; CHECK-NEXT:    vldr s4, .LCPI16_0
; CHECK-NEXT:    vminnm.f32 s0, s0, s2
; CHECK-NEXT:    vminnm.f32 s0, s0, s4
; CHECK-NEXT:    bx lr
; CHECK-NEXT:    .p2align 2
; CHECK-NEXT:  @ %bb.1:
; CHECK-NEXT:  .LCPI16_0:
; CHECK-NEXT:    .long 0x42080000 @ float 34
  %cmp1 = fcmp fast olt float %a, 12.
  %cond1 = select nsz i1 %cmp1, float %a, float 12.
  %cmp2 = fcmp fast olt float 34., %cond1
  %cond2 = select nsz i1 %cmp2, float 34., float %cond1
  ret float %cond2
}

define double @fparmv8_vminnm_NNNole(double %a) {
; CHECK-LABEL: fparmv8_vminnm_NNNole:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vldr d16, .LCPI17_0
; CHECK-NEXT:    vldr d17, .LCPI17_1
; CHECK-NEXT:    vminnm.f64 d16, d0, d16
; CHECK-NEXT:    vminnm.f64 d0, d16, d17
; CHECK-NEXT:    bx lr
; CHECK-NEXT:    .p2align 3
; CHECK-NEXT:  @ %bb.1:
; CHECK-NEXT:  .LCPI17_0:
; CHECK-NEXT:    .long 0 @ double 34
; CHECK-NEXT:    .long 1078001664
; CHECK-NEXT:  .LCPI17_1:
; CHECK-NEXT:    .long 0 @ double 56
; CHECK-NEXT:    .long 1078722560
  %cmp1 = fcmp fast ole double %a, 34.
  %cond1 = select nsz i1 %cmp1, double %a, double 34.
  %cmp2 = fcmp fast ole double 56., %cond1
  %cond2 = select nsz i1 %cmp2, double 56., double %cond1
  ret double %cond2
}

define float @fparmv8_vminnm_NNNo_rev(float %a) {
; CHECK-LABEL: fparmv8_vminnm_NNNo_rev:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vldr s2, .LCPI18_0
; CHECK-NEXT:    vldr s4, .LCPI18_1
; CHECK-NEXT:    vminnm.f32 s0, s0, s2
; CHECK-NEXT:    vminnm.f32 s0, s0, s4
; CHECK-NEXT:    bx lr
; CHECK-NEXT:    .p2align 2
; CHECK-NEXT:  @ %bb.1:
; CHECK-NEXT:  .LCPI18_0:
; CHECK-NEXT:    .long 0x42600000 @ float 56
; CHECK-NEXT:  .LCPI18_1:
; CHECK-NEXT:    .long 0x429c0000 @ float 78
  %cmp1 = fcmp fast ogt float %a, 56.
  %cond1 = select nsz i1 %cmp1, float 56., float %a
  %cmp2 = fcmp fast ogt float 78., %cond1
  %cond2 = select nsz i1 %cmp2, float %cond1, float 78.
  ret float %cond2
}

define double @fparmv8_vminnm_NNNoge_rev(double %a) {
; CHECK-LABEL: fparmv8_vminnm_NNNoge_rev:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vldr d16, .LCPI19_0
; CHECK-NEXT:    vldr d17, .LCPI19_1
; CHECK-NEXT:    vminnm.f64 d16, d0, d16
; CHECK-NEXT:    vminnm.f64 d0, d16, d17
; CHECK-NEXT:    bx lr
; CHECK-NEXT:    .p2align 3
; CHECK-NEXT:  @ %bb.1:
; CHECK-NEXT:  .LCPI19_0:
; CHECK-NEXT:    .long 0 @ double 78
; CHECK-NEXT:    .long 1079214080
; CHECK-NEXT:  .LCPI19_1:
; CHECK-NEXT:    .long 0 @ double 90
; CHECK-NEXT:    .long 1079410688
  %cmp1 = fcmp fast oge double %a, 78.
  %cond1 = select nsz i1 %cmp1, double 78., double %a
  %cmp2 = fcmp fast oge double 90., %cond1
  %cond2 = select nsz i1 %cmp2, double %cond1, double 90.
  ret double %cond2
}

define float @fparmv8_vminnm_NNNu(float %b) {
; CHECK-LABEL: fparmv8_vminnm_NNNu:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmov.f32 s2, #1.200000e+01
; CHECK-NEXT:    vldr s4, .LCPI20_0
; CHECK-NEXT:    vminnm.f32 s0, s0, s2
; CHECK-NEXT:    vminnm.f32 s0, s0, s4
; CHECK-NEXT:    bx lr
; CHECK-NEXT:    .p2align 2
; CHECK-NEXT:  @ %bb.1:
; CHECK-NEXT:  .LCPI20_0:
; CHECK-NEXT:    .long 0x42080000 @ float 34
  %cmp1 = fcmp fast ult float 12., %b
  %cond1 = select nsz i1 %cmp1, float 12., float %b
  %cmp2 = fcmp fast ult float %cond1, 34.
  %cond2 = select nsz i1 %cmp2, float %cond1, float 34.
  ret float %cond2
}

define float @fparmv8_vminnm_NNNule(float %b) {
; CHECK-LABEL: fparmv8_vminnm_NNNule:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vldr s2, .LCPI21_0
; CHECK-NEXT:    vldr s4, .LCPI21_1
; CHECK-NEXT:    vminnm.f32 s0, s0, s2
; CHECK-NEXT:    vminnm.f32 s0, s0, s4
; CHECK-NEXT:    bx lr
; CHECK-NEXT:    .p2align 2
; CHECK-NEXT:  @ %bb.1:
; CHECK-NEXT:  .LCPI21_0:
; CHECK-NEXT:    .long 0x42080000 @ float 34
; CHECK-NEXT:  .LCPI21_1:
; CHECK-NEXT:    .long 0x42600000 @ float 56
  %cmp1 = fcmp fast ule float 34., %b
  %cond1 = select nsz i1 %cmp1, float 34., float %b
  %cmp2 = fcmp fast ule float %cond1, 56.
  %cond2 = select nsz i1 %cmp2, float %cond1, float 56.
  ret float %cond2
}

define float @fparmv8_vminnm_NNNu_rev(float %b) {
; CHECK-LABEL: fparmv8_vminnm_NNNu_rev:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vldr s2, .LCPI22_0
; CHECK-NEXT:    vldr s4, .LCPI22_1
; CHECK-NEXT:    vminnm.f32 s0, s0, s2
; CHECK-NEXT:    vminnm.f32 s0, s0, s4
; CHECK-NEXT:    bx lr
; CHECK-NEXT:    .p2align 2
; CHECK-NEXT:  @ %bb.1:
; CHECK-NEXT:  .LCPI22_0:
; CHECK-NEXT:    .long 0x42600000 @ float 56
; CHECK-NEXT:  .LCPI22_1:
; CHECK-NEXT:    .long 0x429c0000 @ float 78
  %cmp1 = fcmp fast ugt float 56., %b
  %cond1 = select nsz i1 %cmp1, float %b, float 56.
  %cmp2 = fcmp fast ugt float %cond1, 78.
  %cond2 = select nsz i1 %cmp2, float 78., float %cond1
  ret float %cond2
}

define double @fparmv8_vminnm_NNNuge_rev(double %b) {
; CHECK-LABEL: fparmv8_vminnm_NNNuge_rev:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vldr d16, .LCPI23_0
; CHECK-NEXT:    vldr d17, .LCPI23_1
; CHECK-NEXT:    vminnm.f64 d16, d0, d16
; CHECK-NEXT:    vminnm.f64 d0, d16, d17
; CHECK-NEXT:    bx lr
; CHECK-NEXT:    .p2align 3
; CHECK-NEXT:  @ %bb.1:
; CHECK-NEXT:  .LCPI23_0:
; CHECK-NEXT:    .long 0 @ double 78
; CHECK-NEXT:    .long 1079214080
; CHECK-NEXT:  .LCPI23_1:
; CHECK-NEXT:    .long 0 @ double 90
; CHECK-NEXT:    .long 1079410688
  %cmp1 = fcmp fast uge double 78., %b
  %cond1 = select nsz i1 %cmp1, double %b, double 78.
  %cmp2 = fcmp fast uge double %cond1, 90.
  %cond2 = select nsz i1 %cmp2, double 90., double %cond1
  ret double %cond2
}

define float @fparmv8_vmaxnm_NNNo(float %a) {
; CHECK-LABEL: fparmv8_vmaxnm_NNNo:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmov.f32 s2, #1.200000e+01
; CHECK-NEXT:    vldr s4, .LCPI24_0
; CHECK-NEXT:    vmaxnm.f32 s0, s0, s2
; CHECK-NEXT:    vmaxnm.f32 s0, s0, s4
; CHECK-NEXT:    bx lr
; CHECK-NEXT:    .p2align 2
; CHECK-NEXT:  @ %bb.1:
; CHECK-NEXT:  .LCPI24_0:
; CHECK-NEXT:    .long 0x42080000 @ float 34
  %cmp1 = fcmp fast ogt float %a, 12.
  %cond1 = select nsz i1 %cmp1, float %a, float 12.
  %cmp2 = fcmp fast ogt float 34., %cond1
  %cond2 = select nsz i1 %cmp2, float 34., float %cond1
  ret float %cond2
}

define float @fparmv8_vmaxnm_NNNoge(float %a) {
; CHECK-LABEL: fparmv8_vmaxnm_NNNoge:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vldr s2, .LCPI25_0
; CHECK-NEXT:    vldr s4, .LCPI25_1
; CHECK-NEXT:    vmaxnm.f32 s0, s0, s2
; CHECK-NEXT:    vmaxnm.f32 s0, s0, s4
; CHECK-NEXT:    bx lr
; CHECK-NEXT:    .p2align 2
; CHECK-NEXT:  @ %bb.1:
; CHECK-NEXT:  .LCPI25_0:
; CHECK-NEXT:    .long 0x42080000 @ float 34
; CHECK-NEXT:  .LCPI25_1:
; CHECK-NEXT:    .long 0x42600000 @ float 56
  %cmp1 = fcmp fast oge float %a, 34.
  %cond1 = select nsz i1 %cmp1, float %a, float 34.
  %cmp2 = fcmp fast oge float 56., %cond1
  %cond2 = select nsz i1 %cmp2, float 56., float %cond1
  ret float %cond2
}

define float @fparmv8_vmaxnm_NNNo_rev(float %a) {
; CHECK-LABEL: fparmv8_vmaxnm_NNNo_rev:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vldr s2, .LCPI26_0
; CHECK-NEXT:    vldr s4, .LCPI26_1
; CHECK-NEXT:    vmaxnm.f32 s0, s0, s2
; CHECK-NEXT:    vmaxnm.f32 s0, s0, s4
; CHECK-NEXT:    bx lr
; CHECK-NEXT:    .p2align 2
; CHECK-NEXT:  @ %bb.1:
; CHECK-NEXT:  .LCPI26_0:
; CHECK-NEXT:    .long 0x42600000 @ float 56
; CHECK-NEXT:  .LCPI26_1:
; CHECK-NEXT:    .long 0x429c0000 @ float 78
  %cmp1 = fcmp fast olt float %a, 56.
  %cond1 = select nsz i1 %cmp1, float 56., float %a
  %cmp2 = fcmp fast olt float 78., %cond1
  %cond2 = select nsz i1 %cmp2, float %cond1, float 78.
  ret float %cond2
}

define float @fparmv8_vmaxnm_NNNole_rev(float %a) {
; CHECK-LABEL: fparmv8_vmaxnm_NNNole_rev:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vldr s2, .LCPI27_0
; CHECK-NEXT:    vldr s4, .LCPI27_1
; CHECK-NEXT:    vmaxnm.f32 s0, s0, s2
; CHECK-NEXT:    vmaxnm.f32 s0, s0, s4
; CHECK-NEXT:    bx lr
; CHECK-NEXT:    .p2align 2
; CHECK-NEXT:  @ %bb.1:
; CHECK-NEXT:  .LCPI27_0:
; CHECK-NEXT:    .long 0x429c0000 @ float 78
; CHECK-NEXT:  .LCPI27_1:
; CHECK-NEXT:    .long 0x42b40000 @ float 90
  %cmp1 = fcmp fast ole float %a, 78.
  %cond1 = select nsz i1 %cmp1, float 78., float %a
  %cmp2 = fcmp fast ole float 90., %cond1
  %cond2 = select nsz i1 %cmp2, float %cond1, float 90.
  ret float %cond2
}

define float @fparmv8_vmaxnm_NNNu(float %b) {
; CHECK-LABEL: fparmv8_vmaxnm_NNNu:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmov.f32 s2, #1.200000e+01
; CHECK-NEXT:    vldr s4, .LCPI28_0
; CHECK-NEXT:    vmaxnm.f32 s0, s0, s2
; CHECK-NEXT:    vmaxnm.f32 s0, s0, s4
; CHECK-NEXT:    bx lr
; CHECK-NEXT:    .p2align 2
; CHECK-NEXT:  @ %bb.1:
; CHECK-NEXT:  .LCPI28_0:
; CHECK-NEXT:    .long 0x42080000 @ float 34
  %cmp1 = fcmp fast ugt float 12., %b
  %cond1 = select nsz i1 %cmp1, float 12., float %b
  %cmp2 = fcmp fast ugt float %cond1, 34.
  %cond2 = select nsz i1 %cmp2, float %cond1, float 34.
  ret float %cond2
}

define float @fparmv8_vmaxnm_NNNuge(float %b) {
; CHECK-LABEL: fparmv8_vmaxnm_NNNuge:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vldr s2, .LCPI29_0
; CHECK-NEXT:    vldr s4, .LCPI29_1
; CHECK-NEXT:    vmaxnm.f32 s0, s0, s2
; CHECK-NEXT:    vmaxnm.f32 s0, s0, s4
; CHECK-NEXT:    bx lr
; CHECK-NEXT:    .p2align 2
; CHECK-NEXT:  @ %bb.1:
; CHECK-NEXT:  .LCPI29_0:
; CHECK-NEXT:    .long 0x42080000 @ float 34
; CHECK-NEXT:  .LCPI29_1:
; CHECK-NEXT:    .long 0x42600000 @ float 56
  %cmp1 = fcmp fast uge float 34., %b
  %cond1 = select nsz i1 %cmp1, float 34., float %b
  %cmp2 = fcmp fast uge float %cond1, 56.
  %cond2 = select nsz i1 %cmp2, float %cond1, float 56.
  ret float %cond2
}

define float @fparmv8_vmaxnm_NNNu_rev(float %b) {
; CHECK-LABEL: fparmv8_vmaxnm_NNNu_rev:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vldr s2, .LCPI30_0
; CHECK-NEXT:    vldr s4, .LCPI30_1
; CHECK-NEXT:    vmaxnm.f32 s0, s0, s2
; CHECK-NEXT:    vmaxnm.f32 s0, s0, s4
; CHECK-NEXT:    bx lr
; CHECK-NEXT:    .p2align 2
; CHECK-NEXT:  @ %bb.1:
; CHECK-NEXT:  .LCPI30_0:
; CHECK-NEXT:    .long 0x42600000 @ float 56
; CHECK-NEXT:  .LCPI30_1:
; CHECK-NEXT:    .long 0x429c0000 @ float 78
  %cmp1 = fcmp fast ult float 56., %b
  %cond1 = select nsz i1 %cmp1, float %b, float 56.
  %cmp2 = fcmp fast ult float %cond1, 78.
  %cond2 = select nsz i1 %cmp2, float 78., float %cond1
  ret float %cond2
}

define double @fparmv8_vmaxnm_NNNule_rev( double %b) {
; CHECK-LABEL: fparmv8_vmaxnm_NNNule_rev:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vldr d16, .LCPI31_0
; CHECK-NEXT:    vldr d17, .LCPI31_1
; CHECK-NEXT:    vmaxnm.f64 d16, d0, d16
; CHECK-NEXT:    vmaxnm.f64 d0, d16, d17
; CHECK-NEXT:    bx lr
; CHECK-NEXT:    .p2align 3
; CHECK-NEXT:  @ %bb.1:
; CHECK-NEXT:  .LCPI31_0:
; CHECK-NEXT:    .long 0 @ double 78
; CHECK-NEXT:    .long 1079214080
; CHECK-NEXT:  .LCPI31_1:
; CHECK-NEXT:    .long 0 @ double 90
; CHECK-NEXT:    .long 1079410688
  %cmp1 = fcmp fast ule double 78., %b
  %cond1 = select nsz i1 %cmp1, double %b, double 78.
  %cmp2 = fcmp fast ule double %cond1, 90.
  %cond2 = select nsz i1 %cmp2, double 90., double %cond1
  ret double %cond2
}

define float @fparmv8_vminmaxnm_0(float %a) {
; CHECK-LABEL: fparmv8_vminmaxnm_0:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vldr s2, .LCPI32_0
; CHECK-NEXT:    vminnm.f32 s0, s0, s2
; CHECK-NEXT:    vmaxnm.f32 s0, s0, s2
; CHECK-NEXT:    bx lr
; CHECK-NEXT:    .p2align 2
; CHECK-NEXT:  @ %bb.1:
; CHECK-NEXT:  .LCPI32_0:
; CHECK-NEXT:    .long 0x00000000 @ float 0
  %cmp1 = fcmp fast olt float %a, 0.
  %cond1 = select nsz i1 %cmp1, float %a, float 0.
  %cmp2 = fcmp fast ogt float %cond1, 0.
  %cond2 = select nsz i1 %cmp2, float %cond1, float 0.
  ret float %cond2
}

define float @fparmv8_vminmaxnm_neg0(float %a) {
; CHECK-LABEL: fparmv8_vminmaxnm_neg0:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vldr s2, .LCPI33_0
; CHECK-NEXT:    vminnm.f32 s0, s0, s2
; CHECK-NEXT:    vmaxnm.f32 s0, s0, s2
; CHECK-NEXT:    bx lr
; CHECK-NEXT:    .p2align 2
; CHECK-NEXT:  @ %bb.1:
; CHECK-NEXT:  .LCPI33_0:
; CHECK-NEXT:    .long 0x80000000 @ float -0
  %cmp1 = fcmp fast olt float %a, -0.
  %cond1 = select nsz i1 %cmp1, float %a, float -0.
  %cmp2 = fcmp fast ugt float %cond1, -0.
  %cond2 = select nsz i1 %cmp2, float %cond1, float -0.
  ret float %cond2
}

define float @fparmv8_vminmaxnm_e_0(float %a) {
; CHECK-LABEL: fparmv8_vminmaxnm_e_0:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vldr s2, .LCPI34_0
; CHECK-NEXT:    vminnm.f32 s0, s0, s2
; CHECK-NEXT:    vmaxnm.f32 s0, s0, s2
; CHECK-NEXT:    bx lr
; CHECK-NEXT:    .p2align 2
; CHECK-NEXT:  @ %bb.1:
; CHECK-NEXT:  .LCPI34_0:
; CHECK-NEXT:    .long 0x00000000 @ float 0
  %cmp1 = fcmp fast ule float 0., %a
  %cond1 = select nsz i1 %cmp1, float 0., float %a
  %cmp2 = fcmp fast uge float 0., %cond1
  %cond2 = select nsz i1 %cmp2, float 0., float %cond1
  ret float %cond2
}

define float @fparmv8_vminmaxnm_e_neg0(float %a) {
; CHECK-LABEL: fparmv8_vminmaxnm_e_neg0:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vldr s2, .LCPI35_0
; CHECK-NEXT:    vminnm.f32 s0, s0, s2
; CHECK-NEXT:    vmaxnm.f32 s0, s0, s2
; CHECK-NEXT:    bx lr
; CHECK-NEXT:    .p2align 2
; CHECK-NEXT:  @ %bb.1:
; CHECK-NEXT:  .LCPI35_0:
; CHECK-NEXT:    .long 0x80000000 @ float -0
  %cmp1 = fcmp fast ule float -0., %a
  %cond1 = select nsz i1 %cmp1, float -0., float %a
  %cmp2 = fcmp fast oge float -0., %cond1
  %cond2 = select nsz i1 %cmp2, float -0., float %cond1
  ret float %cond2
}

declare <4 x float> @llvm.arm.neon.vminnm.v4f32(<4 x float>, <4 x float>) nounwind readnone
declare <2 x float> @llvm.arm.neon.vminnm.v2f32(<2 x float>, <2 x float>) nounwind readnone
declare <4 x float> @llvm.arm.neon.vmaxnm.v4f32(<4 x float>, <4 x float>) nounwind readnone
declare <2 x float> @llvm.arm.neon.vmaxnm.v2f32(<2 x float>, <2 x float>) nounwind readnone
