; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -mtriple=avr-unknown-unknown < %s | FileCheck -check-prefixes=CHECK,NONGNU %s
; RUN: llc -mtriple=avr-unknown-linux-gnu < %s | FileCheck -check-prefixes=CHECK,GNU %s

define { half, half } @test_sincos_f16(half %a) #0 {
; CHECK-LABEL: test_sincos_f16:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    push r12
; CHECK-NEXT:    push r13
; CHECK-NEXT:    push r14
; CHECK-NEXT:    push r15
; CHECK-NEXT:    push r16
; CHECK-NEXT:    push r17
; CHECK-NEXT:    rcall __extendhfsf2
; CHECK-NEXT:    mov r16, r22
; CHECK-NEXT:    mov r17, r23
; CHECK-NEXT:    mov r14, r24
; CHECK-NEXT:    mov r15, r25
; CHECK-NEXT:    rcall sin
; CHECK-NEXT:    rcall __truncsfhf2
; CHECK-NEXT:    mov r12, r24
; CHECK-NEXT:    mov r13, r25
; CHECK-NEXT:    mov r22, r16
; CHECK-NEXT:    mov r23, r17
; CHECK-NEXT:    mov r24, r14
; CHECK-NEXT:    mov r25, r15
; CHECK-NEXT:    rcall cos
; CHECK-NEXT:    rcall __truncsfhf2
; CHECK-NEXT:    mov r22, r12
; CHECK-NEXT:    mov r23, r13
; CHECK-NEXT:    pop r17
; CHECK-NEXT:    pop r16
; CHECK-NEXT:    pop r15
; CHECK-NEXT:    pop r14
; CHECK-NEXT:    pop r13
; CHECK-NEXT:    pop r12
; CHECK-NEXT:    ret
  %result = call { half, half } @llvm.sincos.f16(half %a)
  ret { half, half } %result
}

define half @test_sincos_f16_only_use_sin(half %a) #0 {
; CHECK-LABEL: test_sincos_f16_only_use_sin:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    rcall __extendhfsf2
; CHECK-NEXT:    rcall sin
; CHECK-NEXT:    rcall __truncsfhf2
; CHECK-NEXT:    ret
  %result = call { half, half } @llvm.sincos.f16(half %a)
  %result.0 = extractvalue { half, half } %result, 0
  ret half %result.0
}

define half @test_sincos_f16_only_use_cos(half %a) #0 {
; CHECK-LABEL: test_sincos_f16_only_use_cos:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    rcall __extendhfsf2
; CHECK-NEXT:    rcall cos
; CHECK-NEXT:    rcall __truncsfhf2
; CHECK-NEXT:    ret
  %result = call { half, half } @llvm.sincos.f16(half %a)
  %result.1 = extractvalue { half, half } %result, 1
  ret half %result.1
}

define { <2 x half>, <2 x half> } @test_sincos_v2f16(<2 x half> %a) #0 {
; CHECK-LABEL: test_sincos_v2f16:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    push r6
; CHECK-NEXT:    push r7
; CHECK-NEXT:    push r8
; CHECK-NEXT:    push r9
; CHECK-NEXT:    push r10
; CHECK-NEXT:    push r11
; CHECK-NEXT:    push r12
; CHECK-NEXT:    push r13
; CHECK-NEXT:    push r14
; CHECK-NEXT:    push r15
; CHECK-NEXT:    push r16
; CHECK-NEXT:    push r17
; CHECK-NEXT:    mov r16, r24
; CHECK-NEXT:    mov r17, r25
; CHECK-NEXT:    mov r24, r22
; CHECK-NEXT:    mov r25, r23
; CHECK-NEXT:    rcall __extendhfsf2
; CHECK-NEXT:    mov r14, r22
; CHECK-NEXT:    mov r15, r23
; CHECK-NEXT:    mov r12, r24
; CHECK-NEXT:    mov r13, r25
; CHECK-NEXT:    rcall sin
; CHECK-NEXT:    rcall __truncsfhf2
; CHECK-NEXT:    mov r10, r24
; CHECK-NEXT:    mov r11, r25
; CHECK-NEXT:    mov r24, r16
; CHECK-NEXT:    mov r25, r17
; CHECK-NEXT:    rcall __extendhfsf2
; CHECK-NEXT:    mov r16, r22
; CHECK-NEXT:    mov r17, r23
; CHECK-NEXT:    mov r8, r24
; CHECK-NEXT:    mov r9, r25
; CHECK-NEXT:    rcall sin
; CHECK-NEXT:    rcall __truncsfhf2
; CHECK-NEXT:    mov r6, r24
; CHECK-NEXT:    mov r7, r25
; CHECK-NEXT:    mov r22, r14
; CHECK-NEXT:    mov r23, r15
; CHECK-NEXT:    mov r24, r12
; CHECK-NEXT:    mov r25, r13
; CHECK-NEXT:    rcall cos
; CHECK-NEXT:    rcall __truncsfhf2
; CHECK-NEXT:    mov r14, r24
; CHECK-NEXT:    mov r15, r25
; CHECK-NEXT:    mov r22, r16
; CHECK-NEXT:    mov r23, r17
; CHECK-NEXT:    mov r24, r8
; CHECK-NEXT:    mov r25, r9
; CHECK-NEXT:    rcall cos
; CHECK-NEXT:    rcall __truncsfhf2
; CHECK-NEXT:    mov r18, r10
; CHECK-NEXT:    mov r19, r11
; CHECK-NEXT:    mov r20, r6
; CHECK-NEXT:    mov r21, r7
; CHECK-NEXT:    mov r22, r14
; CHECK-NEXT:    mov r23, r15
; CHECK-NEXT:    pop r17
; CHECK-NEXT:    pop r16
; CHECK-NEXT:    pop r15
; CHECK-NEXT:    pop r14
; CHECK-NEXT:    pop r13
; CHECK-NEXT:    pop r12
; CHECK-NEXT:    pop r11
; CHECK-NEXT:    pop r10
; CHECK-NEXT:    pop r9
; CHECK-NEXT:    pop r8
; CHECK-NEXT:    pop r7
; CHECK-NEXT:    pop r6
; CHECK-NEXT:    ret
  %result = call { <2 x half>, <2 x half> } @llvm.sincos.v2f16(<2 x half> %a)
  ret { <2 x half>, <2 x half> } %result
}

define { float, float } @test_sincos_f32(float %a) #0 {
; CHECK-LABEL: test_sincos_f32:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    push r10
; CHECK-NEXT:    push r11
; CHECK-NEXT:    push r12
; CHECK-NEXT:    push r13
; CHECK-NEXT:    push r14
; CHECK-NEXT:    push r15
; CHECK-NEXT:    push r16
; CHECK-NEXT:    push r17
; CHECK-NEXT:    mov r16, r24
; CHECK-NEXT:    mov r17, r25
; CHECK-NEXT:    mov r14, r22
; CHECK-NEXT:    mov r15, r23
; CHECK-NEXT:    rcall sin
; CHECK-NEXT:    mov r12, r22
; CHECK-NEXT:    mov r13, r23
; CHECK-NEXT:    mov r10, r24
; CHECK-NEXT:    mov r11, r25
; CHECK-NEXT:    mov r22, r14
; CHECK-NEXT:    mov r23, r15
; CHECK-NEXT:    mov r24, r16
; CHECK-NEXT:    mov r25, r17
; CHECK-NEXT:    rcall cos
; CHECK-NEXT:    mov r18, r12
; CHECK-NEXT:    mov r19, r13
; CHECK-NEXT:    mov r20, r10
; CHECK-NEXT:    mov r21, r11
; CHECK-NEXT:    pop r17
; CHECK-NEXT:    pop r16
; CHECK-NEXT:    pop r15
; CHECK-NEXT:    pop r14
; CHECK-NEXT:    pop r13
; CHECK-NEXT:    pop r12
; CHECK-NEXT:    pop r11
; CHECK-NEXT:    pop r10
; CHECK-NEXT:    ret
  %result = call { float, float } @llvm.sincos.f32(float %a)
  ret { float, float } %result
}

define { <2 x float>, <2 x float> } @test_sincos_v2f32(<2 x float> %a) #0 {
; CHECK-LABEL: test_sincos_v2f32:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    push r8
; CHECK-NEXT:    push r9
; CHECK-NEXT:    push r10
; CHECK-NEXT:    push r11
; CHECK-NEXT:    push r12
; CHECK-NEXT:    push r13
; CHECK-NEXT:    push r14
; CHECK-NEXT:    push r15
; CHECK-NEXT:    mov r14, r22
; CHECK-NEXT:    mov r15, r23
; CHECK-NEXT:    mov r12, r20
; CHECK-NEXT:    mov r13, r21
; CHECK-NEXT:    mov r10, r18
; CHECK-NEXT:    mov r11, r19
; CHECK-NEXT:    mov r8, r24
; CHECK-NEXT:    mov r9, r25
; CHECK-NEXT:    mov r22, r12
; CHECK-NEXT:    mov r23, r13
; CHECK-NEXT:    mov r24, r14
; CHECK-NEXT:    mov r25, r15
; CHECK-NEXT:    rcall cos
; CHECK-NEXT:    mov r30, r8
; CHECK-NEXT:    mov r31, r9
; CHECK-NEXT:    std Z+15, r25
; CHECK-NEXT:    std Z+14, r24
; CHECK-NEXT:    std Z+13, r23
; CHECK-NEXT:    std Z+12, r22
; CHECK-NEXT:    mov r22, r16
; CHECK-NEXT:    mov r23, r17
; CHECK-NEXT:    mov r24, r10
; CHECK-NEXT:    mov r25, r11
; CHECK-NEXT:    rcall cos
; CHECK-NEXT:    mov r30, r8
; CHECK-NEXT:    mov r31, r9
; CHECK-NEXT:    std Z+11, r25
; CHECK-NEXT:    std Z+10, r24
; CHECK-NEXT:    std Z+9, r23
; CHECK-NEXT:    std Z+8, r22
; CHECK-NEXT:    mov r22, r12
; CHECK-NEXT:    mov r23, r13
; CHECK-NEXT:    mov r24, r14
; CHECK-NEXT:    mov r25, r15
; CHECK-NEXT:    rcall sin
; CHECK-NEXT:    mov r30, r8
; CHECK-NEXT:    mov r31, r9
; CHECK-NEXT:    std Z+7, r25
; CHECK-NEXT:    std Z+6, r24
; CHECK-NEXT:    std Z+5, r23
; CHECK-NEXT:    std Z+4, r22
; CHECK-NEXT:    mov r22, r16
; CHECK-NEXT:    mov r23, r17
; CHECK-NEXT:    mov r24, r10
; CHECK-NEXT:    mov r25, r11
; CHECK-NEXT:    rcall sin
; CHECK-NEXT:    mov r30, r8
; CHECK-NEXT:    mov r31, r9
; CHECK-NEXT:    std Z+3, r25
; CHECK-NEXT:    std Z+2, r24
; CHECK-NEXT:    std Z+1, r23
; CHECK-NEXT:    st Z, r22
; CHECK-NEXT:    pop r15
; CHECK-NEXT:    pop r14
; CHECK-NEXT:    pop r13
; CHECK-NEXT:    pop r12
; CHECK-NEXT:    pop r11
; CHECK-NEXT:    pop r10
; CHECK-NEXT:    pop r9
; CHECK-NEXT:    pop r8
; CHECK-NEXT:    ret
  %result = call { <2 x float>, <2 x float> } @llvm.sincos.v2f32(<2 x float> %a)
  ret { <2 x float>, <2 x float> } %result
}

; FIXME: Broken
; define { double, double } @test_sincos_f64(double %a) #0 {
;   %result = call { double, double } @llvm.sincos.f64(double %a)
;   ret { double, double } %result
; }

; FIXME: Broken
; define { <2 x double>, <2 x double> } @test_sincos_v2f64(<2 x double> %a) #0 {
;   %result = call { <2 x double>, <2 x double> } @llvm.sincos.v2f64(<2 x double> %a)
;   ret { <2 x double>, <2 x double> } %result
; }

define { fp128, fp128 } @test_sincos_f128(fp128 %a) #0 {
; CHECK-LABEL: test_sincos_f128:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    push r2
; CHECK-NEXT:    push r3
; CHECK-NEXT:    push r4
; CHECK-NEXT:    push r5
; CHECK-NEXT:    push r6
; CHECK-NEXT:    push r7
; CHECK-NEXT:    push r28
; CHECK-NEXT:    push r29
; CHECK-NEXT:    in r28, 61
; CHECK-NEXT:    in r29, 62
; CHECK-NEXT:    sbiw r28, 34
; CHECK-NEXT:    in r0, 63
; CHECK-NEXT:    cli
; CHECK-NEXT:    out 62, r29
; CHECK-NEXT:    out 63, r0
; CHECK-NEXT:    out 61, r28
; CHECK-NEXT:    std Y+2, r23 ; 2-byte Folded Spill
; CHECK-NEXT:    std Y+1, r22 ; 2-byte Folded Spill
; CHECK-NEXT:    mov r2, r20
; CHECK-NEXT:    mov r3, r21
; CHECK-NEXT:    mov r4, r18
; CHECK-NEXT:    mov r5, r19
; CHECK-NEXT:    mov r6, r24
; CHECK-NEXT:    mov r7, r25
; CHECK-NEXT:    mov r24, r28
; CHECK-NEXT:    mov r25, r29
; CHECK-NEXT:    adiw r24, 3
; CHECK-NEXT:    rcall cosl
; CHECK-NEXT:    mov r24, r28
; CHECK-NEXT:    mov r25, r29
; CHECK-NEXT:    adiw r24, 19
; CHECK-NEXT:    mov r18, r4
; CHECK-NEXT:    mov r19, r5
; CHECK-NEXT:    mov r20, r2
; CHECK-NEXT:    mov r21, r3
; CHECK-NEXT:    ldd r22, Y+1 ; 2-byte Folded Reload
; CHECK-NEXT:    ldd r23, Y+2 ; 2-byte Folded Reload
; CHECK-NEXT:    rcall sinl
; CHECK-NEXT:    ldd r24, Y+17
; CHECK-NEXT:    ldd r25, Y+18
; CHECK-NEXT:    mov r30, r6
; CHECK-NEXT:    mov r31, r7
; CHECK-NEXT:    std Z+31, r25
; CHECK-NEXT:    std Z+30, r24
; CHECK-NEXT:    ldd r24, Y+15
; CHECK-NEXT:    ldd r25, Y+16
; CHECK-NEXT:    std Z+29, r25
; CHECK-NEXT:    std Z+28, r24
; CHECK-NEXT:    ldd r24, Y+13
; CHECK-NEXT:    ldd r25, Y+14
; CHECK-NEXT:    std Z+27, r25
; CHECK-NEXT:    std Z+26, r24
; CHECK-NEXT:    ldd r24, Y+11
; CHECK-NEXT:    ldd r25, Y+12
; CHECK-NEXT:    std Z+25, r25
; CHECK-NEXT:    std Z+24, r24
; CHECK-NEXT:    ldd r24, Y+9
; CHECK-NEXT:    ldd r25, Y+10
; CHECK-NEXT:    std Z+23, r25
; CHECK-NEXT:    std Z+22, r24
; CHECK-NEXT:    ldd r24, Y+7
; CHECK-NEXT:    ldd r25, Y+8
; CHECK-NEXT:    std Z+21, r25
; CHECK-NEXT:    std Z+20, r24
; CHECK-NEXT:    ldd r24, Y+5
; CHECK-NEXT:    ldd r25, Y+6
; CHECK-NEXT:    std Z+19, r25
; CHECK-NEXT:    std Z+18, r24
; CHECK-NEXT:    ldd r24, Y+3
; CHECK-NEXT:    ldd r25, Y+4
; CHECK-NEXT:    std Z+17, r25
; CHECK-NEXT:    std Z+16, r24
; CHECK-NEXT:    ldd r24, Y+33
; CHECK-NEXT:    ldd r25, Y+34
; CHECK-NEXT:    std Z+15, r25
; CHECK-NEXT:    std Z+14, r24
; CHECK-NEXT:    ldd r24, Y+31
; CHECK-NEXT:    ldd r25, Y+32
; CHECK-NEXT:    std Z+13, r25
; CHECK-NEXT:    std Z+12, r24
; CHECK-NEXT:    ldd r24, Y+29
; CHECK-NEXT:    ldd r25, Y+30
; CHECK-NEXT:    std Z+11, r25
; CHECK-NEXT:    std Z+10, r24
; CHECK-NEXT:    ldd r24, Y+27
; CHECK-NEXT:    ldd r25, Y+28
; CHECK-NEXT:    std Z+9, r25
; CHECK-NEXT:    std Z+8, r24
; CHECK-NEXT:    ldd r24, Y+25
; CHECK-NEXT:    ldd r25, Y+26
; CHECK-NEXT:    std Z+7, r25
; CHECK-NEXT:    std Z+6, r24
; CHECK-NEXT:    ldd r24, Y+23
; CHECK-NEXT:    ldd r25, Y+24
; CHECK-NEXT:    std Z+5, r25
; CHECK-NEXT:    std Z+4, r24
; CHECK-NEXT:    ldd r24, Y+21
; CHECK-NEXT:    ldd r25, Y+22
; CHECK-NEXT:    std Z+3, r25
; CHECK-NEXT:    std Z+2, r24
; CHECK-NEXT:    ldd r24, Y+19
; CHECK-NEXT:    ldd r25, Y+20
; CHECK-NEXT:    std Z+1, r25
; CHECK-NEXT:    st Z, r24
; CHECK-NEXT:    adiw r28, 34
; CHECK-NEXT:    in r0, 63
; CHECK-NEXT:    cli
; CHECK-NEXT:    out 62, r29
; CHECK-NEXT:    out 63, r0
; CHECK-NEXT:    out 61, r28
; CHECK-NEXT:    pop r29
; CHECK-NEXT:    pop r28
; CHECK-NEXT:    pop r7
; CHECK-NEXT:    pop r6
; CHECK-NEXT:    pop r5
; CHECK-NEXT:    pop r4
; CHECK-NEXT:    pop r3
; CHECK-NEXT:    pop r2
; CHECK-NEXT:    ret
  %result = call { fp128, fp128 } @llvm.sincos.f128(fp128 %a)
  ret { fp128, fp128 } %result
}

attributes #0 = { nounwind }

;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; GNU: {{.*}}
; NONGNU: {{.*}}
