/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

import java.util.Vector;
import javax.mail.event.MailEvent;

class EventQueue
implements Runnable {
    private QueueElement head;
    private QueueElement tail;
    private Thread qThread = new Thread(this);

    public EventQueue() {
        this.qThread.setDaemon(true);
        this.qThread.start();
    }

    public synchronized void enqueue(MailEvent mailEvent, Vector vector) {
        QueueElement queueElement = new QueueElement(mailEvent, vector);
        if (this.head == null) {
            this.head = queueElement;
            this.tail = queueElement;
        } else {
            queueElement.next = this.head;
            this.head.prev = queueElement;
            this.head = queueElement;
        }
        this.notify();
    }

    private synchronized QueueElement dequeue() throws InterruptedException {
        while (this.tail == null) {
            this.wait();
        }
        QueueElement queueElement = this.tail;
        this.tail = queueElement.prev;
        if (this.tail == null) {
            this.head = null;
        } else {
            this.tail.next = null;
        }
        queueElement.next = null;
        queueElement.prev = null;
        return queueElement;
    }

    public void run() {
        try {
            QueueElement queueElement;
            while ((queueElement = this.dequeue()) != null) {
                MailEvent mailEvent = queueElement.event;
                Vector vector = queueElement.vector;
                int n = 0;
                while (n < vector.size()) {
                    mailEvent.dispatch(vector.elementAt(n));
                    ++n;
                }
                queueElement = null;
                mailEvent = null;
                vector = null;
            }
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    void stop() {
        if (this.qThread != null) {
            this.qThread.interrupt();
            this.qThread = null;
        }
    }

    class QueueElement {
        QueueElement next;
        QueueElement prev;
        MailEvent event;
        Vector vector;

        QueueElement(MailEvent mailEvent, Vector vector) {
            EventQueue.this = EventQueue.this;
            this.event = mailEvent;
            this.vector = vector;
        }
    }
}

