// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                             avtMFIXOptions.C                              //
// ************************************************************************* //

#include <avtMFIXOptions.h>

#include <DBOptionsAttributes.h>

#include <string>


// ****************************************************************************
//  Function: GetMFIXReadOptions
//
//  Purpose:
//      Creates the options for MFIX readers.
//
//  Important Note:
//      The code below sets up empty options.  If your format
//      does not require read options, no modifications are
//      necessary.
//
//  Programmer: jyanovich -- generated by xml2avt
//  Creation:   Fri Aug 13 12:30:33 PDT 2010
//
// ****************************************************************************

DBOptionsAttributes *
GetMFIXReadOptions(void)
{
    DBOptionsAttributes *rv = new DBOptionsAttributes;
    rv->SetBool("Big Endian", true);
    rv->SetInt(N_X_DOMAINS, DEF_N_X_DOMAINS);
    rv->SetInt(N_Y_DOMAINS, DEF_N_Y_DOMAINS);
    rv->SetInt(N_Z_DOMAINS, DEF_N_Z_DOMAINS);
    return rv;
}


// ****************************************************************************
//  Function: GetMFIXWriteOptions
//
//  Purpose:
//      Creates the options for MFIX writers.
//
//  Important Note:
//      The code below sets up empty options.  If your format
//      does not require write options, no modifications are
//      necessary.
//
//  Programmer: jyanovich -- generated by xml2avt
//  Creation:   Fri Aug 13 12:30:33 PDT 2010
//
// ****************************************************************************

DBOptionsAttributes *
GetMFIXWriteOptions(void)
{
    DBOptionsAttributes *rv = new DBOptionsAttributes;
    return rv;
}
