%feature("docstring") PERSALYS::SimulationAnalysis
"Simulation reliability analysis."

// ----------------------------------------------------------------------

%feature("docstring") PERSALYS::SimulationAnalysis::setSeed
"Seed accessor.

Parameters
----------
seed : int
    Seed value"

// ----------------------------------------------------------------------

%feature("docstring") PERSALYS::SimulationAnalysis::getSeed
"Seed accessor.

Returns
-------
seed : int
    Seed value"

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::SimulationAnalysis::getFailedInputSample
"Failed input sample accessor.

Returns
-------
sample : :py:class:`openturns.Sample`
    Sample with the failed input values"

// ----------------------------------------------------------------------

%feature("docstring") PERSALYS::SimulationAnalysis::getBlockSize
"Block size accessor.

Returns
-------
blockSize : positive int
    Number of terms analysed together.
    It is set by default to 1."

// ----------------------------------------------------------------------

%feature("docstring") PERSALYS::SimulationAnalysis::setBlockSize
"Block size accessor.

Parameters
----------
blockSize : positive int
    Number of terms analysed together.
    It is set by default to 1."

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::SimulationAnalysis::getDesignOfExperiment
"Design of experiments accessor.

Returns
-------
design : :class:`~persalys.DesignOfExperiment`
    Design of experiments, result of the analysis"

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::SimulationAnalysis::getErrorDescription
"Design of experiments accessor.

Returns
-------
errorDesc : :class:`~openturns.Description`
    :class:`~openturns.Description` containing messages from failed points."
