# Instruction to build libHaru from internal package source
INCLUDE(ExternalProject)
SET(EXTRA "")
IF(APPLE)
   SET(EXTRA  -DCMAKE_INSTALL_NAME_DIR=${CMAKE_INSTALL_PREFIX}/lib)
ENDIF(APPLE)

IF(NOT STANDALONE)
  SET(EXTRA ${EXTRA} -DBUILD_SHARED_LIBS=ON)
ENDIF(NOT STANDALONE)

EXTERNALPROJECT_ADD(libPCRE
		URL file://${PROJECT_SOURCE_DIR}/extern/pcre-8.45.tar.bz2
		PREFIX ${CMAKE_CURRENT_BINARY_DIR}/libPCRE
		CMAKE_ARGS -DCMAKE_INSTALL_PREFIX:PATH=${CMAKE_CURRENT_BINARY_DIR}/libPCRE
			   -DPCRE_BUILD_TESTS=OFF
			   -DPCRE_BUILD_PCREGREP=OFF
			   -DPCRE_BUILD_PCRECPP=OFF
			   ${EXTRA}
		)

ExternalProject_Get_Property(libPCRE install_dir)
include_directories(${CMAKE_CURRENT_BINARY_DIR}/libPCRE/include)

MESSAGE( STATUS "libPCRE will be built in ${install_dir}" )

#SET( PCRE_LIBRARY_DIRS ${CMAKE_CURRENT_BINARY_DIR}/libHDF5/lib PATH)
# Set uncached variables as per standard.
# 	  set(hdf5_FOUND ON)
SET(PCRE_INCLUDE_DIR ${CMAKE_CURRENT_BINARY_DIR}/libPCRE/include CACHE PATH "PCRE include directory" FORCE)

IF(STANDALONE)
  SET(PCRE_LIBRARY ${CMAKE_CURRENT_BINARY_DIR}/libPCRE/lib64/libpcre${CMAKE_STATIC_LIBRARY_SUFFIX}
      CACHE STRING "PCRE libraries" FORCE)
ELSE(STANDALONE)
  SET(PCRE_LIBRARY ${CMAKE_CURRENT_BINARY_DIR}/libPCRE/lib64/libpcre${CMAKE_SHARED_LIBRARY_SUFFIX}
		  CACHE STRING "PCRE libraries" FORCE
	)
  INSTALL(DIRECTORY ${CMAKE_CURRENT_BINARY_DIR}/libPCRE/lib64
          DESTINATION ./
          USE_SOURCE_PERMISSIONS
					FILES_MATCHING PATTERN "*${CMAKE_SHARED_LIBRARY_SUFFIX}*"
	)
ENDIF(STANDALONE)

MARK_AS_ADVANCED(PCRE_INCLUDE_DIR PCRE_LIBRARY PCRE_LIBRARIES)
