/*
 *  R : A Computer Language for Statistical Data Analysis
 *  Copyright (C) 2005-2021   The R Core Team
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, a copy is available at
 *  https://www.R-project.org/Licenses/
 */

/* R i18n fake locale functions. */
enum { MB_Default, MB_ja_JP, MB_ko_KR, MB_zh_SG, MB_zh_CN, MB_zh_HK,
       MB_zh_TW, MB_SIZE };

struct interval {
    int first;
    int last;
};

/* ------------------- wcwidth -------------------- */
struct interval_wcwidth {
    int first;
    int last;
    char mb[MB_SIZE];
};

/* Background info for the first column is in
   http://www.unicode.org/Public/UCD/latest/ucd/EastAsianWidth.txt
*/

/* Anything not in this table nor the zero-width one is width one */

/* glibc treats the ARIB STD 24 speed limit numbers U+3248-324F and the I Ching
 * hexagrams U+4DC0-4DFF as wide, so we do too.
 */

static const struct interval_wcwidth table_wcwidth[] = {
    {0xa1,0xa1,{1,2,2,1,2,1,1}}, // 'East Asian' ambiguous
    {0xa2,0xa3,{1,2,1,1,1,2,1}},
    {0xa4,0xa4,{1,2,2,2,2,1,1}}, // EA ambiguous
    {0xa5,0xa5,{1,1,1,1,1,2,1}},
    {0xa6,0xa6,{1,2,1,1,1,1,1}},
    {0xa7,0xa7,{1,2,2,2,2,2,2}}, // EA ambiguous
    {0xa8,0xa8,{1,2,2,2,2,1,1}}, // EA ambiguous
    {0xa9,0xa9,{1,2,1,1,1,1,1}},
    {0xaa,0xaa,{1,2,2,1,2,1,1}}, // EA ambiguous
    {0xac,0xac,{1,2,1,1,1,1,1}},
    {0xad,0xad,{1,1,2,1,2,1,1}},
    {0xae,0xae,{1,2,2,1,2,1,1}}, // EA ambiguous
    {0xaf,0xaf,{1,2,1,1,1,1,2}},
    {0xb0,0xb1,{1,2,2,2,2,2,2}}, // EA ambiguous
    {0xb2,0xb3,{1,1,2,1,2,1,1}}, // EA ambiguous
    {0xb4,0xb4,{1,2,2,1,2,1,1}}, // EA ambiguous
    {0xb6,0xb6,{1,2,2,1,2,1,1}}, // EA ambiguous
    {0xb7,0xb7,{1,1,2,2,2,2,2}}, // EA ambiguous
    {0xb8,0xb8,{1,2,2,1,2,1,1}}, // EA ambiguous
    {0xb9,0xb9,{1,1,2,1,2,1,1}}, // EA ambiguous
    {0xba,0xba,{1,2,2,1,2,1,1}}, // EA ambiguous
    {0xbc,0xbe,{1,1,2,1,2,1,1}}, // EA ambiguous
    {0xbf,0xbf,{1,2,2,1,2,1,1}}, // EA ambiguous
    {0xc0,0xc5,{1,2,1,1,1,1,1}},
    {0xc6,0xc6,{1,2,2,1,2,1,1}}, // EA ambiguous
    {0xc7,0xcf,{1,2,1,1,1,1,1}},
    {0xd0,0xd0,{1,1,2,1,2,1,1}}, // EA ambiguous
    {0xd1,0xd6,{1,2,1,1,1,1,1}},
    {0xd7,0xd7,{1,2,2,2,2,2,2}}, // EA ambiguous
    {0xd8,0xd8,{1,2,2,1,2,1,1}}, // EA ambiguous
    {0xd9,0xdd,{1,2,1,1,1,1,1}},
    {0xde,0xdf,{1,2,2,1,2,1,1}}, // 0xde is EA ambiguous
#ifdef					Win32
    {0xe0,0xe1,{1,2,1,2,1,1,1}}, // EA ambiguous
#else					/* Win32 */
    {0xe0,0xe1,{1,2,1,2,2,1,1}},
#endif					/* Win32 */
    {0xe2,0xe5,{1,2,1,1,1,1,1}},
    {0xe6,0xe6,{1,2,2,1,2,1,1}}, // EA ambiguous
    {0xe7,0xe7,{1,2,1,1,1,1,1}},
#ifdef					Win32
    {0xe8,0xea,{1,2,1,2,1,1,1}}, // EA ambiguous
#else					/* Win32 */
    {0xe8,0xea,{1,2,1,2,2,1,1}},
#endif					/* Win32 */
    {0xeb,0xeb,{1,2,1,1,1,1,1}},
#ifdef					Win32
    {0xec,0xed,{1,2,1,2,1,1,1}}, // EA ambiguous
#else					/* Win32 */
    {0xec,0xed,{1,2,1,2,2,1,1}},
#endif					/* Win32 */
    {0xee,0xef,{1,2,1,1,1,1,1}},
    {0xf0,0xf0,{1,2,2,1,2,1,1}}, // EA ambiguous
    {0xf1,0xf1,{1,2,1,1,1,1,1}},
#ifdef					Win32
    {0xf2,0xf3,{1,2,1,2,1,1,1}}, // EA ambiguous
#else					/* Win32 */
    {0xf2,0xf3,{1,2,1,2,2,1,1}},
#endif					/* Win32 */
    {0xf4,0xf6,{1,2,1,1,1,1,1}},
    {0xf7,0xf7,{1,2,2,2,2,2,2}}, // EA ambiguous
    {0xf8,0xf8,{1,2,2,1,2,1,1}}, // EA ambiguous
#ifdef					Win32
    {0xf9,0xfa,{1,2,1,2,1,1,1}}, // EA ambiguous
#else					/* Win32 */
    {0xf9,0xfa,{1,2,1,2,2,1,1}},
#endif					/* Win32 */
    {0xfb,0xfb,{1,2,1,1,1,1,1}},
#ifdef					Win32
    {0xfc,0xfc,{1,2,1,2,1,1,1}}, // EA ambiguous
#else					/* Win32 */
    {0xfc,0xfc,{1,2,1,2,2,1,1}},
#endif					/* Win32 */
    {0xfd,0xfd,{1,2,1,1,1,1,1}},
    {0xfe,0xfe,{1,2,2,1,2,1,1}}, // EA ambiguous
    {0xff,0x100,{1,2,1,1,1,1,1}},
#ifdef					Win32
    {0x101,0x101,{1,2,1,2,1,1,1}}, // EA ambiguous
#else					/* Win32 */
    {0x101,0x101,{1,2,1,2,2,1,1}},
#endif					/* Win32 */
    {0x102,0x110,{1,2,1,1,1,1,1}},
    {0x111,0x111,{1,2,2,1,2,1,1}}, // EA ambiguous
    {0x112,0x112,{1,2,1,1,1,1,1}},
#ifdef					Win32
    {0x113,0x113,{1,2,1,2,1,1,1}}, // EA ambiguous
#else					/* Win32 */
    {0x113,0x113,{1,2,1,2,2,1,1}},
#endif					/* Win32 */
    {0x116,0x11a,{1,2,1,1,1,1,1}},
#ifdef					Win32
    {0x11b,0x11b,{1,2,1,2,1,1,1}}, // EA ambiguous
#else					/* Win32 */
    {0x11b,0x11b,{1,2,1,2,2,1,1}},
#endif					/* Win32 */
    {0x11c,0x122,{1,2,1,1,1,1,1}},
    {0x124,0x125,{1,2,1,1,1,1,1}},
    {0x126,0x127,{1,2,2,1,2,1,1}}, // EA ambiguous
    {0x128,0x12a,{1,2,1,1,1,1,1}},
#ifdef					Win32
    {0x12b,0x12b,{1,2,1,2,1,1,1}}, // EA ambiguous
#else					/* Win32 */
    {0x12b,0x12b,{1,2,1,2,2,1,1}},
#endif					/* Win32 */
    {0x12e,0x130,{1,2,1,1,1,1,1}},
    {0x131,0x133,{1,2,2,1,2,1,1}}, // EA ambiguous
    {0x134,0x137,{1,2,1,1,1,1,1}},
    {0x138,0x138,{1,2,2,1,2,1,1}}, // EA ambiguous
    {0x139,0x13e,{1,2,1,1,1,1,1}},
    {0x13f,0x142,{1,2,2,1,2,1,1}}, // EA ambiguous
    {0x143,0x143,{1,2,1,1,1,1,1}},
#ifdef					Win32
    {0x144,0x144,{1,2,1,2,1,1,1}}, // EA ambiguous
#else					/* Win32 */
    {0x144,0x144,{1,2,1,2,2,1,1}},
#endif					/* Win32 */
    {0x145,0x147,{1,2,1,1,1,1,1}},
#ifdef					Win32
    {0x148,0x148,{1,2,1,2,1,1,1}}, // EA ambiguous
#else					/* Win32 */
    {0x148,0x148,{1,2,1,2,2,1,1}},
#endif					/* Win32 */
    {0x149,0x14b,{1,2,2,1,2,1,1}},
    {0x14c,0x14c,{1,2,1,1,1,1,1}},
#ifdef					Win32
    {0x14d,0x14d,{1,2,1,2,1,1,1}}, // EA ambiguous
#else					/* Win32 */
    {0x14d,0x14d,{1,2,1,2,2,1,1}},
#endif					/* Win32 */
    {0x150,0x151,{1,2,1,1,1,1,1}},
    {0x152,0x153,{1,2,2,1,2,1,1}}, // EA ambiguous
    {0x154,0x165,{1,2,1,1,1,1,1}},
    {0x166,0x167,{1,2,2,1,2,1,1}}, // EA ambiguous
    {0x168,0x16a,{1,2,1,1,1,1,1}},
#ifdef					Win32
    {0x16b,0x16b,{1,2,1,2,1,1,1}}, // EA ambiguous
#else					/* Win32 */
    {0x16b,0x16b,{1,2,1,2,2,1,1}},
#endif					/* Win32 */
    {0x16c,0x17e,{1,2,1,1,1,1,1}},
    {0x1cd,0x1cd,{1,2,1,1,1,1,1}},
#ifdef					Win32
    {0x1ce,0x1ce,{1,2,1,2,1,1,1}}, // EA ambiguous
#else					/* Win32 */
    {0x1ce,0x1ce,{1,2,1,2,2,1,1}},
#endif					/* Win32 */
    {0x1cf,0x1cf,{1,2,1,1,1,1,1}},
#ifdef					Win32
    {0x1d0,0x1d0,{1,2,1,2,1,1,1}}, // EA ambiguous
#else					/* Win32 */
    {0x1d0,0x1d0,{1,2,1,2,2,1,1}},
#endif					/* Win32 */
    {0x1d1,0x1d1,{1,2,1,1,1,1,1}},
#ifdef					Win32
    {0x1d2,0x1d2,{1,2,1,2,1,1,1}}, // EA ambiguous
#else					/* Win32 */
    {0x1d2,0x1d2,{1,2,1,2,2,1,1}},
#endif					/* Win32 */
    {0x1d3,0x1d3,{1,2,1,1,1,1,1}},
#ifdef					Win32
    {0x1d4,0x1d4,{1,2,1,2,1,1,1}}, // EA ambiguous
#else					/* Win32 */
    {0x1d4,0x1d4,{1,2,1,2,2,1,1}},
#endif					/* Win32 */
    {0x1d5,0x1d5,{1,2,1,1,1,1,1}},
#ifdef					Win32
    {0x1d6,0x1d6,{1,2,1,2,1,1,1}}, // EA ambiguous
#else					/* Win32 */
    {0x1d6,0x1d6,{1,2,1,2,2,1,1}},
#endif					/* Win32 */
    {0x1d7,0x1d7,{1,2,1,1,1,1,1}},
#ifdef					Win32
    {0x1d8,0x1d8,{1,2,1,2,1,1,1}}, // EA ambiguous
#else					/* Win32 */
    {0x1d8,0x1d8,{1,2,1,2,2,1,1}},
#endif					/* Win32 */
    {0x1d9,0x1d9,{1,2,1,1,1,1,1}},
#ifdef					Win32
    {0x1da,0x1da,{1,2,1,2,1,1,1}}, // EA ambiguous
#else					/* Win32 */
    {0x1da,0x1da,{1,2,1,2,2,1,1}},
#endif					/* Win32 */
    {0x1db,0x1db,{1,2,1,1,1,1,1}},
#ifdef					Win32
    {0x1dc,0x1dc,{1,2,1,2,1,1,1}}, // EA ambiguous
#else					/* Win32 */
    {0x1dc,0x1dc,{1,2,1,2,2,1,1}},
#endif					/* Win32 */
    {0x1f5,0x1f5,{1,2,1,1,1,1,1}},
#ifdef					Win32
    {0x251,0x251,{1,1,1,2,1,1,1}}, // EA ambiguous
#else					/* Win32 */
    {0x251,0x251,{1,1,1,2,2,1,1}},
#endif					/* Win32 */
#ifdef					Win32
    {0x261,0x261,{1,1,1,2,1,1,1}}, // EA ambiguous
#else					/* Win32 */
    {0x261,0x261,{1,1,1,2,2,1,1}},
#endif					/* Win32 */
    {0x2c4,0x2c4,{1,1,1,1,2,1,1}}, // EA ambiguous
    {0x2c7,0x2c7,{1,2,2,2,2,1,2}}, // EA ambiguous
    {0x2c9,0x2cb,{1,1,1,2,2,1,2}}, // EA ambiguous
    {0x2cd,0x2cd,{1,1,1,1,2,1,2}}, // EA ambiguous
    {0x2d0,0x2d0,{1,1,2,1,2,1,1}}, // EA ambiguous
    {0x2d8,0x2d8,{1,2,2,1,2,1,1}}, // EA ambiguous
    {0x2d9,0x2d9,{1,2,2,2,2,1,2}},
    {0x2da,0x2db,{1,2,2,1,2,1,1}},
    {0x2dd,0x2dd,{1,2,2,1,2,1,1}}, // EA ambiguous
    {0x2df,0x2df,{1,1,1,1,2,1,1}}, // EA ambiguous
    {0x384,0x386,{1,2,1,1,1,1,1}},
    {0x388,0x38a,{1,2,1,1,1,1,1}},
    {0x38c,0x38c,{1,2,1,1,1,1,1}},
    {0x38e,0x390,{1,2,1,1,1,1,1}},
    {0x391,0x3a1,{1,2,2,2,2,1,2}}, // EA ambiguous
    {0x3a3,0x3a9,{1,2,2,2,2,1,2}}, // EA ambiguous
    {0x3aa,0x3b0,{1,2,1,1,1,1,1}},
    {0x3b1,0x3c1,{1,2,2,2,2,1,2}}, // EA ambiguous
    {0x3c2,0x3c2,{1,2,1,1,1,1,1}},
    {0x3c3,0x3c9,{1,2,2,2,2,1,2}}, // EA ambiguous
    {0x3ca,0x3ce,{1,2,1,1,1,1,1}},
    {0x401,0x401,{1,2,2,2,2,1,1}}, // EA ambiguous
    {0x402,0x40c,{1,2,1,1,1,1,1}},
    {0x40e,0x40f,{1,2,1,1,1,1,1}},
    {0x410,0x44f,{1,2,2,2,2,1,1}}, // Greek and Cyrillic,  EA ambiguous
    {0x451,0x451,{1,2,2,2,2,1,1}}, // EA ambiguous
    {0x452,0x45c,{1,2,1,1,1,1,1}},
    {0x45e,0x45f,{1,2,1,1,1,1,1}},
    {0x1100,0x115f,{2,2,2,2,2,2,2}}, // Hangul
    {0x2010,0x2010,{1,2,1,2,2,1,1}}, // EA ambiguous
    {0x2013,0x2014,{1,1,1,2,2,2,2}}, // EA ambiguous
    {0x2015,0x2015,{1,2,2,2,2,1,1}}, // EA ambiguous
    {0x2016,0x2016,{1,2,1,2,2,1,2}}, // EA ambiguous
    {0x2018,0x2019,{1,2,2,2,2,2,2}}, // EA ambiguous
    {0x201c,0x201d,{1,2,2,2,2,2,2}}, // EA ambiguous
    {0x2020,0x2021,{1,2,2,1,2,1,1}}, // EA ambiguous
    {0x2022,0x2022,{1,1,1,1,2,2,1}}, // EA ambiguous
    {0x2024,0x2024,{1,1,1,1,2,1,1}}, // EA ambiguous
    {0x2025,0x2026,{1,2,2,2,2,2,2}}, // EA ambiguous
    {0x2027,0x2027,{1,1,1,1,2,1,2}}, // EA ambiguous
    {0x2030,0x2030,{1,2,2,2,2,1,1}}, // permille
    {0x2032,0x2032,{1,2,2,2,2,2,2}}, // EA ambiguous
    {0x2033,0x2033,{1,2,2,2,2,1,1}}, // EA ambiguous
    {0x2035,0x2035,{1,1,1,2,2,2,2}}, // EA ambiguous
    {0x203b,0x203b,{1,2,2,2,2,2,2}}, // EA ambiguous
    {0x203e,0x203e,{1,1,1,1,2,2,2}}, // EA ambiguous
    {0x2074,0x2074,{1,1,2,1,2,1,1}}, // EA ambiguous
    {0x207f,0x207f,{1,1,2,1,2,1,1}}, // EA ambiguous
    {0x2081,0x2084,{1,1,2,1,2,1,1}}, // EA ambiguous
    {0x20ac,0x20ac,{1,1,2,1,2,1,2}}, // EA ambiguous
    {0x2103,0x2103,{1,2,2,2,2,2,2}}, // EA ambiguous
    {0x2105,0x2105,{1,1,1,2,2,2,2}}, // EA ambiguous
    {0x2109,0x2109,{1,1,2,2,2,2,2}}, // EA ambiguous
    {0x2113,0x2113,{1,1,2,1,2,1,1}}, // EA ambiguous
    {0x2116,0x2116,{1,2,2,2,2,2,1}}, // EA ambiguous
    {0x2121,0x2121,{1,1,2,2,2,2,1}}, // EA ambiguous
    {0x2122,0x2122,{1,2,2,1,2,1,1}}, // EA ambiguous
    {0x2126,0x2126,{1,1,2,1,2,1,1}}, // EA ambiguous
    {0x212b,0x212b,{1,2,2,1,2,1,1}}, // EA ambiguous
    {0x2153,0x2154,{1,1,2,1,2,1,1}}, // EA ambiguous
    {0x215b,0x215e,{1,1,2,1,2,1,1}}, // EA ambiguous
    {0x2160,0x2169,{1,1,2,2,2,2,2}}, // EA ambiguous
    {0x216a,0x216b,{1,1,1,2,2,1,1}}, // EA ambiguous
    {0x2170,0x2179,{1,1,2,2,2,2,2}}, // EA ambiguous
    {0x2190,0x2193,{1,2,2,2,2,2,2}}, // EA ambiguous
    {0x2194,0x2195,{1,1,2,1,2,1,1}}, // EA ambiguous
    {0x2196,0x2199,{1,1,2,2,2,2,2}}, // EA ambiguous
    {0x21b8,0x21b9,{1,1,1,1,2,1,1}}, // EA ambiguous
    {0x21d2,0x21d2,{1,2,2,1,2,1,1}}, // EA ambiguous
    {0x21d4,0x21d4,{1,2,2,1,2,1,1}}, // EA ambiguous
    {0x21e7,0x21e7,{1,1,1,1,2,1,1}}, // EA ambiguous
    {0x2200,0x2200,{1,2,2,1,2,1,1}}, // EA ambiguous
    {0x2202,0x2203,{1,2,2,1,2,1,1}}, // EA ambiguous
    {0x2207,0x2207,{1,2,2,1,2,1,1}}, // EA ambiguous
    {0x2208,0x2208,{1,2,2,2,2,1,1}}, // EA ambiguous
    {0x220b,0x220b,{1,2,2,1,2,1,1}}, // EA ambiguous
    {0x220f,0x220f,{1,1,2,2,2,1,1}}, // EA ambiguous
    {0x2211,0x2211,{1,1,2,2,2,1,1}}, // EA ambiguous
    {0x2212,0x2212,{1,2,1,1,1,1,1}}, // minus sign
    {0x2215,0x2215,{1,1,1,2,2,1,2}}, // EA ambiguous
    {0x221a,0x221a,{1,2,2,2,2,2,2}}, // EA ambiguous
    {0x221d,0x221d,{1,2,2,2,2,1,1}}, // EA ambiguous
    {0x221e,0x221e,{1,2,2,2,2,2,2}}, // EA ambiguous
    {0x221f,0x221f,{1,1,1,2,2,2,2}}, // EA ambiguous
    {0x2220,0x2220,{1,2,2,2,2,2,2}}, // EA ambiguous
    {0x2223,0x2223,{1,1,1,2,2,2,2}}, // EA ambiguous
    {0x2225,0x2225,{1,1,2,2,2,2,2}}, // EA ambiguous
    {0x2227,0x2228,{1,2,2,2,2,1,1}}, // EA ambiguous
    {0x2229,0x222b,{1,2,2,2,2,2,2}}, // EA ambiguous
    {0x222c,0x222c,{1,2,2,1,2,1,1}}, // EA ambiguous
    {0x222e,0x222e,{1,1,2,2,2,2,2}}, // EA ambiguous
    {0x2234,0x2235,{1,2,2,2,2,2,2}}, // EA ambiguous
    {0x2236,0x2237,{1,1,1,2,2,1,1}}, // EA ambiguous
    {0x223c,0x223c,{1,1,2,1,2,2,2}}, // EA ambiguous
    {0x223d,0x223d,{1,2,2,2,2,1,1}}, // EA ambiguous
    {0x2248,0x2248,{1,1,1,2,2,1,1}}, // EA ambiguous
    {0x224c,0x224c,{1,1,1,2,2,1,1}}, // EA ambiguous
    {0x2252,0x2252,{1,2,2,2,2,2,2}}, // EA ambiguous
    {0x2260,0x2261,{1,2,2,2,2,2,2}}, // EA ambiguous
    {0x2264,0x2265,{1,1,2,2,2,1,1}}, // EA ambiguous
    {0x2266,0x2267,{1,2,1,2,2,2,2}}, // EA ambiguous
    {0x226a,0x226b,{1,2,2,1,2,1,1}}, // EA ambiguous
    {0x226e,0x226f,{1,1,1,2,2,1,1}}, // EA ambiguous
    {0x2282,0x2283,{1,2,2,1,2,1,1}}, // EA ambiguous
    {0x2286,0x2287,{1,2,2,1,2,1,1}}, // EA ambiguous
    {0x2295,0x2295,{1,1,1,2,2,1,2}}, // EA ambiguous
    {0x2299,0x2299,{1,1,2,2,2,1,2}}, // EA ambiguous
    {0x22a5,0x22a5,{1,2,2,2,2,2,2}}, // EA ambiguous
    {0x22bf,0x22bf,{1,1,1,2,2,2,2}}, // EA ambiguous
    {0x2312,0x2312,{1,2,2,2,2,1,1}}, // EA ambiguous
    {0x231a,0x231b,{2,2,2,2,2,2,2}},
    {0x2329,0x232a,{2,2,2,2,2,2,2}}, // arrows (at least ends)
    {0x23e9,0x23ec,{2,2,2,2,2,2,2}},
    {0x23f0,0x23f0,{2,2,2,2,2,2,2}},
    {0x23f3,0x23f3,{2,2,2,2,2,2,2}},
    {0x2400,0x241f,{1,1,1,1,1,1,2}}, // control pictures
    {0x2421,0x2421,{1,1,1,1,1,1,2}},
    {0x2460,0x2469,{1,1,2,2,2,2,2}}, // EA ambiguous to 24e9
    {0x246a,0x246e,{1,1,2,1,2,1,1}},
    {0x246f,0x2473,{1,1,1,1,2,1,1}},
    {0x2474,0x247d,{1,1,2,2,2,2,2}},
    {0x247e,0x2482,{1,1,2,2,2,1,1}},
    {0x2483,0x249b,{1,1,1,2,2,1,1}},
    {0x249c,0x24b5,{1,1,2,1,2,1,1}},
    {0x24b6,0x24cf,{1,1,1,1,2,1,1}},
    {0x24d0,0x24e9,{1,1,2,1,2,1,1}},
    {0x24eb,0x24fe,{1,1,1,1,2,1,1}}, // EA ambiguous to 254b
    {0x2500,0x2500,{1,2,2,2,2,2,2}},
    {0x2501,0x2501,{1,2,2,2,2,1,1}},
    {0x2502,0x2502,{1,2,2,2,2,2,2}},
    {0x2503,0x2503,{1,2,2,2,2,1,1}},
    {0x2504,0x250b,{1,1,1,2,2,1,1}},
    {0x250c,0x250c,{1,2,2,2,2,2,2}},
    {0x250d,0x250e,{1,1,2,2,2,1,1}},
    {0x250f,0x250f,{1,2,2,2,2,1,1}},
    {0x2510,0x2510,{1,2,2,2,2,2,2}},
    {0x2511,0x2512,{1,1,2,2,2,1,1}},
    {0x2513,0x2513,{1,2,2,2,2,1,1}},
    {0x2514,0x2514,{1,2,2,2,2,2,2}},
    {0x2515,0x2516,{1,1,2,2,2,1,1}},
    {0x2517,0x2517,{1,2,2,2,2,1,1}},
    {0x2518,0x2518,{1,2,2,2,2,2,2}},
    {0x2519,0x251a,{1,1,2,2,2,1,1}},
    {0x251b,0x251b,{1,2,2,2,2,1,1}},
    {0x251c,0x251c,{1,2,2,2,2,2,2}},
    {0x251d,0x251d,{1,2,2,2,2,1,1}},
    {0x251e,0x251f,{1,1,2,2,2,1,1}},
    {0x2520,0x2520,{1,2,2,2,2,1,1}},
    {0x2521,0x2522,{1,1,2,2,2,1,1}},
    {0x2523,0x2523,{1,2,2,2,2,1,1}},
    {0x2524,0x2524,{1,2,2,2,2,2,2}},
    {0x2525,0x2525,{1,2,2,2,2,1,1}},
    {0x2526,0x2527,{1,1,2,2,2,1,1}},
    {0x2528,0x2528,{1,2,2,2,2,1,1}},
    {0x2529,0x252a,{1,1,2,2,2,1,1}},
    {0x252b,0x252b,{1,2,2,2,2,1,1}},
    {0x252c,0x252c,{1,2,2,2,2,2,2}},
    {0x252d,0x252e,{1,1,2,2,2,1,1}},
    {0x252f,0x2530,{1,2,2,2,2,1,1}},
    {0x2531,0x2532,{1,1,2,2,2,1,1}},
    {0x2533,0x2533,{1,2,2,2,2,1,1}},
    {0x2534,0x2534,{1,2,2,2,2,2,2}},
    {0x2535,0x2536,{1,1,2,2,2,1,1}},
    {0x2537,0x2538,{1,2,2,2,2,1,1}},
    {0x2539,0x253a,{1,1,2,2,2,1,1}},
    {0x253b,0x253b,{1,2,2,2,2,1,1}},
    {0x253c,0x253c,{1,2,2,2,2,2,2}},
    {0x253d,0x253e,{1,1,2,2,2,1,1}},
    {0x253f,0x253f,{1,2,2,2,2,1,1}},
    {0x2540,0x2541,{1,1,2,2,2,1,1}},
    {0x2542,0x2542,{1,2,2,2,2,1,1}},
    {0x2543,0x254a,{1,1,2,2,2,1,1}},
    {0x254b,0x254b,{1,2,2,2,2,1,1}},  // end of EA ambiguous
    {0x2550,0x2573,{1,1,1,2,2,2,2}}, // EA ambiguous
    {0x2574,0x2574,{1,1,1,1,1,1,2}},
    {0x2580,0x2580,{1,1,1,1,2,1,1}}, // EA ambiguous
    {0x2581,0x258f,{1,1,1,2,2,2,2}}, // EA ambiguous
    {0x2592,0x2592,{1,1,2,1,2,1,1}}, // EA ambiguous
    {0x2593,0x2593,{1,1,1,2,2,1,2}}, // EA ambiguous
    {0x2594,0x2595,{1,1,1,2,2,2,2}}, // EA ambiguous
    {0x25a0,0x25a1,{1,2,2,2,2,2,2}}, // EA ambiguous
    {0x25a3,0x25a9,{1,1,2,1,2,1,1}}, // EA ambiguous
    {0x25b2,0x25b3,{1,2,2,2,2,2,2}}, // EA ambiguous
    {0x25b6,0x25b7,{1,1,2,1,2,1,1}}, // EA ambiguous
    {0x25bc,0x25bd,{1,2,2,2,2,2,2}}, // EA ambiguous
    {0x25c0,0x25c1,{1,1,2,1,2,1,1}}, // EA ambiguous
    {0x25c6,0x25c7,{1,2,2,2,2,2,2}}, // EA ambiguous
    {0x25c8,0x25c8,{1,1,2,1,2,1,1}}, // EA ambiguous
    {0x25cb,0x25cb,{1,2,2,2,2,2,2}}, // EA ambiguous
    {0x25ce,0x25cf,{1,2,2,2,2,2,2}}, // EA ambiguous
    {0x25d0,0x25d1,{1,1,2,1,2,1,1}}, // EA ambiguous
    {0x25e2,0x25e5,{1,1,1,2,2,2,2}}, // EA ambiguous
    {0x25ef,0x25ef,{1,2,1,1,2,1,1}}, // EA ambiguous
    {0x25fd,0x25fe,{2,2,2,2,2,2,2}},
    {0x2605,0x2606,{1,2,2,2,2,2,2}}, // EA ambiguous
    {0x2609,0x2609,{1,1,1,2,2,2,2}}, // EA ambiguous
    {0x260e,0x260f,{1,1,2,1,2,1,1}}, // EA ambiguous
    {0x2614,0x2615,{2,2,2,2,2,2,2}},
    {0x261c,0x261c,{1,1,2,1,2,1,1}}, // EA ambiguous
    {0x261e,0x261e,{1,1,2,1,2,1,1}}, // EA ambiguous
    {0x2640,0x2640,{1,2,2,2,2,2,2}}, // EA ambiguous
    {0x2641,0x2641,{1,1,1,1,1,2,2}},
    {0x2642,0x2642,{1,2,2,2,2,2,2}}, // EA ambiguous
    {0x2648,0x2653,{2,2,2,2,2,2,2}},
    {0x2660,0x2661,{1,1,2,1,2,1,1}}, // EA ambiguous
    {0x2663,0x2665,{1,1,2,1,2,1,1}}, // EA ambiguous
    {0x2667,0x2669,{1,1,2,1,2,1,1}}, // EA ambiguous
    {0x266a,0x266a,{1,2,2,1,2,1,1}}, // EA ambiguous
    {0x266c,0x266c,{1,1,2,1,2,1,1}}, // EA ambiguous
    {0x266d,0x266d,{1,2,2,1,2,1,1}}, // EA ambiguous
    {0x266f,0x266f,{1,2,1,1,2,1,1}}, // EA ambiguous
    {0x267f,0x267f,{2,2,2,2,2,2,2}},
    {0x2693,0x2693,{2,2,2,2,2,2,2}},
    {0x26a1,0x26a1,{2,2,2,2,2,2,2}},
    {0x26aa,0x26ab,{2,2,2,2,2,2,2}},
    {0x26bd,0x26be,{2,2,2,2,2,2,2}},
    {0x26c4,0x26c5,{2,2,2,2,2,2,2}},
    {0x26ce,0x26ce,{2,2,2,2,2,2,2}},
    {0x26d4,0x26d4,{2,2,2,2,2,2,2}},
    {0x26ea,0x26ea,{2,2,2,2,2,2,2}},
    {0x26f2,0x26f3,{2,2,2,2,2,2,2}},
    {0x26f5,0x26f5,{2,2,2,2,2,2,2}},
    {0x26fa,0x26fa,{2,2,2,2,2,2,2}},
    {0x26fd,0x26fd,{2,2,2,2,2,2,2}},
    {0x2705,0x2705,{2,2,2,2,2,2,2}},
    {0x270a,0x270b,{2,2,2,2,2,2,2}},
    {0x2728,0x2728,{2,2,2,2,2,2,2}},
    {0x273d,0x273d,{1,1,1,1,2,2,1}},
    {0x273e,0x274b,{1,1,1,1,1,1,1}}, // EA ambiguous
    {0x274c,0x274c,{2,2,2,2,2,2,2}},
    {0x274e,0x274e,{2,2,2,2,2,2,2}},
    {0x2753,0x2755,{2,2,2,2,2,2,2}},
    {0x2757,0x2757,{2,2,2,2,2,2,2}},
    {0x2776,0x277f,{1,1,1,1,2,1,1}}, // EA ambiguous
    {0x2795,0x2797,{2,2,2,2,2,2,2}},
    {0x27b0,0x27b0,{2,2,2,2,2,2,2}},
    {0x27bf,0x27bf,{2,2,2,2,2,2,2}},
    {0x2b1b,0x2b1c,{2,2,2,2,2,2,2}},
    {0x2b50,0x2b50,{2,2,2,2,2,2,2}},
    {0x2b55,0x2b55,{2,2,2,2,2,2,2}},
    {0x2e80,0x2e99,{2,2,2,2,2,2,2}},
    {0x2e9b,0x2ef3,{2,2,2,2,2,2,2}},
    {0x2f00,0x2fd5,{2,2,2,2,2,2,2}},
    {0x2ff0,0x2ffb,{2,2,2,2,2,2,2}},
    {0x3000,0x3029,{2,2,2,2,2,2,2}},
    {0x302e,0x302f,{2,2,2,2,2,2,2}},
    {0x3030,0x303e,{2,2,2,2,2,2,2}},
    {0x3041,0x3096,{2,2,2,2,2,2,2}},
    {0x309b,0x30ff,{2,2,2,2,2,2,2}},
    {0x3105,0x312d,{2,2,2,2,2,2,2}},
    {0x312e,0x312f,{2,2,2,2,2,2,2}},
    {0x3131,0x318e,{2,2,2,2,2,2,2}},
    {0x3190,0x31ba,{2,2,2,2,2,2,2}},
    {0x31c0,0x31e3,{2,2,2,2,2,2,2}},
    {0x31f0,0x321e,{2,2,2,2,2,2,2}},
    {0x3220,0x32fe,{2,2,2,2,2,2,2}},
    {0x32ff,0x32ff,{2,2,2,2,2,2,2}},
    {0x3300,0x33ff,{2,2,2,2,2,2,2}},
    {0x3400,0x4db5,{2,2,2,2,2,2,2}}, // CJK Unified Ideographs Externsion A (to 4dbf)
    {0x4db6,0x4dbf,{2,2,2,2,2,2,2}},
    {0x4dc0,0x4dff,{2,2,2,2,2,2,2}},
    {0x4e00,0x9fcc,{2,2,2,2,2,2,2}}, // CJK Unified Ideographs (to 9fff)
    {0x9fcd,0x9fff,{2,2,2,2,2,2,2}},
    {0xa000,0xa48c,{2,2,2,2,2,2,2}},
    {0xa490,0xa4c6,{2,2,2,2,2,2,2}},
    {0xa960,0xa97c,{2,2,2,2,2,2,2}},
//    {0xa960,0xa97c,{2,2,2,2,2,2,2}},
    {0xac00,0xd7a3,{2,2,2,2,2,2,2}}, // Hangul
    {0xe000,0xe002,{1,1,1,1,2,1,1}}, // EA ambiguous to f8ff
    {0xe003,0xe003,{1,1,1,1,2,2,1}},
    {0xe004,0xe017,{1,1,1,1,2,1,1}},
    {0xe018,0xe018,{1,1,1,1,2,2,1}},
    {0xe019,0xe01a,{1,1,1,1,2,1,1}},
    {0xe01b,0xe01b,{1,1,1,1,2,2,1}},
    {0xe01c,0xe02c,{1,1,1,1,2,1,1}},
    {0xe02d,0xe02d,{1,1,1,1,2,2,1}},
    {0xe02e,0xe037,{1,1,1,1,2,1,1}},
    {0xe038,0xe038,{1,1,1,1,2,2,1}},
    {0xe039,0xe04b,{1,1,1,1,2,1,1}},
    {0xe04c,0xe04c,{1,1,1,1,2,2,1}},
    {0xe04d,0xe059,{1,1,1,1,2,1,1}},
    {0xe05a,0xe05a,{1,1,1,1,2,2,1}},
    {0xe05b,0xe093,{1,1,1,1,2,1,1}},
    {0xe094,0xe094,{1,1,1,1,2,2,1}},
    {0xe095,0xe098,{1,1,1,1,2,1,1}},
    {0xe099,0xe09a,{1,1,1,1,2,2,1}},
    {0xe09b,0xe0c4,{1,1,1,1,2,1,1}},
    {0xe0c5,0xe0c5,{1,1,1,1,2,2,1}},
    {0xe0c6,0xe0cf,{1,1,1,1,2,1,1}},
    {0xe0d0,0xe0d0,{1,1,1,1,2,2,1}},
    {0xe0d1,0xe0f1,{1,1,1,1,2,1,1}},
    {0xe0f2,0xe0f2,{1,1,1,1,2,2,1}},
    {0xe0f3,0xe0f8,{1,1,1,1,2,1,1}},
    {0xe0f9,0xe0f9,{1,1,1,1,2,2,1}},
    {0xe0fa,0xe0fc,{1,1,1,1,2,1,1}},
    {0xe0fd,0xe0fd,{1,1,1,1,2,2,1}},
    {0xe0fe,0xe105,{1,1,1,1,2,1,1}},
    {0xe106,0xe106,{1,1,1,1,2,2,1}},
    {0xe107,0xe108,{1,1,1,1,2,1,1}},
    {0xe109,0xe10a,{1,1,1,1,2,2,1}},
    {0xe10b,0xe12f,{1,1,1,1,2,1,1}},
    {0xe130,0xe130,{1,1,1,1,2,2,1}},
    {0xe131,0xe14f,{1,1,1,1,2,1,1}},
    {0xe150,0xe150,{1,1,1,1,2,2,1}},
    {0xe151,0xe153,{1,1,1,1,2,1,1}},
    {0xe154,0xe154,{1,1,1,1,2,2,1}},
    {0xe155,0xe15c,{1,1,1,1,2,1,1}},
    {0xe15d,0xe15d,{1,1,1,1,2,2,1}},
    {0xe15e,0xe167,{1,1,1,1,2,1,1}},
    {0xe168,0xe168,{1,1,1,1,2,2,1}},
    {0xe169,0xe169,{1,1,1,1,2,1,1}},
    {0xe16a,0xe16a,{1,1,1,1,2,2,1}},
    {0xe16b,0xe170,{1,1,1,1,2,1,1}},
    {0xe171,0xe171,{1,1,1,1,2,2,1}},
    {0xe172,0xe174,{1,1,1,1,2,1,1}},
    {0xe175,0xe175,{1,1,1,1,2,2,1}},
    {0xe176,0xe18e,{1,1,1,1,2,1,1}},
    {0xe18f,0xe18f,{1,1,1,1,2,2,1}},
    {0xe190,0xe1ba,{1,1,1,1,2,1,1}},
    {0xe1bb,0xe1bb,{1,1,1,1,2,2,1}},
    {0xe1bc,0xe1cb,{1,1,1,1,2,1,1}},
    {0xe1cc,0xe1cd,{1,1,1,1,2,2,1}},
    {0xe1ce,0xe1d6,{1,1,1,1,2,1,1}},
    {0xe1d7,0xe1d7,{1,1,1,1,2,2,1}},
    {0xe1d8,0xe1ee,{1,1,1,1,2,1,1}},
    {0xe1ef,0xe1ef,{1,1,1,1,2,2,1}},
    {0xe1f0,0xe1f1,{1,1,1,1,2,1,1}},
    {0xe1f2,0xe1f2,{1,1,1,1,2,2,1}},
    {0xe1f3,0xe1f9,{1,1,1,1,2,1,1}},
    {0xe1fa,0xe1fa,{1,1,1,1,2,2,1}},
    {0xe1fb,0xe1fd,{1,1,1,1,2,1,1}},
    {0xe1fe,0xe1fe,{1,1,1,1,2,2,1}},
    {0xe1ff,0xe201,{1,1,1,1,2,1,1}},
    {0xe202,0xe202,{1,1,1,1,2,2,1}},
    {0xe203,0xe20a,{1,1,1,1,2,1,1}},
    {0xe20b,0xe20b,{1,1,1,1,2,2,1}},
    {0xe20c,0xe218,{1,1,1,1,2,1,1}},
    {0xe219,0xe219,{1,1,1,1,2,2,1}},
    {0xe21a,0xe21b,{1,1,1,1,2,1,1}},
    {0xe21c,0xe21c,{1,1,1,1,2,2,1}},
    {0xe21d,0xe226,{1,1,1,1,2,1,1}},
    {0xe227,0xe227,{1,1,1,1,2,2,1}},
    {0xe228,0xe244,{1,1,1,1,2,1,1}},
    {0xe245,0xe245,{1,1,1,1,2,2,1}},
    {0xe246,0xe249,{1,1,1,1,2,1,1}},
    {0xe24a,0xe24a,{1,1,1,1,2,2,1}},
    {0xe24b,0xe24d,{1,1,1,1,2,1,1}},
    {0xe24e,0xe24e,{1,1,1,1,2,2,1}},
    {0xe24f,0xe26a,{1,1,1,1,2,1,1}},
    {0xe26b,0xe26b,{1,1,1,1,2,2,1}},
    {0xe26c,0xe279,{1,1,1,1,2,1,1}},
    {0xe27a,0xe27a,{1,1,1,1,2,2,1}},
    {0xe27b,0xe281,{1,1,1,1,2,1,1}},
    {0xe282,0xe282,{1,1,1,1,2,2,1}},
    {0xe283,0xe28f,{1,1,1,1,2,1,1}},
    {0xe290,0xe290,{1,1,1,1,2,2,1}},
    {0xe291,0xe29a,{1,1,1,1,2,1,1}},
    {0xe29b,0xe29b,{1,1,1,1,2,2,1}},
    {0xe29c,0xe2a0,{1,1,1,1,2,1,1}},
    {0xe2a1,0xe2a1,{1,1,1,1,2,2,1}},
    {0xe2a2,0xe2b1,{1,1,1,1,2,1,1}},
    {0xe2b2,0xe2b2,{1,1,1,1,2,2,1}},
    {0xe2b3,0xe2b6,{1,1,1,1,2,1,1}},
    {0xe2b7,0xe2b7,{1,1,1,1,2,2,1}},
    {0xe2b8,0xe2c0,{1,1,1,1,2,1,1}},
    {0xe2c1,0xe2c1,{1,1,1,1,2,2,1}},
    {0xe2c2,0xe2c8,{1,1,1,1,2,1,1}},
    {0xe2c9,0xe2c9,{1,1,1,1,2,2,1}},
    {0xe2ca,0xe2d3,{1,1,1,1,2,1,1}},
    {0xe2d4,0xe2d4,{1,1,1,1,2,2,1}},
    {0xe2d5,0xe2e1,{1,1,1,1,2,1,1}},
    {0xe2e2,0xe2e2,{1,1,1,1,2,2,1}},
    {0xe2e3,0xe2ea,{1,1,1,1,2,1,1}},
    {0xe2eb,0xe2ec,{1,1,1,1,2,2,1}},
    {0xe2ed,0xe2ef,{1,1,1,1,2,1,1}},
    {0xe2f0,0xe2f1,{1,1,1,1,2,2,1}},
    {0xe2f2,0xe2ff,{1,1,1,1,2,1,1}},
    {0xe300,0xe300,{1,1,1,1,2,2,1}},
    {0xe301,0xe310,{1,1,1,1,2,1,1}},
    {0xe311,0xe311,{1,1,1,1,2,2,1}},
    {0xe312,0xe324,{1,1,1,1,2,1,1}},
    {0xe325,0xe325,{1,1,1,1,2,2,1}},
    {0xe326,0xe32f,{1,1,1,1,2,1,1}},
    {0xe330,0xe330,{1,1,1,1,2,2,1}},
    {0xe331,0xe344,{1,1,1,1,2,1,1}},
    {0xe345,0xe345,{1,1,1,1,2,2,1}},
    {0xe346,0xe361,{1,1,1,1,2,1,1}},
    {0xe362,0xe362,{1,1,1,1,2,2,1}},
    {0xe363,0xe380,{1,1,1,1,2,1,1}},
    {0xe381,0xe382,{1,1,1,1,2,2,1}},
    {0xe383,0xe385,{1,1,1,1,2,1,1}},
    {0xe386,0xe386,{1,1,1,1,2,2,1}},
    {0xe387,0xe388,{1,1,1,1,2,1,1}},
    {0xe389,0xe389,{1,1,1,1,2,2,1}},
    {0xe38a,0xe393,{1,1,1,1,2,1,1}},
    {0xe394,0xe394,{1,1,1,1,2,2,1}},
    {0xe395,0xe395,{1,1,1,1,2,1,1}},
    {0xe396,0xe396,{1,1,1,1,2,2,1}},
    {0xe397,0xe39d,{1,1,1,1,2,1,1}},
    {0xe39e,0xe39e,{1,1,1,1,2,2,1}},
    {0xe39f,0xe39f,{1,1,1,1,2,1,1}},
    {0xe3a0,0xe3a0,{1,1,1,1,2,2,1}},
    {0xe3a1,0xe3b3,{1,1,1,1,2,1,1}},
    {0xe3b4,0xe3b4,{1,1,1,1,2,2,1}},
    {0xe3b5,0xe3ba,{1,1,1,1,2,1,1}},
    {0xe3bb,0xe3bb,{1,1,1,1,2,2,1}},
    {0xe3bc,0xe3cc,{1,1,1,1,2,1,1}},
    {0xe3cd,0xe3cd,{1,1,1,1,2,2,1}},
    {0xe3ce,0xe3ce,{1,1,1,1,2,1,1}},
    {0xe3cf,0xe3cf,{1,1,1,1,2,2,1}},
    {0xe3d0,0xe3d4,{1,1,1,1,2,1,1}},
    {0xe3d5,0xe3d5,{1,1,1,1,2,2,1}},
    {0xe3d6,0xe3e0,{1,1,1,1,2,1,1}},
    {0xe3e1,0xe3e1,{1,1,1,1,2,2,1}},
    {0xe3e2,0xe3e6,{1,1,1,1,2,1,1}},
    {0xe3e7,0xe3e7,{1,1,1,1,2,2,1}},
    {0xe3e8,0xe3ef,{1,1,1,1,2,1,1}},
    {0xe3f0,0xe3f0,{1,1,1,1,2,2,1}},
    {0xe3f1,0xe3f1,{1,1,1,1,2,1,1}},
    {0xe3f2,0xe3f2,{1,1,1,1,2,2,1}},
    {0xe3f3,0xe3f3,{1,1,1,1,2,1,1}},
    {0xe3f4,0xe3f4,{1,1,1,1,2,2,1}},
    {0xe3f5,0xe425,{1,1,1,1,2,1,1}},
    {0xe426,0xe426,{1,1,1,1,2,2,1}},
    {0xe427,0xe435,{1,1,1,1,2,1,1}},
    {0xe436,0xe436,{1,1,1,1,2,2,1}},
    {0xe437,0xe447,{1,1,1,1,2,1,1}},
    {0xe448,0xe448,{1,1,1,1,2,2,1}},
    {0xe449,0xe44c,{1,1,1,1,2,1,1}},
    {0xe44d,0xe44d,{1,1,1,1,2,2,1}},
    {0xe44e,0xe44f,{1,1,1,1,2,1,1}},
    {0xe450,0xe450,{1,1,1,1,2,2,1}},
    {0xe451,0xe466,{1,1,1,1,2,1,1}},
    {0xe467,0xe469,{1,1,1,1,2,2,1}},
    {0xe46a,0xe473,{1,1,1,1,2,1,1}},
    {0xe474,0xe474,{1,1,1,1,2,2,1}},
    {0xe475,0xe489,{1,1,1,1,2,1,1}},
    {0xe48a,0xe48a,{1,1,1,1,2,2,1}},
    {0xe48b,0xe4a0,{1,1,1,1,2,1,1}},
    {0xe4a1,0xe4a1,{1,1,1,1,2,2,1}},
    {0xe4a2,0xe4c0,{1,1,1,1,2,1,1}},
    {0xe4c1,0xe4c1,{1,1,1,1,2,2,1}},
    {0xe4c2,0xe4c5,{1,1,1,1,2,1,1}},
    {0xe4c6,0xe4c6,{1,1,1,1,2,2,1}},
    {0xe4c7,0xe4dc,{1,1,1,1,2,1,1}},
    {0xe4dd,0xe4dd,{1,1,1,1,2,2,1}},
    {0xe4de,0xe51d,{1,1,1,1,2,1,1}},
    {0xe51e,0xe51e,{1,1,1,1,2,2,1}},
    {0xe51f,0xe523,{1,1,1,1,2,1,1}},
    {0xe524,0xe524,{1,1,1,1,2,2,1}},
    {0xe525,0xe527,{1,1,1,1,2,1,1}},
    {0xe528,0xe528,{1,1,1,1,2,2,1}},
    {0xe529,0xe52d,{1,1,1,1,2,1,1}},
    {0xe52e,0xe52f,{1,1,1,1,2,2,1}},
    {0xe530,0xe56c,{1,1,1,1,2,1,1}},
    {0xe56d,0xe56d,{1,1,1,1,2,2,1}},
    {0xe56e,0xe56f,{1,1,1,1,2,1,1}},
    {0xe570,0xe570,{1,1,1,1,2,2,1}},
    {0xe571,0xe579,{1,1,1,1,2,1,1}},
    {0xe57a,0xe57a,{1,1,1,1,2,2,1}},
    {0xe57b,0xe57c,{1,1,1,1,2,1,1}},
    {0xe57d,0xe57d,{1,1,1,1,2,2,1}},
    {0xe57e,0xe583,{1,1,1,1,2,1,1}},
    {0xe584,0xe584,{1,1,1,1,2,2,1}},
    {0xe585,0xe58a,{1,1,1,1,2,1,1}},
    {0xe58b,0xe58b,{1,1,1,1,2,2,1}},
    {0xe58c,0xe599,{1,1,1,1,2,1,1}},
    {0xe59a,0xe59a,{1,1,1,1,2,2,1}},
    {0xe59b,0xe59d,{1,1,1,1,2,1,1}},
    {0xe59e,0xe59e,{1,1,1,1,2,2,1}},
    {0xe59f,0xe59f,{1,1,1,1,2,1,1}},
    {0xe5a0,0xe5a0,{1,1,1,1,2,2,1}},
    {0xe5a1,0xe5a5,{1,1,1,1,2,1,1}},
    {0xe5a6,0xe5a6,{1,1,1,1,2,2,1}},
    {0xe5a7,0xe5a9,{1,1,1,1,2,1,1}},
    {0xe5aa,0xe5aa,{1,1,1,1,2,2,1}},
    {0xe5ab,0xe5c1,{1,1,1,1,2,1,1}},
    {0xe5c2,0xe5c2,{1,1,1,1,2,2,1}},
    {0xe5c3,0xe5c7,{1,1,1,1,2,1,1}},
    {0xe5c8,0xe5c8,{1,1,1,1,2,2,1}},
    {0xe5c9,0xe5d7,{1,1,1,1,2,1,1}},
    {0xe5d8,0xe5d8,{1,1,1,1,2,2,1}},
    {0xe5d9,0xe5f0,{1,1,1,1,2,1,1}},
    {0xe5f1,0xe5f1,{1,1,1,1,2,2,1}},
    {0xe5f2,0xe618,{1,1,1,1,2,1,1}},
    {0xe619,0xe619,{1,1,1,1,2,2,1}},
    {0xe61a,0xe61b,{1,1,1,1,2,1,1}},
    {0xe61c,0xe61c,{1,1,1,1,2,2,1}},
    {0xe61d,0xe645,{1,1,1,1,2,1,1}},
    {0xe646,0xe646,{1,1,1,1,2,2,1}},
    {0xe647,0xe653,{1,1,1,1,2,1,1}},
    {0xe654,0xe654,{1,1,1,1,2,2,1}},
    {0xe655,0xe65f,{1,1,1,1,2,1,1}},
    {0xe660,0xe660,{1,1,1,1,2,2,1}},
    {0xe661,0xe669,{1,1,1,1,2,1,1}},
    {0xe66a,0xe66a,{1,1,1,1,2,2,1}},
    {0xe66b,0xe67c,{1,1,1,1,2,1,1}},
    {0xe67d,0xe67d,{1,1,1,1,2,2,1}},
    {0xe67e,0xe67f,{1,1,1,1,2,1,1}},
    {0xe680,0xe680,{1,1,1,1,2,2,1}},
    {0xe681,0xe68d,{1,1,1,1,2,1,1}},
    {0xe68e,0xe68e,{1,1,1,1,2,2,1}},
    {0xe68f,0xe696,{1,1,1,1,2,1,1}},
    {0xe697,0xe697,{1,1,1,1,2,2,1}},
    {0xe698,0xe69d,{1,1,1,1,2,1,1}},
    {0xe69e,0xe69e,{1,1,1,1,2,2,1}},
    {0xe69f,0xe6bf,{1,1,1,1,2,1,1}},
    {0xe6c0,0xe6c0,{1,1,1,1,2,2,1}},
    {0xe6c1,0xe6c4,{1,1,1,1,2,1,1}},
    {0xe6c5,0xe6c5,{1,1,1,1,2,2,1}},
    {0xe6c6,0xe6dd,{1,1,1,1,2,1,1}},
    {0xe6de,0xe6df,{1,1,1,1,2,2,1}},
    {0xe6e0,0xe700,{1,1,1,1,2,1,1}},
    {0xe701,0xe701,{1,1,1,1,2,2,1}},
    {0xe702,0xe712,{1,1,1,1,2,1,1}},
    {0xe713,0xe713,{1,1,1,1,2,2,1}},
    {0xe714,0xe724,{1,1,1,1,2,1,1}},
    {0xe725,0xe725,{1,1,1,1,2,2,1}},
    {0xe726,0xe73c,{1,1,1,1,2,1,1}},
    {0xe73d,0xe73d,{1,1,1,1,2,2,1}},
    {0xe73e,0xe740,{1,1,1,1,2,1,1}},
    {0xe741,0xe741,{1,1,1,1,2,2,1}},
    {0xe742,0xe751,{1,1,1,1,2,1,1}},
    {0xe752,0xe752,{1,1,1,1,2,2,1}},
    {0xe753,0xe75c,{1,1,1,1,2,1,1}},
    {0xe75d,0xe75d,{1,1,1,1,2,2,1}},
    {0xe75e,0xe760,{1,1,1,1,2,1,1}},
    {0xe761,0xe761,{1,1,1,1,2,2,1}},
    {0xe762,0xe767,{1,1,1,1,2,1,1}},
    {0xe768,0xe768,{1,1,1,1,2,2,1}},
    {0xe769,0xe774,{1,1,1,1,2,1,1}},
    {0xe775,0xe775,{1,1,1,1,2,2,1}},
    {0xe776,0xe779,{1,1,1,1,2,1,1}},
    {0xe77a,0xe77a,{1,1,1,1,2,2,1}},
    {0xe77b,0xe77c,{1,1,1,1,2,1,1}},
    {0xe77d,0xe77d,{1,1,1,1,2,2,1}},
    {0xe77e,0xe78f,{1,1,1,1,2,1,1}},
    {0xe790,0xe790,{1,1,1,1,2,2,1}},
    {0xe791,0xe796,{1,1,1,1,2,1,1}},
    {0xe797,0xe797,{1,1,1,1,2,2,1}},
    {0xe798,0xe7a5,{1,1,1,1,2,1,1}},
    {0xe7a6,0xe7a6,{1,1,1,1,2,2,1}},
    {0xe7a7,0xe7b3,{1,1,1,1,2,1,1}},
    {0xe7b4,0xe7b4,{1,1,1,1,2,2,1}},
    {0xe7b5,0xe7c6,{1,1,1,1,2,1,1}},
#ifdef					Win32
    {0xe7c7,0xe7c7,{1,1,1,1,1,1,1}},
#else					/* Win32 */
    {0xe7c7,0xe7c7,{1,1,1,1,2,1,1}},
#endif					/* Win32 */
    {0xe7c8,0xe7d9,{1,1,1,1,2,1,1}},
    {0xe7da,0xe7da,{1,1,1,1,2,2,1}},
    {0xe7db,0xe7dc,{1,1,1,1,2,1,1}},
    {0xe7dd,0xe7dd,{1,1,1,1,2,2,1}},
    {0xe7de,0xe7e7,{1,1,1,1,2,1,1}},
    {0xe7e8,0xe7e9,{1,1,1,1,2,2,1}},
    {0xe7ea,0xe7ec,{1,1,1,1,2,1,1}},
    {0xe7ed,0xe7ed,{1,1,1,1,2,2,1}},
    {0xe7ee,0xe7f0,{1,1,1,1,2,1,1}},
    {0xe7f1,0xe7f1,{1,1,1,1,2,2,1}},
    {0xe7f2,0xe7fa,{1,1,1,1,2,1,1}},
    {0xe7fb,0xe7fc,{1,1,1,1,2,2,1}},
    {0xe7fd,0xe7ff,{1,1,1,1,2,1,1}},
    {0xe800,0xe800,{1,1,1,1,2,2,1}},
    {0xe801,0xe80b,{1,1,1,1,2,1,1}},
    {0xe80c,0xe80c,{1,1,1,1,2,2,1}},
    {0xe80d,0xe812,{1,1,1,1,2,1,1}},
    {0xe813,0xe813,{1,1,1,1,2,2,1}},
    {0xe814,0xe820,{1,1,1,1,2,1,1}},
    {0xe821,0xe821,{1,1,1,1,2,2,1}},
    {0xe822,0xe827,{1,1,1,1,2,1,1}},
    {0xe828,0xe828,{1,1,1,1,2,2,1}},
    {0xe829,0xe82c,{1,1,1,1,2,1,1}},
    {0xe82d,0xe82d,{1,1,1,1,2,2,1}},
    {0xe82e,0xe82e,{1,1,1,1,2,1,1}},
    {0xe82f,0xe82f,{1,1,1,1,2,2,1}},
    {0xe830,0xe84c,{1,1,1,1,2,1,1}},
    {0xe84d,0xe84d,{1,1,1,1,2,2,1}},
    {0xe84e,0xe854,{1,1,1,1,2,1,1}},
    {0xe855,0xe856,{1,1,1,1,2,2,1}},
    {0xe857,0xe85a,{1,1,1,1,2,1,1}},
    {0xe85b,0xe85b,{1,1,1,1,2,2,1}},
    {0xe85c,0xe85c,{1,1,1,1,2,1,1}},
    {0xe85d,0xe85d,{1,1,1,1,2,2,1}},
    {0xe85e,0xe864,{1,1,1,1,2,1,1}},
    {0xe865,0xe865,{1,1,1,1,2,2,1}},
    {0xe866,0xe886,{1,1,1,1,2,1,1}},
    {0xe887,0xe887,{1,1,1,1,2,2,1}},
    {0xe888,0xe88e,{1,1,1,1,2,1,1}},
    {0xe88f,0xe88f,{1,1,1,1,2,2,1}},
    {0xe890,0xe890,{1,1,1,1,2,1,1}},
    {0xe891,0xe891,{1,1,1,1,2,2,1}},
    {0xe892,0xe8a0,{1,1,1,1,2,1,1}},
    {0xe8a1,0xe8a1,{1,1,1,1,2,2,1}},
    {0xe8a2,0xe8a3,{1,1,1,1,2,1,1}},
    {0xe8a4,0xe8a4,{1,1,1,1,2,2,1}},
    {0xe8a5,0xe8c1,{1,1,1,1,2,1,1}},
    {0xe8c2,0xe8c3,{1,1,1,1,2,2,1}},
    {0xe8c4,0xe8cc,{1,1,1,1,2,1,1}},
    {0xe8cd,0xe8cd,{1,1,1,1,2,2,1}},
    {0xe8ce,0xe8d4,{1,1,1,1,2,1,1}},
    {0xe8d5,0xe8d6,{1,1,1,1,2,2,1}},
    {0xe8d7,0xe8d8,{1,1,1,1,2,1,1}},
    {0xe8d9,0xe8da,{1,1,1,1,2,2,1}},
    {0xe8db,0xe8e0,{1,1,1,1,2,1,1}},
    {0xe8e1,0xe8e1,{1,1,1,1,2,2,1}},
    {0xe8e2,0xe8e4,{1,1,1,1,2,1,1}},
    {0xe8e5,0xe8e5,{1,1,1,1,2,2,1}},
    {0xe8e6,0xe8fd,{1,1,1,1,2,1,1}},
    {0xe8fe,0xe8fe,{1,1,1,1,2,2,1}},
    {0xe8ff,0xe916,{1,1,1,1,2,1,1}},
    {0xe917,0xe918,{1,1,1,1,2,2,1}},
    {0xe919,0xe91e,{1,1,1,1,2,1,1}},
    {0xe91f,0xe91f,{1,1,1,1,2,2,1}},
    {0xe920,0xe924,{1,1,1,1,2,1,1}},
    {0xe925,0xe925,{1,1,1,1,2,2,1}},
    {0xe926,0xe92a,{1,1,1,1,2,1,1}},
    {0xe92b,0xe92b,{1,1,1,1,2,2,1}},
    {0xe92c,0xe933,{1,1,1,1,2,1,1}},
    {0xe934,0xe934,{1,1,1,1,2,2,1}},
    {0xe935,0xe94f,{1,1,1,1,2,1,1}},
    {0xe950,0xe950,{1,1,1,1,2,2,1}},
    {0xe951,0xe966,{1,1,1,1,2,1,1}},
    {0xe967,0xe967,{1,1,1,1,2,2,1}},
    {0xe968,0xe96d,{1,1,1,1,2,1,1}},
    {0xe96e,0xe96f,{1,1,1,1,2,2,1}},
    {0xe970,0xe972,{1,1,1,1,2,1,1}},
    {0xe973,0xe973,{1,1,1,1,2,2,1}},
    {0xe974,0xe976,{1,1,1,1,2,1,1}},
    {0xe977,0xe977,{1,1,1,1,2,2,1}},
    {0xe978,0xe979,{1,1,1,1,2,1,1}},
    {0xe97a,0xe97b,{1,1,1,1,2,2,1}},
    {0xe97c,0xe97c,{1,1,1,1,2,1,1}},
    {0xe97d,0xe97d,{1,1,1,1,2,2,1}},
    {0xe97e,0xe981,{1,1,1,1,2,1,1}},
    {0xe982,0xe982,{1,1,1,1,2,2,1}},
    {0xe983,0xe990,{1,1,1,1,2,1,1}},
    {0xe991,0xe991,{1,1,1,1,2,2,1}},
    {0xe992,0xe9ca,{1,1,1,1,2,1,1}},
    {0xe9cb,0xe9cb,{1,1,1,1,2,2,1}},
    {0xe9cc,0xeaa8,{1,1,1,1,2,1,1}},
    {0xeaa9,0xeaa9,{1,1,1,1,2,2,1}},
    {0xeaaa,0xeabe,{1,1,1,1,2,1,1}},
    {0xeabf,0xeac1,{1,1,1,1,2,2,1}},
    {0xeac2,0xeac4,{1,1,1,1,2,1,1}},
    {0xeac5,0xeac5,{1,1,1,1,2,2,1}},
    {0xeac6,0xeac8,{1,1,1,1,2,1,1}},
    {0xeac9,0xeacc,{1,1,1,1,2,2,1}},
    {0xeacd,0xeace,{1,1,1,1,2,1,1}},
    {0xeacf,0xead1,{1,1,1,1,2,2,1}},
    {0xead2,0xead2,{1,1,1,1,2,1,1}},
    {0xead3,0xead4,{1,1,1,1,2,2,1}},
    {0xead5,0xead5,{1,1,1,1,2,1,1}},
    {0xead6,0xead7,{1,1,1,1,2,2,1}},
    {0xead8,0xead8,{1,1,1,1,2,1,1}},
    {0xead9,0xeada,{1,1,1,1,2,2,1}},
    {0xeadb,0xeadb,{1,1,1,1,2,1,1}},
    {0xeadc,0xeadc,{1,1,1,1,2,2,1}},
    {0xeadd,0xeadd,{1,1,1,1,2,1,1}},
    {0xeade,0xeae3,{1,1,1,1,2,2,1}},
    {0xeae4,0xeae6,{1,1,1,1,2,1,1}},
    {0xeae7,0xeae7,{1,1,1,1,2,2,1}},
    {0xeae8,0xeae8,{1,1,1,1,2,1,1}},
    {0xeae9,0xeaea,{1,1,1,1,2,2,1}},
    {0xeaeb,0xeaeb,{1,1,1,1,2,1,1}},
    {0xeaec,0xeaec,{1,1,1,1,2,2,1}},
    {0xeaed,0xeaed,{1,1,1,1,2,1,1}},
    {0xeaee,0xeaee,{1,1,1,1,2,2,1}},
    {0xeaef,0xeaef,{1,1,1,1,2,1,1}},
    {0xeaf0,0xeaf1,{1,1,1,1,2,2,1}},
    {0xeaf2,0xeaf4,{1,1,1,1,2,1,1}},
    {0xeaf5,0xeaf6,{1,1,1,1,2,2,1}},
    {0xeaf7,0xeaf7,{1,1,1,1,2,1,1}},
    {0xeaf8,0xeafb,{1,1,1,1,2,2,1}},
    {0xeafc,0xeafe,{1,1,1,1,2,1,1}},
    {0xeaff,0xeb00,{1,1,1,1,2,2,1}},
    {0xeb01,0xeb01,{1,1,1,1,2,1,1}},
    {0xeb02,0xeb05,{1,1,1,1,2,2,1}},
    {0xeb06,0xeb07,{1,1,1,1,2,1,1}},
    {0xeb08,0xeb0f,{1,1,1,1,2,2,1}},
    {0xeb10,0xeb11,{1,1,1,1,2,1,1}},
    {0xeb12,0xeb12,{1,1,1,1,2,2,1}},
    {0xeb13,0xeb14,{1,1,1,1,2,1,1}},
    {0xeb15,0xeb15,{1,1,1,1,2,2,1}},
    {0xeb16,0xeb18,{1,1,1,1,2,1,1}},
    {0xeb19,0xeb1d,{1,1,1,1,2,2,1}},
    {0xeb1e,0xeb1e,{1,1,1,1,2,1,1}},
    {0xeb1f,0xeb20,{1,1,1,1,2,2,1}},
    {0xeb21,0xeb22,{1,1,1,1,2,1,1}},
    {0xeb23,0xeb23,{1,1,1,1,2,2,1}},
    {0xeb24,0xeb24,{1,1,1,1,2,1,1}},
    {0xeb25,0xeb25,{1,1,1,1,2,2,1}},
    {0xeb26,0xeb26,{1,1,1,1,2,1,1}},
    {0xeb27,0xeb27,{1,1,1,1,2,2,1}},
    {0xeb28,0xeb29,{1,1,1,1,2,1,1}},
    {0xeb2a,0xeb2a,{1,1,1,1,2,2,1}},
    {0xeb2b,0xeb2b,{1,1,1,1,2,1,1}},
    {0xeb2c,0xeb2e,{1,1,1,1,2,2,1}},
    {0xeb2f,0xeb2f,{1,1,1,1,2,1,1}},
    {0xeb30,0xeb39,{1,1,1,1,2,2,1}},
    {0xeb3a,0xeb3c,{1,1,1,1,2,1,1}},
    {0xeb3d,0xeb3f,{1,1,1,1,2,2,1}},
    {0xeb40,0xeb42,{1,1,1,1,2,1,1}},
    {0xeb43,0xeb44,{1,1,1,1,2,2,1}},
    {0xeb45,0xeb49,{1,1,1,1,2,1,1}},
    {0xeb4a,0xeb4a,{1,1,1,1,2,2,1}},
    {0xeb4b,0xeb4c,{1,1,1,1,2,1,1}},
    {0xeb4d,0xeb4e,{1,1,1,1,2,2,1}},
    {0xeb4f,0xeb52,{1,1,1,1,2,1,1}},
    {0xeb53,0xeb53,{1,1,1,1,2,2,1}},
    {0xeb54,0xeb54,{1,1,1,1,2,1,1}},
    {0xeb55,0xeb56,{1,1,1,1,2,2,1}},
    {0xeb57,0xeb57,{1,1,1,1,2,1,1}},
    {0xeb58,0xeb58,{1,1,1,1,2,2,1}},
    {0xeb59,0xeb59,{1,1,1,1,2,1,1}},
    {0xeb5a,0xeb5b,{1,1,1,1,2,2,1}},
    {0xeb5c,0xeb61,{1,1,1,1,2,1,1}},
    {0xeb62,0xeb63,{1,1,1,1,2,2,1}},
    {0xeb64,0xeb64,{1,1,1,1,2,1,1}},
    {0xeb65,0xeb65,{1,1,1,1,2,2,1}},
    {0xeb66,0xeb66,{1,1,1,1,2,1,1}},
    {0xeb67,0xeb69,{1,1,1,1,2,2,1}},
    {0xeb6a,0xeb6e,{1,1,1,1,2,1,1}},
    {0xeb6f,0xeb71,{1,1,1,1,2,2,1}},
    {0xeb72,0xeb72,{1,1,1,1,2,1,1}},
    {0xeb73,0xeb73,{1,1,1,1,2,2,1}},
    {0xeb74,0xeb75,{1,1,1,1,2,1,1}},
    {0xeb76,0xeb77,{1,1,1,1,2,2,1}},
    {0xeb78,0xeb79,{1,1,1,1,2,1,1}},
    {0xeb7a,0xeb7a,{1,1,1,1,2,2,1}},
    {0xeb7b,0xeb7d,{1,1,1,1,2,1,1}},
    {0xeb7e,0xeb80,{1,1,1,1,2,2,1}},
    {0xeb81,0xeb82,{1,1,1,1,2,1,1}},
    {0xeb83,0xeb83,{1,1,1,1,2,2,1}},
    {0xeb84,0xeb87,{1,1,1,1,2,1,1}},
    {0xeb88,0xeb88,{1,1,1,1,2,2,1}},
    {0xeb89,0xeb89,{1,1,1,1,2,1,1}},
    {0xeb8a,0xeb8a,{1,1,1,1,2,2,1}},
    {0xeb8b,0xeb8b,{1,1,1,1,2,1,1}},
    {0xeb8c,0xeb8c,{1,1,1,1,2,2,1}},
    {0xeb8d,0xeb8f,{1,1,1,1,2,1,1}},
    {0xeb90,0xeb90,{1,1,1,1,2,2,1}},
    {0xeb91,0xeb92,{1,1,1,1,2,1,1}},
    {0xeb93,0xeb93,{1,1,1,1,2,2,1}},
    {0xeb94,0xeb94,{1,1,1,1,2,1,1}},
    {0xeb95,0xeb95,{1,1,1,1,2,2,1}},
    {0xeb96,0xeb98,{1,1,1,1,2,1,1}},
    {0xeb99,0xeb99,{1,1,1,1,2,2,1}},
    {0xeb9a,0xeb9a,{1,1,1,1,2,1,1}},
    {0xeb9b,0xeb9b,{1,1,1,1,2,2,1}},
    {0xeb9c,0xeb9e,{1,1,1,1,2,1,1}},
    {0xeb9f,0xeb9f,{1,1,1,1,2,2,1}},
    {0xeba0,0xeba1,{1,1,1,1,2,1,1}},
    {0xeba2,0xeba2,{1,1,1,1,2,2,1}},
    {0xeba3,0xeba4,{1,1,1,1,2,1,1}},
    {0xeba5,0xeba6,{1,1,1,1,2,2,1}},
    {0xeba7,0xeba9,{1,1,1,1,2,1,1}},
    {0xebaa,0xebab,{1,1,1,1,2,2,1}},
    {0xebac,0xebad,{1,1,1,1,2,1,1}},
    {0xebae,0xebae,{1,1,1,1,2,2,1}},
    {0xebaf,0xebb1,{1,1,1,1,2,1,1}},
    {0xebb2,0xebb3,{1,1,1,1,2,2,1}},
    {0xebb4,0xebbc,{1,1,1,1,2,1,1}},
    {0xebbd,0xebbd,{1,1,1,1,2,2,1}},
    {0xebbe,0xebbe,{1,1,1,1,2,1,1}},
    {0xebbf,0xebbf,{1,1,1,1,2,2,1}},
    {0xebc0,0xebc4,{1,1,1,1,2,1,1}},
    {0xebc5,0xebc5,{1,1,1,1,2,2,1}},
    {0xebc6,0xebc9,{1,1,1,1,2,1,1}},
    {0xebca,0xebca,{1,1,1,1,2,2,1}},
    {0xebcb,0xebcb,{1,1,1,1,2,1,1}},
    {0xebcc,0xebcc,{1,1,1,1,2,2,1}},
    {0xebcd,0xebcd,{1,1,1,1,2,1,1}},
    {0xebce,0xebce,{1,1,1,1,2,2,1}},
    {0xebcf,0xebcf,{1,1,1,1,2,1,1}},
    {0xebd0,0xebd0,{1,1,1,1,2,2,1}},
    {0xebd1,0xebd4,{1,1,1,1,2,1,1}},
    {0xebd5,0xebd5,{1,1,1,1,2,2,1}},
    {0xebd6,0xebd6,{1,1,1,1,2,1,1}},
    {0xebd7,0xebd8,{1,1,1,1,2,2,1}},
    {0xebd9,0xebd9,{1,1,1,1,2,1,1}},
    {0xebda,0xebdb,{1,1,1,1,2,2,1}},
    {0xebdc,0xebdc,{1,1,1,1,2,1,1}},
    {0xebdd,0xebdd,{1,1,1,1,2,2,1}},
    {0xebde,0xebde,{1,1,1,1,2,1,1}},
    {0xebdf,0xebdf,{1,1,1,1,2,2,1}},
    {0xebe0,0xebe0,{1,1,1,1,2,1,1}},
    {0xebe1,0xebe1,{1,1,1,1,2,2,1}},
    {0xebe2,0xebe3,{1,1,1,1,2,1,1}},
    {0xebe4,0xebe4,{1,1,1,1,2,2,1}},
    {0xebe5,0xebe7,{1,1,1,1,2,1,1}},
    {0xebe8,0xebe9,{1,1,1,1,2,2,1}},
    {0xebea,0xebea,{1,1,1,1,2,1,1}},
    {0xebeb,0xebec,{1,1,1,1,2,2,1}},
    {0xebed,0xebee,{1,1,1,1,2,1,1}},
    {0xebef,0xebef,{1,1,1,1,2,2,1}},
    {0xebf0,0xebf1,{1,1,1,1,2,1,1}},
    {0xebf2,0xebf2,{1,1,1,1,2,2,1}},
    {0xebf3,0xebf4,{1,1,1,1,2,1,1}},
    {0xebf5,0xebf5,{1,1,1,1,2,2,1}},
    {0xebf6,0xebf8,{1,1,1,1,2,1,1}},
    {0xebf9,0xebfa,{1,1,1,1,2,2,1}},
    {0xebfb,0xebfd,{1,1,1,1,2,1,1}},
    {0xebfe,0xebfe,{1,1,1,1,2,2,1}},
    {0xebff,0xec07,{1,1,1,1,2,1,1}},
    {0xec08,0xec09,{1,1,1,1,2,2,1}},
    {0xec0a,0xec0e,{1,1,1,1,2,1,1}},
    {0xec0f,0xec0f,{1,1,1,1,2,2,1}},
    {0xec10,0xec12,{1,1,1,1,2,1,1}},
    {0xec13,0xec13,{1,1,1,1,2,2,1}},
    {0xec14,0xec18,{1,1,1,1,2,1,1}},
    {0xec19,0xec1c,{1,1,1,1,2,2,1}},
    {0xec1d,0xec23,{1,1,1,1,2,1,1}},
    {0xec24,0xec24,{1,1,1,1,2,2,1}},
    {0xec25,0xec25,{1,1,1,1,2,1,1}},
    {0xec26,0xec26,{1,1,1,1,2,2,1}},
    {0xec27,0xec2a,{1,1,1,1,2,1,1}},
    {0xec2b,0xec2b,{1,1,1,1,2,2,1}},
    {0xec2c,0xec2e,{1,1,1,1,2,1,1}},
    {0xec2f,0xec2f,{1,1,1,1,2,2,1}},
    {0xec30,0xec31,{1,1,1,1,2,1,1}},
    {0xec32,0xec32,{1,1,1,1,2,2,1}},
    {0xec33,0xec3e,{1,1,1,1,2,1,1}},
    {0xec3f,0xec3f,{1,1,1,1,2,2,1}},
    {0xec40,0xec42,{1,1,1,1,2,1,1}},
    {0xec43,0xec49,{1,1,1,1,2,2,1}},
    {0xec4a,0xec4a,{1,1,1,1,2,1,1}},
    {0xec4b,0xec4b,{1,1,1,1,2,2,1}},
    {0xec4c,0xec4e,{1,1,1,1,2,1,1}},
    {0xec4f,0xec4f,{1,1,1,1,2,2,1}},
    {0xec50,0xec51,{1,1,1,1,2,1,1}},
    {0xec52,0xec52,{1,1,1,1,2,2,1}},
    {0xec53,0xec53,{1,1,1,1,2,1,1}},
    {0xec54,0xec54,{1,1,1,1,2,2,1}},
    {0xec55,0xec55,{1,1,1,1,2,1,1}},
    {0xec56,0xec58,{1,1,1,1,2,2,1}},
    {0xec59,0xec59,{1,1,1,1,2,1,1}},
    {0xec5a,0xec5a,{1,1,1,1,2,2,1}},
    {0xec5b,0xec5b,{1,1,1,1,2,1,1}},
    {0xec5c,0xec5d,{1,1,1,1,2,2,1}},
    {0xec5e,0xec5f,{1,1,1,1,2,1,1}},
    {0xec60,0xec60,{1,1,1,1,2,2,1}},
    {0xec61,0xec61,{1,1,1,1,2,1,1}},
    {0xec62,0xec63,{1,1,1,1,2,2,1}},
    {0xec64,0xec66,{1,1,1,1,2,1,1}},
    {0xec67,0xec67,{1,1,1,1,2,2,1}},
    {0xec68,0xec68,{1,1,1,1,2,1,1}},
    {0xec69,0xec6d,{1,1,1,1,2,2,1}},
    {0xec6e,0xec6e,{1,1,1,1,2,1,1}},
    {0xec6f,0xec70,{1,1,1,1,2,2,1}},
    {0xec71,0xec71,{1,1,1,1,2,1,1}},
    {0xec72,0xec73,{1,1,1,1,2,2,1}},
    {0xec74,0xec74,{1,1,1,1,2,1,1}},
    {0xec75,0xec75,{1,1,1,1,2,2,1}},
    {0xec76,0xec78,{1,1,1,1,2,1,1}},
    {0xec79,0xec79,{1,1,1,1,2,2,1}},
    {0xec7a,0xec7a,{1,1,1,1,2,1,1}},
    {0xec7b,0xec7b,{1,1,1,1,2,2,1}},
    {0xec7c,0xec7d,{1,1,1,1,2,1,1}},
    {0xec7e,0xec7e,{1,1,1,1,2,2,1}},
    {0xec7f,0xec83,{1,1,1,1,2,1,1}},
    {0xec84,0xec84,{1,1,1,1,2,2,1}},
    {0xec85,0xec8d,{1,1,1,1,2,1,1}},
    {0xec8e,0xec8e,{1,1,1,1,2,2,1}},
    {0xec8f,0xec91,{1,1,1,1,2,1,1}},
    {0xec92,0xec92,{1,1,1,1,2,2,1}},
    {0xec93,0xec94,{1,1,1,1,2,1,1}},
    {0xec95,0xec95,{1,1,1,1,2,2,1}},
    {0xec96,0xecae,{1,1,1,1,2,1,1}},
    {0xecaf,0xecaf,{1,1,1,1,2,2,1}},
    {0xecb0,0xecb5,{1,1,1,1,2,1,1}},
    {0xecb6,0xecb6,{1,1,1,1,2,2,1}},
    {0xecb7,0xecce,{1,1,1,1,2,1,1}},
    {0xeccf,0xeccf,{1,1,1,1,2,2,1}},
    {0xecd0,0xecdb,{1,1,1,1,2,1,1}},
    {0xecdc,0xecdc,{1,1,1,1,2,2,1}},
    {0xecdd,0xecdf,{1,1,1,1,2,1,1}},
    {0xece0,0xece1,{1,1,1,1,2,2,1}},
    {0xece2,0xecef,{1,1,1,1,2,1,1}},
    {0xecf0,0xecf0,{1,1,1,1,2,2,1}},
    {0xecf1,0xecf1,{1,1,1,1,2,1,1}},
    {0xecf2,0xecf2,{1,1,1,1,2,2,1}},
    {0xecf3,0xecfb,{1,1,1,1,2,1,1}},
    {0xecfc,0xecfc,{1,1,1,1,2,2,1}},
    {0xecfd,0xed10,{1,1,1,1,2,1,1}},
    {0xed11,0xed11,{1,1,1,1,2,2,1}},
    {0xed12,0xed1c,{1,1,1,1,2,1,1}},
    {0xed1d,0xed1d,{1,1,1,1,2,2,1}},
    {0xed1e,0xed23,{1,1,1,1,2,1,1}},
    {0xed24,0xed24,{1,1,1,1,2,2,1}},
    {0xed25,0xed28,{1,1,1,1,2,1,1}},
    {0xed29,0xed29,{1,1,1,1,2,2,1}},
    {0xed2a,0xed2b,{1,1,1,1,2,1,1}},
    {0xed2c,0xed2c,{1,1,1,1,2,2,1}},
    {0xed2d,0xed3a,{1,1,1,1,2,1,1}},
    {0xed3b,0xed3b,{1,1,1,1,2,2,1}},
    {0xed3c,0xed40,{1,1,1,1,2,1,1}},
    {0xed41,0xed41,{1,1,1,1,2,2,1}},
    {0xed42,0xed4e,{1,1,1,1,2,1,1}},
    {0xed4f,0xed4f,{1,1,1,1,2,2,1}},
    {0xed50,0xed51,{1,1,1,1,2,1,1}},
    {0xed52,0xed52,{1,1,1,1,2,2,1}},
    {0xed53,0xed5e,{1,1,1,1,2,1,1}},
    {0xed5f,0xed5f,{1,1,1,1,2,2,1}},
    {0xed60,0xed6a,{1,1,1,1,2,1,1}},
    {0xed6b,0xed6b,{1,1,1,1,2,2,1}},
    {0xed6c,0xed77,{1,1,1,1,2,1,1}},
    {0xed78,0xed78,{1,1,1,1,2,2,1}},
    {0xed79,0xed83,{1,1,1,1,2,1,1}},
    {0xed84,0xed85,{1,1,1,1,2,2,1}},
    {0xed86,0xed87,{1,1,1,1,2,1,1}},
    {0xed88,0xed88,{1,1,1,1,2,2,1}},
    {0xed89,0xed8a,{1,1,1,1,2,1,1}},
    {0xed8b,0xed8b,{1,1,1,1,2,2,1}},
    {0xed8c,0xed8d,{1,1,1,1,2,1,1}},
    {0xed8e,0xed8e,{1,1,1,1,2,2,1}},
    {0xed8f,0xedce,{1,1,1,1,2,1,1}},
    {0xedcf,0xedcf,{1,1,1,1,2,2,1}},
    {0xedd0,0xedd9,{1,1,1,1,2,1,1}},
    {0xedda,0xedda,{1,1,1,1,2,2,1}},
    {0xeddb,0xedec,{1,1,1,1,2,1,1}},
    {0xeded,0xeded,{1,1,1,1,2,2,1}},
    {0xedee,0xee07,{1,1,1,1,2,1,1}},
    {0xee08,0xee08,{1,1,1,1,2,2,1}},
    {0xee09,0xee5c,{1,1,1,1,2,1,1}},
    {0xee5d,0xee5d,{1,1,1,1,2,2,1}},
    {0xee5e,0xee69,{1,1,1,1,2,1,1}},
    {0xee6a,0xee6a,{1,1,1,1,2,2,1}},
    {0xee6b,0xeea4,{1,1,1,1,2,1,1}},
    {0xeea5,0xeea5,{1,1,1,1,2,2,1}},
    {0xeea6,0xeeaf,{1,1,1,1,2,1,1}},
    {0xeeb0,0xeeb0,{1,1,1,1,2,2,1}},
    {0xeeb1,0xeeb3,{1,1,1,1,2,1,1}},
    {0xeeb4,0xeeb4,{1,1,1,1,2,2,1}},
    {0xeeb5,0xeeb6,{1,1,1,1,2,1,1}},
    {0xeeb7,0xeeb7,{1,1,1,1,2,2,1}},
    {0xeeb8,0xf302,{1,1,1,1,2,1,1}},
    {0xf303,0xf318,{1,1,1,1,2,2,1}},
    {0xf319,0xf324,{1,1,1,1,2,1,1}},
    {0xf325,0xf325,{1,1,1,1,2,2,1}},
    {0xf326,0xf326,{1,1,1,1,2,1,1}},
    {0xf327,0xf327,{1,1,1,1,2,2,1}},
    {0xf328,0xf343,{1,1,1,1,2,1,1}},
    {0xf344,0xf344,{1,1,1,1,2,2,1}},
    {0xf345,0xf345,{1,1,1,1,2,1,1}},
    {0xf346,0xf346,{1,1,1,1,2,2,1}},
    {0xf347,0xf349,{1,1,1,1,2,1,1}},
    {0xf34a,0xf34b,{1,1,1,1,2,2,1}},
    {0xf34c,0xf3a0,{1,1,1,1,2,1,1}},
    {0xf3a1,0xf3a1,{1,1,1,1,2,2,1}},
    {0xf3a2,0xf3ef,{1,1,1,1,2,1,1}},
    {0xf3f0,0xf3f0,{1,1,1,1,2,2,1}},
    {0xf3f1,0xf3f8,{1,1,1,1,2,1,1}},
    {0xf3f9,0xf3f9,{1,1,1,1,2,2,1}},
    {0xf3fa,0xf3fb,{1,1,1,1,2,1,1}},
    {0xf3fc,0xf3fc,{1,1,1,1,2,2,1}},
    {0xf3fd,0xf407,{1,1,1,1,2,1,1}},
    {0xf408,0xf408,{1,1,1,1,2,2,1}},
    {0xf409,0xf40a,{1,1,1,1,2,1,1}},
    {0xf40b,0xf40b,{1,1,1,1,2,2,1}},
    {0xf40c,0xf43c,{1,1,1,1,2,1,1}},
    {0xf43d,0xf43d,{1,1,1,1,2,2,1}},
    {0xf43e,0xf440,{1,1,1,1,2,1,1}},
    {0xf441,0xf442,{1,1,1,1,2,2,1}},
    {0xf443,0xf448,{1,1,1,1,2,1,1}},
    {0xf449,0xf449,{1,1,1,1,2,2,1}},
    {0xf44a,0xf44c,{1,1,1,1,2,1,1}},
    {0xf44d,0xf44d,{1,1,1,1,2,2,1}},
    {0xf44e,0xf44f,{1,1,1,1,2,1,1}},
    {0xf450,0xf450,{1,1,1,1,2,2,1}},
    {0xf451,0xf453,{1,1,1,1,2,1,1}},
    {0xf454,0xf454,{1,1,1,1,2,2,1}},
    {0xf455,0xf459,{1,1,1,1,2,1,1}},
    {0xf45a,0xf45d,{1,1,1,1,2,2,1}},
    {0xf45e,0xf461,{1,1,1,1,2,1,1}},
    {0xf462,0xf462,{1,1,1,1,2,2,1}},
    {0xf463,0xf464,{1,1,1,1,2,1,1}},
    {0xf465,0xf466,{1,1,1,1,2,2,1}},
    {0xf467,0xf468,{1,1,1,1,2,1,1}},
    {0xf469,0xf469,{1,1,1,1,2,2,1}},
    {0xf46a,0xf46c,{1,1,1,1,2,1,1}},
    {0xf46d,0xf46f,{1,1,1,1,2,2,1}},
    {0xf470,0xf476,{1,1,1,1,2,1,1}},
    {0xf477,0xf478,{1,1,1,1,2,2,1}},
    {0xf479,0xf47b,{1,1,1,1,2,1,1}},
    {0xf47c,0xf47e,{1,1,1,1,2,2,1}},
    {0xf47f,0xf47f,{1,1,1,1,2,1,1}},
    {0xf480,0xf480,{1,1,1,1,2,2,1}},
    {0xf481,0xf484,{1,1,1,1,2,1,1}},
    {0xf485,0xf485,{1,1,1,1,2,2,1}},
    {0xf486,0xf487,{1,1,1,1,2,1,1}},
    {0xf488,0xf488,{1,1,1,1,2,2,1}},
    {0xf489,0xf48a,{1,1,1,1,2,1,1}},
    {0xf48b,0xf48b,{1,1,1,1,2,2,1}},
    {0xf48c,0xf48c,{1,1,1,1,2,1,1}},
    {0xf48d,0xf48d,{1,1,1,1,2,2,1}},
    {0xf48e,0xf48e,{1,1,1,1,2,1,1}},
    {0xf48f,0xf491,{1,1,1,1,2,2,1}},
    {0xf492,0xf496,{1,1,1,1,2,1,1}},
    {0xf497,0xf498,{1,1,1,1,2,2,1}},
    {0xf499,0xf49a,{1,1,1,1,2,1,1}},
    {0xf49b,0xf49b,{1,1,1,1,2,2,1}},
    {0xf49c,0xf4a3,{1,1,1,1,2,1,1}},
    {0xf4a4,0xf4a4,{1,1,1,1,2,2,1}},
    {0xf4a5,0xf4a6,{1,1,1,1,2,1,1}},
    {0xf4a7,0xf4a7,{1,1,1,1,2,2,1}},
    {0xf4a8,0xf4a9,{1,1,1,1,2,1,1}},
    {0xf4aa,0xf4aa,{1,1,1,1,2,2,1}},
    {0xf4ab,0xf4ac,{1,1,1,1,2,1,1}},
    {0xf4ad,0xf4ad,{1,1,1,1,2,2,1}},
    {0xf4ae,0xf4ae,{1,1,1,1,2,1,1}},
    {0xf4af,0xf4af,{1,1,1,1,2,2,1}},
    {0xf4b0,0xf4b2,{1,1,1,1,2,1,1}},
    {0xf4b3,0xf4b4,{1,1,1,1,2,2,1}},
    {0xf4b5,0xf4b6,{1,1,1,1,2,1,1}},
    {0xf4b7,0xf4b7,{1,1,1,1,2,2,1}},
    {0xf4b8,0xf4b9,{1,1,1,1,2,1,1}},
    {0xf4ba,0xf4bd,{1,1,1,1,2,2,1}},
    {0xf4be,0xf4bf,{1,1,1,1,2,1,1}},
    {0xf4c0,0xf4c1,{1,1,1,1,2,2,1}},
    {0xf4c2,0xf4c2,{1,1,1,1,2,1,1}},
    {0xf4c3,0xf4c3,{1,1,1,1,2,2,1}},
    {0xf4c4,0xf4c7,{1,1,1,1,2,1,1}},
    {0xf4c8,0xf4c8,{1,1,1,1,2,2,1}},
    {0xf4c9,0xf4cd,{1,1,1,1,2,1,1}},
    {0xf4ce,0xf4cf,{1,1,1,1,2,2,1}},
    {0xf4d0,0xf4d1,{1,1,1,1,2,1,1}},
    {0xf4d2,0xf4d2,{1,1,1,1,2,2,1}},
    {0xf4d3,0xf4e1,{1,1,1,1,2,1,1}},
    {0xf4e2,0xf4e2,{1,1,1,1,2,2,1}},
    {0xf4e3,0xf4e4,{1,1,1,1,2,1,1}},
    {0xf4e5,0xf4e5,{1,1,1,1,2,2,1}},
    {0xf4e6,0xf4e6,{1,1,1,1,2,1,1}},
    {0xf4e7,0xf4e9,{1,1,1,1,2,2,1}},
    {0xf4ea,0xf4f2,{1,1,1,1,2,1,1}},
    {0xf4f3,0xf4f3,{1,1,1,1,2,2,1}},
    {0xf4f4,0xf521,{1,1,1,1,2,1,1}},
    {0xf522,0xf523,{1,1,1,1,2,2,1}},
    {0xf524,0xf524,{1,1,1,1,2,1,1}},
    {0xf525,0xf526,{1,1,1,1,2,2,1}},
    {0xf527,0xf529,{1,1,1,1,2,1,1}},
    {0xf52a,0xf52a,{1,1,1,1,2,2,1}},
    {0xf52b,0xf539,{1,1,1,1,2,1,1}},
    {0xf53a,0xf53b,{1,1,1,1,2,2,1}},
    {0xf53c,0xf53c,{1,1,1,1,2,1,1}},
    {0xf53d,0xf53d,{1,1,1,1,2,2,1}},
    {0xf53e,0xf54d,{1,1,1,1,2,1,1}},
    {0xf54e,0xf54e,{1,1,1,1,2,2,1}},
    {0xf54f,0xf552,{1,1,1,1,2,1,1}},
    {0xf553,0xf553,{1,1,1,1,2,2,1}},
    {0xf554,0xf555,{1,1,1,1,2,1,1}},
    {0xf556,0xf556,{1,1,1,1,2,2,1}},
    {0xf557,0xf558,{1,1,1,1,2,1,1}},
    {0xf559,0xf55a,{1,1,1,1,2,2,1}},
    {0xf55b,0xf55d,{1,1,1,1,2,1,1}},
    {0xf55e,0xf55e,{1,1,1,1,2,2,1}},
    {0xf55f,0xf564,{1,1,1,1,2,1,1}},
    {0xf565,0xf565,{1,1,1,1,2,2,1}},
    {0xf566,0xf56a,{1,1,1,1,2,1,1}},
    {0xf56b,0xf56b,{1,1,1,1,2,2,1}},
    {0xf56c,0xf571,{1,1,1,1,2,1,1}},
    {0xf572,0xf572,{1,1,1,1,2,2,1}},
    {0xf573,0xf6af,{1,1,1,1,2,1,1}},
    {0xf6b0,0xf6b0,{1,1,1,1,2,2,1}},
    {0xf6b1,0xf7e4,{1,1,1,1,2,1,2}},
    {0xf7e5,0xf7e6,{1,1,1,1,2,2,2}},
    {0xf7e7,0xf7e7,{1,1,1,1,2,1,2}},
    {0xf7e8,0xf7e8,{1,1,1,1,2,2,2}},
    {0xf7e9,0xf7e9,{1,1,1,1,2,1,2}},
    {0xf7ea,0xf7eb,{1,1,1,1,2,2,2}},
    {0xf7ec,0xf7ec,{1,1,1,1,2,1,2}},
    {0xf7ed,0xf7ee,{1,1,1,1,2,2,2}},
    {0xf7ef,0xf848,{1,1,1,1,2,1,2}},  // EA ambiguous to f8ff
    {0xf849,0xf8ef,{1,1,1,1,2,1,1}},
    {0xf900,0xfa6d,{2,2,2,2,2,2,2}}, // CJK COMPATIBILITY IDEOGRAPH
    {0xfa6e,0xfa6f,{2,2,2,2,2,2,2}},
    {0xfa70,0xfad9,{2,2,2,2,2,2,2}}, // CJK COMPATIBILITY IDEOGRAPH
    {0xfada,0xfaff,{2,2,2,2,2,2,2}},
    {0xfe10,0xfe19,{2,2,2,2,2,2,2}}, // Presentation forms, small signs
    {0xfe30,0xfe52,{2,2,2,2,2,2,2}},
    {0xfe54,0xfe66,{2,2,2,2,2,2,2}},
    {0xfe68,0xfe6b,{2,2,2,2,2,2,2}}, // end of small signs
    {0xff01,0xff60,{2,2,2,2,2,2,2}}, // fullwidth
    {0xff64,0xff64,{1,1,1,1,1,2,1}},
    {0xffe0,0xffe6,{2,2,2,2,2,2,2}}, // fullwidth
    {0xfffd,0xfffd,{1,1,1,1,2,1,1}}, // EA ambiguous
    {0x16fe0,0x16fe3,{2,2,2,2,2,2,2}},
    {0x17000,0x187f7,{2,2,2,2,2,2,2}},
    {0x18800,0x18af2,{2,2,2,2,2,2,2}},
    {0x1b000,0x1b11e,{2,2,2,2,2,2,2}},
    {0x1b150,0x1b152,{2,2,2,2,2,2,2}},
    {0x1b164,0x1b167,{2,2,2,2,2,2,2}},
    {0x1b170,0x1b2fb,{2,2,2,2,2,2,2}},
    {0x1f004,0x1f004,{2,2,2,2,2,2,2}},
    {0x1f0cf,0x1f0cf,{2,2,2,2,2,2,2}},
    {0x1f18e,0x1f18e,{2,2,2,2,2,2,2}},
    {0x1f191,0x1f19a,{2,2,2,2,2,2,2}},
    {0x1f200,0x1f202,{2,2,2,2,2,2,2}},
    {0x1f210,0x1f23b,{2,2,2,2,2,2,2}},
    {0x1f240,0x1f248,{2,2,2,2,2,2,2}},
    {0x1f250,0x1f251,{2,2,2,2,2,2,2}},
    {0x1f260,0x1f265,{2,2,2,2,2,2,2}},
    {0x1f300,0x1f320,{2,2,2,2,2,2,2}},
    {0x1f32d,0x1f335,{2,2,2,2,2,2,2}},
    {0x1f337,0x1f37c,{2,2,2,2,2,2,2}},
    {0x1f37e,0x1f393,{2,2,2,2,2,2,2}},
    {0x1f3a0,0x1f3ca,{2,2,2,2,2,2,2}},
    {0x1f3cf,0x1f3d3,{2,2,2,2,2,2,2}},
    {0x1f3e0,0x1f3f0,{2,2,2,2,2,2,2}},
    {0x1f3f4,0x1f3f4,{2,2,2,2,2,2,2}},
    {0x1f3f8,0x1f43e,{2,2,2,2,2,2,2}},
    {0x1f440,0x1f440,{2,2,2,2,2,2,2}},
    {0x1f442,0x1f4fc,{2,2,2,2,2,2,2}},
    {0x1f4ff,0x1f53d,{2,2,2,2,2,2,2}},
    {0x1f54b,0x1f54e,{2,2,2,2,2,2,2}},
    {0x1f550,0x1f567,{2,2,2,2,2,2,2}},
    {0x1f57a,0x1f57a,{2,2,2,2,2,2,2}},
    {0x1f595,0x1f596,{2,2,2,2,2,2,2}},
    {0x1f5a4,0x1f5a4,{2,2,2,2,2,2,2}},
    {0x1f5fb,0x1f64f,{2,2,2,2,2,2,2}},
    {0x1f680,0x1f6c5,{2,2,2,2,2,2,2}},
    {0x1f6cc,0x1f6cc,{2,2,2,2,2,2,2}},
    {0x1f6d0,0x1f6d2,{2,2,2,2,2,2,2}},
    {0x1f6d5,0x1f6d5,{2,2,2,2,2,2,2}},
    {0x1f6eb,0x1f6ec,{2,2,2,2,2,2,2}},
    {0x1f6f4,0x1f6fa,{2,2,2,2,2,2,2}},
    {0x1f7e0,0x1f7eb,{2,2,2,2,2,2,2}},
    {0x1f90d,0x1f971,{2,2,2,2,2,2,2}},
    {0x1f973,0x1f976,{2,2,2,2,2,2,2}},
    {0x1f97a,0x1f9a2,{2,2,2,2,2,2,2}},
    {0x1f9a5,0x1f9aa,{2,2,2,2,2,2,2}},
    {0x1f9ae,0x1f9ca,{2,2,2,2,2,2,2}},
    {0x1f9cd,0x1f9ff,{2,2,2,2,2,2,2}},
    {0x1fa70,0x1fa73,{2,2,2,2,2,2,2}},
    {0x1fa78,0x1fa7a,{2,2,2,2,2,2,2}},
    {0x1fa80,0x1fa82,{2,2,2,2,2,2,2}},
    {0x1fa90,0x1fa95,{2,2,2,2,2,2,2}},
    // tr11 has all unassigned in these planes as wide chars
    {0x20000,0x2a6d6,{2,2,2,2,2,2,2}}, // Supplementary Ideographic Plane
    {0x2a6d7,0x2f7ff,{2,2,2,2,2,2,2}},
    {0x2f800,0x2fa1d,{2,2,2,2,2,2,2}}, // to 2fffd
    {0x2fa1e,0x2fffd,{2,2,2,2,2,2,2}},
    {0x30000,0x3fffd,{2,2,2,2,2,2,2}}, // Tertiary Ideographic Plane
    {0xf0000,0xffffd,{1,1,1,1,2,1,1}}, // EA ambiguous
    {0x100000,0x10fffd,{1,1,1,1,2,1,1}}, // EA ambiguous
};

#if defined(__APPLE__) || defined(Win32) || defined(_AIX)
/* ------------------- iswalpha -------------------- */
static const struct interval table_walpha[] = {
    { 0x41, 0x5a },
    { 0x61, 0x7a },
    { 0xaa, 0xaa },
    { 0xb5, 0xb5 },
    { 0xba, 0xba },
    { 0xc0, 0xd6 },
    { 0xd8, 0xf6 },
    { 0xf8, 0x220 },
    { 0x222, 0x233 },
    { 0x250, 0x2ad },
    { 0x2b0, 0x2b8 },
    { 0x2bb, 0x2c1 },
    { 0x2d0, 0x2d1 },
    { 0x2e0, 0x2e4 },
    { 0x2ee, 0x2ee },
    { 0x345, 0x345 },
    { 0x37a, 0x37a },
    { 0x386, 0x386 },
    { 0x388, 0x38a },
    { 0x38c, 0x38c },
    { 0x38e, 0x3a1 },
    { 0x3a3, 0x3ce },
    { 0x3d0, 0x3f5 },
    { 0x400, 0x481 },
    { 0x48a, 0x4ce },
    { 0x4d0, 0x4f5 },
    { 0x4f8, 0x4f9 },
    { 0x500, 0x50f },
    { 0x531, 0x556 },
    { 0x559, 0x559 },
    { 0x561, 0x587 },
    { 0x5d0, 0x5ea },
    { 0x5f0, 0x5f2 },
    { 0x621, 0x63a },
    { 0x640, 0x64a },
    { 0x660, 0x669 },
    { 0x66e, 0x66f },
    { 0x671, 0x6d3 },
    { 0x6d5, 0x6d5 },
    { 0x6e5, 0x6e6 },
    { 0x6f0, 0x6fc },
    { 0x710, 0x710 },
    { 0x712, 0x72c },
    { 0x780, 0x7a5 },
    { 0x7b1, 0x7b1 },
    { 0x905, 0x939 },
    { 0x93d, 0x93d },
    { 0x950, 0x950 },
    { 0x958, 0x961 },
    { 0x966, 0x96f },
    { 0x985, 0x98c },
    { 0x98f, 0x990 },
    { 0x993, 0x9a8 },
    { 0x9aa, 0x9b0 },
    { 0x9b2, 0x9b2 },
    { 0x9b6, 0x9b9 },
    { 0x9dc, 0x9dd },
    { 0x9df, 0x9e1 },
    { 0x9e6, 0x9f1 },
    { 0xa05, 0xa0a },
    { 0xa0f, 0xa10 },
    { 0xa13, 0xa28 },
    { 0xa2a, 0xa30 },
    { 0xa32, 0xa33 },
    { 0xa35, 0xa36 },
    { 0xa38, 0xa39 },
    { 0xa59, 0xa5c },
    { 0xa5e, 0xa5e },
    { 0xa66, 0xa6f },
    { 0xa72, 0xa74 },
    { 0xa85, 0xa8b },
    { 0xa8d, 0xa8d },
    { 0xa8f, 0xa91 },
    { 0xa93, 0xaa8 },
    { 0xaaa, 0xab0 },
    { 0xab2, 0xab3 },
    { 0xab5, 0xab9 },
    { 0xabd, 0xabd },
    { 0xad0, 0xad0 },
    { 0xae0, 0xae0 },
    { 0xae6, 0xaef },
    { 0xb05, 0xb0c },
    { 0xb0f, 0xb10 },
    { 0xb13, 0xb28 },
    { 0xb2a, 0xb30 },
    { 0xb32, 0xb33 },
    { 0xb36, 0xb39 },
    { 0xb3d, 0xb3d },
    { 0xb5c, 0xb5d },
    { 0xb5f, 0xb61 },
    { 0xb66, 0xb6f },
    { 0xb83, 0xb83 },
    { 0xb85, 0xb8a },
    { 0xb8e, 0xb90 },
    { 0xb92, 0xb95 },
    { 0xb99, 0xb9a },
    { 0xb9c, 0xb9c },
    { 0xb9e, 0xb9f },
    { 0xba3, 0xba4 },
    { 0xba8, 0xbaa },
    { 0xbae, 0xbb5 },
    { 0xbb7, 0xbb9 },
    { 0xbe7, 0xbef },
    { 0xc05, 0xc0c },
    { 0xc0e, 0xc10 },
    { 0xc12, 0xc28 },
    { 0xc2a, 0xc33 },
    { 0xc35, 0xc39 },
    { 0xc60, 0xc61 },
    { 0xc66, 0xc6f },
    { 0xc85, 0xc8c },
    { 0xc8e, 0xc90 },
    { 0xc92, 0xca8 },
    { 0xcaa, 0xcb3 },
    { 0xcb5, 0xcb9 },
    { 0xcde, 0xcde },
    { 0xce0, 0xce1 },
    { 0xce6, 0xcef },
    { 0xd05, 0xd0c },
    { 0xd0e, 0xd10 },
    { 0xd12, 0xd28 },
    { 0xd2a, 0xd39 },
    { 0xd60, 0xd61 },
    { 0xd66, 0xd6f },
    { 0xd85, 0xd96 },
    { 0xd9a, 0xdb1 },
    { 0xdb3, 0xdbb },
    { 0xdbd, 0xdbd },
    { 0xdc0, 0xdc6 },
    { 0xe01, 0xe2e },
    { 0xe30, 0xe3a },
    { 0xe40, 0xe45 },
    { 0xe47, 0xe4e },
    { 0xe50, 0xe59 },
    { 0xe81, 0xe82 },
    { 0xe84, 0xe84 },
    { 0xe87, 0xe88 },
    { 0xe8a, 0xe8a },
    { 0xe8d, 0xe8d },
    { 0xe94, 0xe97 },
    { 0xe99, 0xe9f },
    { 0xea1, 0xea3 },
    { 0xea5, 0xea5 },
    { 0xea7, 0xea7 },
    { 0xeaa, 0xeab },
    { 0xead, 0xeb0 },
    { 0xeb2, 0xeb3 },
    { 0xebd, 0xebd },
    { 0xec0, 0xec4 },
    { 0xec6, 0xec6 },
    { 0xed0, 0xed9 },
    { 0xedc, 0xedd },
    { 0xf00, 0xf00 },
    { 0xf20, 0xf29 },
    { 0xf40, 0xf47 },
    { 0xf49, 0xf6a },
    { 0xf88, 0xf8b },
    { 0x1000, 0x1021 },
    { 0x1023, 0x1027 },
    { 0x1029, 0x102a },
    { 0x1040, 0x1049 },
    { 0x1050, 0x1055 },
    { 0x10a0, 0x10c5 },
    { 0x10d0, 0x10f8 },
    { 0x1100, 0x1159 },
    { 0x115f, 0x11a2 },
    { 0x11a8, 0x11f9 },
    { 0x1200, 0x1206 },
    { 0x1208, 0x1246 },
    { 0x1248, 0x1248 },
    { 0x124a, 0x124d },
    { 0x1250, 0x1256 },
    { 0x1258, 0x1258 },
    { 0x125a, 0x125d },
    { 0x1260, 0x1286 },
    { 0x1288, 0x1288 },
    { 0x128a, 0x128d },
    { 0x1290, 0x12ae },
    { 0x12b0, 0x12b0 },
    { 0x12b2, 0x12b5 },
    { 0x12b8, 0x12be },
    { 0x12c0, 0x12c0 },
    { 0x12c2, 0x12c5 },
    { 0x12c8, 0x12ce },
    { 0x12d0, 0x12d6 },
    { 0x12d8, 0x12ee },
    { 0x12f0, 0x130e },
    { 0x1310, 0x1310 },
    { 0x1312, 0x1315 },
    { 0x1318, 0x131e },
    { 0x1320, 0x1346 },
    { 0x1348, 0x135a },
    { 0x1369, 0x1371 },
    { 0x13a0, 0x13f4 },
    { 0x1401, 0x166c },
    { 0x166f, 0x1676 },
    { 0x1681, 0x169a },
    { 0x16a0, 0x16ea },
    { 0x16ee, 0x16f0 },
    { 0x1700, 0x170c },
    { 0x170e, 0x1711 },
    { 0x1720, 0x1731 },
    { 0x1740, 0x1751 },
    { 0x1760, 0x176c },
    { 0x176e, 0x1770 },
    { 0x1780, 0x17b3 },
    { 0x17d7, 0x17d7 },
    { 0x17dc, 0x17dc },
    { 0x17e0, 0x17e9 },
    { 0x1810, 0x1819 },
    { 0x1820, 0x1877 },
    { 0x1880, 0x18a8 },
    { 0x1e00, 0x1e9b },
    { 0x1ea0, 0x1ef9 },
    { 0x1f00, 0x1f15 },
    { 0x1f18, 0x1f1d },
    { 0x1f20, 0x1f45 },
    { 0x1f48, 0x1f4d },
    { 0x1f50, 0x1f57 },
    { 0x1f59, 0x1f59 },
    { 0x1f5b, 0x1f5b },
    { 0x1f5d, 0x1f5d },
    { 0x1f5f, 0x1f7d },
    { 0x1f80, 0x1fb4 },
    { 0x1fb6, 0x1fbc },
    { 0x1fbe, 0x1fbe },
    { 0x1fc2, 0x1fc4 },
    { 0x1fc6, 0x1fcc },
    { 0x1fd0, 0x1fd3 },
    { 0x1fd6, 0x1fdb },
    { 0x1fe0, 0x1fec },
    { 0x1ff2, 0x1ff4 },
    { 0x1ff6, 0x1ffc },
    { 0x2071, 0x2071 },
    { 0x207f, 0x207f },
    { 0x2102, 0x2102 },
    { 0x2107, 0x2107 },
    { 0x210a, 0x2113 },
    { 0x2115, 0x2115 },
    { 0x2119, 0x211d },
    { 0x2124, 0x2124 },
    { 0x2126, 0x2126 },
    { 0x2128, 0x212d },
    { 0x212f, 0x2131 },
    { 0x2133, 0x2139 },
    { 0x213d, 0x213f },
    { 0x2145, 0x2149 },
    { 0x2160, 0x2183 },
    { 0x249c, 0x24e9 },
    { 0x3005, 0x3007 },
    { 0x3021, 0x3029 },
    { 0x3031, 0x3035 },
    { 0x3038, 0x303c },
    { 0x3041, 0x3096 },
    { 0x309d, 0x309f },
    { 0x30a1, 0x30fa },
    { 0x30fc, 0x30ff },
    { 0x3105, 0x312c },
    { 0x3131, 0x318e },
    { 0x31a0, 0x31b7 },
    { 0x31f0, 0x31ff },
    { 0x3400, 0x4db5 },
    { 0x4e00, 0x9fa5 },
    { 0xa000, 0xa48c },
    { 0xac00, 0xd7a3 },
    { 0xf900, 0xfa2d },
    { 0xfa30, 0xfa6a },
    { 0xfb00, 0xfb06 },
    { 0xfb13, 0xfb17 },
    { 0xfb1d, 0xfb1d },
    { 0xfb1f, 0xfb28 },
    { 0xfb2a, 0xfb36 },
    { 0xfb38, 0xfb3c },
    { 0xfb3e, 0xfb3e },
    { 0xfb40, 0xfb41 },
    { 0xfb43, 0xfb44 },
    { 0xfb46, 0xfbb1 },
    { 0xfbd3, 0xfd3d },
    { 0xfd50, 0xfd8f },
    { 0xfd92, 0xfdc7 },
    { 0xfdf0, 0xfdfb },
    { 0xfe70, 0xfe74 },
    { 0xfe76, 0xfefc },
    { 0xff10, 0xff19 },
    { 0xff21, 0xff3a },
    { 0xff41, 0xff5a },
    { 0xff66, 0xffbe },
    { 0xffc2, 0xffc7 },
    { 0xffca, 0xffcf },
    { 0xffd2, 0xffd7 },
    { 0xffda, 0xffdc },
    { 0x10300, 0x1031e },
    { 0x10330, 0x1034a },
    { 0x10400, 0x10425 },
    { 0x10428, 0x1044d },
    { 0x1d400, 0x1d454 },
    { 0x1d456, 0x1d49c },
    { 0x1d49e, 0x1d49f },
    { 0x1d4a2, 0x1d4a2 },
    { 0x1d4a5, 0x1d4a6 },
    { 0x1d4a9, 0x1d4ac },
    { 0x1d4ae, 0x1d4b9 },
    { 0x1d4bb, 0x1d4bb },
    { 0x1d4bd, 0x1d4c0 },
    { 0x1d4c2, 0x1d4c3 },
    { 0x1d4c5, 0x1d505 },
    { 0x1d507, 0x1d50a },
    { 0x1d50d, 0x1d514 },
    { 0x1d516, 0x1d51c },
    { 0x1d51e, 0x1d539 },
    { 0x1d53b, 0x1d53e },
    { 0x1d540, 0x1d544 },
    { 0x1d546, 0x1d546 },
    { 0x1d54a, 0x1d550 },
    { 0x1d552, 0x1d6a3 },
    { 0x1d6a8, 0x1d6c0 },
    { 0x1d6c2, 0x1d6da },
    { 0x1d6dc, 0x1d6fa },
    { 0x1d6fc, 0x1d714 },
    { 0x1d716, 0x1d734 },
    { 0x1d736, 0x1d74e },
    { 0x1d750, 0x1d76e },
    { 0x1d770, 0x1d788 },
    { 0x1d78a, 0x1d7a8 },
    { 0x1d7aa, 0x1d7c2 },
    { 0x1d7c4, 0x1d7c9 },
    { 0x1d7ce, 0x1d7ff },
    { 0x20000, 0x2a6d6 },
    { 0x2f800, 0x2fa1d }
};
static const int table_walpha_count =
  (sizeof(table_walpha)/sizeof(struct interval));

/* ------------------- iswblank -------------------- */
static const struct interval table_wblank[] = {
  { 0x9, 0x9 },
  { 0x20, 0x20 },
  { 0xa0, 0xa0 }, /* non-breaking space */
  { 0x1680, 0x1680 }, /* ogham space mark */
  { 0x2000, 0x2006 }, /* why not figure space, 2007? Not in glibc */
  { 0x2008, 0x200b },
//  { 0x202f, 0x202f }, /* narrow no-break space, not in glibc */
  { 0x205f, 0x205f }, /* medium mathematical space */
  { 0x3000, 0x3000 }  /* (CJK) ideographic space */
};
static const int table_wblank_count =
  (sizeof(table_wblank)/sizeof(struct interval));

/* ------------------- iswcntrl -------------------- */
static const struct interval table_wcntrl[] = {
  { 0x0, 0x1f },
  { 0x7f, 0x9f },
  { 0x2028, 0x2029 }
};
static const int table_wcntrl_count =
  (sizeof(table_wcntrl)/sizeof(struct interval));

/* ------------------- iswdigit -------------------- */
static const struct interval table_wdigit[] = {
    { 0x30, 0x39 }
};
static const int table_wdigit_count =
  (sizeof(table_wdigit)/sizeof(struct interval));

/* ------------------- iswgraph -------------------- */
/* Could be derived from other tables: C99 says

   The iswgraph function tests for any wide character for which
   iswprint is true and iswspace is false
   
   PCRE has

      Graphic character. Implement this as not Z (space or separator) and
      not C (other), except for Cf (format) with a few exceptions. This seems
      to be what Perl does. The exceptional characters are:

      U+061C           Arabic Letter Mark
      U+180E           Mongolian Vowel Separator
      U+2066 - U+2069  Various "isolate"s
*/

static const struct interval table_wgraph[] = {
    { 0x21, 0x7e },
    { 0xa0, 0x220 },
    { 0x222, 0x233 },
    { 0x250, 0x2ad },
    { 0x2b0, 0x2ee },
    { 0x300, 0x34f },
    { 0x360, 0x36f },
    { 0x374, 0x375 },
    { 0x37a, 0x37a },
    { 0x37e, 0x37e },
    { 0x384, 0x38a },
    { 0x38c, 0x38c },
    { 0x38e, 0x3a1 },
    { 0x3a3, 0x3ce },
    { 0x3d0, 0x3f6 },
    { 0x400, 0x486 },
    { 0x488, 0x4ce },
    { 0x4d0, 0x4f5 },
    { 0x4f8, 0x4f9 },
    { 0x500, 0x50f },
    { 0x531, 0x556 },
    { 0x559, 0x55f },
    { 0x561, 0x587 },
    { 0x589, 0x58a },
    { 0x591, 0x5a1 },
    { 0x5a3, 0x5b9 },
    { 0x5bb, 0x5c4 },
    { 0x5d0, 0x5ea },
    { 0x5f0, 0x5f4 },
    { 0x60c, 0x60c },
    { 0x61b, 0x61b },
    { 0x61f, 0x61f },
    { 0x621, 0x63a },
    { 0x640, 0x655 },
    { 0x660, 0x6ed },
    { 0x6f0, 0x6fe },
    { 0x700, 0x70d },
    { 0x70f, 0x72c },
    { 0x730, 0x74a },
    { 0x780, 0x7b1 },
    { 0x901, 0x903 },
    { 0x905, 0x939 },
    { 0x93c, 0x94d },
    { 0x950, 0x954 },
    { 0x958, 0x970 },
    { 0x981, 0x983 },
    { 0x985, 0x98c },
    { 0x98f, 0x990 },
    { 0x993, 0x9a8 },
    { 0x9aa, 0x9b0 },
    { 0x9b2, 0x9b2 },
    { 0x9b6, 0x9b9 },
    { 0x9bc, 0x9bc },
    { 0x9be, 0x9c4 },
    { 0x9c7, 0x9c8 },
    { 0x9cb, 0x9cd },
    { 0x9d7, 0x9d7 },
    { 0x9dc, 0x9dd },
    { 0x9df, 0x9e3 },
    { 0x9e6, 0x9fa },
    { 0xa02, 0xa02 },
    { 0xa05, 0xa0a },
    { 0xa0f, 0xa10 },
    { 0xa13, 0xa28 },
    { 0xa2a, 0xa30 },
    { 0xa32, 0xa33 },
    { 0xa35, 0xa36 },
    { 0xa38, 0xa39 },
    { 0xa3c, 0xa3c },
    { 0xa3e, 0xa42 },
    { 0xa47, 0xa48 },
    { 0xa4b, 0xa4d },
    { 0xa59, 0xa5c },
    { 0xa5e, 0xa5e },
    { 0xa66, 0xa74 },
    { 0xa81, 0xa83 },
    { 0xa85, 0xa8b },
    { 0xa8d, 0xa8d },
    { 0xa8f, 0xa91 },
    { 0xa93, 0xaa8 },
    { 0xaaa, 0xab0 },
    { 0xab2, 0xab3 },
    { 0xab5, 0xab9 },
    { 0xabc, 0xac5 },
    { 0xac7, 0xac9 },
    { 0xacb, 0xacd },
    { 0xad0, 0xad0 },
    { 0xae0, 0xae0 },
    { 0xae6, 0xaef },
    { 0xb01, 0xb03 },
    { 0xb05, 0xb0c },
    { 0xb0f, 0xb10 },
    { 0xb13, 0xb28 },
    { 0xb2a, 0xb30 },
    { 0xb32, 0xb33 },
    { 0xb36, 0xb39 },
    { 0xb3c, 0xb43 },
    { 0xb47, 0xb48 },
    { 0xb4b, 0xb4d },
    { 0xb56, 0xb57 },
    { 0xb5c, 0xb5d },
    { 0xb5f, 0xb61 },
    { 0xb66, 0xb70 },
    { 0xb82, 0xb83 },
    { 0xb85, 0xb8a },
    { 0xb8e, 0xb90 },
    { 0xb92, 0xb95 },
    { 0xb99, 0xb9a },
    { 0xb9c, 0xb9c },
    { 0xb9e, 0xb9f },
    { 0xba3, 0xba4 },
    { 0xba8, 0xbaa },
    { 0xbae, 0xbb5 },
    { 0xbb7, 0xbb9 },
    { 0xbbe, 0xbc2 },
    { 0xbc6, 0xbc8 },
    { 0xbca, 0xbcd },
    { 0xbd7, 0xbd7 },
    { 0xbe7, 0xbf2 },
    { 0xc01, 0xc03 },
    { 0xc05, 0xc0c },
    { 0xc0e, 0xc10 },
    { 0xc12, 0xc28 },
    { 0xc2a, 0xc33 },
    { 0xc35, 0xc39 },
    { 0xc3e, 0xc44 },
    { 0xc46, 0xc48 },
    { 0xc4a, 0xc4d },
    { 0xc55, 0xc56 },
    { 0xc60, 0xc61 },
    { 0xc66, 0xc6f },
    { 0xc82, 0xc83 },
    { 0xc85, 0xc8c },
    { 0xc8e, 0xc90 },
    { 0xc92, 0xca8 },
    { 0xcaa, 0xcb3 },
    { 0xcb5, 0xcb9 },
    { 0xcbe, 0xcc4 },
    { 0xcc6, 0xcc8 },
    { 0xcca, 0xccd },
    { 0xcd5, 0xcd6 },
    { 0xcde, 0xcde },
    { 0xce0, 0xce1 },
    { 0xce6, 0xcef },
    { 0xd02, 0xd03 },
    { 0xd05, 0xd0c },
    { 0xd0e, 0xd10 },
    { 0xd12, 0xd28 },
    { 0xd2a, 0xd39 },
    { 0xd3e, 0xd43 },
    { 0xd46, 0xd48 },
    { 0xd4a, 0xd4d },
    { 0xd57, 0xd57 },
    { 0xd60, 0xd61 },
    { 0xd66, 0xd6f },
    { 0xd82, 0xd83 },
    { 0xd85, 0xd96 },
    { 0xd9a, 0xdb1 },
    { 0xdb3, 0xdbb },
    { 0xdbd, 0xdbd },
    { 0xdc0, 0xdc6 },
    { 0xdca, 0xdca },
    { 0xdcf, 0xdd4 },
    { 0xdd6, 0xdd6 },
    { 0xdd8, 0xddf },
    { 0xdf2, 0xdf4 },
    { 0xe01, 0xe3a },
    { 0xe3f, 0xe5b },
    { 0xe81, 0xe82 },
    { 0xe84, 0xe84 },
    { 0xe87, 0xe88 },
    { 0xe8a, 0xe8a },
    { 0xe8d, 0xe8d },
    { 0xe94, 0xe97 },
    { 0xe99, 0xe9f },
    { 0xea1, 0xea3 },
    { 0xea5, 0xea5 },
    { 0xea7, 0xea7 },
    { 0xeaa, 0xeab },
    { 0xead, 0xeb9 },
    { 0xebb, 0xebd },
    { 0xec0, 0xec4 },
    { 0xec6, 0xec6 },
    { 0xec8, 0xecd },
    { 0xed0, 0xed9 },
    { 0xedc, 0xedd },
    { 0xf00, 0xf47 },
    { 0xf49, 0xf6a },
    { 0xf71, 0xf8b },
    { 0xf90, 0xf97 },
    { 0xf99, 0xfbc },
    { 0xfbe, 0xfcc },
    { 0xfcf, 0xfcf },
    { 0x1000, 0x1021 },
    { 0x1023, 0x1027 },
    { 0x1029, 0x102a },
    { 0x102c, 0x1032 },
    { 0x1036, 0x1039 },
    { 0x1040, 0x1059 },
    { 0x10a0, 0x10c5 },
    { 0x10d0, 0x10f8 },
    { 0x10fb, 0x10fb },
    { 0x1100, 0x1159 },
    { 0x115f, 0x11a2 },
    { 0x11a8, 0x11f9 },
    { 0x1200, 0x1206 },
    { 0x1208, 0x1246 },
    { 0x1248, 0x1248 },
    { 0x124a, 0x124d },
    { 0x1250, 0x1256 },
    { 0x1258, 0x1258 },
    { 0x125a, 0x125d },
    { 0x1260, 0x1286 },
    { 0x1288, 0x1288 },
    { 0x128a, 0x128d },
    { 0x1290, 0x12ae },
    { 0x12b0, 0x12b0 },
    { 0x12b2, 0x12b5 },
    { 0x12b8, 0x12be },
    { 0x12c0, 0x12c0 },
    { 0x12c2, 0x12c5 },
    { 0x12c8, 0x12ce },
    { 0x12d0, 0x12d6 },
    { 0x12d8, 0x12ee },
    { 0x12f0, 0x130e },
    { 0x1310, 0x1310 },
    { 0x1312, 0x1315 },
    { 0x1318, 0x131e },
    { 0x1320, 0x1346 },
    { 0x1348, 0x135a },
    { 0x1361, 0x137c },
    { 0x13a0, 0x13f4 },
    { 0x1401, 0x1676 },
    { 0x1681, 0x169c },
    { 0x16a0, 0x16f0 },
    { 0x1700, 0x170c },
    { 0x170e, 0x1714 },
    { 0x1720, 0x1736 },
    { 0x1740, 0x1753 },
    { 0x1760, 0x176c },
    { 0x176e, 0x1770 },
    { 0x1772, 0x1773 },
    { 0x1780, 0x17dc },
    { 0x17e0, 0x17e9 },
    { 0x1800, 0x180e },
    { 0x1810, 0x1819 },
    { 0x1820, 0x1877 },
    { 0x1880, 0x18a9 },
    { 0x1e00, 0x1e9b },
    { 0x1ea0, 0x1ef9 },
    { 0x1f00, 0x1f15 },
    { 0x1f18, 0x1f1d },
    { 0x1f20, 0x1f45 },
    { 0x1f48, 0x1f4d },
    { 0x1f50, 0x1f57 },
    { 0x1f59, 0x1f59 },
    { 0x1f5b, 0x1f5b },
    { 0x1f5d, 0x1f5d },
    { 0x1f5f, 0x1f7d },
    { 0x1f80, 0x1fb4 },
    { 0x1fb6, 0x1fc4 },
    { 0x1fc6, 0x1fd3 },
    { 0x1fd6, 0x1fdb },
    { 0x1fdd, 0x1fef },
    { 0x1ff2, 0x1ff4 },
    { 0x1ff6, 0x1ffe },
    { 0x2007, 0x2007 },
    { 0x200b, 0x200b }, // excluded from space
    { 0x200c, 0x2027 },
    { 0x202a, 0x2052 },
    { 0x2057, 0x2057 },
    { 0x2060, 0x2063 },
    { 0x206a, 0x2071 },
    { 0x2074, 0x208e },
    { 0x20a0, 0x20b1 },
    { 0x20d0, 0x20ea },
    { 0x2100, 0x213a },
    { 0x213d, 0x214b },
    { 0x2153, 0x2183 },
    { 0x2190, 0x23ce },
    { 0x2400, 0x2426 },
    { 0x2440, 0x244a },
    { 0x2460, 0x24fe },
    { 0x2500, 0x2613 },
    { 0x2616, 0x2617 },
    { 0x2619, 0x267d },
    { 0x2680, 0x2689 },
    { 0x2701, 0x2704 },
    { 0x2706, 0x2709 },
    { 0x270c, 0x2727 },
    { 0x2729, 0x274b },
    { 0x274d, 0x274d },
    { 0x274f, 0x2752 },
    { 0x2756, 0x2756 },
    { 0x2758, 0x275e },
    { 0x2761, 0x2794 },
    { 0x2798, 0x27af },
    { 0x27b1, 0x27be },
    { 0x27d0, 0x27eb },
    { 0x27f0, 0x2aff },
    { 0x2e80, 0x2e99 },
    { 0x2e9b, 0x2ef3 },
    { 0x2f00, 0x2fd5 },
    { 0x2ff0, 0x2ffb },
    { 0x3001, 0x303f },
    { 0x3041, 0x3096 },
    { 0x3099, 0x30ff },
    { 0x3105, 0x312c },
    { 0x3131, 0x318e },
    { 0x3190, 0x31b7 },
    { 0x31f0, 0x321c },
    { 0x3220, 0x3243 },
    { 0x3251, 0x327b },
    { 0x327f, 0x32cb },
    { 0x32d0, 0x32fe },
    { 0x3300, 0x3376 },
    { 0x337b, 0x33dd },
    { 0x33e0, 0x33fe },
    { 0x3400, 0x4db5 },
    { 0x4e00, 0x9fa5 },
    { 0xa000, 0xa48c },
    { 0xa490, 0xa4c6 },
    { 0xac00, 0xd7a3 },
    { 0xe000, 0xfa2d },
    { 0xfa30, 0xfa6a },
    { 0xfb00, 0xfb06 },
    { 0xfb13, 0xfb17 },
    { 0xfb1d, 0xfb36 },
    { 0xfb38, 0xfb3c },
    { 0xfb3e, 0xfb3e },
    { 0xfb40, 0xfb41 },
    { 0xfb43, 0xfb44 },
    { 0xfb46, 0xfbb1 },
    { 0xfbd3, 0xfd3f },
    { 0xfd50, 0xfd8f },
    { 0xfd92, 0xfdc7 },
    { 0xfdf0, 0xfdfc },
    { 0xfe00, 0xfe0f },
    { 0xfe20, 0xfe23 },
    { 0xfe30, 0xfe46 },
    { 0xfe49, 0xfe52 },
    { 0xfe54, 0xfe66 },
    { 0xfe68, 0xfe6b },
    { 0xfe70, 0xfe74 },
    { 0xfe76, 0xfefc },
    { 0xfeff, 0xfeff },
    { 0xff01, 0xffbe },
    { 0xffc2, 0xffc7 },
    { 0xffca, 0xffcf },
    { 0xffd2, 0xffd7 },
    { 0xffda, 0xffdc },
    { 0xffe0, 0xffe6 },
    { 0xffe8, 0xffee },
    { 0xfff9, 0xfffd },
    { 0x10300, 0x1031e },
    { 0x10320, 0x10323 },
    { 0x10330, 0x1034a },
    { 0x10400, 0x10425 },
    { 0x10428, 0x1044d },
    { 0x1d000, 0x1d0f5 },
    { 0x1d100, 0x1d126 },
    { 0x1d12a, 0x1d1dd },
    { 0x1d400, 0x1d454 },
    { 0x1d456, 0x1d49c },
    { 0x1d49e, 0x1d49f },
    { 0x1d4a2, 0x1d4a2 },
    { 0x1d4a5, 0x1d4a6 },
    { 0x1d4a9, 0x1d4ac },
    { 0x1d4ae, 0x1d4b9 },
    { 0x1d4bb, 0x1d4bb },
    { 0x1d4bd, 0x1d4c0 },
    { 0x1d4c2, 0x1d4c3 },
    { 0x1d4c5, 0x1d505 },
    { 0x1d507, 0x1d50a },
    { 0x1d50d, 0x1d514 },
    { 0x1d516, 0x1d51c },
    { 0x1d51e, 0x1d539 },
    { 0x1d53b, 0x1d53e },
    { 0x1d540, 0x1d544 },
    { 0x1d546, 0x1d546 },
    { 0x1d54a, 0x1d550 },
    { 0x1d552, 0x1d6a3 },
    { 0x1d6a8, 0x1d7c9 },
    { 0x1d7ce, 0x1d7ff },
    { 0x20000, 0x2a6d6 },
    { 0x2f800, 0x2fa1d },
    { 0xe0001, 0xe0001 },
    { 0xe0020, 0xe007f },
    { 0xf0000, 0xffffd },
    { 0x100000, 0x10fffd }
};
static const int table_wgraph_count =
  (sizeof(table_wgraph)/sizeof(struct interval));

/* ------------------- iswlower -------------------- */
static const struct interval table_wlower[] = {
    { 0x61, 0x7a },
    { 0xb5, 0xb5 },
    { 0xdf, 0xf6 },
    { 0xf8, 0xff },
    { 0x101, 0x101 },
    { 0x103, 0x103 },
    { 0x105, 0x105 },
    { 0x107, 0x107 },
    { 0x109, 0x109 },
    { 0x10b, 0x10b },
    { 0x10d, 0x10d },
    { 0x10f, 0x10f },
    { 0x111, 0x111 },
    { 0x113, 0x113 },
    { 0x115, 0x115 },
    { 0x117, 0x117 },
    { 0x119, 0x119 },
    { 0x11b, 0x11b },
    { 0x11d, 0x11d },
    { 0x11f, 0x11f },
    { 0x121, 0x121 },
    { 0x123, 0x123 },
    { 0x125, 0x125 },
    { 0x127, 0x127 },
    { 0x129, 0x129 },
    { 0x12b, 0x12b },
    { 0x12d, 0x12d },
    { 0x12f, 0x12f },
    { 0x131, 0x131 },
    { 0x133, 0x133 },
    { 0x135, 0x135 },
    { 0x137, 0x137 },
    { 0x13a, 0x13a },
    { 0x13c, 0x13c },
    { 0x13e, 0x13e },
    { 0x140, 0x140 },
    { 0x142, 0x142 },
    { 0x144, 0x144 },
    { 0x146, 0x146 },
    { 0x148, 0x148 },
    { 0x14b, 0x14b },
    { 0x14d, 0x14d },
    { 0x14f, 0x14f },
    { 0x151, 0x151 },
    { 0x153, 0x153 },
    { 0x155, 0x155 },
    { 0x157, 0x157 },
    { 0x159, 0x159 },
    { 0x15b, 0x15b },
    { 0x15d, 0x15d },
    { 0x15f, 0x15f },
    { 0x161, 0x161 },
    { 0x163, 0x163 },
    { 0x165, 0x165 },
    { 0x167, 0x167 },
    { 0x169, 0x169 },
    { 0x16b, 0x16b },
    { 0x16d, 0x16d },
    { 0x16f, 0x16f },
    { 0x171, 0x171 },
    { 0x173, 0x173 },
    { 0x175, 0x175 },
    { 0x177, 0x177 },
    { 0x17a, 0x17a },
    { 0x17c, 0x17c },
    { 0x17e, 0x17f },
    { 0x183, 0x183 },
    { 0x185, 0x185 },
    { 0x188, 0x188 },
    { 0x18c, 0x18c },
    { 0x192, 0x192 },
    { 0x195, 0x195 },
    { 0x199, 0x199 },
    { 0x19e, 0x19e },
    { 0x1a1, 0x1a1 },
    { 0x1a3, 0x1a3 },
    { 0x1a5, 0x1a5 },
    { 0x1a8, 0x1a8 },
    { 0x1ad, 0x1ad },
    { 0x1b0, 0x1b0 },
    { 0x1b4, 0x1b4 },
    { 0x1b6, 0x1b6 },
    { 0x1b9, 0x1b9 },
    { 0x1bd, 0x1bd },
    { 0x1bf, 0x1bf },
    { 0x1c5, 0x1c6 },
    { 0x1c8, 0x1c9 },
    { 0x1cb, 0x1cc },
    { 0x1ce, 0x1ce },
    { 0x1d0, 0x1d0 },
    { 0x1d2, 0x1d2 },
    { 0x1d4, 0x1d4 },
    { 0x1d6, 0x1d6 },
    { 0x1d8, 0x1d8 },
    { 0x1da, 0x1da },
    { 0x1dc, 0x1dd },
    { 0x1df, 0x1df },
    { 0x1e1, 0x1e1 },
    { 0x1e3, 0x1e3 },
    { 0x1e5, 0x1e5 },
    { 0x1e7, 0x1e7 },
    { 0x1e9, 0x1e9 },
    { 0x1eb, 0x1eb },
    { 0x1ed, 0x1ed },
    { 0x1ef, 0x1ef },
    { 0x1f2, 0x1f3 },
    { 0x1f5, 0x1f5 },
    { 0x1f9, 0x1f9 },
    { 0x1fb, 0x1fb },
    { 0x1fd, 0x1fd },
    { 0x1ff, 0x1ff },
    { 0x201, 0x201 },
    { 0x203, 0x203 },
    { 0x205, 0x205 },
    { 0x207, 0x207 },
    { 0x209, 0x209 },
    { 0x20b, 0x20b },
    { 0x20d, 0x20d },
    { 0x20f, 0x20f },
    { 0x211, 0x211 },
    { 0x213, 0x213 },
    { 0x215, 0x215 },
    { 0x217, 0x217 },
    { 0x219, 0x219 },
    { 0x21b, 0x21b },
    { 0x21d, 0x21d },
    { 0x21f, 0x21f },
    { 0x223, 0x223 },
    { 0x225, 0x225 },
    { 0x227, 0x227 },
    { 0x229, 0x229 },
    { 0x22b, 0x22b },
    { 0x22d, 0x22d },
    { 0x22f, 0x22f },
    { 0x231, 0x231 },
    { 0x233, 0x233 },
    { 0x253, 0x254 },
    { 0x256, 0x257 },
    { 0x259, 0x259 },
    { 0x25b, 0x25b },
    { 0x260, 0x260 },
    { 0x263, 0x263 },
    { 0x268, 0x269 },
    { 0x26f, 0x26f },
    { 0x272, 0x272 },
    { 0x275, 0x275 },
    { 0x280, 0x280 },
    { 0x283, 0x283 },
    { 0x288, 0x288 },
    { 0x28a, 0x28b },
    { 0x292, 0x292 },
    { 0x345, 0x345 },
    { 0x3ac, 0x3af },
    { 0x3b1, 0x3ce },
    { 0x3d0, 0x3d1 },
    { 0x3d5, 0x3d6 },
    { 0x3d9, 0x3d9 },
    { 0x3db, 0x3db },
    { 0x3dd, 0x3dd },
    { 0x3df, 0x3df },
    { 0x3e1, 0x3e1 },
    { 0x3e3, 0x3e3 },
    { 0x3e5, 0x3e5 },
    { 0x3e7, 0x3e7 },
    { 0x3e9, 0x3e9 },
    { 0x3eb, 0x3eb },
    { 0x3ed, 0x3ed },
    { 0x3ef, 0x3f2 },
    { 0x3f5, 0x3f5 },
    { 0x430, 0x45f },
    { 0x461, 0x461 },
    { 0x463, 0x463 },
    { 0x465, 0x465 },
    { 0x467, 0x467 },
    { 0x469, 0x469 },
    { 0x46b, 0x46b },
    { 0x46d, 0x46d },
    { 0x46f, 0x46f },
    { 0x471, 0x471 },
    { 0x473, 0x473 },
    { 0x475, 0x475 },
    { 0x477, 0x477 },
    { 0x479, 0x479 },
    { 0x47b, 0x47b },
    { 0x47d, 0x47d },
    { 0x47f, 0x47f },
    { 0x481, 0x481 },
    { 0x48b, 0x48b },
    { 0x48d, 0x48d },
    { 0x48f, 0x48f },
    { 0x491, 0x491 },
    { 0x493, 0x493 },
    { 0x495, 0x495 },
    { 0x497, 0x497 },
    { 0x499, 0x499 },
    { 0x49b, 0x49b },
    { 0x49d, 0x49d },
    { 0x49f, 0x49f },
    { 0x4a1, 0x4a1 },
    { 0x4a3, 0x4a3 },
    { 0x4a5, 0x4a5 },
    { 0x4a7, 0x4a7 },
    { 0x4a9, 0x4a9 },
    { 0x4ab, 0x4ab },
    { 0x4ad, 0x4ad },
    { 0x4af, 0x4af },
    { 0x4b1, 0x4b1 },
    { 0x4b3, 0x4b3 },
    { 0x4b5, 0x4b5 },
    { 0x4b7, 0x4b7 },
    { 0x4b9, 0x4b9 },
    { 0x4bb, 0x4bb },
    { 0x4bd, 0x4bd },
    { 0x4bf, 0x4bf },
    { 0x4c2, 0x4c2 },
    { 0x4c4, 0x4c4 },
    { 0x4c6, 0x4c6 },
    { 0x4c8, 0x4c8 },
    { 0x4ca, 0x4ca },
    { 0x4cc, 0x4cc },
    { 0x4ce, 0x4ce },
    { 0x4d1, 0x4d1 },
    { 0x4d3, 0x4d3 },
    { 0x4d5, 0x4d5 },
    { 0x4d7, 0x4d7 },
    { 0x4d9, 0x4d9 },
    { 0x4db, 0x4db },
    { 0x4dd, 0x4dd },
    { 0x4df, 0x4df },
    { 0x4e1, 0x4e1 },
    { 0x4e3, 0x4e3 },
    { 0x4e5, 0x4e5 },
    { 0x4e7, 0x4e7 },
    { 0x4e9, 0x4e9 },
    { 0x4eb, 0x4eb },
    { 0x4ed, 0x4ed },
    { 0x4ef, 0x4ef },
    { 0x4f1, 0x4f1 },
    { 0x4f3, 0x4f3 },
    { 0x4f5, 0x4f5 },
    { 0x4f9, 0x4f9 },
    { 0x501, 0x501 },
    { 0x503, 0x503 },
    { 0x505, 0x505 },
    { 0x507, 0x507 },
    { 0x509, 0x509 },
    { 0x50b, 0x50b },
    { 0x50d, 0x50d },
    { 0x50f, 0x50f },
    { 0x561, 0x586 },
    { 0x1e01, 0x1e01 },
    { 0x1e03, 0x1e03 },
    { 0x1e05, 0x1e05 },
    { 0x1e07, 0x1e07 },
    { 0x1e09, 0x1e09 },
    { 0x1e0b, 0x1e0b },
    { 0x1e0d, 0x1e0d },
    { 0x1e0f, 0x1e0f },
    { 0x1e11, 0x1e11 },
    { 0x1e13, 0x1e13 },
    { 0x1e15, 0x1e15 },
    { 0x1e17, 0x1e17 },
    { 0x1e19, 0x1e19 },
    { 0x1e1b, 0x1e1b },
    { 0x1e1d, 0x1e1d },
    { 0x1e1f, 0x1e1f },
    { 0x1e21, 0x1e21 },
    { 0x1e23, 0x1e23 },
    { 0x1e25, 0x1e25 },
    { 0x1e27, 0x1e27 },
    { 0x1e29, 0x1e29 },
    { 0x1e2b, 0x1e2b },
    { 0x1e2d, 0x1e2d },
    { 0x1e2f, 0x1e2f },
    { 0x1e31, 0x1e31 },
    { 0x1e33, 0x1e33 },
    { 0x1e35, 0x1e35 },
    { 0x1e37, 0x1e37 },
    { 0x1e39, 0x1e39 },
    { 0x1e3b, 0x1e3b },
    { 0x1e3d, 0x1e3d },
    { 0x1e3f, 0x1e3f },
    { 0x1e41, 0x1e41 },
    { 0x1e43, 0x1e43 },
    { 0x1e45, 0x1e45 },
    { 0x1e47, 0x1e47 },
    { 0x1e49, 0x1e49 },
    { 0x1e4b, 0x1e4b },
    { 0x1e4d, 0x1e4d },
    { 0x1e4f, 0x1e4f },
    { 0x1e51, 0x1e51 },
    { 0x1e53, 0x1e53 },
    { 0x1e55, 0x1e55 },
    { 0x1e57, 0x1e57 },
    { 0x1e59, 0x1e59 },
    { 0x1e5b, 0x1e5b },
    { 0x1e5d, 0x1e5d },
    { 0x1e5f, 0x1e5f },
    { 0x1e61, 0x1e61 },
    { 0x1e63, 0x1e63 },
    { 0x1e65, 0x1e65 },
    { 0x1e67, 0x1e67 },
    { 0x1e69, 0x1e69 },
    { 0x1e6b, 0x1e6b },
    { 0x1e6d, 0x1e6d },
    { 0x1e6f, 0x1e6f },
    { 0x1e71, 0x1e71 },
    { 0x1e73, 0x1e73 },
    { 0x1e75, 0x1e75 },
    { 0x1e77, 0x1e77 },
    { 0x1e79, 0x1e79 },
    { 0x1e7b, 0x1e7b },
    { 0x1e7d, 0x1e7d },
    { 0x1e7f, 0x1e7f },
    { 0x1e81, 0x1e81 },
    { 0x1e83, 0x1e83 },
    { 0x1e85, 0x1e85 },
    { 0x1e87, 0x1e87 },
    { 0x1e89, 0x1e89 },
    { 0x1e8b, 0x1e8b },
    { 0x1e8d, 0x1e8d },
    { 0x1e8f, 0x1e8f },
    { 0x1e91, 0x1e91 },
    { 0x1e93, 0x1e93 },
    { 0x1e95, 0x1e95 },
    { 0x1e9b, 0x1e9b },
    { 0x1ea1, 0x1ea1 },
    { 0x1ea3, 0x1ea3 },
    { 0x1ea5, 0x1ea5 },
    { 0x1ea7, 0x1ea7 },
    { 0x1ea9, 0x1ea9 },
    { 0x1eab, 0x1eab },
    { 0x1ead, 0x1ead },
    { 0x1eaf, 0x1eaf },
    { 0x1eb1, 0x1eb1 },
    { 0x1eb3, 0x1eb3 },
    { 0x1eb5, 0x1eb5 },
    { 0x1eb7, 0x1eb7 },
    { 0x1eb9, 0x1eb9 },
    { 0x1ebb, 0x1ebb },
    { 0x1ebd, 0x1ebd },
    { 0x1ebf, 0x1ebf },
    { 0x1ec1, 0x1ec1 },
    { 0x1ec3, 0x1ec3 },
    { 0x1ec5, 0x1ec5 },
    { 0x1ec7, 0x1ec7 },
    { 0x1ec9, 0x1ec9 },
    { 0x1ecb, 0x1ecb },
    { 0x1ecd, 0x1ecd },
    { 0x1ecf, 0x1ecf },
    { 0x1ed1, 0x1ed1 },
    { 0x1ed3, 0x1ed3 },
    { 0x1ed5, 0x1ed5 },
    { 0x1ed7, 0x1ed7 },
    { 0x1ed9, 0x1ed9 },
    { 0x1edb, 0x1edb },
    { 0x1edd, 0x1edd },
    { 0x1edf, 0x1edf },
    { 0x1ee1, 0x1ee1 },
    { 0x1ee3, 0x1ee3 },
    { 0x1ee5, 0x1ee5 },
    { 0x1ee7, 0x1ee7 },
    { 0x1ee9, 0x1ee9 },
    { 0x1eeb, 0x1eeb },
    { 0x1eed, 0x1eed },
    { 0x1eef, 0x1eef },
    { 0x1ef1, 0x1ef1 },
    { 0x1ef3, 0x1ef3 },
    { 0x1ef5, 0x1ef5 },
    { 0x1ef7, 0x1ef7 },
    { 0x1ef9, 0x1ef9 },
    { 0x1f00, 0x1f07 },
    { 0x1f10, 0x1f15 },
    { 0x1f20, 0x1f27 },
    { 0x1f30, 0x1f37 },
    { 0x1f40, 0x1f45 },
    { 0x1f51, 0x1f51 },
    { 0x1f53, 0x1f53 },
    { 0x1f55, 0x1f55 },
    { 0x1f57, 0x1f57 },
    { 0x1f60, 0x1f67 },
    { 0x1f70, 0x1f7d },
    { 0x1f80, 0x1f87 },
    { 0x1f90, 0x1f97 },
    { 0x1fa0, 0x1fa7 },
    { 0x1fb0, 0x1fb1 },
    { 0x1fb3, 0x1fb3 },
    { 0x1fbe, 0x1fbe },
    { 0x1fc3, 0x1fc3 },
    { 0x1fd0, 0x1fd1 },
    { 0x1fe0, 0x1fe1 },
    { 0x1fe5, 0x1fe5 },
    { 0x1ff3, 0x1ff3 },
    { 0x2170, 0x217f },
    { 0x24d0, 0x24e9 },
    { 0xff41, 0xff5a },
    { 0x10428, 0x1044d }
};
static const int table_wlower_count =
  (sizeof(table_wlower)/sizeof(struct interval));

/* ------------------- iswprint -------------------- */
static const struct interval table_wprint[] = {
    { 0x20, 0x7e },
    { 0xa0, 0x377 },
    { 0x38e, 0x3a1 },
    { 0x384, 0x38a },
    { 0x38c, 0x38c },
    { 0x38e, 0x3a1 },
    { 0x58d, 0x58f },
    { 0x531, 0x556 },
    { 0x5d0, 0x5ea },
    { 0x5ef, 0x5f4 },
    { 0x600, 0x61c },
    { 0x5d0, 0x5ea },
    { 0x70f, 0x74a },
    { 0x74d, 0x7b1 },
    { 0x7c0, 0x7fa },
    { 0x7fd, 0x82d },
    { 0x830, 0x83e },
    { 0x840, 0x85b },
    { 0x85e, 0x85e },
    { 0x860, 0x86a },
    { 0x8a0, 0x8b4 },
    { 0x8b6, 0x8c7 },
    { 0x8d3, 0x983 },
    { 0x985, 0x98c },
    { 0x98f, 0x990 },
    { 0x993, 0x9a8 },
    { 0x985, 0x98c },
    { 0x98f, 0x990 },
    { 0x993, 0x9a8 },
    { 0x9aa, 0x9b0 },
    { 0x9b2, 0x9b2 },
    { 0x9b6, 0x9b9 },
    { 0x9d7, 0x9d7 },
    { 0x9c7, 0x9c8 },
    { 0x9df, 0x9e3 },
    { 0x9d7, 0x9d7 },
    { 0x9dc, 0x9dd },
    { 0x9df, 0x9e3 },
    { 0xa0f, 0xa10 },
    { 0xa13, 0xa28 },
    { 0xa05, 0xa0a },
    { 0xa0f, 0xa10 },
    { 0xa13, 0xa28 },
    { 0xa2a, 0xa30 },
    { 0xa32, 0xa33 },
    { 0xa35, 0xa36 },
    { 0xa38, 0xa39 },
    { 0xa3c, 0xa3c },
    { 0xa3e, 0xa42 },
    { 0xa47, 0xa48 },
    { 0xa4b, 0xa4d },
    { 0xa66, 0xa76 },
    { 0xa59, 0xa5c },
    { 0xa5e, 0xa5e },
    { 0xa8f, 0xa91 },
    { 0xa81, 0xa83 },
    { 0xaaa, 0xab0 },
    { 0xa8f, 0xa91 },
    { 0xa93, 0xaa8 },
    { 0xaaa, 0xab0 },
    { 0xab2, 0xab3 },
    { 0xab5, 0xab9 },
    { 0xabc, 0xac5 },
    { 0xac7, 0xac9 },
    { 0xacb, 0xacd },
    { 0xad0, 0xad0 },
    { 0xb01, 0xb03 },
    { 0xb05, 0xb0c },
    { 0xb0f, 0xb10 },
    { 0xb01, 0xb03 },
    { 0xb05, 0xb0c },
    { 0xb0f, 0xb10 },
    { 0xb13, 0xb28 },
    { 0xb2a, 0xb30 },
    { 0xb32, 0xb33 },
    { 0xb4b, 0xb4d },
    { 0xb55, 0xb57 },
    { 0xb47, 0xb48 },
    { 0xb4b, 0xb4d },
    { 0xb66, 0xb77 },
    { 0xb5c, 0xb5d },
    { 0xb85, 0xb8a },
    { 0xb8e, 0xb90 },
    { 0xb82, 0xb83 },
    { 0xb85, 0xb8a },
    { 0xb8e, 0xb90 },
    { 0xb92, 0xb95 },
    { 0xb99, 0xb9a },
    { 0xb9c, 0xb9c },
    { 0xb9e, 0xb9f },
    { 0xba3, 0xba4 },
    { 0xba8, 0xbaa },
    { 0xbca, 0xbcd },
    { 0xbbe, 0xbc2 },
    { 0xbc6, 0xbc8 },
    { 0xbca, 0xbcd },
    { 0xc00, 0xc0c },
    { 0xbd7, 0xbd7 },
    { 0xc12, 0xc28 },
    { 0xc2a, 0xc39 },
    { 0xc0e, 0xc10 },
    { 0xc12, 0xc28 },
    { 0xc4a, 0xc4d },
    { 0xc55, 0xc56 },
    { 0xc46, 0xc48 },
    { 0xc4a, 0xc4d },
    { 0xc55, 0xc56 },
    { 0xc77, 0xc8c },
    { 0xc8e, 0xc90 },
    { 0xc66, 0xc6f },
    { 0xcaa, 0xcb3 },
    { 0xc8e, 0xc90 },
    { 0xc92, 0xca8 },
    { 0xcaa, 0xcb3 },
    { 0xcb5, 0xcb9 },
    { 0xcd5, 0xcd6 },
    { 0xcc6, 0xcc8 },
    { 0xcca, 0xccd },
    { 0xcd5, 0xcd6 },
    { 0xcde, 0xcde },
    { 0xd00, 0xd0c },
    { 0xce6, 0xcef },
    { 0xd12, 0xd44 },
    { 0xd46, 0xd48 },
    { 0xd0e, 0xd10 },
    { 0xd54, 0xd63 },
    { 0xd46, 0xd48 },
    { 0xd81, 0xd83 },
    { 0xd85, 0xd96 },
    { 0xd9a, 0xdb1 },
    { 0xdb3, 0xdbb },
    { 0xd85, 0xd96 },
    { 0xd9a, 0xdb1 },
    { 0xdb3, 0xdbb },
    { 0xdbd, 0xdbd },
    { 0xdc0, 0xdc6 },
    { 0xdca, 0xdca },
    { 0xdcf, 0xdd4 },
    { 0xdd6, 0xdd6 },
    { 0xdd8, 0xddf },
    { 0xe3f, 0xe5b },
    { 0xdf2, 0xdf4 },
    { 0xe01, 0xe3a },
    { 0xe3f, 0xe5b },
    { 0xe81, 0xe82 },
    { 0xe84, 0xe84 },
    { 0xea7, 0xebd },
    { 0xec0, 0xec4 },
    { 0xea5, 0xea5 },
    { 0xec8, 0xecd },
    { 0xec0, 0xec4 },
    { 0xec6, 0xec6 },
    { 0xec8, 0xecd },
    { 0xed0, 0xed9 },
    { 0xf71, 0xf97 },
    { 0xf00, 0xf47 },
    { 0xfbe, 0xfcc },
    { 0xfce, 0xfda },
    { 0xf99, 0xfbc },
    { 0xfbe, 0xfcc },
    { 0x10cd, 0x10cd },
    { 0x10d0, 0x1248 },
    { 0x124a, 0x124d },
    { 0x1250, 0x1256 },
    { 0x1258, 0x1258 },
    { 0x124a, 0x124d },
    { 0x1250, 0x1256 },
    { 0x1258, 0x1258 },
    { 0x125a, 0x125d },
    { 0x12b2, 0x12b5 },
    { 0x128a, 0x128d },
    { 0x12c0, 0x12c0 },
    { 0x12b2, 0x12b5 },
    { 0x12b8, 0x12be },
    { 0x12c0, 0x12c0 },
    { 0x12c2, 0x12c5 },
    { 0x1318, 0x135a },
    { 0x135d, 0x137c },
    { 0x1312, 0x1315 },
    { 0x13a0, 0x13f5 },
    { 0x13f8, 0x13fd },
    { 0x1400, 0x169c },
    { 0x16a0, 0x16f8 },
    { 0x1700, 0x170c },
    { 0x170e, 0x1714 },
    { 0x1720, 0x1736 },
    { 0x1700, 0x170c },
    { 0x170e, 0x1714 },
    { 0x1720, 0x1736 },
    { 0x1740, 0x1753 },
    { 0x1760, 0x176c },
    { 0x176e, 0x1770 },
    { 0x1772, 0x1773 },
    { 0x1800, 0x180e },
    { 0x17e0, 0x17e9 },
    { 0x1820, 0x1878 },
    { 0x1800, 0x180e },
    { 0x1810, 0x1819 },
    { 0x1900, 0x191e },
    { 0x1920, 0x192b },
    { 0x1930, 0x193b },
    { 0x1940, 0x1940 },
    { 0x1944, 0x196d },
    { 0x1970, 0x1974 },
    { 0x1980, 0x19ab },
    { 0x19b0, 0x19c9 },
    { 0x19d0, 0x19da },
    { 0x19de, 0x1a1b },
    { 0x1a1e, 0x1a5e },
    { 0x1a60, 0x1a7c },
    { 0x1a7f, 0x1a89 },
    { 0x1a90, 0x1a99 },
    { 0x1aa0, 0x1aad },
    { 0x1ab0, 0x1ac0 },
    { 0x1b00, 0x1b4b },
    { 0x1b50, 0x1b7c },
    { 0x1b80, 0x1bf3 },
    { 0x1bfc, 0x1c37 },
    { 0x1c3b, 0x1c49 },
    { 0x1c4d, 0x1c88 },
    { 0x1c90, 0x1cba },
    { 0x1cbd, 0x1cc7 },
    { 0x1cd0, 0x1cfa },
    { 0x1d00, 0x1df9 },
    { 0x1dfb, 0x1f15 },
    { 0x1f18, 0x1f1d },
    { 0x1f20, 0x1f45 },
    { 0x1f48, 0x1f4d },
    { 0x1f18, 0x1f1d },
    { 0x1f20, 0x1f45 },
    { 0x1f48, 0x1f4d },
    { 0x1f50, 0x1f57 },
    { 0x1f59, 0x1f59 },
    { 0x1f5b, 0x1f5b },
    { 0x1f5d, 0x1f5d },
    { 0x1f5f, 0x1f7d },
    { 0x1f80, 0x1fb4 },
    { 0x1fb6, 0x1fc4 },
    { 0x1fc6, 0x1fd3 },
    { 0x1fd6, 0x1fdb },
    { 0x1fdd, 0x1fef },
    { 0x1ff2, 0x1ff4 },
    { 0x1ff6, 0x1ffe },
    { 0x2000, 0x2027 },
    { 0x2090, 0x209c },
    { 0x20a0, 0x20bf },
    { 0x2074, 0x208e },
    { 0x2100, 0x218b },
    { 0x2190, 0x2426 },
    { 0x2440, 0x244a },
    { 0x2460, 0x2b73 },
    { 0x2b76, 0x2b95 },
    { 0x2440, 0x244a },
    { 0x2c30, 0x2c5e },
    { 0x2c60, 0x2cf3 },
    { 0x2cf9, 0x2d25 },
    { 0x2d27, 0x2d27 },
    { 0x2d2d, 0x2d2d },
    { 0x2d30, 0x2d67 },
    { 0x2d6f, 0x2d70 },
    { 0x2d7f, 0x2d96 },
    { 0x2da0, 0x2da6 },
    { 0x2da8, 0x2dae },
    { 0x2db0, 0x2db6 },
    { 0x2db8, 0x2dbe },
    { 0x2dc0, 0x2dc6 },
    { 0x2dc8, 0x2dce },
    { 0x2dd0, 0x2dd6 },
    { 0x2dd8, 0x2dde },
    { 0x2de0, 0x2e52 },
    { 0x2e80, 0x2e99 },
    { 0x2e9b, 0x2ef3 },
    { 0x2f00, 0x2fd5 },
    { 0x2e80, 0x2e99 },
    { 0x2e9b, 0x2ef3 },
    { 0x2f00, 0x2fd5 },
    { 0x2ff0, 0x2ffb },
    { 0x3000, 0x303f },
    { 0x3041, 0x3096 },
    { 0x3099, 0x30ff },
    { 0x31f0, 0x321e },
    { 0x3131, 0x318e },
    { 0xa000, 0xa48c },
    { 0xa490, 0xa4c6 },
    { 0xa4d0, 0xa62b },
    { 0xa000, 0xa48c },
    { 0xa490, 0xa4c6 },
    { 0xa7c2, 0xa7ca },
    { 0xa7f5, 0xa82c },
    { 0xa830, 0xa839 },
    { 0xa840, 0xa877 },
    { 0xa880, 0xa8c5 },
    { 0xa8ce, 0xa8d9 },
    { 0xa8e0, 0xa953 },
    { 0xa95f, 0xa97c },
    { 0xa980, 0xa9cd },
    { 0xa9cf, 0xa9d9 },
    { 0xa9de, 0xa9fe },
    { 0xaa00, 0xaa36 },
    { 0xaa40, 0xaa4d },
    { 0xaa50, 0xaa59 },
    { 0xaa5c, 0xaac2 },
    { 0xaadb, 0xaaf6 },
    { 0xab01, 0xab06 },
    { 0xab09, 0xab0e },
    { 0xab11, 0xab16 },
    { 0xab20, 0xab26 },
    { 0xab28, 0xab2e },
    { 0xab30, 0xab6b },
    { 0xab70, 0xabed },
    { 0xabf0, 0xabf9 },
    { 0xac00, 0xd7a3 },
    { 0xd7b0, 0xd7c6 },
    { 0xd7cb, 0xd7fb },
    { 0xac00, 0xd7a3 },
    { 0xfa70, 0xfad9 },
    { 0xfb00, 0xfb06 },
    { 0xfb13, 0xfb17 },
    { 0xfb1d, 0xfb36 },
    { 0xfb00, 0xfb06 },
    { 0xfb13, 0xfb17 },
    { 0xfb1d, 0xfb36 },
    { 0xfb38, 0xfb3c },
    { 0xfb3e, 0xfb3e },
    { 0xfb40, 0xfb41 },
    { 0xfb43, 0xfb44 },
    { 0xfd92, 0xfdc7 },
    { 0xfbd3, 0xfd3f },
    { 0xfd50, 0xfd8f },
    { 0xfd92, 0xfdc7 },
    { 0xfe54, 0xfe66 },
    { 0xfe68, 0xfe6b },
    { 0xfe70, 0xfe74 },
    { 0xfe54, 0xfe66 },
    { 0xfe68, 0xfe6b },
    { 0xfe70, 0xfe74 },
    { 0xfe76, 0xfefc },
    { 0xfeff, 0xfeff },
    { 0xff01, 0xffbe },
    { 0xffc2, 0xffc7 },
    { 0xffca, 0xffcf },
    { 0xffd2, 0xffd7 },
    { 0xffda, 0xffdc },
    { 0xffe0, 0xffe6 },
    { 0xffe8, 0xffee },
    { 0xfff9, 0xfffd },
    { 0x1003c, 0x1003d },
    { 0x1003f, 0x1004d },
    { 0x10050, 0x1005d },
    { 0x10080, 0x100fa },
    { 0x10100, 0x10102 },
    { 0x10107, 0x10133 },
    { 0x10137, 0x1018e },
    { 0x10190, 0x1019c },
    { 0x101a0, 0x101a0 },
    { 0x101d0, 0x101fd },
    { 0x10280, 0x1029c },
    { 0x102a0, 0x102d0 },
    { 0x102e0, 0x102fb },
    { 0x10300, 0x10323 },
    { 0x1032d, 0x1034a },
    { 0x10350, 0x1037a },
    { 0x10380, 0x1039d },
    { 0x1039f, 0x103c3 },
    { 0x103c8, 0x103d5 },
    { 0x10400, 0x1049d },
    { 0x104a0, 0x104a9 },
    { 0x104b0, 0x104d3 },
    { 0x104d8, 0x104fb },
    { 0x10500, 0x10527 },
    { 0x10530, 0x10563 },
    { 0x1056f, 0x1056f },
    { 0x10600, 0x10736 },
    { 0x10740, 0x10755 },
    { 0x10760, 0x10767 },
    { 0x10800, 0x10805 },
    { 0x10808, 0x10808 },
    { 0x1080a, 0x10835 },
    { 0x10837, 0x10838 },
    { 0x1083c, 0x1083c },
    { 0x1083f, 0x10855 },
    { 0x10857, 0x1089e },
    { 0x108a7, 0x108af },
    { 0x108e0, 0x108f2 },
    { 0x108f4, 0x108f5 },
    { 0x108fb, 0x1091b },
    { 0x1091f, 0x10939 },
    { 0x1093f, 0x1093f },
    { 0x10980, 0x109b7 },
    { 0x109bc, 0x109cf },
    { 0x109d2, 0x10a03 },
    { 0x10a05, 0x10a06 },
    { 0x10a0c, 0x10a13 },
    { 0x10a15, 0x10a17 },
    { 0x10a19, 0x10a35 },
    { 0x10a38, 0x10a3a },
    { 0x10a3f, 0x10a48 },
    { 0x10a50, 0x10a58 },
    { 0x10a60, 0x10a9f },
    { 0x10ac0, 0x10ae6 },
    { 0x10aeb, 0x10af6 },
    { 0x10b00, 0x10b35 },
    { 0x10b39, 0x10b55 },
    { 0x10b58, 0x10b72 },
    { 0x10b78, 0x10b91 },
    { 0x10b99, 0x10b9c },
    { 0x10ba9, 0x10baf },
    { 0x10c00, 0x10c48 },
    { 0x10c80, 0x10cb2 },
    { 0x10cc0, 0x10cf2 },
    { 0x10cfa, 0x10d27 },
    { 0x10d30, 0x10d39 },
    { 0x10e60, 0x10e7e },
    { 0x10e80, 0x10ea9 },
    { 0x10eab, 0x10ead },
    { 0x10eb0, 0x10eb1 },
    { 0x10f00, 0x10f27 },
    { 0x10f30, 0x10f59 },
    { 0x10fb0, 0x10fcb },
    { 0x10fe0, 0x10ff6 },
    { 0x11000, 0x1104d },
    { 0x11052, 0x1106f },
    { 0x1107f, 0x110c1 },
    { 0x110cd, 0x110cd },
    { 0x110d0, 0x110e8 },
    { 0x110f0, 0x110f9 },
    { 0x11100, 0x11134 },
    { 0x11136, 0x11147 },
    { 0x11150, 0x11176 },
    { 0x11180, 0x111df },
    { 0x111e1, 0x111f4 },
    { 0x11200, 0x11211 },
    { 0x11213, 0x1123e },
    { 0x11280, 0x11286 },
    { 0x11288, 0x11288 },
    { 0x1128a, 0x1128d },
    { 0x1128f, 0x1129d },
    { 0x1129f, 0x112a9 },
    { 0x112b0, 0x112ea },
    { 0x112f0, 0x112f9 },
    { 0x11300, 0x11303 },
    { 0x11305, 0x1130c },
    { 0x1130f, 0x11310 },
    { 0x11313, 0x11328 },
    { 0x1132a, 0x11330 },
    { 0x11332, 0x11333 },
    { 0x11335, 0x11339 },
    { 0x1133b, 0x11344 },
    { 0x11347, 0x11348 },
    { 0x1134b, 0x1134d },
    { 0x11350, 0x11350 },
    { 0x11357, 0x11357 },
    { 0x1135d, 0x11363 },
    { 0x11366, 0x1136c },
    { 0x11370, 0x11374 },
    { 0x11400, 0x1145b },
    { 0x1145d, 0x11461 },
    { 0x11480, 0x114c7 },
    { 0x114d0, 0x114d9 },
    { 0x11580, 0x115b5 },
    { 0x115b8, 0x115dd },
    { 0x11600, 0x11644 },
    { 0x11650, 0x11659 },
    { 0x11660, 0x1166c },
    { 0x11680, 0x116b8 },
    { 0x116c0, 0x116c9 },
    { 0x11700, 0x1171a },
    { 0x1171d, 0x1172b },
    { 0x11730, 0x1173f },
    { 0x11800, 0x1183b },
    { 0x118a0, 0x118f2 },
    { 0x118ff, 0x11906 },
    { 0x11909, 0x11909 },
    { 0x1190c, 0x11913 },
    { 0x11915, 0x11916 },
    { 0x11918, 0x11935 },
    { 0x11937, 0x11938 },
    { 0x1193b, 0x11946 },
    { 0x11950, 0x11959 },
    { 0x119a0, 0x119a7 },
    { 0x119aa, 0x119d7 },
    { 0x119da, 0x119e4 },
    { 0x11a00, 0x11a47 },
    { 0x11a50, 0x11aa2 },
    { 0x11ac0, 0x11af8 },
    { 0x11c00, 0x11c08 },
    { 0x11c0a, 0x11c36 },
    { 0x11c38, 0x11c45 },
    { 0x11c50, 0x11c6c },
    { 0x11c70, 0x11c8f },
    { 0x11c92, 0x11ca7 },
    { 0x11ca9, 0x11cb6 },
    { 0x11d00, 0x11d06 },
    { 0x11d08, 0x11d09 },
    { 0x11d0b, 0x11d36 },
    { 0x11d3a, 0x11d3a },
    { 0x11d3c, 0x11d3d },
    { 0x11d3f, 0x11d47 },
    { 0x11d50, 0x11d59 },
    { 0x11d60, 0x11d65 },
    { 0x11d67, 0x11d68 },
    { 0x11d6a, 0x11d8e },
    { 0x11d90, 0x11d91 },
    { 0x11d93, 0x11d98 },
    { 0x11da0, 0x11da9 },
    { 0x11ee0, 0x11ef8 },
    { 0x11fb0, 0x11fb0 },
    { 0x11fc0, 0x11ff1 },
    { 0x11fff, 0x12399 },
    { 0x12400, 0x1246e },
    { 0x12470, 0x12474 },
    { 0x12480, 0x12543 },
    { 0x13000, 0x1342e },
    { 0x13430, 0x13438 },
    { 0x14400, 0x14646 },
    { 0x16800, 0x16a38 },
    { 0x16a40, 0x16a5e },
    { 0x16a60, 0x16a69 },
    { 0x16a6e, 0x16a6f },
    { 0x16ad0, 0x16aed },
    { 0x16af0, 0x16af5 },
    { 0x16b00, 0x16b45 },
    { 0x16b50, 0x16b59 },
    { 0x16b5b, 0x16b61 },
    { 0x16b63, 0x16b77 },
    { 0x16b7d, 0x16b8f },
    { 0x16e40, 0x16e9a },
    { 0x16f00, 0x16f4a },
    { 0x16f4f, 0x16f87 },
    { 0x16f8f, 0x16f9f },
    { 0x16fe0, 0x16fe4 },
    { 0x16ff0, 0x16ff1 },
    { 0x17000, 0x187f7 },
    { 0x18800, 0x18cd5 },
    { 0x18d00, 0x18d08 },
    { 0x1b000, 0x1b11e },
    { 0x1b150, 0x1b152 },
    { 0x1b164, 0x1b167 },
    { 0x1b170, 0x1b2fb },
    { 0x1bc00, 0x1bc6a },
    { 0x1bc70, 0x1bc7c },
    { 0x1bc80, 0x1bc88 },
    { 0x1bc90, 0x1bc99 },
    { 0x1bc9c, 0x1bca3 },
    { 0x1d000, 0x1d0f5 },
    { 0x1d100, 0x1d126 },
    { 0x1d129, 0x1d1e8 },
    { 0x1d000, 0x1d0f5 },
    { 0x1d100, 0x1d126 },
    { 0x1d300, 0x1d356 },
    { 0x1d360, 0x1d378 },
    { 0x1d400, 0x1d454 },
    { 0x1d456, 0x1d49c },
    { 0x1d49e, 0x1d49f },
    { 0x1d400, 0x1d454 },
    { 0x1d456, 0x1d49c },
    { 0x1d49e, 0x1d49f },
    { 0x1d4a2, 0x1d4a2 },
    { 0x1d4a5, 0x1d4a6 },
    { 0x1d4a9, 0x1d4ac },
    { 0x1d4ae, 0x1d4b9 },
    { 0x1d4bb, 0x1d4bb },
    { 0x1d50d, 0x1d514 },
    { 0x1d4c5, 0x1d505 },
    { 0x1d507, 0x1d50a },
    { 0x1d50d, 0x1d514 },
    { 0x1d516, 0x1d51c },
    { 0x1d51e, 0x1d539 },
    { 0x1d53b, 0x1d53e },
    { 0x1d540, 0x1d544 },
    { 0x1d546, 0x1d546 },
    { 0x1d54a, 0x1d550 },
    { 0x1da9b, 0x1da9f },
    { 0x1daa1, 0x1daaf },
    { 0x1e000, 0x1e006 },
    { 0x1e008, 0x1e018 },
    { 0x1e01b, 0x1e021 },
    { 0x1e023, 0x1e024 },
    { 0x1e026, 0x1e02a },
    { 0x1e100, 0x1e12c },
    { 0x1e130, 0x1e13d },
    { 0x1e140, 0x1e149 },
    { 0x1e14e, 0x1e14f },
    { 0x1e2c0, 0x1e2f9 },
    { 0x1e2ff, 0x1e2ff },
    { 0x1e800, 0x1e8c4 },
    { 0x1e8c7, 0x1e8d6 },
    { 0x1e900, 0x1e94b },
    { 0x1e950, 0x1e959 },
    { 0x1e95e, 0x1e95f },
    { 0x1ec71, 0x1ecb4 },
    { 0x1ed01, 0x1ed3d },
    { 0x1ee00, 0x1ee03 },
    { 0x1ee05, 0x1ee1f },
    { 0x1ee21, 0x1ee22 },
    { 0x1ee24, 0x1ee24 },
    { 0x1ee27, 0x1ee27 },
    { 0x1ee29, 0x1ee32 },
    { 0x1ee34, 0x1ee37 },
    { 0x1ee39, 0x1ee39 },
    { 0x1ee3b, 0x1ee3b },
    { 0x1ee42, 0x1ee42 },
    { 0x1ee47, 0x1ee47 },
    { 0x1ee49, 0x1ee49 },
    { 0x1ee4b, 0x1ee4b },
    { 0x1ee4d, 0x1ee4f },
    { 0x1ee51, 0x1ee52 },
    { 0x1ee54, 0x1ee54 },
    { 0x1ee57, 0x1ee57 },
    { 0x1ee59, 0x1ee59 },
    { 0x1ee5b, 0x1ee5b },
    { 0x1ee5d, 0x1ee5d },
    { 0x1ee5f, 0x1ee5f },
    { 0x1ee61, 0x1ee62 },
    { 0x1ee64, 0x1ee64 },
    { 0x1ee67, 0x1ee6a },
    { 0x1ee6c, 0x1ee72 },
    { 0x1ee74, 0x1ee77 },
    { 0x1ee79, 0x1ee7c },
    { 0x1ee7e, 0x1ee7e },
    { 0x1ee80, 0x1ee89 },
    { 0x1ee8b, 0x1ee9b },
    { 0x1eea1, 0x1eea3 },
    { 0x1eea5, 0x1eea9 },
    { 0x1eeab, 0x1eebb },
    { 0x1eef0, 0x1eef1 },
    { 0x1f000, 0x1f02b },
    { 0x1f030, 0x1f093 },
    { 0x1f0a0, 0x1f0ae },
    { 0x1f0b1, 0x1f0bf },
    { 0x1f0c1, 0x1f0cf },
    { 0x1f0d1, 0x1f0f5 },
    { 0x1f100, 0x1f1ad },
    { 0x1f1e6, 0x1f202 },
    { 0x1f210, 0x1f23b },
    { 0x1f240, 0x1f248 },
    { 0x1f250, 0x1f251 },
    { 0x1f260, 0x1f265 },
    { 0x1f300, 0x1f6d7 },
    { 0x1f6e0, 0x1f6ec },
    { 0x1f6f0, 0x1f6fc },
    { 0x1f700, 0x1f773 },
    { 0x1f780, 0x1f7d8 },
    { 0x1f7e0, 0x1f7eb },
    { 0x1f800, 0x1f80b },
    { 0x1f810, 0x1f847 },
    { 0x1f850, 0x1f859 },
    { 0x1f860, 0x1f887 },
    { 0x1f890, 0x1f8ad },
    { 0x1f8b0, 0x1f8b1 },
    { 0x1f900, 0x1f978 },
    { 0x1f97a, 0x1f9cb },
    { 0x1f9cd, 0x1fa53 },
    { 0x1fa60, 0x1fa6d },
    { 0x1fa70, 0x1fa74 },
    { 0x1fa78, 0x1fa7a },
    { 0x1fa80, 0x1fa86 },
    { 0x1fa90, 0x1faa8 },
    { 0x1fab0, 0x1fab6 },
    { 0x1fac0, 0x1fac2 },
    { 0x1fad0, 0x1fad6 },
    { 0x1fb00, 0x1fb92 },
    { 0x1fb94, 0x1fbca },
    { 0x1fbf0, 0x1fbf9 },
    { 0x20000, 0x2a6dd },
    { 0x2a700, 0x2b734 },
    { 0x2b740, 0x2b81d },
    { 0x2b820, 0x2cea1 },
    { 0x2ceb0, 0x2ebe0 },
    { 0x2f800, 0x2fa1d },
    { 0x30000, 0x3134a },
    { 0xe0001, 0xe0001 },
    { 0xf0000, 0xffffd },
    { 0x100000, 0x10fffd }
};
static const int table_wprint_count =
  (sizeof(table_wprint)/sizeof(struct interval));

/* ------------------- iswpunct -------------------- */
static const struct interval table_wpunct[] = {
    { 0x21, 0x2f }, // includes $ & + 
    { 0x3a, 0x40 },
    { 0x5b, 0x60 },
    { 0x7b, 0x7e },
    { 0xa1, 0xa9 }, // a0 is a space, which glibc includes
    { 0xab, 0xb1 }, // glibc includes b2 and b3 (superscript 2 and 3)
    { 0xb4, 0xb4 },
    { 0xb6, 0xb9 },
    { 0xbb, 0xbf },
    { 0xd7, 0xd7 },
    { 0xf7, 0xf7 },
//    { 0x2b9, 0x2ba }, // glibc does not have these
    { 0x2c2, 0x2cf },
    { 0x2d2, 0x2df },
    { 0x2e5, 0x2ed },
    { 0x300, 0x344 },
    { 0x346, 0x34f },
    { 0x360, 0x36f },
    { 0x374, 0x375 },
    { 0x37e, 0x37e },
    { 0x384, 0x385 },
    { 0x387, 0x387 },
    { 0x3f6, 0x3f6 },
    { 0x482, 0x486 },
    { 0x488, 0x489 },
    { 0x55a, 0x55f },
    { 0x589, 0x58a },
    { 0x591, 0x5a1 },
    { 0x5a3, 0x5b9 },
    { 0x5bb, 0x5c4 },
    { 0x5f3, 0x5f4 },
    { 0x60c, 0x60c },
    { 0x61b, 0x61b },
    { 0x61f, 0x61f },
    { 0x64b, 0x655 },
    { 0x66a, 0x66d },
    { 0x670, 0x670 },
    { 0x6d4, 0x6d4 },
    { 0x6d6, 0x6e4 },
    { 0x6e7, 0x6ed },
    { 0x6fd, 0x6fe },
    { 0x700, 0x70d },
    { 0x70f, 0x70f },
    { 0x711, 0x711 },
    { 0x730, 0x74a },
    { 0x7a6, 0x7b0 },
    { 0x901, 0x903 },
    { 0x93c, 0x93c },
    { 0x93e, 0x94d },
    { 0x951, 0x954 },
    { 0x962, 0x965 },
    { 0x970, 0x970 },
    { 0x981, 0x983 },
    { 0x9bc, 0x9bc },
    { 0x9be, 0x9c4 },
    { 0x9c7, 0x9c8 },
    { 0x9cb, 0x9cd },
    { 0x9d7, 0x9d7 },
    { 0x9e2, 0x9e3 },
    { 0x9f2, 0x9fa },
    { 0xa02, 0xa02 },
    { 0xa3c, 0xa3c },
    { 0xa3e, 0xa42 },
    { 0xa47, 0xa48 },
    { 0xa4b, 0xa4d },
    { 0xa70, 0xa71 },
    { 0xa81, 0xa83 },
    { 0xabc, 0xabc },
    { 0xabe, 0xac5 },
    { 0xac7, 0xac9 },
    { 0xacb, 0xacd },
    { 0xb01, 0xb03 },
    { 0xb3c, 0xb3c },
    { 0xb3e, 0xb43 },
    { 0xb47, 0xb48 },
    { 0xb4b, 0xb4d },
    { 0xb56, 0xb57 },
    { 0xb70, 0xb70 },
    { 0xb82, 0xb82 },
    { 0xbbe, 0xbc2 },
    { 0xbc6, 0xbc8 },
    { 0xbca, 0xbcd },
    { 0xbd7, 0xbd7 },
    { 0xbf0, 0xbf2 },
    { 0xc01, 0xc03 },
    { 0xc3e, 0xc44 },
    { 0xc46, 0xc48 },
    { 0xc4a, 0xc4d },
    { 0xc55, 0xc56 },
    { 0xc82, 0xc83 },
    { 0xcbe, 0xcc4 },
    { 0xcc6, 0xcc8 },
    { 0xcca, 0xccd },
    { 0xcd5, 0xcd6 },
    { 0xd02, 0xd03 },
    { 0xd3e, 0xd43 },
    { 0xd46, 0xd48 },
    { 0xd4a, 0xd4d },
    { 0xd57, 0xd57 },
    { 0xd82, 0xd83 },
    { 0xdca, 0xdca },
    { 0xdcf, 0xdd4 },
    { 0xdd6, 0xdd6 },
    { 0xdd8, 0xddf },
    { 0xdf2, 0xdf4 },
    { 0xe2f, 0xe2f },
    { 0xe3f, 0xe3f },
    { 0xe46, 0xe46 },
    { 0xe4f, 0xe4f },
    { 0xe5a, 0xe5b },
    { 0xeb1, 0xeb1 },
    { 0xeb4, 0xeb9 },
    { 0xebb, 0xebc },
    { 0xec8, 0xecd },
    { 0xf01, 0xf1f },
    { 0xf2a, 0xf3f },
    { 0xf71, 0xf87 },
    { 0xf90, 0xf97 },
    { 0xf99, 0xfbc },
    { 0xfbe, 0xfcc },
    { 0xfcf, 0xfcf },
    { 0x102c, 0x1032 },
    { 0x1036, 0x1039 },
    { 0x104a, 0x104f },
    { 0x1056, 0x1059 },
    { 0x10fb, 0x10fb },
    { 0x1361, 0x1368 },
    { 0x1372, 0x137c },
    { 0x166d, 0x166e },
    { 0x169b, 0x169c },
    { 0x16eb, 0x16ed },
    { 0x1712, 0x1714 },
    { 0x1732, 0x1736 },
    { 0x1752, 0x1753 },
    { 0x1772, 0x1773 },
    { 0x17b4, 0x17d6 },
    { 0x17d8, 0x17db },
    { 0x1800, 0x180e },
    { 0x18a9, 0x18a9 },
    { 0x1fbd, 0x1fbd },
    { 0x1fbf, 0x1fc1 },
    { 0x1fcd, 0x1fcf },
    { 0x1fdd, 0x1fdf },
    { 0x1fed, 0x1fef },
    { 0x1ffd, 0x1ffe },
    { 0x2007, 0x2007 },
    { 0x200c, 0x2027 },
    { 0x202a, 0x2052 },
    { 0x2057, 0x2057 },
    { 0x2060, 0x2063 },
    { 0x206a, 0x2070 },
    { 0x2074, 0x207e },
    { 0x2080, 0x208e },
    { 0x20a0, 0x20b1 },
    { 0x20d0, 0x20ea },
    { 0x2100, 0x2101 },
    { 0x2103, 0x2106 },
    { 0x2108, 0x2109 },
    { 0x2114, 0x2114 },
    { 0x2116, 0x2118 },
    { 0x211e, 0x2123 },
    { 0x2125, 0x2125 },
    { 0x2127, 0x2127 },
    { 0x212e, 0x212e },
    { 0x2132, 0x2132 },
    { 0x213a, 0x213a },
    { 0x2140, 0x2144 },
    { 0x214a, 0x214b },
    { 0x2153, 0x215f },
    { 0x2190, 0x23ce },
    { 0x2400, 0x2426 },
    { 0x2440, 0x244a },
    { 0x2460, 0x249b },
    { 0x24ea, 0x24fe },
    { 0x2500, 0x2613 },
    { 0x2616, 0x2617 },
    { 0x2619, 0x267d },
    { 0x2680, 0x2689 },
    { 0x2701, 0x2704 },
    { 0x2706, 0x2709 },
    { 0x270c, 0x2727 },
    { 0x2729, 0x274b },
    { 0x274d, 0x274d },
    { 0x274f, 0x2752 },
    { 0x2756, 0x2756 },
    { 0x2758, 0x275e },
    { 0x2761, 0x2794 },
    { 0x2798, 0x27af },
    { 0x27b1, 0x27be },
    { 0x27d0, 0x27eb },
    { 0x27f0, 0x2aff },
    { 0x2e80, 0x2e99 },
    { 0x2e9b, 0x2ef3 },
    { 0x2f00, 0x2fd5 },
    { 0x2ff0, 0x2ffb },
    { 0x3001, 0x3004 },
    { 0x3008, 0x3020 },
    { 0x302a, 0x3030 },
    { 0x3036, 0x3037 },
    { 0x303d, 0x303f },
    { 0x3099, 0x309c },
    { 0x30a0, 0x30a0 },
    { 0x30fb, 0x30fb },
    { 0x3190, 0x319f },
    { 0x3200, 0x321c },
    { 0x3220, 0x3243 },
    { 0x3251, 0x327b },
    { 0x327f, 0x32cb },
    { 0x32d0, 0x32fe },
    { 0x3300, 0x3376 },
    { 0x337b, 0x33dd },
    { 0x33e0, 0x33fe },
    { 0xa490, 0xa4c6 },
    { 0xe000, 0xf8ff },
    { 0xfb1e, 0xfb1e },
    { 0xfb29, 0xfb29 },
    { 0xfd3e, 0xfd3f },
    { 0xfdfc, 0xfdfc },
    { 0xfe00, 0xfe0f },
    { 0xfe20, 0xfe23 },
    { 0xfe30, 0xfe44 },
    { 0xfe49, 0xfe52 },
    { 0xfe54, 0xfe66 },
    { 0xfe68, 0xfe6b },
    { 0xfeff, 0xfeff },
    { 0xff01, 0xff0f },
    { 0xff1a, 0xff20 },
    { 0xff3b, 0xff40 },
    { 0xff5b, 0xff65 },
    { 0xffe0, 0xffe6 },
    { 0xffe8, 0xffee },
    { 0xfff9, 0xfffd },
    { 0x10320, 0x10323 },
    { 0x1d000, 0x1d0f5 },
    { 0x1d100, 0x1d126 },
    { 0x1d12a, 0x1d1dd },
    { 0x1d6c1, 0x1d6c1 },
    { 0x1d6db, 0x1d6db },
    { 0x1d6fb, 0x1d6fb },
    { 0x1d715, 0x1d715 },
    { 0x1d735, 0x1d735 },
    { 0x1d74f, 0x1d74f },
    { 0x1d76f, 0x1d76f },
    { 0x1d789, 0x1d789 },
    { 0x1d7a9, 0x1d7a9 },
    { 0x1d7c3, 0x1d7c3 },
    { 0xe0001, 0xe0001 },
    { 0xe0020, 0xe007f },
    { 0xf0000, 0xffffd },
    { 0x100000, 0x10fffd }
};
static const int table_wpunct_count =
  (sizeof(table_wpunct)/sizeof(struct interval));

/* ------------------- iswspace -------------------- */
static const struct interval table_wspace[] = {
    { 0x9, 0xd }, /* tab, LF, vtab, FF, CR */
    { 0x20, 0x20 },
//    { 0xa0, 0xa0 }, /* non-breaking space, omitted by glibc */
    { 0x1680, 0x1680 }, /* ogham space mark */
    { 0x2000, 0x2006 }, /* not figure space, 2007? */
    { 0x2008, 0x200a }, /* not zero-width-space, 200b */
    { 0x2028, 0x2029 }, /* line separator, para separator */
//    { 0x202f, 0x202f }, /* narrow no-break space, omitted by glibc */
    { 0x205f, 0x205f }, /* medium mathematical space */
    { 0x3000, 0x3000 }  /* (CJK) ideographic space */
};
static const int table_wspace_count =
  (sizeof(table_wspace)/sizeof(struct interval));

/* ------------------- iswupper -------------------- */
static const struct interval table_wupper[] = {
    { 0x41, 0x5a },
    { 0xc0, 0xd6 },
    { 0xd8, 0xde },
    { 0x100, 0x100 },
    { 0x102, 0x102 },
    { 0x104, 0x104 },
    { 0x106, 0x106 },
    { 0x108, 0x108 },
    { 0x10a, 0x10a },
    { 0x10c, 0x10c },
    { 0x10e, 0x10e },
    { 0x110, 0x110 },
    { 0x112, 0x112 },
    { 0x114, 0x114 },
    { 0x116, 0x116 },
    { 0x118, 0x118 },
    { 0x11a, 0x11a },
    { 0x11c, 0x11c },
    { 0x11e, 0x11e },
    { 0x120, 0x120 },
    { 0x122, 0x122 },
    { 0x124, 0x124 },
    { 0x126, 0x126 },
    { 0x128, 0x128 },
    { 0x12a, 0x12a },
    { 0x12c, 0x12c },
    { 0x12e, 0x12e },
    { 0x130, 0x130 },
    { 0x132, 0x132 },
    { 0x134, 0x134 },
    { 0x136, 0x136 },
    { 0x139, 0x139 },
    { 0x13b, 0x13b },
    { 0x13d, 0x13d },
    { 0x13f, 0x13f },
    { 0x141, 0x141 },
    { 0x143, 0x143 },
    { 0x145, 0x145 },
    { 0x147, 0x147 },
    { 0x14a, 0x14a },
    { 0x14c, 0x14c },
    { 0x14e, 0x14e },
    { 0x150, 0x150 },
    { 0x152, 0x152 },
    { 0x154, 0x154 },
    { 0x156, 0x156 },
    { 0x158, 0x158 },
    { 0x15a, 0x15a },
    { 0x15c, 0x15c },
    { 0x15e, 0x15e },
    { 0x160, 0x160 },
    { 0x162, 0x162 },
    { 0x164, 0x164 },
    { 0x166, 0x166 },
    { 0x168, 0x168 },
    { 0x16a, 0x16a },
    { 0x16c, 0x16c },
    { 0x16e, 0x16e },
    { 0x170, 0x170 },
    { 0x172, 0x172 },
    { 0x174, 0x174 },
    { 0x176, 0x176 },
    { 0x178, 0x179 },
    { 0x17b, 0x17b },
    { 0x17d, 0x17d },
    { 0x181, 0x182 },
    { 0x184, 0x184 },
    { 0x186, 0x187 },
    { 0x189, 0x18b },
    { 0x18e, 0x191 },
    { 0x193, 0x194 },
    { 0x196, 0x198 },
    { 0x19c, 0x19d },
    { 0x19f, 0x1a0 },
    { 0x1a2, 0x1a2 },
    { 0x1a4, 0x1a4 },
    { 0x1a6, 0x1a7 },
    { 0x1a9, 0x1a9 },
    { 0x1ac, 0x1ac },
    { 0x1ae, 0x1af },
    { 0x1b1, 0x1b3 },
    { 0x1b5, 0x1b5 },
    { 0x1b7, 0x1b8 },
    { 0x1bc, 0x1bc },
    { 0x1c4, 0x1c5 },
    { 0x1c7, 0x1c8 },
    { 0x1ca, 0x1cb },
    { 0x1cd, 0x1cd },
    { 0x1cf, 0x1cf },
    { 0x1d1, 0x1d1 },
    { 0x1d3, 0x1d3 },
    { 0x1d5, 0x1d5 },
    { 0x1d7, 0x1d7 },
    { 0x1d9, 0x1d9 },
    { 0x1db, 0x1db },
    { 0x1de, 0x1de },
    { 0x1e0, 0x1e0 },
    { 0x1e2, 0x1e2 },
    { 0x1e4, 0x1e4 },
    { 0x1e6, 0x1e6 },
    { 0x1e8, 0x1e8 },
    { 0x1ea, 0x1ea },
    { 0x1ec, 0x1ec },
    { 0x1ee, 0x1ee },
    { 0x1f1, 0x1f2 },
    { 0x1f4, 0x1f4 },
    { 0x1f6, 0x1f8 },
    { 0x1fa, 0x1fa },
    { 0x1fc, 0x1fc },
    { 0x1fe, 0x1fe },
    { 0x200, 0x200 },
    { 0x202, 0x202 },
    { 0x204, 0x204 },
    { 0x206, 0x206 },
    { 0x208, 0x208 },
    { 0x20a, 0x20a },
    { 0x20c, 0x20c },
    { 0x20e, 0x20e },
    { 0x210, 0x210 },
    { 0x212, 0x212 },
    { 0x214, 0x214 },
    { 0x216, 0x216 },
    { 0x218, 0x218 },
    { 0x21a, 0x21a },
    { 0x21c, 0x21c },
    { 0x21e, 0x21e },
    { 0x220, 0x220 },
    { 0x222, 0x222 },
    { 0x224, 0x224 },
    { 0x226, 0x226 },
    { 0x228, 0x228 },
    { 0x22a, 0x22a },
    { 0x22c, 0x22c },
    { 0x22e, 0x22e },
    { 0x230, 0x230 },
    { 0x232, 0x232 },
    { 0x386, 0x386 },
    { 0x388, 0x38a },
    { 0x38c, 0x38c },
    { 0x38e, 0x38f },
    { 0x391, 0x3a1 },
    { 0x3a3, 0x3ab },
    { 0x3d8, 0x3d8 },
    { 0x3da, 0x3da },
    { 0x3dc, 0x3dc },
    { 0x3de, 0x3de },
    { 0x3e0, 0x3e0 },
    { 0x3e2, 0x3e2 },
    { 0x3e4, 0x3e4 },
    { 0x3e6, 0x3e6 },
    { 0x3e8, 0x3e8 },
    { 0x3ea, 0x3ea },
    { 0x3ec, 0x3ec },
    { 0x3ee, 0x3ee },
    { 0x3f4, 0x3f4 },
    { 0x400, 0x42f },
    { 0x460, 0x460 },
    { 0x462, 0x462 },
    { 0x464, 0x464 },
    { 0x466, 0x466 },
    { 0x468, 0x468 },
    { 0x46a, 0x46a },
    { 0x46c, 0x46c },
    { 0x46e, 0x46e },
    { 0x470, 0x470 },
    { 0x472, 0x472 },
    { 0x474, 0x474 },
    { 0x476, 0x476 },
    { 0x478, 0x478 },
    { 0x47a, 0x47a },
    { 0x47c, 0x47c },
    { 0x47e, 0x47e },
    { 0x480, 0x480 },
    { 0x48a, 0x48a },
    { 0x48c, 0x48c },
    { 0x48e, 0x48e },
    { 0x490, 0x490 },
    { 0x492, 0x492 },
    { 0x494, 0x494 },
    { 0x496, 0x496 },
    { 0x498, 0x498 },
    { 0x49a, 0x49a },
    { 0x49c, 0x49c },
    { 0x49e, 0x49e },
    { 0x4a0, 0x4a0 },
    { 0x4a2, 0x4a2 },
    { 0x4a4, 0x4a4 },
    { 0x4a6, 0x4a6 },
    { 0x4a8, 0x4a8 },
    { 0x4aa, 0x4aa },
    { 0x4ac, 0x4ac },
    { 0x4ae, 0x4ae },
    { 0x4b0, 0x4b0 },
    { 0x4b2, 0x4b2 },
    { 0x4b4, 0x4b4 },
    { 0x4b6, 0x4b6 },
    { 0x4b8, 0x4b8 },
    { 0x4ba, 0x4ba },
    { 0x4bc, 0x4bc },
    { 0x4be, 0x4be },
    { 0x4c1, 0x4c1 },
    { 0x4c3, 0x4c3 },
    { 0x4c5, 0x4c5 },
    { 0x4c7, 0x4c7 },
    { 0x4c9, 0x4c9 },
    { 0x4cb, 0x4cb },
    { 0x4cd, 0x4cd },
    { 0x4d0, 0x4d0 },
    { 0x4d2, 0x4d2 },
    { 0x4d4, 0x4d4 },
    { 0x4d6, 0x4d6 },
    { 0x4d8, 0x4d8 },
    { 0x4da, 0x4da },
    { 0x4dc, 0x4dc },
    { 0x4de, 0x4de },
    { 0x4e0, 0x4e0 },
    { 0x4e2, 0x4e2 },
    { 0x4e4, 0x4e4 },
    { 0x4e6, 0x4e6 },
    { 0x4e8, 0x4e8 },
    { 0x4ea, 0x4ea },
    { 0x4ec, 0x4ec },
    { 0x4ee, 0x4ee },
    { 0x4f0, 0x4f0 },
    { 0x4f2, 0x4f2 },
    { 0x4f4, 0x4f4 },
    { 0x4f8, 0x4f8 },
    { 0x500, 0x500 },
    { 0x502, 0x502 },
    { 0x504, 0x504 },
    { 0x506, 0x506 },
    { 0x508, 0x508 },
    { 0x50a, 0x50a },
    { 0x50c, 0x50c },
    { 0x50e, 0x50e },
    { 0x531, 0x556 },
    { 0x1e00, 0x1e00 },
    { 0x1e02, 0x1e02 },
    { 0x1e04, 0x1e04 },
    { 0x1e06, 0x1e06 },
    { 0x1e08, 0x1e08 },
    { 0x1e0a, 0x1e0a },
    { 0x1e0c, 0x1e0c },
    { 0x1e0e, 0x1e0e },
    { 0x1e10, 0x1e10 },
    { 0x1e12, 0x1e12 },
    { 0x1e14, 0x1e14 },
    { 0x1e16, 0x1e16 },
    { 0x1e18, 0x1e18 },
    { 0x1e1a, 0x1e1a },
    { 0x1e1c, 0x1e1c },
    { 0x1e1e, 0x1e1e },
    { 0x1e20, 0x1e20 },
    { 0x1e22, 0x1e22 },
    { 0x1e24, 0x1e24 },
    { 0x1e26, 0x1e26 },
    { 0x1e28, 0x1e28 },
    { 0x1e2a, 0x1e2a },
    { 0x1e2c, 0x1e2c },
    { 0x1e2e, 0x1e2e },
    { 0x1e30, 0x1e30 },
    { 0x1e32, 0x1e32 },
    { 0x1e34, 0x1e34 },
    { 0x1e36, 0x1e36 },
    { 0x1e38, 0x1e38 },
    { 0x1e3a, 0x1e3a },
    { 0x1e3c, 0x1e3c },
    { 0x1e3e, 0x1e3e },
    { 0x1e40, 0x1e40 },
    { 0x1e42, 0x1e42 },
    { 0x1e44, 0x1e44 },
    { 0x1e46, 0x1e46 },
    { 0x1e48, 0x1e48 },
    { 0x1e4a, 0x1e4a },
    { 0x1e4c, 0x1e4c },
    { 0x1e4e, 0x1e4e },
    { 0x1e50, 0x1e50 },
    { 0x1e52, 0x1e52 },
    { 0x1e54, 0x1e54 },
    { 0x1e56, 0x1e56 },
    { 0x1e58, 0x1e58 },
    { 0x1e5a, 0x1e5a },
    { 0x1e5c, 0x1e5c },
    { 0x1e5e, 0x1e5e },
    { 0x1e60, 0x1e60 },
    { 0x1e62, 0x1e62 },
    { 0x1e64, 0x1e64 },
    { 0x1e66, 0x1e66 },
    { 0x1e68, 0x1e68 },
    { 0x1e6a, 0x1e6a },
    { 0x1e6c, 0x1e6c },
    { 0x1e6e, 0x1e6e },
    { 0x1e70, 0x1e70 },
    { 0x1e72, 0x1e72 },
    { 0x1e74, 0x1e74 },
    { 0x1e76, 0x1e76 },
    { 0x1e78, 0x1e78 },
    { 0x1e7a, 0x1e7a },
    { 0x1e7c, 0x1e7c },
    { 0x1e7e, 0x1e7e },
    { 0x1e80, 0x1e80 },
    { 0x1e82, 0x1e82 },
    { 0x1e84, 0x1e84 },
    { 0x1e86, 0x1e86 },
    { 0x1e88, 0x1e88 },
    { 0x1e8a, 0x1e8a },
    { 0x1e8c, 0x1e8c },
    { 0x1e8e, 0x1e8e },
    { 0x1e90, 0x1e90 },
    { 0x1e92, 0x1e92 },
    { 0x1e94, 0x1e94 },
    { 0x1ea0, 0x1ea0 },
    { 0x1ea2, 0x1ea2 },
    { 0x1ea4, 0x1ea4 },
    { 0x1ea6, 0x1ea6 },
    { 0x1ea8, 0x1ea8 },
    { 0x1eaa, 0x1eaa },
    { 0x1eac, 0x1eac },
    { 0x1eae, 0x1eae },
    { 0x1eb0, 0x1eb0 },
    { 0x1eb2, 0x1eb2 },
    { 0x1eb4, 0x1eb4 },
    { 0x1eb6, 0x1eb6 },
    { 0x1eb8, 0x1eb8 },
    { 0x1eba, 0x1eba },
    { 0x1ebc, 0x1ebc },
    { 0x1ebe, 0x1ebe },
    { 0x1ec0, 0x1ec0 },
    { 0x1ec2, 0x1ec2 },
    { 0x1ec4, 0x1ec4 },
    { 0x1ec6, 0x1ec6 },
    { 0x1ec8, 0x1ec8 },
    { 0x1eca, 0x1eca },
    { 0x1ecc, 0x1ecc },
    { 0x1ece, 0x1ece },
    { 0x1ed0, 0x1ed0 },
    { 0x1ed2, 0x1ed2 },
    { 0x1ed4, 0x1ed4 },
    { 0x1ed6, 0x1ed6 },
    { 0x1ed8, 0x1ed8 },
    { 0x1eda, 0x1eda },
    { 0x1edc, 0x1edc },
    { 0x1ede, 0x1ede },
    { 0x1ee0, 0x1ee0 },
    { 0x1ee2, 0x1ee2 },
    { 0x1ee4, 0x1ee4 },
    { 0x1ee6, 0x1ee6 },
    { 0x1ee8, 0x1ee8 },
    { 0x1eea, 0x1eea },
    { 0x1eec, 0x1eec },
    { 0x1eee, 0x1eee },
    { 0x1ef0, 0x1ef0 },
    { 0x1ef2, 0x1ef2 },
    { 0x1ef4, 0x1ef4 },
    { 0x1ef6, 0x1ef6 },
    { 0x1ef8, 0x1ef8 },
    { 0x1f08, 0x1f0f },
    { 0x1f18, 0x1f1d },
    { 0x1f28, 0x1f2f },
    { 0x1f38, 0x1f3f },
    { 0x1f48, 0x1f4d },
    { 0x1f59, 0x1f59 },
    { 0x1f5b, 0x1f5b },
    { 0x1f5d, 0x1f5d },
    { 0x1f5f, 0x1f5f },
    { 0x1f68, 0x1f6f },
    { 0x1f88, 0x1f8f },
    { 0x1f98, 0x1f9f },
    { 0x1fa8, 0x1faf },
    { 0x1fb8, 0x1fbc },
    { 0x1fc8, 0x1fcc },
    { 0x1fd8, 0x1fdb },
    { 0x1fe8, 0x1fec },
    { 0x1ff8, 0x1ffc },
    { 0x2126, 0x2126 },
    { 0x212a, 0x212b },
    { 0x2160, 0x216f },
    { 0x24b6, 0x24cf },
    { 0xff21, 0xff3a },
    { 0x10400, 0x10425 }
};
static const int table_wupper_count =
  (sizeof(table_wupper)/sizeof(struct interval));


/* ------------------- iswxdigit -------------------- */
static const struct interval table_wxdigit[] = {
  { 0x30, 0x39 },
  { 0x41, 0x46 },
  { 0x61, 0x66 }
};
static const int table_wxdigit_count =
  (sizeof(table_wxdigit)/sizeof(struct interval));
#endif

/* -------------------helper for wcwidth -------------------- */

/* From http://www.cl.cam.ac.uk/~mgk25/ucs/wcwidth.c
 *    - Non-spacing and enclosing combining characters (general
 *      category code Mn or Me in the Unicode database) have a
 *      column width of 0.
 *
 *    - SOFT HYPHEN (U+00AD) has a column width of 1.
 *
 *    - Prepended_Concatenation_Mark have column width of 1.
 *
 *    - Other format characters (general category code Cf in the Unicode
 *      database) and ZERO WIDTH SPACE (U+200B) have a column width of 0.
 *
 *    - Hangul Jamo medial vowels and final consonants (U+1160-U+11FF)
 *      have a column width of 0.
 *
 *    - C0 and C1 control characters have a column width of 0.
 *
 *    Updated based on the Unicode 12.1.0 tables at
 *    https://www.unicode.org/Public/12.1.0/ucd/UnicodeData.txt
 *    https://www.unicode.org/Public/12.1.0/ucd/EastAsianWidth.txt
 *
 *    And reflecting practices in glibc's wcwidth()
 */
 
static const struct interval zero_width[] = {
    { 0x0000, 0x001F }, { 0x007F, 0x009F }, { 0x0300, 0x036F },
    { 0x0483, 0x0489 }, { 0x0591, 0x05BD }, { 0x05BF, 0x05BF },
    { 0x05C1, 0x05C2 }, { 0x05C4, 0x05C5 }, { 0x05C7, 0x05C7 },
    { 0x0610, 0x061A }, { 0x061C, 0x061C }, { 0x064B, 0x065F },
    { 0x0670, 0x0670 }, { 0x06D6, 0x06DC }, { 0x06DF, 0x06E4 },
    { 0x06E7, 0x06E8 }, { 0x06EA, 0x06ED }, { 0x0711, 0x0711 },
    { 0x0730, 0x074A }, { 0x07A6, 0x07B0 }, { 0x07EB, 0x07F3 },
    { 0x07FD, 0x07FD }, { 0x0816, 0x0819 }, { 0x081B, 0x0823 },
    { 0x0825, 0x0827 }, { 0x0829, 0x082D }, { 0x0859, 0x085B },
    { 0x08D3, 0x08E1 }, { 0x08E3, 0x0902 }, { 0x093A, 0x093A },
    { 0x093C, 0x093C }, { 0x0941, 0x0948 }, { 0x094D, 0x094D },
    { 0x0951, 0x0957 }, { 0x0962, 0x0963 }, { 0x0981, 0x0981 },
    { 0x09BC, 0x09BC }, { 0x09C1, 0x09C4 }, { 0x09CD, 0x09CD },
    { 0x09E2, 0x09E3 }, { 0x09FE, 0x09FE }, { 0x0A01, 0x0A02 },
    { 0x0A3C, 0x0A3C }, { 0x0A41, 0x0A42 }, { 0x0A47, 0x0A48 },
    { 0x0A4B, 0x0A4D }, { 0x0A51, 0x0A51 }, { 0x0A70, 0x0A71 },
    { 0x0A75, 0x0A75 }, { 0x0A81, 0x0A82 }, { 0x0ABC, 0x0ABC },
    { 0x0AC1, 0x0AC5 }, { 0x0AC7, 0x0AC8 }, { 0x0ACD, 0x0ACD },
    { 0x0AE2, 0x0AE3 }, { 0x0AFA, 0x0AFF }, { 0x0B01, 0x0B01 },
    { 0x0B3C, 0x0B3C }, { 0x0B3F, 0x0B3F }, { 0x0B41, 0x0B44 },
    { 0x0B4D, 0x0B4D }, { 0x0B56, 0x0B56 }, { 0x0B62, 0x0B63 },
    { 0x0B82, 0x0B82 }, { 0x0BC0, 0x0BC0 }, { 0x0BCD, 0x0BCD },
    { 0x0C00, 0x0C00 }, { 0x0C04, 0x0C04 }, { 0x0C3E, 0x0C40 },
    { 0x0C46, 0x0C48 }, { 0x0C4A, 0x0C4D }, { 0x0C55, 0x0C56 },
    { 0x0C62, 0x0C63 }, { 0x0C81, 0x0C81 }, { 0x0CBC, 0x0CBC },
    { 0x0CBF, 0x0CBF }, { 0x0CC6, 0x0CC6 }, { 0x0CCC, 0x0CCD },
    { 0x0CE2, 0x0CE3 }, { 0x0D00, 0x0D01 }, { 0x0D3B, 0x0D3C },
    { 0x0D41, 0x0D44 }, { 0x0D4D, 0x0D4D }, { 0x0D62, 0x0D63 },
    { 0x0DCA, 0x0DCA }, { 0x0DD2, 0x0DD4 }, { 0x0DD6, 0x0DD6 },
    { 0x0E31, 0x0E31 }, { 0x0E34, 0x0E3A }, { 0x0E47, 0x0E4E },
    { 0x0EB1, 0x0EB1 }, { 0x0EB4, 0x0EBC }, { 0x0EC8, 0x0ECD },
    { 0x0F18, 0x0F19 }, { 0x0F35, 0x0F35 }, { 0x0F37, 0x0F37 },
    { 0x0F39, 0x0F39 }, { 0x0F71, 0x0F7E }, { 0x0F80, 0x0F84 },
    { 0x0F86, 0x0F87 }, { 0x0F8D, 0x0F97 }, { 0x0F99, 0x0FBC },
    { 0x0FC6, 0x0FC6 }, { 0x102D, 0x1030 }, { 0x1032, 0x1037 },
    { 0x1039, 0x103A }, { 0x103D, 0x103E }, { 0x1058, 0x1059 },
    { 0x105E, 0x1060 }, { 0x1071, 0x1074 }, { 0x1082, 0x1082 },
    { 0x1085, 0x1086 }, { 0x108D, 0x108D }, { 0x109D, 0x109D },
    { 0x1160, 0x11FF }, { 0x135D, 0x135F }, { 0x1712, 0x1714 },
    { 0x1732, 0x1734 }, { 0x1752, 0x1753 }, { 0x1772, 0x1773 },
    { 0x17B4, 0x17B5 }, { 0x17B7, 0x17BD }, { 0x17C6, 0x17C6 },
    { 0x17C9, 0x17D3 }, { 0x17DD, 0x17DD }, { 0x180B, 0x180E },
    { 0x1885, 0x1886 }, { 0x18A9, 0x18A9 }, { 0x1920, 0x1922 },
    { 0x1927, 0x1928 }, { 0x1932, 0x1932 }, { 0x1939, 0x193B },
    { 0x1A17, 0x1A18 }, { 0x1A1B, 0x1A1B }, { 0x1A56, 0x1A56 },
    { 0x1A58, 0x1A5E }, { 0x1A60, 0x1A60 }, { 0x1A62, 0x1A62 },
    { 0x1A65, 0x1A6C }, { 0x1A73, 0x1A7C }, { 0x1A7F, 0x1A7F },
    { 0x1AB0, 0x1ABE }, { 0x1B00, 0x1B03 }, { 0x1B34, 0x1B34 },
    { 0x1B36, 0x1B3A }, { 0x1B3C, 0x1B3C }, { 0x1B42, 0x1B42 },
    { 0x1B6B, 0x1B73 }, { 0x1B80, 0x1B81 }, { 0x1BA2, 0x1BA5 },
    { 0x1BA8, 0x1BA9 }, { 0x1BAB, 0x1BAD }, { 0x1BE6, 0x1BE6 },
    { 0x1BE8, 0x1BE9 }, { 0x1BED, 0x1BED }, { 0x1BEF, 0x1BF1 },
    { 0x1C2C, 0x1C33 }, { 0x1C36, 0x1C37 }, { 0x1CD0, 0x1CD2 },
    { 0x1CD4, 0x1CE0 }, { 0x1CE2, 0x1CE8 }, { 0x1CED, 0x1CED },
    { 0x1CF4, 0x1CF4 }, { 0x1CF8, 0x1CF9 }, { 0x1DC0, 0x1DF9 },
    { 0x1DFB, 0x1DFF }, { 0x200B, 0x200F }, { 0x202A, 0x202E },
    { 0x2060, 0x2064 }, { 0x2066, 0x206F }, { 0x20D0, 0x20F0 },
    { 0x2CEF, 0x2CF1 }, { 0x2D7F, 0x2D7F }, { 0x2DE0, 0x2DFF },
    { 0x302A, 0x302D }, { 0x3099, 0x309A }, { 0xA66F, 0xA672 },
    { 0xA674, 0xA67D }, { 0xA69E, 0xA69F }, { 0xA6F0, 0xA6F1 },
    { 0xA802, 0xA802 }, { 0xA806, 0xA806 }, { 0xA80B, 0xA80B },
    { 0xA825, 0xA826 }, { 0xA8C4, 0xA8C5 }, { 0xA8E0, 0xA8F1 },
    { 0xA8FF, 0xA8FF }, { 0xA926, 0xA92D }, { 0xA947, 0xA951 },
    { 0xA980, 0xA982 }, { 0xA9B3, 0xA9B3 }, { 0xA9B6, 0xA9B9 },
    { 0xA9BC, 0xA9BD }, { 0xA9E5, 0xA9E5 }, { 0xAA29, 0xAA2E },
    { 0xAA31, 0xAA32 }, { 0xAA35, 0xAA36 }, { 0xAA43, 0xAA43 },
    { 0xAA4C, 0xAA4C }, { 0xAA7C, 0xAA7C }, { 0xAAB0, 0xAAB0 },
    { 0xAAB2, 0xAAB4 }, { 0xAAB7, 0xAAB8 }, { 0xAABE, 0xAABF },
    { 0xAAC1, 0xAAC1 }, { 0xAAEC, 0xAAED }, { 0xAAF6, 0xAAF6 },
    { 0xABE5, 0xABE5 }, { 0xABE8, 0xABE8 }, { 0xABED, 0xABED },
    { 0xFB1E, 0xFB1E }, { 0xFE00, 0xFE0F }, { 0xFE20, 0xFE2F },
    { 0xFEFF, 0xFEFF }, { 0xFFF9, 0xFFFB }, { 0x101FD, 0x101FD },
    { 0x102E0, 0x102E0 }, { 0x10376, 0x1037A }, { 0x10A01, 0x10A03 },
    { 0x10A05, 0x10A06 }, { 0x10A0C, 0x10A0F }, { 0x10A38, 0x10A3A },
    { 0x10A3F, 0x10A3F }, { 0x10AE5, 0x10AE6 }, { 0x10D24, 0x10D27 },
    { 0x10F46, 0x10F50 }, { 0x11001, 0x11001 }, { 0x11038, 0x11046 },
    { 0x1107F, 0x11081 }, { 0x110B3, 0x110B6 }, { 0x110B9, 0x110BA },
    { 0x11100, 0x11102 }, { 0x11127, 0x1112B }, { 0x1112D, 0x11134 },
    { 0x11173, 0x11173 }, { 0x11180, 0x11181 }, { 0x111B6, 0x111BE },
    { 0x111C9, 0x111CC }, { 0x1122F, 0x11231 }, { 0x11234, 0x11234 },
    { 0x11236, 0x11237 }, { 0x1123E, 0x1123E }, { 0x112DF, 0x112DF },
    { 0x112E3, 0x112EA }, { 0x11300, 0x11301 }, { 0x1133B, 0x1133C },
    { 0x11340, 0x11340 }, { 0x11366, 0x1136C }, { 0x11370, 0x11374 },
    { 0x11438, 0x1143F }, { 0x11442, 0x11444 }, { 0x11446, 0x11446 },
    { 0x1145E, 0x1145E }, { 0x114B3, 0x114B8 }, { 0x114BA, 0x114BA },
    { 0x114BF, 0x114C0 }, { 0x114C2, 0x114C3 }, { 0x115B2, 0x115B5 },
    { 0x115BC, 0x115BD }, { 0x115BF, 0x115C0 }, { 0x115DC, 0x115DD },
    { 0x11633, 0x1163A }, { 0x1163D, 0x1163D }, { 0x1163F, 0x11640 },
    { 0x116AB, 0x116AB }, { 0x116AD, 0x116AD }, { 0x116B0, 0x116B5 },
    { 0x116B7, 0x116B7 }, { 0x1171D, 0x1171F }, { 0x11722, 0x11725 },
    { 0x11727, 0x1172B }, { 0x1182F, 0x11837 }, { 0x11839, 0x1183A },
    { 0x119D4, 0x119D7 }, { 0x119DA, 0x119DB }, { 0x119E0, 0x119E0 },
    { 0x11A01, 0x11A0A }, { 0x11A33, 0x11A38 }, { 0x11A3B, 0x11A3E },
    { 0x11A47, 0x11A47 }, { 0x11A51, 0x11A56 }, { 0x11A59, 0x11A5B },
    { 0x11A8A, 0x11A96 }, { 0x11A98, 0x11A99 }, { 0x11C30, 0x11C36 },
    { 0x11C38, 0x11C3D }, { 0x11C3F, 0x11C3F }, { 0x11C92, 0x11CA7 },
    { 0x11CAA, 0x11CB0 }, { 0x11CB2, 0x11CB3 }, { 0x11CB5, 0x11CB6 },
    { 0x11D31, 0x11D36 }, { 0x11D3A, 0x11D3A }, { 0x11D3C, 0x11D3D },
    { 0x11D3F, 0x11D45 }, { 0x11D47, 0x11D47 }, { 0x11D90, 0x11D91 },
    { 0x11D95, 0x11D95 }, { 0x11D97, 0x11D97 }, { 0x11EF3, 0x11EF4 },
    { 0x13430, 0x13438 }, { 0x16AF0, 0x16AF4 }, { 0x16B30, 0x16B36 },
    { 0x16F4F, 0x16F4F }, { 0x16F8F, 0x16F92 }, { 0x1BC9D, 0x1BC9E },
    { 0x1BCA0, 0x1BCA3 }, { 0x1D167, 0x1D169 }, { 0x1D173, 0x1D182 },
    { 0x1D185, 0x1D18B }, { 0x1D1AA, 0x1D1AD }, { 0x1D242, 0x1D244 },
    { 0x1DA00, 0x1DA36 }, { 0x1DA3B, 0x1DA6C }, { 0x1DA75, 0x1DA75 },
    { 0x1DA84, 0x1DA84 }, { 0x1DA9B, 0x1DA9F }, { 0x1DAA1, 0x1DAAF },
    { 0x1E000, 0x1E006 }, { 0x1E008, 0x1E018 }, { 0x1E01B, 0x1E021 },
    { 0x1E023, 0x1E024 }, { 0x1E026, 0x1E02A }, { 0x1E130, 0x1E136 },
    { 0x1E2EC, 0x1E2EF }, { 0x1E8D0, 0x1E8D6 }, { 0x1E944, 0x1E94A },
    { 0xE0001, 0xE0001 }, { 0xE0020, 0xE007F }, { 0xE0100, 0xE01EF }
  };

static const int 
zero_width_count = (sizeof(zero_width)/sizeof(struct interval));
