% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowMads.R
\name{rowMads}
\alias{rowMads}
\alias{rowMads,matrix_OR_array_OR_table_OR_numeric-method}
\alias{rowMads,ANY-method}
\alias{colMads}
\alias{colMads,matrix_OR_array_OR_table_OR_numeric-method}
\alias{colMads,ANY-method}
\title{Calculates the median absolute deviation for each row (column) of a
matrix-like object}
\usage{
rowMads(x, rows = NULL, cols = NULL, center = NULL, constant = 1.4826,
  na.rm = FALSE, ...)

\S4method{rowMads}{matrix_OR_array_OR_table_OR_numeric}(x, rows = NULL,
  cols = NULL, center = NULL, constant = 1.4826, na.rm = FALSE,
  dim. = dim(x), ...)

\S4method{rowMads}{ANY}(x, rows = NULL, cols = NULL, center = NULL,
  constant = 1.4826, na.rm = FALSE, ...)

colMads(x, rows = NULL, cols = NULL, center = NULL, constant = 1.4826,
  na.rm = FALSE, ...)

\S4method{colMads}{matrix_OR_array_OR_table_OR_numeric}(x, rows = NULL,
  cols = NULL, center = NULL, constant = 1.4826, na.rm = FALSE,
  dim. = dim(x), ...)

\S4method{colMads}{ANY}(x, rows = NULL, cols = NULL, center = NULL,
  constant = 1.4826, na.rm = FALSE, ...)
}
\arguments{
\item{x}{An NxK matrix-like object.}

\item{rows, cols}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{center}{(optional) the center, defaults to the row means}

\item{constant}{A scale factor. See \code{stats::\link[stats]{mad}()} for
details.}

\item{na.rm}{If \code{\link[base:logical]{TRUE}}, \code{\link{NA}}s
are excluded first, otherwise not.}

\item{...}{Additional arguments passed to specific methods.}

\item{dim.}{An \code{\link{integer}} \code{\link{vector}} of length two
specifying the dimension of \code{x}, essential when x is a
\code{\link{numeric}} vector. Note, that this is not a generic
argument and not all methods need provide it.}
}
\value{
Returns a \code{\link{numeric}} \code{\link{vector}} of length N (K).
}
\description{
Calculates the median absolute deviation for each row (column) of a
matrix-like object.
}
\details{
The S4 methods for \code{x} of type \code{\link{matrix}},
\code{\link{array}}, or \code{\link{numeric}} call
\code{matrixStats::rowMads}
/ \code{matrixStats::colMads}.
}
\examples{
  mat <- matrix(rnorm(15), nrow = 5, ncol = 3)
  mat[2, 1] <- NA
  mat[3, 3] <- Inf
  mat[4, 1] <- 0
  
  print(mat)
  
  rowMads(mat)
  colMads(mat)
  
}
\seealso{
\itemize{
\item \code{matrixStats::\link[matrixStats:rowSds]{rowMads}()} and
\code{matrixStats::\link[matrixStats:rowSds]{colMads}()} which are used
when  the input is a \code{matrix} or \code{numeric} vector.
\item For mean estimates, see \code{\link{rowMeans2}()} and
\code{\link[base:colSums]{rowMeans}()}.
\item For non-robust standard deviation estimates, see
\code{\link{rowSds}()}.
}
}
\keyword{array}
\keyword{iteration}
\keyword{robust}
\keyword{univar}
