% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partition.R
\name{listTips}
\alias{listTips}
\title{List tips descendings from all nodes of a tree}
\usage{
listTips(x)
}
\arguments{
\item{x}{A tree of class \code{\link[ape:read.tree]{phylo}},
\code{\link[phylobase]{phylo4-class}} or \code{\link[phylobase]{phylo4d-class}}.}
}
\value{
A list whose components are vectors of named tips for a given node.
}
\description{
The function \code{listTips} lists the tips descending from each node of a
tree. The tree can be of class \code{\link[ape:read.tree]{phylo}},
\code{\link[phylobase]{phylo4-class}} or \code{\link[phylobase]{phylo4d-class}}.
}
\examples{

if(require(ape) & require(phylobase)){
## make a tree
x <- as(rtree(20),"phylo4")
plot(x,show.node=TRUE)
listTips(x)
}

}
\seealso{
\code{\link{listDD}} which lists the direct descendants for each
node. \cr

\code{\link{treePart}} which defines partitions of tips according to the
tree topology.
}
\author{
Thibaut Jombart \email{tjombart@imperial.ac.uk}
}
\keyword{manip}
