% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time-point.R
\name{time_point_spanning_seq}
\alias{time_point_spanning_seq}
\title{Spanning sequence: time points}
\usage{
time_point_spanning_seq(x)
}
\arguments{
\item{x}{\verb{[clock_sys_time / clock_naive_time]}

A time point vector.}
}
\value{
A sequence along \verb{[min(x), max(x)]}.
}
\description{
\code{time_point_spanning_seq()} generates a regular sequence along the span of
\code{x}, i.e. along \verb{[min(x), max(x)]}. The sequence is generated at the
precision of \code{x}.
}
\details{
Missing values are automatically removed before the sequence is generated.

If you need more precise sequence generation, call \code{\link[=range]{range()}} and \code{\link[=seq]{seq()}}
directly.
}
\examples{
x <- as_naive_time(year_month_day(2019, c(1, 2, 1, 2), c(15, 4, 12, 2)))
x

time_point_spanning_seq(x)

# The sequence is generated at the precision of `x`
x <- as_naive_time(c(
  year_month_day(2019, 1, 1, 5),
  year_month_day(2019, 1, 2, 10),
  year_month_day(2019, 1, 1, 3)
))
time_point_spanning_seq(x)
}
