% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/memdb.R
\name{memdb_frame}
\alias{memdb_frame}
\alias{tbl_memdb}
\alias{src_memdb}
\title{Create a database table in temporary in-memory database.}
\usage{
memdb_frame(..., .name = unique_table_name())

tbl_memdb(df, name = deparse(substitute(df)))

src_memdb()
}
\arguments{
\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}>
A set of name-value pairs. These arguments are
processed with \code{\link[rlang:nse-defuse]{rlang::quos()}} and support unquote via \code{\link{!!}} and
unquote-splice via \code{\link{!!!}}. Use \verb{:=} to create columns that start with a dot.

Arguments are evaluated sequentially.
You can refer to previously created elements directly or using the \link{.data}
pronoun.
An existing \code{.data} pronoun, provided e.g. inside \code{\link[dplyr:mutate]{dplyr::mutate()}},
is not available.}

\item{df}{Data frame to copy}

\item{name, .name}{Name of table in database: defaults to a random name that's
unlikely to conflict with an existing table.}
}
\description{
\code{memdb_frame()} works like \code{\link[tibble:tibble]{tibble::tibble()}}, but instead of creating a new
data frame in R, it creates a table in \code{\link[=src_memdb]{src_memdb()}}.
}
\examples{
library(dplyr)
df <- memdb_frame(x = runif(100), y = runif(100))
df \%>\% arrange(x)
df \%>\% arrange(x) \%>\% show_query()

mtcars_db <- tbl_memdb(mtcars)
mtcars_db \%>\% group_by(cyl) \%>\% summarise(n = n()) \%>\% show_query()
}
