% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verb-window.R
\name{window_order}
\alias{window_order}
\alias{window_frame}
\title{Override window order and frame}
\usage{
window_order(.data, ...)

window_frame(.data, from = -Inf, to = Inf)
}
\arguments{
\item{.data}{A lazy data frame backed by a database query.}

\item{...}{Variables to order by}

\item{from, to}{Bounds of the frame.}
}
\description{
These allow you to override the \verb{PARTITION BY} and \verb{ORDER BY} clauses
of window functions generated by grouped mutates.
}
\examples{
library(dplyr, warn.conflicts = FALSE)

db <- memdb_frame(g = rep(1:2, each = 5), y = runif(10), z = 1:10)
db \%>\%
  window_order(y) \%>\%
  mutate(z = cumsum(y)) \%>\%
  show_query()

db \%>\%
  group_by(g) \%>\%
  window_frame(-3, 0) \%>\%
  window_order(z) \%>\%
  mutate(z = sum(y)) \%>\%
  show_query()
}
