% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encoding.R
\name{fct_encode_one_hot}
\alias{fct_encode_one_hot}
\title{Encode a factor as a one-hot indicator matrix}
\usage{
fct_encode_one_hot(x)
}
\arguments{
\item{x}{A factor.

\code{x} can't contain missing values.

\code{x} is allowed to be an ordered factor.}
}
\value{
An integer matrix with \code{length(x)} rows and \code{length(levels(x))}
columns.
}
\description{
\code{fct_encode_one_hot()} encodes a factor as a one-hot indicator matrix.

This matrix consists of \code{length(x)} rows and \code{length(levels(x))} columns.
Every value in row \code{i} of the matrix is filled with \code{0L} except for the
column that has the same name as \code{x[[i]]}, which is instead filled with \code{1L}.
}
\details{
The columns are returned in the same order as \code{levels(x)}.

If \code{x} has names, the names are propagated onto the result as the row names.
}
\examples{
fct_encode_one_hot(factor(letters))

fct_encode_one_hot(factor(letters[1:2], levels = letters))

set.seed(1234)
fct_encode_one_hot(factor(sample(letters[1:4], 10, TRUE)))
}
