% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pool.scalar.R
\name{pool.scalar}
\alias{pool.scalar}
\title{Multiple imputation pooling: univariate version}
\usage{
pool.scalar(Q, U, n = Inf, k = 1)
}
\arguments{
\item{Q}{A vector of univariate estimates of \code{m} repeated complete data
analyses.}

\item{U}{A vector containing the corresponding \code{m} variances of the univariate
estimates.}

\item{n}{A number providing the sample size. If nothing is specified,
an infinite sample \code{n = Inf} is assumed.}

\item{k}{A number indicating the number of parameters to be estimated.
By default, \code{k = 1} is assumed.}
}
\value{
Returns a list with components.
  \describe{
    \item{\code{m}:}{Number of imputations.}
    \item{\code{qhat}:}{The \code{m} univariate estimates of repeated complete-data analyses.}
    \item{\code{u}:}{The corresponding \code{m} variances of the univariate estimates.}
    \item{\code{qbar}:}{The pooled univariate estimate, formula (3.1.2) Rubin (1987).}
    \item{\code{ubar}:}{The mean of the variances (i.e. the pooled within-imputation variance),
    formula (3.1.3) Rubin (1987).}
    \item{\code{b}:}{The between-imputation variance, formula (3.1.4) Rubin (1987).}
    \item{\code{t}:}{The total variance of the pooled estimated, formula (3.1.5)
    Rubin (1987).}
    \item{\code{r}:}{The relative increase in variance due to nonresponse, formula
    (3.1.7) Rubin (1987).}
    \item{\code{df}:}{The degrees of freedom for t reference distribution by the
    method of Barnard-Rubin (1999).}
    \item{\code{fmi}:}{The fraction missing information due to nonresponse,
    formula (3.1.10) Rubin (1987).}
    }
}
\description{
Pools univariate estimates of m repeated complete data analysis
}
\details{
The function averages the univariate estimates of the complete data model,
computes the total variance over the repeated analyses, and computes the
relative increase in variance due to nonresponse and the fraction of missing
information.
}
\examples{
# example with manual and automatic pooling
imp <- mice(nhanes, maxit = 2, m = 2, print = FALSE, seed = 18210)
fit <- with(data = imp, lm(bmi ~ age))

# manual pooling
summary(fit$analyses[[1]])
summary(fit$analyses[[2]])
pool.scalar(Q = c(-1.5457, -1.428), U = c(0.9723^2, 1.041^2), n = 25, k = 2)

# automatic pooling using broom
pool(fit)
}
\references{
Rubin, D.B. (1987). Multiple Imputation for Nonresponse in
Surveys.  New York: John Wiley and Sons.
}
\seealso{
\code{\link{pool}}
}
\author{
Karin Groothuis-Oudshoorn and Stef van Buuren, 2009
}
