% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ooxml_run_objects.R
\name{page_mar}
\alias{page_mar}
\title{Page margins object}
\usage{
page_mar(
  bottom = 1417/1440,
  top = 1417/1440,
  right = 1417/1440,
  left = 1417/1440,
  header = 708/1440,
  footer = 708/1440,
  gutter = 0/1440
)
}
\arguments{
\item{bottom, top}{distance (in inches) between the bottom/top of the text
margin and the bottom/top of the page. The text is placed at the greater of
the value of this attribute and the extent of the header/footer text. A
negative value indicates that the content should be measured from the
bottom/top of the page regardless of the footer/header, and so will overlap
the footer/header. For example, \verb{header=-0.5, bottom=1} means that the footer
must start one inch from the bottom of the page and the main document text
must start a half inch from the bottom of the page. In this case, the text
and footer overlap since bottom is negative.}

\item{left, right}{distance (in inches) from the left/right edge of the page
to the left/right edge of the text.}

\item{header}{distance (in inches) from the top edge of the page to the top
edge of the header.}

\item{footer}{distance (in inches) from the bottom edge of the page to the
bottom edge of the footer.}

\item{gutter}{page gutter (in inches).}
}
\description{
Define margins for each page of a section.

The function creates a representation of the dimensions of a page. The
dimensions are defined by length, width and orientation. If the orientation
is in landscape mode then the length becomes the width and the width becomes
the length.
}
\examples{
page_mar()
}
\seealso{
Other functions for section definition: 
\code{\link{page_size}()},
\code{\link{prop_section}()},
\code{\link{section_columns}()}
}
\concept{functions for section definition}
