% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{removeTable}
\alias{removeTable}
\title{Remove an Excel table in a workbook}
\usage{
removeTable(wb, sheet, table)
}
\arguments{
\item{wb}{A workbook object}

\item{sheet}{A name or index of a worksheet}

\item{table}{Name of table to remove. See \code{\link{getTables}}}
}
\value{
character vector of table names on the specified sheet
}
\description{
List Excel tables in a workbook
}
\examples{

wb <- createWorkbook()
addWorksheet(wb, sheetName = "Sheet 1")
addWorksheet(wb, sheetName = "Sheet 2")
writeDataTable(wb, sheet = "Sheet 1", x = iris, tableName = "iris")
writeDataTable(wb, sheet = 1, x = mtcars, tableName = "mtcars", startCol = 10)


removeWorksheet(wb, sheet = 1) ## delete worksheet removes table objects

writeDataTable(wb, sheet = 1, x = iris, tableName = "iris")
writeDataTable(wb, sheet = 1, x = mtcars, tableName = "mtcars", startCol = 10)

## removeTable() deletes table object and all data
getTables(wb, sheet = 1)
removeTable(wb = wb, sheet = 1, table = "iris")
writeDataTable(wb, sheet = 1, x = iris, tableName = "iris", startCol = 1)

getTables(wb, sheet = 1)
removeTable(wb = wb, sheet = 1, table = "iris")
writeDataTable(wb, sheet = 1, x = iris, tableName = "iris", startCol = 1)
\dontrun{
saveWorkbook(wb = wb, file = "removeTableExample.xlsx", overwrite = TRUE)
}

}
