% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xx_modcomp_new.R
\name{comodex}
\alias{comodex}
\alias{comodex.lmerMod}
\alias{comodex.default}
\title{Model comparison}
\usage{
comodex(
  largeModel,
  smallModel,
  test = "x2",
  control = list(),
  details = 0,
  ...
)

\method{comodex}{lmerMod}(
  largeModel,
  smallModel,
  test = "x2",
  control = list(),
  details = 0,
  ...
)

\method{comodex}{default}(
  largeModel,
  smallModel,
  test = "x2",
  control = list(),
  details = 0,
  ...
)
}
\arguments{
\item{largeModel}{A model object}

\item{smallModel}{A model object, a formula or a restriction matrix}

\item{test}{A character string}

\item{control}{A list controlling the model comparions.}

\item{details}{should details be printed}

\item{...}{Additional arguments to be passed on to other methods}
}
\description{
Wrapper for functions KRmodcomp, SATmodcomp, PBmodcomp, X2modcomp
}
\examples{
(lmm0 <- lmer(Reaction ~ (Days|Subject), sleepstudy))
(lmm1 <- lmer(Reaction ~ Days + (Days|Subject), sleepstudy))
(lmm2 <- lmer(Reaction ~ Days + I(Days^2) + (Days|Subject), sleepstudy))

lm1 <- lm(dist ~ speed + I(speed^2), data=cars)
lm0 <- lm(dist ~ speed, data=cars)

comodex(lmm2, lmm1, test="x2")
comodex(lmm2, lmm1, test="kr")
comodex(lmm2, lmm1, test="sat")
comodex(lmm2, lmm1, test="PB", control=list(nsim=50, cl=1))
comodex(lmm2, .~. - I(Days^2))

comodex(lm1, lm0)
comodex(lm1, lm0, test="pb", control=list(nsim=50, cl=1))

}
\author{
Søren Højsgaard
}
