% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item_reliability.R
\name{item_reliability}
\alias{item_reliability}
\title{Reliability Test for Items or Scales}
\usage{
item_reliability(x, standardize = FALSE, digits = 3, verbose = TRUE)
}
\arguments{
\item{x}{A matrix or a data frame.}

\item{standardize}{Logical, if \code{TRUE}, the data frame's vectors will be
standardized. Recommended when the variables have different measures /
scales.}

\item{digits}{Amount of digits for returned values.}

\item{verbose}{Toggle warnings and messages.}
}
\value{
A data frame with the item-total correlations (column
\code{Item_Total_Correlation}), corrected item-total correlations (\emph{item
discrimination}, column \code{Discrimination}) and Cronbach's Alpha (if item
deleted, column \code{Alpha_if_deleted}) for each item of the scale, or \code{NULL} if
data frame had too less columns.
}
\description{
Compute various measures of internal consistencies for tests or
item-scales of questionnaires.
}
\details{
This function calculates the item-total correlations, item discriminations
(corrected item-total correlations for each item of \code{x} with the remaining
items) and the Cronbach's alpha for each item, if it was deleted from the
scale. The absolute value of the item discrimination indices should be above
0.2. An index between 0.2 and 0.4 is considered as "fair", while an index
above 0.4 (or below -0.4) is "good". The range of satisfactory values is from
0.4 to 0.7. Items with low discrimination indices are often ambiguously
worded and should be examined. Items with negative indices should be examined
to determine why a negative value was obtained (e.g. reversed answer
categories regarding positive and negative poles).

See \code{\link[=check_itemscale]{check_itemscale()}} and \code{\link[=item_discrimination]{item_discrimination()}} for more details on
the interpretation of the results.
}
\note{
\itemize{
\item \emph{Item difficulty} should range between 0.2 and 0.8. Ideal value
is \code{p+(1-p)/2} (which mostly is between 0.5 and 0.8). See
\code{\link[=item_difficulty]{item_difficulty()}} for details.
\item For \emph{item discrimination}, also known as \emph{corrected item-total correlations},
acceptable values are 0.20 or higher; the closer to 1.00 the better. See
\code{\link[=item_discrimination]{item_discrimination()}} for more details. If an item discrimination is
negative, the corresponding item probably need to be reverse-coded (which
can be done with \code{\link[datawizard:reverse]{datawizard::reverse()}}).
\item In case the total \emph{Cronbach's alpha} value is below the acceptable
cut-off of 0.7 (mostly if an index has few items), the
\emph{mean inter-item-correlation} is an alternative measure to indicate
acceptability. Satisfactory range lies between 0.2 and 0.4. See also
\code{\link[=item_intercor]{item_intercor()}}.
}
}
\examples{
data(mtcars)
x <- mtcars[, c("cyl", "gear", "carb", "hp")]
item_reliability(x)
}
\references{
\itemize{
\item Briggs SR, Cheek JM (1986) The role of factor analysis in the development
and evaluation of personality scales. Journal of Personality, 54(1),
106-148. doi: 10.1111/j.1467-6494.1986.tb00391.x
}
}
