% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcdk.R
\name{convert.implicit.to.explicit}
\alias{convert.implicit.to.explicit}
\title{Convert implicit hydrogens to explicit.}
\usage{
convert.implicit.to.explicit(mol)
}
\arguments{
\item{mol}{The molecule to query. Should be a `jobjRef` representing an `IAtomContainer`}
}
\description{
In some cases, a molecule may not have any hydrogens (such as when read
in from an MDL MOL file that did not have hydrogens or SMILES with no
explicit hydrogens). In such cases, this method
will add implicit hydrogens and then convert them to explicit ones. The 
newly added H's will not have any 2D or 3D coordinates associated with them.
Ensure that the molecule has been typed beforehand.
}
\seealso{
\code{\link{get.hydrogen.count}}, \code{\link{remove.hydrogens}}, \code{\link{set.atom.types}}
}
\author{
Rajarshi Guha (\email{rajarshi.guha@gmail.com})
}
