% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{load.molecules}
\alias{load.molecules}
\title{Load molecular structures from disk or URL}
\usage{
load.molecules(
  molfiles = NA,
  aromaticity = TRUE,
  typing = TRUE,
  isotopes = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{molfiles}{A `character` vector of filenames. Note that the full
path to the files should be provided. URL's can also be used as
paths. In such a case, the URL should start with "http://"}

\item{aromaticity}{If `TRUE` then aromaticity detection is
performed on all loaded molecules. If this fails for a given
molecule, then the molecule is set to `NA` in the return list}

\item{typing}{If `TRUE` then atom typing is
performed on all loaded molecules. The assigned types will be CDK
internal types. If this fails for a given molecule, then the molecule 
is set to `NA` in the return list}

\item{isotopes}{If `TRUE` then atoms are configured with isotopic masses}

\item{verbose}{If `TRUE`, output (such as file download progress) will
be bountiful}
}
\value{
A `list` of CDK `IAtomContainer` objects, represented as `jobjRef` objects 
in R, which can be used in other `rcdk` functions
}
\description{
The CDK can read a variety of molecular structure formats. This function
encapsulates the calls to the CDK API to load a structure given its filename
or a URL to a structure file.
}
\details{
Note that this method will load all molecules into memory. For files containing
tens of thousands of molecules this may lead to out of memory errors. In such 
situations consider using the iterating file readers.

Note that if molecules are read in from formats that do not have rules for
handling implicit hydrogens (such as MDL MOL), the molecule will not have
implicit or explicit hydrogens. To add explicit hydrogens, make sure that the molecule
has been typed (this is `TRUE` by default for this function) and then call 
\code{\link{convert.implicit.to.explicit}}. On the other hand for a format 
such as SMILES, implicit or explicit hydrogens will be present.
}
\examples{
\dontrun{
sdffile <- system.file("molfiles/dhfr00008.sdf", package="rcdk")
mols <- load.molecules(c('mol1.sdf', 'mol2.smi', sdfile))
}
}
\seealso{
\code{\link{write.molecules}}, \code{\link{parse.smiles}}, \code{\link{iload.molecules}}
}
\author{
Rajarshi Guha (\email{rajarshi.guha@gmail.com})
}
