% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rle_utils.R
\name{rle-methods}
\alias{rle-methods}
\alias{c.rle}
\alias{mean.rle}
\alias{length.rle}
\alias{is.na.rle}
\alias{str.rle}
\title{Miscellaneous Common Methods for \code{\link{rle}} Objects}
\usage{
\method{c}{rle}(...)

\method{mean}{rle}(x, na.rm = FALSE, ...)

\method{length}{rle}(x)

\method{is.na}{rle}(x)

\method{str}{rle}(object, ...)
}
\arguments{
\item{...}{For \code{c}, objects to be concatenated. The first object
must be of class \code{\link{rle}}.}

\item{x, object}{An \code{\link{rle}} object.}

\item{na.rm}{Whether missing values are to be ignored (\code{TRUE}) or propagated (\code{FALSE}).}
}
\description{
Miscellaneous Common Methods for \code{\link{rle}} Objects
}
\note{
The \code{\link{length}} method returns the length of the vector
represented by the object, obtained by summing the lengths of
individual runs. This can be overridden by setting
\code{options(rle.unclass_index = FALSE)}, which causes it to
return the length of the underlying representation (usually 2) instead.
}
\examples{
x <- rle(as.logical(rbinom(10,1,.7)))
y <- rle(as.logical(rbinom(10,1,.3)))

stopifnot(isTRUE(all.equal(c(inverse.rle(x),inverse.rle(y)),inverse.rle(c(x,y)))))


stopifnot(isTRUE(all.equal(mean(inverse.rle(x)),mean(x))))
stopifnot(isTRUE(all.equal(mean(inverse.rle(y)),mean(y))))


stopifnot(isTRUE(all.equal(length(inverse.rle(x)),length(x))))
stopifnot(isTRUE(all.equal(length(inverse.rle(y)),length(y))))

x$values[1] <- NA
y$values[1] <- NA
stopifnot(isTRUE(all.equal(is.na(inverse.rle(x)),inverse.rle(is.na(x)))))
stopifnot(isTRUE(all.equal(is.na(inverse.rle(y)),inverse.rle(is.na(y)))))


str(x)

}
