% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s2-options.R
\name{s2_options}
\alias{s2_options}
\alias{s2_snap_identity}
\alias{s2_snap_level}
\alias{s2_snap_precision}
\alias{s2_snap_distance}
\title{Geography Operation Options}
\usage{
s2_options(
  model = NULL,
  snap = s2_snap_identity(),
  snap_radius = -1,
  duplicate_edges = FALSE,
  edge_type = "directed",
  validate = FALSE,
  polyline_type = "path",
  polyline_sibling_pairs = "keep",
  simplify_edge_chains = FALSE,
  split_crossing_edges = FALSE,
  idempotent = FALSE
)

s2_snap_identity()

s2_snap_level(level)

s2_snap_precision(precision)

s2_snap_distance(distance)
}
\arguments{
\item{model}{One of 'open', 'semi-open' (default for polygons),
or 'closed' (default for polylines). See section 'Model'}

\item{snap}{Use \code{s2_snap_identity()}, \code{s2_snap_distance()}, \code{s2_snap_level()},
or \code{s2_snap_precision()} to specify how or if coordinate rounding should
occur.}

\item{snap_radius}{As opposed to the snap function, which specifies
the maximum distance a vertex should move, the snap radius (in radians) sets
the minimum distance between vertices of the output that don't cause vertices
to move more than the distance specified by the snap function. This can be used
to simplify the result of a boolean operation. Use -1 to specify that any
minimum distance is acceptable.}

\item{duplicate_edges}{Use \code{TRUE} to keep duplicate edges (e.g., duplicate
points).}

\item{edge_type}{One of 'directed' (default) or 'undirected'.}

\item{validate}{Use \code{TRUE} to validate the result from the builder.}

\item{polyline_type}{One of 'path' (default) or 'walk'. If 'walk',
polylines that backtrack are preserved.}

\item{polyline_sibling_pairs}{One of 'discard' (default) or 'keep'.}

\item{simplify_edge_chains}{Use \code{TRUE} to remove vertices that are within
\code{snap_radius} of the original vertex.}

\item{split_crossing_edges}{Use \code{TRUE} to split crossing polyline edges
when creating geometries.}

\item{idempotent}{Use \code{FALSE} to apply snap even if snapping is not necessary
to satisfy vertex constraints.}

\item{level}{A value from 0 to 30 corresponding to the cell level
at which snapping should occur.}

\item{precision}{A number by which coordinates should be multiplied
before being rounded. Rounded to the nearest exponent of 10.}

\item{distance}{A distance (in radians) denoting the maximum
distance a vertex should move in the snapping process.}
}
\description{
These functions specify defaults for options used to perform operations
and construct geometries. These are used in predicates (e.g., \code{\link[=s2_intersects]{s2_intersects()}}),
and boolean operations (e.g., \code{\link[=s2_intersection]{s2_intersection()}}) to specify the model for
containment and how new geometries should be constructed.
}
\section{Model}{

The geometry model indicates whether or not a geometry includes its boundaries.
Boundaries of line geometries are its end points.
OPEN geometries do not contain their boundary (\code{model = "open"}); CLOSED
geometries (\code{model = "closed"}) contain their boundary; SEMI-OPEN geometries
(\code{model = "semi-open"}) contain half of their boundaries, such that when two polygons
do not overlap or two lines do not cross, no point exist that belong to
more than one of the geometries. (This latter form, half-closed, is
not present in the OpenGIS "simple feature access" (SFA) standard nor DE9-IM on
which that is based). The default values for \code{\link[=s2_contains]{s2_contains()}} (open)
and covers/covered_by (closed) correspond to the SFA standard specification
of these operators.
}

\examples{
# use s2_options() to specify containment models, snap level
# layer creation options, and builder options
s2_options(model = "closed", snap = s2_snap_level(30))

}
