% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encoding_detection.R
\name{stri_enc_isutf16be}
\alias{stri_enc_isutf16be}
\alias{stri_enc_isutf16le}
\alias{stri_enc_isutf32be}
\alias{stri_enc_isutf32le}
\title{Check If a Data Stream Is Possibly in UTF-16 or UTF-32}
\usage{
stri_enc_isutf16be(str)

stri_enc_isutf16le(str)

stri_enc_isutf32be(str)

stri_enc_isutf32le(str)
}
\arguments{
\item{str}{character vector, a raw vector, or
a list of \code{raw} vectors}
}
\value{
Returns a logical vector.
}
\description{
These functions detect whether a given byte stream is
valid UTF-16LE, UTF-16BE, UTF-32LE, or UTF-32BE.
}
\details{
These functions are independent of the way \R marks encodings in
character strings (see \link{Encoding} and \link{stringi-encoding}).
Most often, these functions act on raw vectors.

A result of \code{FALSE} means that a string is surely not valid UTF-16
or UTF-32. However, false positives are possible.

Also note that a data stream may be sometimes classified
as both valid UTF-16LE and UTF-16BE.
}
\seealso{
The official online manual of \pkg{stringi} at \url{https://stringi.gagolewski.com/}

Gagolewski M., \pkg{stringi}: Fast and portable character string processing in R, \emph{Journal of Statistical Software} 103(2), 2022, 1-59, \doi{10.18637/jss.v103.i02}

Other encoding_detection: 
\code{\link{about_encoding}},
\code{\link{stri_enc_detect2}()},
\code{\link{stri_enc_detect}()},
\code{\link{stri_enc_isascii}()},
\code{\link{stri_enc_isutf8}()}
}
\concept{encoding_detection}
\author{
\href{https://www.gagolewski.com/}{Marek Gagolewski} and other contributors
}
