% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recycle.R
\name{vec_recycle}
\alias{vec_recycle}
\alias{vec_recycle_common}
\title{Vector recycling}
\usage{
vec_recycle(x, size, ..., x_arg = "", call = caller_env())

vec_recycle_common(..., .size = NULL, .arg = "", .call = caller_env())
}
\arguments{
\item{x}{A vector to recycle.}

\item{size}{Desired output size.}

\item{...}{Depending on the function used:
\itemize{
\item For \code{vec_recycle_common()}, vectors to recycle.
\item For \code{vec_recycle()}, these dots should be empty.
}}

\item{x_arg}{Argument name for \code{x}. These are used in error
messages to inform the user about which argument has an
incompatible size.}

\item{call, .call}{The execution environment of a currently
running function, e.g. \code{caller_env()}. The function will be
mentioned in error messages as the source of the error. See the
\code{call} argument of \code{\link[rlang:abort]{abort()}} for more information.}

\item{.size}{Desired output size. If omitted,
will use the common size from \code{\link[=vec_size_common]{vec_size_common()}}.}

\item{.arg}{An argument name as a string. This argument
will be mentioned in error messages as the input that is at the
origin of a problem.}
}
\description{
\code{vec_recycle(x, size)} recycles a single vector to a given size.
\code{vec_recycle_common(...)} recycles multiple vectors to their common size. All
functions obey the \link[=theory-faq-recycling]{vctrs recycling rules}, and will
throw an error if recycling is not possible. See \code{\link[=vec_size]{vec_size()}} for the precise
definition of size.
}
\section{Dependencies}{

\itemize{
\item \code{\link[=vec_slice]{vec_slice()}}
}
}

\examples{
# Inputs with 1 observation are recycled
vec_recycle_common(1:5, 5)
vec_recycle_common(integer(), 5)
\dontrun{
vec_recycle_common(1:5, 1:2)
}

# Data frames and matrices are recycled along their rows
vec_recycle_common(data.frame(x = 1), 1:5)
vec_recycle_common(array(1:2, c(1, 2)), 1:5)
vec_recycle_common(array(1:3, c(1, 3, 1)), 1:5)
}
