% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/debug.R
\name{wkb_debug}
\alias{wkb_debug}
\alias{wkt_debug}
\alias{wkt_streamer_debug}
\title{Debug well-known geometry}
\usage{
wkb_debug(wkb)

wkt_debug(wkt)

wkt_streamer_debug(wkt)
}
\arguments{
\item{wkb}{A \code{list()} of \code{\link[=raw]{raw()}} vectors, such as that
returned by \code{sf::st_as_binary()}.}

\item{wkt}{A character vector containing well-known text.}
}
\value{
The input, invisibly
}
\description{
Prints the raw calls to the \code{WKBGeometryHandler()}. Useful for writing
custom C++ handlers and debugging read problems.
}
\examples{
wkt_debug("MULTIPOLYGON (((0 0, 10 0, 0 10, 0 0)))")
wkt_streamer_debug("MULTIPOLYGON (((0 0, 10 0, 0 10, 0 0)))")
wkb_debug(
  wk::wkt_translate_wkb(
    "MULTIPOLYGON (((0 0, 10 0, 0 10, 0 0)))"
  )
)

}
