% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/string.R
\name{str_wrap}
\alias{str_wrap}
\title{Wrap character vectors}
\usage{
str_wrap(...)
}
\arguments{
\item{...}{Arguments passed to \code{\link[=strwrap]{strwrap()}}.}
}
\value{
A character vector.
}
\description{
A wrapper function to make \code{\link[=strwrap]{strwrap()}} return a character vector of the same
length as the input vector; each element of the output vector is a string
formed by concatenating wrapped strings by \verb{\\n}.
}
\examples{
x = sample(c(letters, " "), 200, TRUE, c(rep(0.5/26, 26), 0.5))
x = rep(paste(x, collapse = ""), 2)
strwrap(x, width = 30)
xfun::str_wrap(x, width = 30)  # same length as x
}
