# Copyright 2015 Google Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

require 'date'
require 'google/apis/core/base_service'
require 'google/apis/core/json_representation'
require 'google/apis/core/hashable'
require 'google/apis/errors'

module Google
  module Apis
    module Adexchangebuyer2V2beta1
      
      class AbsoluteDateRange
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class AcceptProposalRequest
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class AdSize
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class AdTechnologyProviders
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class AddDealAssociationRequest
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class AddNoteRequest
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class AppContext
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class AuctionContext
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class BidMetricsRow
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class BidResponseWithoutBidsStatusRow
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Buyer
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class CalloutStatusRow
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class CancelNegotiationRequest
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Client
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ClientUser
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ClientUserInvitation
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class CompleteSetupRequest
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ContactInformation
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Correction
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Creative
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class CreativeDealAssociation
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class CreativeRestrictions
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class CreativeSize
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class CreativeSpecification
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class CreativeStatusRow
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class CriteriaTargeting
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Date
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class DayPart
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class DayPartTargeting
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Deal
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class DealPauseStatus
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class DealServingMetadata
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class DealTerms
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class DeliveryControl
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Disapproval
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Empty
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class FilterSet
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class FilteredBidCreativeRow
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class FilteredBidDetailRow
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class FirstPartyMobileApplicationTargeting
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class FrequencyCap
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GuaranteedFixedPriceTerms
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class HtmlContent
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Image
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ImpressionMetricsRow
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class InventorySizeTargeting
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ListBidMetricsResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ListBidResponseErrorsResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ListBidResponsesWithoutBidsResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ListClientUserInvitationsResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ListClientUsersResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ListClientsResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ListCreativeStatusBreakdownByCreativeResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ListCreativeStatusBreakdownByDetailResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ListCreativesResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ListDealAssociationsResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ListFilterSetsResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ListFilteredBidRequestsResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ListFilteredBidsResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ListImpressionMetricsResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ListLosingBidsResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ListNonBillableWinningBidsResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ListProductsResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ListProposalsResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ListPublisherProfilesResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class LocationContext
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class MarketplaceTargeting
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class MetricValue
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class MobileApplicationTargeting
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Money
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class NativeContent
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class NonBillableWinningBidStatusRow
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class NonGuaranteedAuctionTerms
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class NonGuaranteedFixedPriceTerms
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Note
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class OperatingSystemTargeting
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class PauseProposalRequest
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class PlacementTargeting
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class PlatformContext
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Price
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class PricePerBuyer
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class PrivateData
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Product
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Proposal
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class PublisherProfile
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class RealtimeTimeRange
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class RelativeDateRange
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class RemoveDealAssociationRequest
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ResumeProposalRequest
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class RowDimensions
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class SecurityContext
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Seller
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ServingContext
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ServingRestriction
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Size
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class StopWatchingCreativeRequest
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class TargetingCriteria
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class TargetingValue
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class TechnologyTargeting
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class TimeInterval
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class TimeOfDay
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class UrlTargeting
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class VideoContent
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class VideoTargeting
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class WatchCreativeRequest
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class AbsoluteDateRange
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :end_date, as: 'endDate', class: Google::Apis::Adexchangebuyer2V2beta1::Date, decorator: Google::Apis::Adexchangebuyer2V2beta1::Date::Representation
      
          property :start_date, as: 'startDate', class: Google::Apis::Adexchangebuyer2V2beta1::Date, decorator: Google::Apis::Adexchangebuyer2V2beta1::Date::Representation
      
        end
      end
      
      class AcceptProposalRequest
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :proposal_revision, :numeric_string => true, as: 'proposalRevision'
        end
      end
      
      class AdSize
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :height, :numeric_string => true, as: 'height'
          property :size_type, as: 'sizeType'
          property :width, :numeric_string => true, as: 'width'
        end
      end
      
      class AdTechnologyProviders
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :detected_provider_ids, as: 'detectedProviderIds'
          property :has_unidentified_provider, as: 'hasUnidentifiedProvider'
        end
      end
      
      class AddDealAssociationRequest
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :association, as: 'association', class: Google::Apis::Adexchangebuyer2V2beta1::CreativeDealAssociation, decorator: Google::Apis::Adexchangebuyer2V2beta1::CreativeDealAssociation::Representation
      
        end
      end
      
      class AddNoteRequest
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :note, as: 'note', class: Google::Apis::Adexchangebuyer2V2beta1::Note, decorator: Google::Apis::Adexchangebuyer2V2beta1::Note::Representation
      
        end
      end
      
      class AppContext
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :app_types, as: 'appTypes'
        end
      end
      
      class AuctionContext
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :auction_types, as: 'auctionTypes'
        end
      end
      
      class BidMetricsRow
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :bids, as: 'bids', class: Google::Apis::Adexchangebuyer2V2beta1::MetricValue, decorator: Google::Apis::Adexchangebuyer2V2beta1::MetricValue::Representation
      
          property :bids_in_auction, as: 'bidsInAuction', class: Google::Apis::Adexchangebuyer2V2beta1::MetricValue, decorator: Google::Apis::Adexchangebuyer2V2beta1::MetricValue::Representation
      
          property :billed_impressions, as: 'billedImpressions', class: Google::Apis::Adexchangebuyer2V2beta1::MetricValue, decorator: Google::Apis::Adexchangebuyer2V2beta1::MetricValue::Representation
      
          property :impressions_won, as: 'impressionsWon', class: Google::Apis::Adexchangebuyer2V2beta1::MetricValue, decorator: Google::Apis::Adexchangebuyer2V2beta1::MetricValue::Representation
      
          property :measurable_impressions, as: 'measurableImpressions', class: Google::Apis::Adexchangebuyer2V2beta1::MetricValue, decorator: Google::Apis::Adexchangebuyer2V2beta1::MetricValue::Representation
      
          property :row_dimensions, as: 'rowDimensions', class: Google::Apis::Adexchangebuyer2V2beta1::RowDimensions, decorator: Google::Apis::Adexchangebuyer2V2beta1::RowDimensions::Representation
      
          property :viewable_impressions, as: 'viewableImpressions', class: Google::Apis::Adexchangebuyer2V2beta1::MetricValue, decorator: Google::Apis::Adexchangebuyer2V2beta1::MetricValue::Representation
      
        end
      end
      
      class BidResponseWithoutBidsStatusRow
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :impression_count, as: 'impressionCount', class: Google::Apis::Adexchangebuyer2V2beta1::MetricValue, decorator: Google::Apis::Adexchangebuyer2V2beta1::MetricValue::Representation
      
          property :row_dimensions, as: 'rowDimensions', class: Google::Apis::Adexchangebuyer2V2beta1::RowDimensions, decorator: Google::Apis::Adexchangebuyer2V2beta1::RowDimensions::Representation
      
          property :status, as: 'status'
        end
      end
      
      class Buyer
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :account_id, as: 'accountId'
        end
      end
      
      class CalloutStatusRow
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :callout_status_id, as: 'calloutStatusId'
          property :impression_count, as: 'impressionCount', class: Google::Apis::Adexchangebuyer2V2beta1::MetricValue, decorator: Google::Apis::Adexchangebuyer2V2beta1::MetricValue::Representation
      
          property :row_dimensions, as: 'rowDimensions', class: Google::Apis::Adexchangebuyer2V2beta1::RowDimensions, decorator: Google::Apis::Adexchangebuyer2V2beta1::RowDimensions::Representation
      
        end
      end
      
      class CancelNegotiationRequest
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
        end
      end
      
      class Client
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :client_account_id, :numeric_string => true, as: 'clientAccountId'
          property :client_name, as: 'clientName'
          property :entity_id, :numeric_string => true, as: 'entityId'
          property :entity_name, as: 'entityName'
          property :entity_type, as: 'entityType'
          property :partner_client_id, as: 'partnerClientId'
          property :role, as: 'role'
          property :status, as: 'status'
          property :visible_to_seller, as: 'visibleToSeller'
        end
      end
      
      class ClientUser
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :client_account_id, :numeric_string => true, as: 'clientAccountId'
          property :email, as: 'email'
          property :status, as: 'status'
          property :user_id, :numeric_string => true, as: 'userId'
        end
      end
      
      class ClientUserInvitation
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :client_account_id, :numeric_string => true, as: 'clientAccountId'
          property :email, as: 'email'
          property :invitation_id, :numeric_string => true, as: 'invitationId'
        end
      end
      
      class CompleteSetupRequest
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
        end
      end
      
      class ContactInformation
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :email, as: 'email'
          property :name, as: 'name'
        end
      end
      
      class Correction
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :contexts, as: 'contexts', class: Google::Apis::Adexchangebuyer2V2beta1::ServingContext, decorator: Google::Apis::Adexchangebuyer2V2beta1::ServingContext::Representation
      
          collection :details, as: 'details'
          property :type, as: 'type'
        end
      end
      
      class Creative
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :account_id, as: 'accountId'
          property :ad_choices_destination_url, as: 'adChoicesDestinationUrl'
          property :ad_technology_providers, as: 'adTechnologyProviders', class: Google::Apis::Adexchangebuyer2V2beta1::AdTechnologyProviders, decorator: Google::Apis::Adexchangebuyer2V2beta1::AdTechnologyProviders::Representation
      
          property :advertiser_name, as: 'advertiserName'
          property :agency_id, :numeric_string => true, as: 'agencyId'
          property :api_update_time, as: 'apiUpdateTime'
          collection :attributes, as: 'attributes'
          collection :click_through_urls, as: 'clickThroughUrls'
          collection :corrections, as: 'corrections', class: Google::Apis::Adexchangebuyer2V2beta1::Correction, decorator: Google::Apis::Adexchangebuyer2V2beta1::Correction::Representation
      
          property :creative_id, as: 'creativeId'
          property :deals_status, as: 'dealsStatus'
          collection :declared_click_through_urls, as: 'declaredClickThroughUrls'
          collection :detected_advertiser_ids, as: 'detectedAdvertiserIds'
          collection :detected_domains, as: 'detectedDomains'
          collection :detected_languages, as: 'detectedLanguages'
          collection :detected_product_categories, as: 'detectedProductCategories'
          collection :detected_sensitive_categories, as: 'detectedSensitiveCategories'
          property :html, as: 'html', class: Google::Apis::Adexchangebuyer2V2beta1::HtmlContent, decorator: Google::Apis::Adexchangebuyer2V2beta1::HtmlContent::Representation
      
          collection :impression_tracking_urls, as: 'impressionTrackingUrls'
          property :native, as: 'native', class: Google::Apis::Adexchangebuyer2V2beta1::NativeContent, decorator: Google::Apis::Adexchangebuyer2V2beta1::NativeContent::Representation
      
          property :open_auction_status, as: 'openAuctionStatus'
          collection :restricted_categories, as: 'restrictedCategories'
          collection :serving_restrictions, as: 'servingRestrictions', class: Google::Apis::Adexchangebuyer2V2beta1::ServingRestriction, decorator: Google::Apis::Adexchangebuyer2V2beta1::ServingRestriction::Representation
      
          collection :vendor_ids, as: 'vendorIds'
          property :version, as: 'version'
          property :video, as: 'video', class: Google::Apis::Adexchangebuyer2V2beta1::VideoContent, decorator: Google::Apis::Adexchangebuyer2V2beta1::VideoContent::Representation
      
        end
      end
      
      class CreativeDealAssociation
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :account_id, as: 'accountId'
          property :creative_id, as: 'creativeId'
          property :deals_id, as: 'dealsId'
        end
      end
      
      class CreativeRestrictions
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :creative_format, as: 'creativeFormat'
          collection :creative_specifications, as: 'creativeSpecifications', class: Google::Apis::Adexchangebuyer2V2beta1::CreativeSpecification, decorator: Google::Apis::Adexchangebuyer2V2beta1::CreativeSpecification::Representation
      
          property :skippable_ad_type, as: 'skippableAdType'
        end
      end
      
      class CreativeSize
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :allowed_formats, as: 'allowedFormats'
          collection :companion_sizes, as: 'companionSizes', class: Google::Apis::Adexchangebuyer2V2beta1::Size, decorator: Google::Apis::Adexchangebuyer2V2beta1::Size::Representation
      
          property :creative_size_type, as: 'creativeSizeType'
          property :native_template, as: 'nativeTemplate'
          property :size, as: 'size', class: Google::Apis::Adexchangebuyer2V2beta1::Size, decorator: Google::Apis::Adexchangebuyer2V2beta1::Size::Representation
      
          property :skippable_ad_type, as: 'skippableAdType'
        end
      end
      
      class CreativeSpecification
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :creative_companion_sizes, as: 'creativeCompanionSizes', class: Google::Apis::Adexchangebuyer2V2beta1::AdSize, decorator: Google::Apis::Adexchangebuyer2V2beta1::AdSize::Representation
      
          property :creative_size, as: 'creativeSize', class: Google::Apis::Adexchangebuyer2V2beta1::AdSize, decorator: Google::Apis::Adexchangebuyer2V2beta1::AdSize::Representation
      
        end
      end
      
      class CreativeStatusRow
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :bid_count, as: 'bidCount', class: Google::Apis::Adexchangebuyer2V2beta1::MetricValue, decorator: Google::Apis::Adexchangebuyer2V2beta1::MetricValue::Representation
      
          property :creative_status_id, as: 'creativeStatusId'
          property :row_dimensions, as: 'rowDimensions', class: Google::Apis::Adexchangebuyer2V2beta1::RowDimensions, decorator: Google::Apis::Adexchangebuyer2V2beta1::RowDimensions::Representation
      
        end
      end
      
      class CriteriaTargeting
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :excluded_criteria_ids, as: 'excludedCriteriaIds'
          collection :targeted_criteria_ids, as: 'targetedCriteriaIds'
        end
      end
      
      class Date
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :day, as: 'day'
          property :month, as: 'month'
          property :year, as: 'year'
        end
      end
      
      class DayPart
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :day_of_week, as: 'dayOfWeek'
          property :end_time, as: 'endTime', class: Google::Apis::Adexchangebuyer2V2beta1::TimeOfDay, decorator: Google::Apis::Adexchangebuyer2V2beta1::TimeOfDay::Representation
      
          property :start_time, as: 'startTime', class: Google::Apis::Adexchangebuyer2V2beta1::TimeOfDay, decorator: Google::Apis::Adexchangebuyer2V2beta1::TimeOfDay::Representation
      
        end
      end
      
      class DayPartTargeting
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :day_parts, as: 'dayParts', class: Google::Apis::Adexchangebuyer2V2beta1::DayPart, decorator: Google::Apis::Adexchangebuyer2V2beta1::DayPart::Representation
      
          property :time_zone_type, as: 'timeZoneType'
        end
      end
      
      class Deal
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :available_end_time, as: 'availableEndTime'
          property :available_start_time, as: 'availableStartTime'
          property :buyer_private_data, as: 'buyerPrivateData', class: Google::Apis::Adexchangebuyer2V2beta1::PrivateData, decorator: Google::Apis::Adexchangebuyer2V2beta1::PrivateData::Representation
      
          property :create_product_id, as: 'createProductId'
          property :create_product_revision, :numeric_string => true, as: 'createProductRevision'
          property :create_time, as: 'createTime'
          property :creative_pre_approval_policy, as: 'creativePreApprovalPolicy'
          property :creative_restrictions, as: 'creativeRestrictions', class: Google::Apis::Adexchangebuyer2V2beta1::CreativeRestrictions, decorator: Google::Apis::Adexchangebuyer2V2beta1::CreativeRestrictions::Representation
      
          property :creative_safe_frame_compatibility, as: 'creativeSafeFrameCompatibility'
          property :deal_id, as: 'dealId'
          property :deal_serving_metadata, as: 'dealServingMetadata', class: Google::Apis::Adexchangebuyer2V2beta1::DealServingMetadata, decorator: Google::Apis::Adexchangebuyer2V2beta1::DealServingMetadata::Representation
      
          property :deal_terms, as: 'dealTerms', class: Google::Apis::Adexchangebuyer2V2beta1::DealTerms, decorator: Google::Apis::Adexchangebuyer2V2beta1::DealTerms::Representation
      
          property :delivery_control, as: 'deliveryControl', class: Google::Apis::Adexchangebuyer2V2beta1::DeliveryControl, decorator: Google::Apis::Adexchangebuyer2V2beta1::DeliveryControl::Representation
      
          property :description, as: 'description'
          property :display_name, as: 'displayName'
          property :external_deal_id, as: 'externalDealId'
          property :is_setup_complete, as: 'isSetupComplete'
          property :programmatic_creative_source, as: 'programmaticCreativeSource'
          property :proposal_id, as: 'proposalId'
          collection :seller_contacts, as: 'sellerContacts', class: Google::Apis::Adexchangebuyer2V2beta1::ContactInformation, decorator: Google::Apis::Adexchangebuyer2V2beta1::ContactInformation::Representation
      
          property :syndication_product, as: 'syndicationProduct'
          property :targeting, as: 'targeting', class: Google::Apis::Adexchangebuyer2V2beta1::MarketplaceTargeting, decorator: Google::Apis::Adexchangebuyer2V2beta1::MarketplaceTargeting::Representation
      
          collection :targeting_criterion, as: 'targetingCriterion', class: Google::Apis::Adexchangebuyer2V2beta1::TargetingCriteria, decorator: Google::Apis::Adexchangebuyer2V2beta1::TargetingCriteria::Representation
      
          property :update_time, as: 'updateTime'
          property :web_property_code, as: 'webPropertyCode'
        end
      end
      
      class DealPauseStatus
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :buyer_pause_reason, as: 'buyerPauseReason'
          property :first_paused_by, as: 'firstPausedBy'
          property :has_buyer_paused, as: 'hasBuyerPaused'
          property :has_seller_paused, as: 'hasSellerPaused'
          property :seller_pause_reason, as: 'sellerPauseReason'
        end
      end
      
      class DealServingMetadata
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :deal_pause_status, as: 'dealPauseStatus', class: Google::Apis::Adexchangebuyer2V2beta1::DealPauseStatus, decorator: Google::Apis::Adexchangebuyer2V2beta1::DealPauseStatus::Representation
      
        end
      end
      
      class DealTerms
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :branding_type, as: 'brandingType'
          property :description, as: 'description'
          property :estimated_gross_spend, as: 'estimatedGrossSpend', class: Google::Apis::Adexchangebuyer2V2beta1::Price, decorator: Google::Apis::Adexchangebuyer2V2beta1::Price::Representation
      
          property :estimated_impressions_per_day, :numeric_string => true, as: 'estimatedImpressionsPerDay'
          property :guaranteed_fixed_price_terms, as: 'guaranteedFixedPriceTerms', class: Google::Apis::Adexchangebuyer2V2beta1::GuaranteedFixedPriceTerms, decorator: Google::Apis::Adexchangebuyer2V2beta1::GuaranteedFixedPriceTerms::Representation
      
          property :non_guaranteed_auction_terms, as: 'nonGuaranteedAuctionTerms', class: Google::Apis::Adexchangebuyer2V2beta1::NonGuaranteedAuctionTerms, decorator: Google::Apis::Adexchangebuyer2V2beta1::NonGuaranteedAuctionTerms::Representation
      
          property :non_guaranteed_fixed_price_terms, as: 'nonGuaranteedFixedPriceTerms', class: Google::Apis::Adexchangebuyer2V2beta1::NonGuaranteedFixedPriceTerms, decorator: Google::Apis::Adexchangebuyer2V2beta1::NonGuaranteedFixedPriceTerms::Representation
      
          property :seller_time_zone, as: 'sellerTimeZone'
        end
      end
      
      class DeliveryControl
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :creative_blocking_level, as: 'creativeBlockingLevel'
          property :delivery_rate_type, as: 'deliveryRateType'
          collection :frequency_caps, as: 'frequencyCaps', class: Google::Apis::Adexchangebuyer2V2beta1::FrequencyCap, decorator: Google::Apis::Adexchangebuyer2V2beta1::FrequencyCap::Representation
      
        end
      end
      
      class Disapproval
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :details, as: 'details'
          property :reason, as: 'reason'
        end
      end
      
      class Empty
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
        end
      end
      
      class FilterSet
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :absolute_date_range, as: 'absoluteDateRange', class: Google::Apis::Adexchangebuyer2V2beta1::AbsoluteDateRange, decorator: Google::Apis::Adexchangebuyer2V2beta1::AbsoluteDateRange::Representation
      
          collection :breakdown_dimensions, as: 'breakdownDimensions'
          property :creative_id, as: 'creativeId'
          property :deal_id, :numeric_string => true, as: 'dealId'
          property :environment, as: 'environment'
          collection :formats, as: 'formats'
          property :name, as: 'name'
          collection :platforms, as: 'platforms'
          collection :publisher_identifiers, as: 'publisherIdentifiers'
          property :realtime_time_range, as: 'realtimeTimeRange', class: Google::Apis::Adexchangebuyer2V2beta1::RealtimeTimeRange, decorator: Google::Apis::Adexchangebuyer2V2beta1::RealtimeTimeRange::Representation
      
          property :relative_date_range, as: 'relativeDateRange', class: Google::Apis::Adexchangebuyer2V2beta1::RelativeDateRange, decorator: Google::Apis::Adexchangebuyer2V2beta1::RelativeDateRange::Representation
      
          collection :seller_network_ids, as: 'sellerNetworkIds'
          property :time_series_granularity, as: 'timeSeriesGranularity'
        end
      end
      
      class FilteredBidCreativeRow
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :bid_count, as: 'bidCount', class: Google::Apis::Adexchangebuyer2V2beta1::MetricValue, decorator: Google::Apis::Adexchangebuyer2V2beta1::MetricValue::Representation
      
          property :creative_id, as: 'creativeId'
          property :row_dimensions, as: 'rowDimensions', class: Google::Apis::Adexchangebuyer2V2beta1::RowDimensions, decorator: Google::Apis::Adexchangebuyer2V2beta1::RowDimensions::Representation
      
        end
      end
      
      class FilteredBidDetailRow
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :bid_count, as: 'bidCount', class: Google::Apis::Adexchangebuyer2V2beta1::MetricValue, decorator: Google::Apis::Adexchangebuyer2V2beta1::MetricValue::Representation
      
          property :detail_id, as: 'detailId'
          property :row_dimensions, as: 'rowDimensions', class: Google::Apis::Adexchangebuyer2V2beta1::RowDimensions, decorator: Google::Apis::Adexchangebuyer2V2beta1::RowDimensions::Representation
      
        end
      end
      
      class FirstPartyMobileApplicationTargeting
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :excluded_app_ids, as: 'excludedAppIds'
          collection :targeted_app_ids, as: 'targetedAppIds'
        end
      end
      
      class FrequencyCap
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :max_impressions, as: 'maxImpressions'
          property :num_time_units, as: 'numTimeUnits'
          property :time_unit_type, as: 'timeUnitType'
        end
      end
      
      class GuaranteedFixedPriceTerms
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :fixed_prices, as: 'fixedPrices', class: Google::Apis::Adexchangebuyer2V2beta1::PricePerBuyer, decorator: Google::Apis::Adexchangebuyer2V2beta1::PricePerBuyer::Representation
      
          property :guaranteed_impressions, :numeric_string => true, as: 'guaranteedImpressions'
          property :guaranteed_looks, :numeric_string => true, as: 'guaranteedLooks'
          property :minimum_daily_looks, :numeric_string => true, as: 'minimumDailyLooks'
        end
      end
      
      class HtmlContent
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :height, as: 'height'
          property :snippet, as: 'snippet'
          property :width, as: 'width'
        end
      end
      
      class Image
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :height, as: 'height'
          property :url, as: 'url'
          property :width, as: 'width'
        end
      end
      
      class ImpressionMetricsRow
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :available_impressions, as: 'availableImpressions', class: Google::Apis::Adexchangebuyer2V2beta1::MetricValue, decorator: Google::Apis::Adexchangebuyer2V2beta1::MetricValue::Representation
      
          property :bid_requests, as: 'bidRequests', class: Google::Apis::Adexchangebuyer2V2beta1::MetricValue, decorator: Google::Apis::Adexchangebuyer2V2beta1::MetricValue::Representation
      
          property :inventory_matches, as: 'inventoryMatches', class: Google::Apis::Adexchangebuyer2V2beta1::MetricValue, decorator: Google::Apis::Adexchangebuyer2V2beta1::MetricValue::Representation
      
          property :responses_with_bids, as: 'responsesWithBids', class: Google::Apis::Adexchangebuyer2V2beta1::MetricValue, decorator: Google::Apis::Adexchangebuyer2V2beta1::MetricValue::Representation
      
          property :row_dimensions, as: 'rowDimensions', class: Google::Apis::Adexchangebuyer2V2beta1::RowDimensions, decorator: Google::Apis::Adexchangebuyer2V2beta1::RowDimensions::Representation
      
          property :successful_responses, as: 'successfulResponses', class: Google::Apis::Adexchangebuyer2V2beta1::MetricValue, decorator: Google::Apis::Adexchangebuyer2V2beta1::MetricValue::Representation
      
        end
      end
      
      class InventorySizeTargeting
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :excluded_inventory_sizes, as: 'excludedInventorySizes', class: Google::Apis::Adexchangebuyer2V2beta1::AdSize, decorator: Google::Apis::Adexchangebuyer2V2beta1::AdSize::Representation
      
          collection :targeted_inventory_sizes, as: 'targetedInventorySizes', class: Google::Apis::Adexchangebuyer2V2beta1::AdSize, decorator: Google::Apis::Adexchangebuyer2V2beta1::AdSize::Representation
      
        end
      end
      
      class ListBidMetricsResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :bid_metrics_rows, as: 'bidMetricsRows', class: Google::Apis::Adexchangebuyer2V2beta1::BidMetricsRow, decorator: Google::Apis::Adexchangebuyer2V2beta1::BidMetricsRow::Representation
      
          property :next_page_token, as: 'nextPageToken'
        end
      end
      
      class ListBidResponseErrorsResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :callout_status_rows, as: 'calloutStatusRows', class: Google::Apis::Adexchangebuyer2V2beta1::CalloutStatusRow, decorator: Google::Apis::Adexchangebuyer2V2beta1::CalloutStatusRow::Representation
      
          property :next_page_token, as: 'nextPageToken'
        end
      end
      
      class ListBidResponsesWithoutBidsResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :bid_response_without_bids_status_rows, as: 'bidResponseWithoutBidsStatusRows', class: Google::Apis::Adexchangebuyer2V2beta1::BidResponseWithoutBidsStatusRow, decorator: Google::Apis::Adexchangebuyer2V2beta1::BidResponseWithoutBidsStatusRow::Representation
      
          property :next_page_token, as: 'nextPageToken'
        end
      end
      
      class ListClientUserInvitationsResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :invitations, as: 'invitations', class: Google::Apis::Adexchangebuyer2V2beta1::ClientUserInvitation, decorator: Google::Apis::Adexchangebuyer2V2beta1::ClientUserInvitation::Representation
      
          property :next_page_token, as: 'nextPageToken'
        end
      end
      
      class ListClientUsersResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :next_page_token, as: 'nextPageToken'
          collection :users, as: 'users', class: Google::Apis::Adexchangebuyer2V2beta1::ClientUser, decorator: Google::Apis::Adexchangebuyer2V2beta1::ClientUser::Representation
      
        end
      end
      
      class ListClientsResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :clients, as: 'clients', class: Google::Apis::Adexchangebuyer2V2beta1::Client, decorator: Google::Apis::Adexchangebuyer2V2beta1::Client::Representation
      
          property :next_page_token, as: 'nextPageToken'
        end
      end
      
      class ListCreativeStatusBreakdownByCreativeResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :filtered_bid_creative_rows, as: 'filteredBidCreativeRows', class: Google::Apis::Adexchangebuyer2V2beta1::FilteredBidCreativeRow, decorator: Google::Apis::Adexchangebuyer2V2beta1::FilteredBidCreativeRow::Representation
      
          property :next_page_token, as: 'nextPageToken'
        end
      end
      
      class ListCreativeStatusBreakdownByDetailResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :detail_type, as: 'detailType'
          collection :filtered_bid_detail_rows, as: 'filteredBidDetailRows', class: Google::Apis::Adexchangebuyer2V2beta1::FilteredBidDetailRow, decorator: Google::Apis::Adexchangebuyer2V2beta1::FilteredBidDetailRow::Representation
      
          property :next_page_token, as: 'nextPageToken'
        end
      end
      
      class ListCreativesResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :creatives, as: 'creatives', class: Google::Apis::Adexchangebuyer2V2beta1::Creative, decorator: Google::Apis::Adexchangebuyer2V2beta1::Creative::Representation
      
          property :next_page_token, as: 'nextPageToken'
        end
      end
      
      class ListDealAssociationsResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :associations, as: 'associations', class: Google::Apis::Adexchangebuyer2V2beta1::CreativeDealAssociation, decorator: Google::Apis::Adexchangebuyer2V2beta1::CreativeDealAssociation::Representation
      
          property :next_page_token, as: 'nextPageToken'
        end
      end
      
      class ListFilterSetsResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :filter_sets, as: 'filterSets', class: Google::Apis::Adexchangebuyer2V2beta1::FilterSet, decorator: Google::Apis::Adexchangebuyer2V2beta1::FilterSet::Representation
      
          property :next_page_token, as: 'nextPageToken'
        end
      end
      
      class ListFilteredBidRequestsResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :callout_status_rows, as: 'calloutStatusRows', class: Google::Apis::Adexchangebuyer2V2beta1::CalloutStatusRow, decorator: Google::Apis::Adexchangebuyer2V2beta1::CalloutStatusRow::Representation
      
          property :next_page_token, as: 'nextPageToken'
        end
      end
      
      class ListFilteredBidsResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :creative_status_rows, as: 'creativeStatusRows', class: Google::Apis::Adexchangebuyer2V2beta1::CreativeStatusRow, decorator: Google::Apis::Adexchangebuyer2V2beta1::CreativeStatusRow::Representation
      
          property :next_page_token, as: 'nextPageToken'
        end
      end
      
      class ListImpressionMetricsResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :impression_metrics_rows, as: 'impressionMetricsRows', class: Google::Apis::Adexchangebuyer2V2beta1::ImpressionMetricsRow, decorator: Google::Apis::Adexchangebuyer2V2beta1::ImpressionMetricsRow::Representation
      
          property :next_page_token, as: 'nextPageToken'
        end
      end
      
      class ListLosingBidsResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :creative_status_rows, as: 'creativeStatusRows', class: Google::Apis::Adexchangebuyer2V2beta1::CreativeStatusRow, decorator: Google::Apis::Adexchangebuyer2V2beta1::CreativeStatusRow::Representation
      
          property :next_page_token, as: 'nextPageToken'
        end
      end
      
      class ListNonBillableWinningBidsResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :next_page_token, as: 'nextPageToken'
          collection :non_billable_winning_bid_status_rows, as: 'nonBillableWinningBidStatusRows', class: Google::Apis::Adexchangebuyer2V2beta1::NonBillableWinningBidStatusRow, decorator: Google::Apis::Adexchangebuyer2V2beta1::NonBillableWinningBidStatusRow::Representation
      
        end
      end
      
      class ListProductsResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :next_page_token, as: 'nextPageToken'
          collection :products, as: 'products', class: Google::Apis::Adexchangebuyer2V2beta1::Product, decorator: Google::Apis::Adexchangebuyer2V2beta1::Product::Representation
      
        end
      end
      
      class ListProposalsResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :next_page_token, as: 'nextPageToken'
          collection :proposals, as: 'proposals', class: Google::Apis::Adexchangebuyer2V2beta1::Proposal, decorator: Google::Apis::Adexchangebuyer2V2beta1::Proposal::Representation
      
        end
      end
      
      class ListPublisherProfilesResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :next_page_token, as: 'nextPageToken'
          collection :publisher_profiles, as: 'publisherProfiles', class: Google::Apis::Adexchangebuyer2V2beta1::PublisherProfile, decorator: Google::Apis::Adexchangebuyer2V2beta1::PublisherProfile::Representation
      
        end
      end
      
      class LocationContext
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :geo_criteria_ids, as: 'geoCriteriaIds'
        end
      end
      
      class MarketplaceTargeting
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :geo_targeting, as: 'geoTargeting', class: Google::Apis::Adexchangebuyer2V2beta1::CriteriaTargeting, decorator: Google::Apis::Adexchangebuyer2V2beta1::CriteriaTargeting::Representation
      
          property :inventory_size_targeting, as: 'inventorySizeTargeting', class: Google::Apis::Adexchangebuyer2V2beta1::InventorySizeTargeting, decorator: Google::Apis::Adexchangebuyer2V2beta1::InventorySizeTargeting::Representation
      
          property :placement_targeting, as: 'placementTargeting', class: Google::Apis::Adexchangebuyer2V2beta1::PlacementTargeting, decorator: Google::Apis::Adexchangebuyer2V2beta1::PlacementTargeting::Representation
      
          property :technology_targeting, as: 'technologyTargeting', class: Google::Apis::Adexchangebuyer2V2beta1::TechnologyTargeting, decorator: Google::Apis::Adexchangebuyer2V2beta1::TechnologyTargeting::Representation
      
          property :video_targeting, as: 'videoTargeting', class: Google::Apis::Adexchangebuyer2V2beta1::VideoTargeting, decorator: Google::Apis::Adexchangebuyer2V2beta1::VideoTargeting::Representation
      
        end
      end
      
      class MetricValue
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :value, :numeric_string => true, as: 'value'
          property :variance, :numeric_string => true, as: 'variance'
        end
      end
      
      class MobileApplicationTargeting
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :first_party_targeting, as: 'firstPartyTargeting', class: Google::Apis::Adexchangebuyer2V2beta1::FirstPartyMobileApplicationTargeting, decorator: Google::Apis::Adexchangebuyer2V2beta1::FirstPartyMobileApplicationTargeting::Representation
      
        end
      end
      
      class Money
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :currency_code, as: 'currencyCode'
          property :nanos, as: 'nanos'
          property :units, :numeric_string => true, as: 'units'
        end
      end
      
      class NativeContent
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :advertiser_name, as: 'advertiserName'
          property :app_icon, as: 'appIcon', class: Google::Apis::Adexchangebuyer2V2beta1::Image, decorator: Google::Apis::Adexchangebuyer2V2beta1::Image::Representation
      
          property :body, as: 'body'
          property :call_to_action, as: 'callToAction'
          property :click_link_url, as: 'clickLinkUrl'
          property :click_tracking_url, as: 'clickTrackingUrl'
          property :headline, as: 'headline'
          property :image, as: 'image', class: Google::Apis::Adexchangebuyer2V2beta1::Image, decorator: Google::Apis::Adexchangebuyer2V2beta1::Image::Representation
      
          property :logo, as: 'logo', class: Google::Apis::Adexchangebuyer2V2beta1::Image, decorator: Google::Apis::Adexchangebuyer2V2beta1::Image::Representation
      
          property :price_display_text, as: 'priceDisplayText'
          property :star_rating, as: 'starRating'
          property :store_url, as: 'storeUrl'
          property :video_url, as: 'videoUrl'
        end
      end
      
      class NonBillableWinningBidStatusRow
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :bid_count, as: 'bidCount', class: Google::Apis::Adexchangebuyer2V2beta1::MetricValue, decorator: Google::Apis::Adexchangebuyer2V2beta1::MetricValue::Representation
      
          property :row_dimensions, as: 'rowDimensions', class: Google::Apis::Adexchangebuyer2V2beta1::RowDimensions, decorator: Google::Apis::Adexchangebuyer2V2beta1::RowDimensions::Representation
      
          property :status, as: 'status'
        end
      end
      
      class NonGuaranteedAuctionTerms
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :auto_optimize_private_auction, as: 'autoOptimizePrivateAuction'
          collection :reserve_prices_per_buyer, as: 'reservePricesPerBuyer', class: Google::Apis::Adexchangebuyer2V2beta1::PricePerBuyer, decorator: Google::Apis::Adexchangebuyer2V2beta1::PricePerBuyer::Representation
      
        end
      end
      
      class NonGuaranteedFixedPriceTerms
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :fixed_prices, as: 'fixedPrices', class: Google::Apis::Adexchangebuyer2V2beta1::PricePerBuyer, decorator: Google::Apis::Adexchangebuyer2V2beta1::PricePerBuyer::Representation
      
        end
      end
      
      class Note
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :create_time, as: 'createTime'
          property :creator_role, as: 'creatorRole'
          property :note, as: 'note'
          property :note_id, as: 'noteId'
          property :proposal_revision, :numeric_string => true, as: 'proposalRevision'
        end
      end
      
      class OperatingSystemTargeting
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :operating_system_criteria, as: 'operatingSystemCriteria', class: Google::Apis::Adexchangebuyer2V2beta1::CriteriaTargeting, decorator: Google::Apis::Adexchangebuyer2V2beta1::CriteriaTargeting::Representation
      
          property :operating_system_version_criteria, as: 'operatingSystemVersionCriteria', class: Google::Apis::Adexchangebuyer2V2beta1::CriteriaTargeting, decorator: Google::Apis::Adexchangebuyer2V2beta1::CriteriaTargeting::Representation
      
        end
      end
      
      class PauseProposalRequest
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :reason, as: 'reason'
        end
      end
      
      class PlacementTargeting
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :mobile_application_targeting, as: 'mobileApplicationTargeting', class: Google::Apis::Adexchangebuyer2V2beta1::MobileApplicationTargeting, decorator: Google::Apis::Adexchangebuyer2V2beta1::MobileApplicationTargeting::Representation
      
          property :url_targeting, as: 'urlTargeting', class: Google::Apis::Adexchangebuyer2V2beta1::UrlTargeting, decorator: Google::Apis::Adexchangebuyer2V2beta1::UrlTargeting::Representation
      
        end
      end
      
      class PlatformContext
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :platforms, as: 'platforms'
        end
      end
      
      class Price
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :amount, as: 'amount', class: Google::Apis::Adexchangebuyer2V2beta1::Money, decorator: Google::Apis::Adexchangebuyer2V2beta1::Money::Representation
      
          property :pricing_type, as: 'pricingType'
        end
      end
      
      class PricePerBuyer
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :advertiser_ids, as: 'advertiserIds'
          property :buyer, as: 'buyer', class: Google::Apis::Adexchangebuyer2V2beta1::Buyer, decorator: Google::Apis::Adexchangebuyer2V2beta1::Buyer::Representation
      
          property :price, as: 'price', class: Google::Apis::Adexchangebuyer2V2beta1::Price, decorator: Google::Apis::Adexchangebuyer2V2beta1::Price::Representation
      
        end
      end
      
      class PrivateData
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :reference_id, as: 'referenceId'
        end
      end
      
      class Product
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :available_end_time, as: 'availableEndTime'
          property :available_start_time, as: 'availableStartTime'
          property :create_time, as: 'createTime'
          collection :creator_contacts, as: 'creatorContacts', class: Google::Apis::Adexchangebuyer2V2beta1::ContactInformation, decorator: Google::Apis::Adexchangebuyer2V2beta1::ContactInformation::Representation
      
          property :display_name, as: 'displayName'
          property :has_creator_signed_off, as: 'hasCreatorSignedOff'
          property :product_id, as: 'productId'
          property :product_revision, :numeric_string => true, as: 'productRevision'
          property :publisher_profile_id, as: 'publisherProfileId'
          property :seller, as: 'seller', class: Google::Apis::Adexchangebuyer2V2beta1::Seller, decorator: Google::Apis::Adexchangebuyer2V2beta1::Seller::Representation
      
          property :syndication_product, as: 'syndicationProduct'
          collection :targeting_criterion, as: 'targetingCriterion', class: Google::Apis::Adexchangebuyer2V2beta1::TargetingCriteria, decorator: Google::Apis::Adexchangebuyer2V2beta1::TargetingCriteria::Representation
      
          property :terms, as: 'terms', class: Google::Apis::Adexchangebuyer2V2beta1::DealTerms, decorator: Google::Apis::Adexchangebuyer2V2beta1::DealTerms::Representation
      
          property :update_time, as: 'updateTime'
          property :web_property_code, as: 'webPropertyCode'
        end
      end
      
      class Proposal
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :billed_buyer, as: 'billedBuyer', class: Google::Apis::Adexchangebuyer2V2beta1::Buyer, decorator: Google::Apis::Adexchangebuyer2V2beta1::Buyer::Representation
      
          property :buyer, as: 'buyer', class: Google::Apis::Adexchangebuyer2V2beta1::Buyer, decorator: Google::Apis::Adexchangebuyer2V2beta1::Buyer::Representation
      
          collection :buyer_contacts, as: 'buyerContacts', class: Google::Apis::Adexchangebuyer2V2beta1::ContactInformation, decorator: Google::Apis::Adexchangebuyer2V2beta1::ContactInformation::Representation
      
          property :buyer_private_data, as: 'buyerPrivateData', class: Google::Apis::Adexchangebuyer2V2beta1::PrivateData, decorator: Google::Apis::Adexchangebuyer2V2beta1::PrivateData::Representation
      
          collection :deals, as: 'deals', class: Google::Apis::Adexchangebuyer2V2beta1::Deal, decorator: Google::Apis::Adexchangebuyer2V2beta1::Deal::Representation
      
          property :display_name, as: 'displayName'
          property :is_renegotiating, as: 'isRenegotiating'
          property :is_setup_complete, as: 'isSetupComplete'
          property :last_updater_or_commentor_role, as: 'lastUpdaterOrCommentorRole'
          collection :notes, as: 'notes', class: Google::Apis::Adexchangebuyer2V2beta1::Note, decorator: Google::Apis::Adexchangebuyer2V2beta1::Note::Representation
      
          property :originator_role, as: 'originatorRole'
          property :private_auction_id, as: 'privateAuctionId'
          property :proposal_id, as: 'proposalId'
          property :proposal_revision, :numeric_string => true, as: 'proposalRevision'
          property :proposal_state, as: 'proposalState'
          property :seller, as: 'seller', class: Google::Apis::Adexchangebuyer2V2beta1::Seller, decorator: Google::Apis::Adexchangebuyer2V2beta1::Seller::Representation
      
          collection :seller_contacts, as: 'sellerContacts', class: Google::Apis::Adexchangebuyer2V2beta1::ContactInformation, decorator: Google::Apis::Adexchangebuyer2V2beta1::ContactInformation::Representation
      
          property :update_time, as: 'updateTime'
        end
      end
      
      class PublisherProfile
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :audience_description, as: 'audienceDescription'
          property :buyer_pitch_statement, as: 'buyerPitchStatement'
          property :direct_deals_contact, as: 'directDealsContact'
          property :display_name, as: 'displayName'
          collection :domains, as: 'domains'
          property :google_plus_url, as: 'googlePlusUrl'
          property :logo_url, as: 'logoUrl'
          property :media_kit_url, as: 'mediaKitUrl'
          property :overview, as: 'overview'
          property :programmatic_deals_contact, as: 'programmaticDealsContact'
          property :publisher_profile_id, as: 'publisherProfileId'
          property :rate_card_info_url, as: 'rateCardInfoUrl'
          property :sample_page_url, as: 'samplePageUrl'
          property :seller, as: 'seller', class: Google::Apis::Adexchangebuyer2V2beta1::Seller, decorator: Google::Apis::Adexchangebuyer2V2beta1::Seller::Representation
      
          collection :top_headlines, as: 'topHeadlines'
        end
      end
      
      class RealtimeTimeRange
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :start_timestamp, as: 'startTimestamp'
        end
      end
      
      class RelativeDateRange
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :duration_days, as: 'durationDays'
          property :offset_days, as: 'offsetDays'
        end
      end
      
      class RemoveDealAssociationRequest
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :association, as: 'association', class: Google::Apis::Adexchangebuyer2V2beta1::CreativeDealAssociation, decorator: Google::Apis::Adexchangebuyer2V2beta1::CreativeDealAssociation::Representation
      
        end
      end
      
      class ResumeProposalRequest
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
        end
      end
      
      class RowDimensions
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :publisher_identifier, as: 'publisherIdentifier'
          property :time_interval, as: 'timeInterval', class: Google::Apis::Adexchangebuyer2V2beta1::TimeInterval, decorator: Google::Apis::Adexchangebuyer2V2beta1::TimeInterval::Representation
      
        end
      end
      
      class SecurityContext
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :securities, as: 'securities'
        end
      end
      
      class Seller
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :account_id, as: 'accountId'
          property :sub_account_id, as: 'subAccountId'
        end
      end
      
      class ServingContext
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :all, as: 'all'
          property :app_type, as: 'appType', class: Google::Apis::Adexchangebuyer2V2beta1::AppContext, decorator: Google::Apis::Adexchangebuyer2V2beta1::AppContext::Representation
      
          property :auction_type, as: 'auctionType', class: Google::Apis::Adexchangebuyer2V2beta1::AuctionContext, decorator: Google::Apis::Adexchangebuyer2V2beta1::AuctionContext::Representation
      
          property :location, as: 'location', class: Google::Apis::Adexchangebuyer2V2beta1::LocationContext, decorator: Google::Apis::Adexchangebuyer2V2beta1::LocationContext::Representation
      
          property :platform, as: 'platform', class: Google::Apis::Adexchangebuyer2V2beta1::PlatformContext, decorator: Google::Apis::Adexchangebuyer2V2beta1::PlatformContext::Representation
      
          property :security_type, as: 'securityType', class: Google::Apis::Adexchangebuyer2V2beta1::SecurityContext, decorator: Google::Apis::Adexchangebuyer2V2beta1::SecurityContext::Representation
      
        end
      end
      
      class ServingRestriction
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :contexts, as: 'contexts', class: Google::Apis::Adexchangebuyer2V2beta1::ServingContext, decorator: Google::Apis::Adexchangebuyer2V2beta1::ServingContext::Representation
      
          property :disapproval, as: 'disapproval', class: Google::Apis::Adexchangebuyer2V2beta1::Disapproval, decorator: Google::Apis::Adexchangebuyer2V2beta1::Disapproval::Representation
      
          collection :disapproval_reasons, as: 'disapprovalReasons', class: Google::Apis::Adexchangebuyer2V2beta1::Disapproval, decorator: Google::Apis::Adexchangebuyer2V2beta1::Disapproval::Representation
      
          property :status, as: 'status'
        end
      end
      
      class Size
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :height, as: 'height'
          property :width, as: 'width'
        end
      end
      
      class StopWatchingCreativeRequest
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
        end
      end
      
      class TargetingCriteria
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :exclusions, as: 'exclusions', class: Google::Apis::Adexchangebuyer2V2beta1::TargetingValue, decorator: Google::Apis::Adexchangebuyer2V2beta1::TargetingValue::Representation
      
          collection :inclusions, as: 'inclusions', class: Google::Apis::Adexchangebuyer2V2beta1::TargetingValue, decorator: Google::Apis::Adexchangebuyer2V2beta1::TargetingValue::Representation
      
          property :key, as: 'key'
        end
      end
      
      class TargetingValue
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :creative_size_value, as: 'creativeSizeValue', class: Google::Apis::Adexchangebuyer2V2beta1::CreativeSize, decorator: Google::Apis::Adexchangebuyer2V2beta1::CreativeSize::Representation
      
          property :day_part_targeting_value, as: 'dayPartTargetingValue', class: Google::Apis::Adexchangebuyer2V2beta1::DayPartTargeting, decorator: Google::Apis::Adexchangebuyer2V2beta1::DayPartTargeting::Representation
      
          property :long_value, :numeric_string => true, as: 'longValue'
          property :string_value, as: 'stringValue'
        end
      end
      
      class TechnologyTargeting
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :device_capability_targeting, as: 'deviceCapabilityTargeting', class: Google::Apis::Adexchangebuyer2V2beta1::CriteriaTargeting, decorator: Google::Apis::Adexchangebuyer2V2beta1::CriteriaTargeting::Representation
      
          property :device_category_targeting, as: 'deviceCategoryTargeting', class: Google::Apis::Adexchangebuyer2V2beta1::CriteriaTargeting, decorator: Google::Apis::Adexchangebuyer2V2beta1::CriteriaTargeting::Representation
      
          property :operating_system_targeting, as: 'operatingSystemTargeting', class: Google::Apis::Adexchangebuyer2V2beta1::OperatingSystemTargeting, decorator: Google::Apis::Adexchangebuyer2V2beta1::OperatingSystemTargeting::Representation
      
        end
      end
      
      class TimeInterval
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :end_time, as: 'endTime'
          property :start_time, as: 'startTime'
        end
      end
      
      class TimeOfDay
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :hours, as: 'hours'
          property :minutes, as: 'minutes'
          property :nanos, as: 'nanos'
          property :seconds, as: 'seconds'
        end
      end
      
      class UrlTargeting
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :excluded_urls, as: 'excludedUrls'
          collection :targeted_urls, as: 'targetedUrls'
        end
      end
      
      class VideoContent
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :video_url, as: 'videoUrl'
          property :video_vast_xml, as: 'videoVastXml'
        end
      end
      
      class VideoTargeting
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :excluded_position_types, as: 'excludedPositionTypes'
          collection :targeted_position_types, as: 'targetedPositionTypes'
        end
      end
      
      class WatchCreativeRequest
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :topic, as: 'topic'
        end
      end
    end
  end
end
