A yield expression was used outside of the coroutine literal.

Erroneous code example:

```compile_fail,E0627
#![feature(coroutines, coroutine_trait, stmt_expr_attributes)]

fn fake_coroutine() -> &'static str {
    yield 1;
    return "foo"
}

fn main() {
    let mut coroutine = fake_coroutine;
}
```

The error occurs because keyword `yield` can only be used inside the coroutine
literal. This can be fixed by constructing the coroutine correctly.

```
#![feature(coroutines, coroutine_trait, stmt_expr_attributes)]

fn main() {
    let mut coroutine = #[coroutine] || {
        yield 1;
        return "foo"
    };
}
```
