# rand_core

[![Test Status](https://github.com/rust-random/rand/actions/workflows/test.yml/badge.svg?event=push)](https://github.com/rust-random/rand/actions)
[![Latest version](https://img.shields.io/crates/v/rand_core.svg)](https://crates.io/crates/rand_core)
[![Book](https://img.shields.io/badge/book-master-yellow.svg)](https://rust-random.github.io/book/)
[![API](https://img.shields.io/badge/api-master-yellow.svg)](https://rust-random.github.io/rand/rand_core)
[![API](https://docs.rs/rand_core/badge.svg)](https://docs.rs/rand_core)

Core traits and error types of the [rand] library, plus tools for implementing
RNGs.

This crate is intended for use when implementing the core trait, `RngCore`; it
defines the core traits to be implemented as well as several small functions to
aid in their implementation and types required for error handling.

The main [rand] crate re-exports most items defined in this crate, along with
tools to convert the integer samples generated by `RngCore` to many different
applications (including sampling from restricted ranges, conversion to floating
point, list permutations and secure initialisation of RNGs). Most users should
prefer to use the main [rand] crate.

Links:

-   [API documentation (master)](https://rust-random.github.io/rand/rand_core)
-   [API documentation (docs.rs)](https://docs.rs/rand_core)
-   [Changelog](https://github.com/rust-random/rand/blob/master/rand_core/CHANGELOG.md)

[rand]: https://crates.io/crates/rand


## Functionality

The `rand_core` crate provides:

-   base random number generator traits
-   error-reporting types
-   functionality to aid implementation of RNGs

The traits and error types are also available via `rand`.

## Versions

The current version is:
```
rand_core = "=0.9.0-beta.1"
```


# License

`rand_core` is distributed under the terms of both the MIT license and the
Apache License (Version 2.0).

See [LICENSE-APACHE](LICENSE-APACHE) and [LICENSE-MIT](LICENSE-MIT), and
[COPYRIGHT](COPYRIGHT) for details.
