# Summary

[Introduction](README.md)

# User Guide

- [Installation and running](guide/installation.md)

- [Asciio's interface](Interface.md)

- [Unicode support](unicode_support.md)

- [Accessing documentation](accessing_documentation.md)

- [UIs](UIs.md)
	- [GUI](UI/GUI.md)
	- [TUI](UI/TUI.md)

- [Stencils](stencils.md)
	- [Asciio boxes and text](stencils/asciio_boxes.md)
		- [Asciio if and process](stencils/asciio_if_and_process.md)
		- [Asciio exec-box](stencils/asciio_exec_box.md)
	- [Asciio arrows](stencils/asciio_arrows.md)
	- [Pseudo connectors](stencils/pseudo_connectors.md)
	- [Box connectors](stencils/box_connectors.md)
	- [Asciio shapes](stencils/asciio_shapes.md)
	- [verbatim objects](stencils/verbatim.md)
	- [user stencils](stencils/user.md)
	
- [Editing elements text and attributes](editing_elements.md)
	- [Markup mode](editing_elements/markup_mode.md)

- [Working efficiently](working_efficiently.md)
	- [Keyboard](editing/keyboard.md)
	- [Mouse](editing/mouse.md)
	- [Cloning](editing/cloning.md)
	- [Grouping](editing/grouping.md)
	- [Strip groups](editing/strip-groups.md)

- [Export/Save](exporting.md)
	- [Asciio format](export/asciio.md)
	- [text](export/text.md)
	- [SVG](export/svg.md)
	- [Clipboard](export/clipboard.md)

- [Modes](modes.md)
	- [Git](modes/git.md)
	- [Cross](modes/cross.md)
	- [Slides](modes/slides.md)

- [Examples](examples.md)
	- [Class hierarchy](examples/example1.md)
	- [German railway](examples/example2.md)
	- [Unicode Example](examples/unicode_example.md)
	- [Videos](videos/videos.md)

## Bindings

- [Bindings](Bindings.md)
	- [Mouse](bindings/mouse.md)
	- [Why vim-like bindings](bindings/vim-like.md)
	
	- [Single key](bindings/single_key.md)
		- [GUI bindings](bindings/gui.md)
		- [Moving elements](bindings/moving.md)
		- [Selecting elements](bindings/selecting.md)
		- [Resizing elements](bindings/resizing.md)
		- [Clipboard](bindings/clipboard.md)
	
	- [Multiple key](bindings/multiple_keys.md)
		- [«:» Command group:](bindings/commands.md)
		- [«i» Insert group](bindings/inserting.md)
		- [«a» Arrow group](bindings/arrows.md)
		- [«A» Align group](bindings/aligning.md)
		- [«g» Grouping group](bindings/grouping.md)
		- [«A-g» Stripes-group group](bindings/grouping_stripes.md)
		- [«z» Display group](bindings/display.md)
		- [«S» Slides group](bindings/slides.md)
		- [«D» Debug group](bindings/debug.md)

# Configuration

- [Configuration](configuration.md)
	- [user bindings](config/user_bindings.md)
		- [Binding format](config/user_bindings/binding_format.md)
		- [Group bindings](config/user_bindings/group_bindings.md)
		- [Capturing groups](config/user_bindings/capturing_groups.md)
		- [Binding override](config/user_bindings/binding_override.md)
		- [Capturing groups with overalay](config/user_bindings/capturing_groups_overlay.md)

	- [user stencils](config/user_stencils.md)

-----------

# Developer Guide

- [For Developers](for_developers/README.md)
	- [Scripting](for_developers/scripting.md)
	- [Modifying Asciio](for_developers/modify_Asciio.md)
		- [Bindings](for_developers/bindings.md)

	- [Debugging](for_developers/debugging.md)
	- [Cross algorithm](for_developers/cross_algorithm.md)
	- [Unicode support](for_developers/unicode_support.md)
	- [Overlay](for_developers/overlay.md)

-----------

[Contributors and License](misc/contributors.md)

[See Also](misc/see_also.md)

