use 5.008001;
use strict;
use warnings;

package Crypt::Diceware::Wordlist::Common;
# ABSTRACT: Crypt::Diceware wordlist from common English words
our $VERSION = '0.004'; # VERSION

our @Words = qw{
  abacus abase abbess abbey abbot abdicate abdomen abdominal abduction abed
  abet abeyance abhorrent abidance abject abjure able ablution abnegate
  abnormal abominate above abrade abrasion abridge abrogate abrupt abscess
  abscissa abscond absence absent absolute absolve absorb absorbed abstain
  abstruse absurd abundant abused abusive abut abyss academic academy accede
  acceded accedes accented accept accepted access accession accessory
  accident acclaim acclimate accompany accorded accordion accost accosts
  account accouter accredit accuracy accurate accursed accuse accusing
  accustom acerbity acetate acetic ache acid acidify ackee acme acoustic
  acquaint acquiesce acquire acquit acquittal acreage acreages acrid acrimony
  acrobat activate activist actuality actuary actuate acumen acute acutely
  adamant adaptable adapters added addendum addle addled address adduce
  adelgid adenoma adequate adhere adherence adherent adheres adhesion adieu
  adios adjacency adjacent adjudge adjunct adjutant admirals admonish ado
  adoration adorning adroit adulthood adumbrate advance advanced advancing
  advent adverse adversely adversity advert advisable adviser advisory
  advocacy advocate aerial aerobics aeronaut aerostat affable affect affected
  affiliate affinity affix afflict affluence affluent affront affronts afire
  afoot aforesaid afresh aft after afterward age aggravate aggregate aggress
  aggrieve aghast agile agility agitate agitated agitprop agnostic agog
  agonal agonized agrarian ague aid ailment aim airbag airfare airfield
  airspace airwaves airy akin alabaster alacrity albeit albino album alchemy
  alcohol alcove alder alderman alert algae algebra alias alien alienable
  alienate alike aliment alkali alkaline allay allege alleged allegory
  alleviate alley alleyway alliance allies allocate allot allotment allowed
  allude allusion allusive alluvion ally almanac almost alone aloof alpha
  alphabet altar alter altercate alternate although altitude alto altruism
  altruist amalgam amass amateur amatory amazed amber ambiguous ambitious
  ambrosia ambrosial ambulance ambulate ambush amenable amended amicable
  amish amity amongst amorous amorphous amount amour ampere ampersand
  amplified amplitude amply amputate amusement anagram analog analogous
  analogy analysed analyst analyze anarchy anathema anatomy ancestry anchor
  anchored ancient ancillary anecdote anemia anemic anew angel angelic angler
  angstrom anguish angular anhydrous animal animate anime animosity anklet
  annalist annals annex annexed annotate annual annuity anode anonymous
  another answer answering ante antecede antedate antenatal anterior anteroom
  anthem anthology antic antidote antilogy antiphon antiphony antipodes
  antiquary antiquate antique antitoxin antonym anxious anymore anyplace
  anything apart apathy aperitif aperture apex aphorism apiary apogee apology
  apostasy apostate apostle appall apparatus apparel apparent appeal appealed
  appease appellate append appertain appoint apposite appraise apprehend
  apprise approved aquarium aqueduct aqueous arachnid arb arbiter arbitrary
  arbitrate arbor arboreal arboretum arbs arcade arch archaic archaism
  archangel arched archetype archival archive archrival ardent ardor arid
  arise armada armament armature armful armistice armless armor armorers
  armory armrest arnica aroma around aroused arraign arrange arrant array
  arrayed arrear arrested arrival arrogant arrogate arrowing arsenate artery
  artful artifice artistry artless aryan ascendant ascension ascent ascetic
  ascribe asexual ashamed ashen ashore asiatic askance asking asperity
  aspirant aspire assailant assassin assault assay assent assertive assess
  assessor assets assiduous assignee associate assonance assonant assonate
  assuage assume assuredly asterisk asters asthma astronaut astute asylums
  atheism athirst athwart atomize atomizer atonal atone atonement atrocious
  atrocity attache attack attacked attain attend attest auburn auction
  auctions audacious audible audition auditory audits augment augur aura
  aural auricle auricular aurora auspice austere autarchy auteur authentic
  authority autocracy autocrat automaton autonomy autopsy autumn autumnal
  auxiliary avalanche avarice aver averse aversion avert aviaries aviary
  aviator avidity avidly avocation avow await awaits awaken awakened awards
  awash awesome awful awry aww axes axioms aye azalea azure babble babe baby
  babysit back backdrop backed backstop bacterium badger badgered baffle
  baffled bag bagel baggage baggier bagpipe bailiff bairn bait baize baked
  bakeware balancing baldly bale baleful ballad ballpark balm balsa balsam
  bamboo banal band banjo banned banquet banter baptisms baptize barbarian
  barbaric barbells barbeque barcarole barefoot bargain baritone barium bark
  barley barograph barometer barrages barrel barreled barrier barring
  barstool bask basket bass basso baste bastion batch bath bather baton
  batons battalion batten batter batting bauble bawl bawled bayonet beacon
  bead beaded beads bear bearer beatify beatitude beatnik beau becalm beck
  bedaub bedding bedeck bedlam bedside beep beeper befog before befriend
  befuddle beget beginner begrudge beguine behavior beheaded behemoth behest
  beholden belate belated belay belie believe belittle belle bellicose
  bellmen bellow belly beloved below bemoan bemoaned bench benched bended
  benefice benefit bengal benign benignant benignity benison bequeath bereave
  bereaved berth beseech beset besides besmear besmirch bespeak best bestial
  bestow bestrew bestride bethink betide betimes betrayed betroth betrothal
  better between betwixt bevel beveled bewilder bias bib bibulous bidding
  bide biennial bier bigamist bigamy biggie bight bigotry bike bilateral bile
  bilingual billfish billow billows billowy binding bingeing bio biograph
  biography biology biomes biped biryani bitter biz bizarre blab blabbing
  blackbird blacked blacklist blackness blank blanket blase blaspheme blatant
  blaze blazon bleak blemish blended blight blind blinded blink blipped
  blithe blitz blizzard blockade blocker blocking blond blonde bloodbath
  bloodied bloodily bloodline bloom bloomed blouses blousy blowhole blowtorch
  blue bluebird bluish blunder blunt blurb blurring blush bluster boards
  boatload boatswain boatyard bobble boded bodice bodily bog bogus bold bole
  bolero boll bolster bolts bomb bombard bombast bombings bomblets bombs bond
  bondsman boob boobs bookcase bookend bookmark bookworm boorish boost
  booster boot bootleg bordello bordering bore borers boring borough bosom
  boss botanical botanist botanize botany bothered bottles bottling bouffant
  bounce bouncing boundary bountiful bow bowel bowing bowl bowler boxing
  boxlike boxwood boycott brace brackets brae braggart brains brainwash
  branch brandish brassy bravado bravo brawl brawls brawny bray braze
  brazenly brazier breach breadth breakaway breakdown breaker breakfast
  breath breech breed brethren brevity bribery bridge bridle brief briefers
  briers brigade brigadier brigand brighten brightly brim brimstone brine
  bristle brittle broach broaches broadcast broader brochure brogan brogans
  brogue broil broiler brokerage brome bromine bronchus bronzers brooch brook
  broom broth brow browbeat brown brownie brownish bruised brushing brushy
  brusque bubble bubonic buck bucket buckled buff buffet buffeted buffoon
  bugging bugle build bulb bulbous bulging bulk bulldoze bulled bullets
  bullock bully bulrush bulwark bum bumper bumpers bumptious bumpy bunch
  bundle bunghole bungle bungled buoyancy buoyant burden bureau burger
  burgess burgher burgundy burlap burned burnet burnish burp burping burrows
  bursar busman bussed busses bust bustards busters bustier busting bustle
  busty busybody butcher butt butte buttered buttress buy buyouts buzzes
  byline cabal cabalism cabin cabinet cabriole cacao cacophony cactus caddies
  caddis caddy cadence cadenza cadet caitiff cajole cajolery calculus calf
  calibers calipers call called caller callosity callow calorie calumny came
  cameo camera camp campaign canadian canard canary candid candor canine
  canines canister cannon canny canon canonize canopy cant cantata canteen
  canto canvases canvass capable capably capacious capillary capital capo
  capon caprice capsizes caption captious captivate captor capture carbonate
  carbos carcass card cardiac cardinal care caret cargo cargoes caring
  carload carnage carnal carnival carotene carouse carped carpentry carpet
  carpeted carried carrion carrot cartilage cartload cartoons cartridge carve
  case cased caseload casement cases cashier cashmere casings cast caste
  castigate casting casual casualty cat cataclysm catalans catalyst catalyze
  cataract cathode catlike caucus caudal causal causally cause caused caustic
  cauterize caution caviar ceaseless cede celebrate celeriac cell cellar
  cenotaph censor census censuses cent centenary centrally centurion ceramic
  cereal cessation cession chafe chaff chagrin chain chair chalk chameleon
  champagne chancery channel chanting chaos chap chapel char charge charlatan
  charmed charming charred chasm chasten chastise chastity chasuble chateau
  chattel cheating check checkered checkup cheer cheerio cheesy cherished
  chervil chicano chick chief chieftain chiffon chill chilled chinaman ching
  chinooks chip chipmunk chipped chipping chirpy chisel chiseled chit
  chivalry chives choice choke cholera choleric choral christen chromatic
  chrome chromed chub chucking chuckle chug chump chunk chunky churlish churn
  cichlids cipher circular circulate citadel cite citizen civilize claim
  claimant claimed clambers clamorous clan clang clangor clank clap clarify
  clarion clasped clasping classic classify classroom classy clavicle claw
  clay clean cleansed clear clearance cleared clearing clearly cleaving
  clemency clement clergyman clique cloak clocks clockwork clogged cloister
  clomps cloned closer closeted closure clot clothe clothed clothier clouds
  cloudy clout clove cloying cluck clucks clue clumsier clumsy coagulant
  coagulate coalition coarsely coasted coat coated coax cob cobalt cobweb
  cocci cockpit coddle code codger codicil codify codon codpiece coerce
  coercion coercive coexist coffin cogent cognate cognizant cohere coherent
  cohesion cohesive cohost coifed coincide coined coital cold coldness coleus
  coliseum collapse collate colleague collector collegian collide collie
  collier collision colloquy collusion colon colossal colossus colt coltish
  columns comatose combat combated combed combers combine combos come comedic
  comedown comely comes comical commando commies commingle committal
  commodity commotion communist commute commuting compact company competent
  complain complex complexly compliant component comport compose composed
  composer compost composts composure compound compress comprise compute
  comrades con conative conceal concealed concede conceit conceive concerted
  concerto concierge concise concord concur condense conduce conducive
  conduit confer conferee confessor confetti confidant confide confident
  confine confluent conform confound confront confuse congeal congenial
  congest conjoin conjugal conjugate conjured connect connected connector
  connive connote connubial conquer conscious conscript consensus consent
  consign consignee consignor console consoled consonant consort conspire
  constable constancy constrict consul consulate contagion contains contender
  contessa contest continual contort contrail contrary contrite contrive
  control contumacy contuse contusion convene converge convert convex
  convivial convolute convolve convoy convulse cookbook cooked cookie cookout
  cool cooled cooperate coos coped copies copious copiously copout copped
  copper coquette cordon cork corkscrew corm corn cornered cornice cornmeal
  corollary coronet corporal corporate corporeal corps corpse corpulent
  corpuscle correctly correlate corrode corroded corrosion corrosive
  corrupted corset corseted cortical cosmetic cosmetics cosmic cosmogony
  cosmology cosmonaut cosmos countess couplers courage course courser
  courtesy cousin covenant cover covered covering covert covey cowardly cower
  cowled coxswain coy cozying crabs crack cracked cracker crackers crackpot
  craft crag cramp cramped crams cranberry cranium craps crapshoot crass
  crate craving craw crawly crazy creak cream creamery creaming creamy
  creator creche credence credible credibly credits credulous creed creep
  creepy crematory crescent cretan cretin crevasse crevice cribbage cried
  criers crimp crinkly crippled crippling crisped criteria criterion critical
  critique crocheted crockery crossbar crosshair crouched croup crow crowbar
  crowd crown crucible crude crudites cruelty cruise crumb crumpled crunch
  crunchy crusade crushed crusted crusts cry crybaby cub cube cubist cudgel
  cued cueing cuff culinary cull culpable culprit cultivar culture culvert
  cupful cupid cupidity curable curator curb cured curio curiously curl
  currency currently cursive cursor cursory curt curtail curtsy curve curved
  curving custards customer cutover cutting cuttings cycled cycling cycloid
  cygnet cynic cynical cynicism cynosure cyst dabbed dabs dagger daily dales
  dali dalliance dam dame dames damned damp dance dancing daring darkling
  darkly darling darn dashboard dashed dastard date dated dating datum dauber
  daunting dauntless daylight daypack daytime daywear dazed dazedly dazzle
  dazzled dba deadened deadlock deafening deal dearest dearth debase
  debatable debated debonair debrief debut decadence decagon decagram
  decaliter decalogue decameter decamp decapod decayed deceit deceitful
  deceive decency decent deception deceptive decide decides deciding
  deciduous decimal decimate decipher decisive decker decks decorate decorous
  decoy decoys decrease decreed decrepit decrying dedicate deduce deduces
  deed deep deepen deepens deer deface defalcate defame defamed defanged
  default defaults defective defendant defensive defer deference defiant
  deficient defiled definite deflate deflates deflect deforest deform
  deformed deformity defraud defray deft degrade degraded degrading dehydrate
  deified deify deign deist deists deity deject dejected dejection delay
  delayed delete delft deli delicacy delineate delirious delirium delivery
  delude deluge delusion demagogue demeanor demented demerit demise demo
  demolish demon demotic demulcent demur demurrage dendroid denial denizen
  denote denounce dented denude denuding deodorant depicted deplete deplore
  deploy deponent deport deposed depositor depot deprave deprecate depress
  depth deputy derby derelict deride derisible derision derive derives
  derrick derriere descent descry desert deserted deserved deserving
  desiccant designate designed desirous desist desktop desolate despair
  desperado desperate despite despond despot despotism dessert destiny
  destitute desultory detach deter deterrent detest detonator detract
  detriment detrude devastate develops deviance deviate device devices
  devilry deviltry devious devise devised devolve devout devoutly dexterity
  dhows diabolic diagnose diagnosis dial dialect dialed dialogue diarist
  diarists diarrhea diatomic diatribe dichotomy diction dictum didactic
  diddling diffident diffuse diffusion dignitary digraph digress dilate
  dilates dilatory dildos dilemma diligence dill dilute dimension dimly dims
  diner dinghies dinky dint diphthong diplomacy diplomat dipping direct
  directive direst dirtied disabled disagree disallow disappear disarm
  disarmed disavow disavowal disburden disburse discard discern disciple
  disclaim disco discolor discomfit discord discover discredit discreet
  disdain disembody disengage disfavor disfigure disgrace dish dishes
  dishonest disinfect dislocate dislodge dismal dismissal dismount disobeys
  disown disowned disparage disparity dispel dispirit displace displaced
  disposed disposer disputed disputes disquiet disregard disrepute disrobe
  disrupt dissect dissemble dissent dissever dissipate dissolute dissolve
  dissonant dissuade distance distant distemper distend distill distiller
  distort distorted distrain distrust disunion diurnal diver divergent
  diverse diversion diversity divert divest divide divided divider dividing
  divinely divinity divisible divisive divisor divulge dizzy docile docket
  dockside doctor doctorate document dodo doe doer doff dogfight doggedly
  doggie dogma dogmatic dogmatize dogsled dole doled doleful dolesome dollies
  dolor dolorous doltish dolts domain domicile dominance dominant dominate
  domineer donate donator donee donkey donor doodled doomsayer door doorpost
  dormant dorsal dosas dosed dotcom dotted double doublet doubling doubly
  doubt doubted doubter doughy dove down downer downgrade downplay downpour
  downward dowry doyen doyenne doze dozens dozes drabness drachma draft
  draftees drafty dragnet dragoon dragoons drain drainage dramatist dramatize
  drape drastic dream drearily drenches dress dressing dribble drill dripping
  drive driveway driving drizzle drone droning drool droopy droplet dropoff
  drought drowsy drudgery druids drummer drunk drunks dubbed dubious duckling
  ductile dud due duel duet dun dung dunk dupe duplex duplexer duplicity
  durance duration dusky dust duster dusting duteous dutiable dutiful dwarf
  dweeb dweller dwelling dwindle dyed dynamic dynamism dyne each eagerly
  eardrum eardrums earless earlier early earn earnest earplug earthwork
  eatable eave ebb ebullient eccentric ecclesia echo echoing eclipse ecliptic
  economize ecstasy ecstatic edible edict edify editorial educate educe
  efface effect effective effectual effete efficacy efficient effluvium
  effuse effusion egghead eggnog egoism egoist egotism egotist egregious
  egress egret eighteen eject ejecting ejector ejido ekes eland elapse
  elastics elbow eld elder elegy element elevation elicit eligible eliminate
  elite elixir ellagic elm elms elocution eloquence eloquent elucidate elude
  elusion elusive emaciate emanate embalmed embargo embark embarrass embedded
  embellish embezzle emblazon emblem embody embolden embolism embrace embroil
  emerge emergence emergent emeritus emigrant emigrate eminence eminent emit
  emitter emotions empathic emperor emphasis emphasize emphatic employed
  employee employer employs emporium empower empowers empty emulate emulated
  enact enamor encamp encased enchant enclave enclosed encomium encompass
  encore encourage encroach encumber endanger endear endeavor ended endemic
  endgame endlessly ends endue endurable endurance energetic enervate
  enfeeble engender engrave engraved engross engulfed enhance enhanced enigma
  enjoin enjoy enjoyment enkindle enlighten enlist enliven enmity ennoble
  enormity enormous enrage enrapture enriched enroll enshrine ensnare
  ensnared ensue ensuing entail entangle enthrall enthrone enthuse enticing
  entirety entitled entity entrails entrap entreaty entree entrench entrust
  entry entwine enumerate enviable envious envy envying ephemera epic epicure
  epicycle epidemic epidermis epigram epilogue epiphany episode episodic
  epitaph epithet epitome epizootic epoch epode eponym equaling equality
  equalize equate equitable equity equivocal eradicate erect errant erratic
  erroneous error erstwhile erudite erudition escapes escaping escarole
  eschew espionage espy esquire essayed essence essential esteemed esthetic
  estimable estrange estrogen estuary etcetera etch etiquette eugenic
  eulogize eulogy euphemism euphony eureka evade evanesce evasion even
  evensong event eventful eventual ever evergreen evert everyone evict
  eviction evidence evil evince evincing evoke evolution evolve evolves
  examiner excavate exceed excel excellent excels excepting excerpt excess
  excitable excitedly exclude excluded exclusion excretion excursion
  excusable excuse execrable executive executor exegesis exemplar exemplary
  exemplify exempt exempted exert exhale exhaled exhaust exhume exigency
  exigent existence existing exists exit exits exodus exonerate exorcise
  exotic expand expanse expansion expansive expect expected expedient
  expedite expend expense experts expiate expired explain explicate explicit
  explode exploding exploiter explosion explosive export exposure expulsion
  extant extempore extend extension extensive extensor extenuate exterior
  external extinct extol extort extortion extradite extremist extremity
  extricate extrude exuberant exurbs eyed eyelash eyelid eyesight fabled
  fables fabricate fabulous face faceless facelift facet facetious facial
  facile facility facsimile faction factious factual faculty fading fail
  faint fairly faith fake falcon fallacy fallback fallen fallible falling
  fallow family famine famish famished famous fanatic fancier fancies
  fanciless fancy fanfare fanned fannies far farm farming fart fashion
  fastball faster fatalism fathers fathom fatties fatuous faulty faun favor
  fawn fax faxes fealty fear feasible feasted feathered feature features
  febrile fecund federate fedora feeling feels feint felicity feline fell
  fellow felon felonious felony female feminine femoral fen fenced fencing
  fend fender fernery ferns ferocious ferocity ferry fervent fervid fervor
  fessed festal festive fetches fete fetus feudal feudalism fevers fez fiasco
  fibrotic fibs fickle fiction fiddler fidelity fiducial fief fiendish
  fiercely fifth fig figure filament filberts filers filet fill filmed filmy
  filtered filth final finale finales finality finally finance financial
  financier finery finesse finger finish finisher finite fireman fireplace
  fires firm first fiscal fishbone fishery fishes fissure fisting fit fitful
  fitted fix fixes fixture fizzles fjord flag flagpole flagrant flags flame
  flamed flanker flare flared flash flasher flatboat flaunted flavor flawless
  fleck flection fledged fledgling fleece fleeting fleshing flexible flicked
  flicks flimsy flippant flirts flit floating flocked floe flogged floods
  floozie flora floral florid florist flout flowing flu fluctuate flue fluent
  fluential fluffier fluidly fluke flunk flush fluted flutist flux fly flyer
  focal focally focus foe fog foggy foible foist folds foliage folic folio
  fond fondle fondly fondness foolery foolishly foolproof footed foothill
  footless footloose footprint footrest foppery foppish foray forby forces
  forcible fore forearm forebear forebode forecast foreclose forecourt forego
  forehead foreign foreigner forejudge foreman forepeak foreplay forerun
  foresail foresee foreshore foresight forestry forests foretell foretold
  forever foreword forfeit forfend forger forgery forget forgiving forgo fork
  forkful forklift format formation former formula forsakes forswear fort
  forte forth fortify fortitude fortnight forum forwards fostered fourfold
  foursome fourth fracture fragile frail frailty frame franchise frantic frat
  fraternal fraud fraught fray frazzle freak freaking freakish freaks free
  freed freelance freely freemason freeplay freesia freezer freight frenetic
  frequency fresco freshness fret fretful fries frigging fright frighten
  frightful frigid frilled frills fringe frivolity frivolous frizz frizzle
  frizzy frontier frostbite frowzy froze frozen frugal frugally fruiting
  fruition fruity frying fueled fugacious fulcrum fulminate fulsome fume
  fumigate funds funereal fungible fungous fungus funk funkiest funnies funny
  furbish furious furled furlong furlough furnish furrier further furtive
  fusarium fuse fusible fusillade fussed futile futurist gabbling gabled
  gaffer gagged gaggle gaiety gaily gained gaining gait gala gale gallant
  gallantly galore galvanic galvanism galvanize gamble gambol game gamebird
  gamester gamine gaming gamut gardens gargle garish garland garlic garlicky
  garner garnish garrison garrote garrulous gaseous gastric gastritis gather
  gathered gaudiest gaudy gauge gauges gawk gawks gay geared geezer gemsbok
  gendarme genealogy generally generate generic genesis genetics geniality
  genital genitive genomes genteel gentile gentle gentry genuine geology
  germane germinate gestalt gestation gesture gestured getaway geyser ghastly
  gherkin ghosting ghoulish giant gibbous gibe giddy gift gigantic ginseng
  girdle girlie git give given giver giving glacial glacier gladden gladioli
  glanced glances glassware glazier gleam glen glided glimmer glimpse glints
  glioma glittery globes globose globular globules gloom gloried glorify
  glorious glory glow glut glutinous glycemic gnash goalpost goat goatee
  goats gobble godly gold golly goodbye goodie goofily gook gopher gordian
  gorge gory gosling goslings gossamer gourd gourmand gown graceless
  gradation grade graded graders gradient gradual graffiti grail granary
  grand grandeur grandiose grandmom grandpa granny grantee grantor granular
  granulate granule grape graph graphic grapple grasp grasping grassy gratify
  gratuity gravelly gravity grayed graying greasier green greenback greeter
  grenadier greying greyness gridlike grief grievance grievous grimace grind
  grins grip gripes gripped grisly grit groggy groom groomers grope groped
  grotesque grotto ground grounding group grouping grousing growls growths
  grudge grueling grumble grumbled grumbling grumpy grungy guard guardrail
  guerrilla guess guessing guidance guidebook guided guile guileless guilty
  guinea guise gullible gumbo gummed gumption gunfight gunmetal gunships
  gunshot gunshots gurney gust gusto gusty gutter guy guzzle gym gyrate
  gyrating gyre gyroscope habitable habitant habitual habitude hack hackle
  hackney hackwork haggard haggling hair hairline hairpin hairy halcyon hale
  halfback halibut hallowed hammer hammering hamming hamper hampers handbag
  handball handedly handily handling handmade handout handy handyman hang
  hanger hanker hankering haole happened harangue harass harbinger harbour
  hardening hardier hardihood hardly harm harmless harness harvest harvests
  hashed hassle hassling hastily hasty hat hatch hater hatless haunt have
  havoc haw hawker hawking hawkish hawthorn hazard hazardous haziness head
  headed headland headrest heads headship heady heal healed healthful hearken
  hearsay hearted hearten heartless heated heathen heavy hectares hedge
  hedges heedless heifer height heinie heinous heist helicity hellcat helm
  helo helpful hen henchman henpeck heptagon heptarchy her herbarium hereby
  heredity heresy heretic herewith heritage hernia heroic herstory hesitancy
  hesitant hetero heterodox hexagon hexapod heyday hiatus hibernal hickory
  hideaway hideous hie high higher hightail hiker hilarious hillbilly hillock
  hillside hinder hindmost hindrance hint hints hippest hirsute his
  hissy history hitherto hive hmong hoard hoarse hobbit hobnob hock hockey
  hog holdover hole hollowed hollowly homage home homed homely homemade
  homemaker homespun homework homily homonym homophone homos honoree
  honorific hood hoodwink hook hooks hoot hopeless hopscotch horde hornless
  horny horribly hosed hosiery hosing hospice host hostility hot hotline
  howitzer huckster huddled huff huffed hum human humane humanize humbling
  humbug humiliate humming hummocks humorless humping hunch hunger hungry
  hunk hunks hunt hunts hurdle hurdler hurt hurting hurtle husband hussar
  hustle hustled hustlers hybrid hydra hydraulic hydride hydrous hygiene
  hygienist hyphal hypnosis hypnotic hypnotism hypnotize hypocrisy hypocrite
  hysteria icebox icecream iceman ichthyic icily iciness icon icy ideal
  idealize identify idiom idolize idylls ignoble ignore ignored iguana ill
  illegal illegible illiberal illicit illiquid illness illogical illumine
  illusion illusive illusory image imaginary imagine imago imbalance imbibe
  imbroglio imbrue imitation imitator immature immense immensity immerse
  immersion immigrant immigrate imminence imminent immodest immoral immovable
  immune immutable impact impair impaired impale impaling impartial impassive
  impatient impede impedes impel impend imperil imperiled imperious impetuous
  impetus impiety impinges impious impliable implicate implicit implode
  implore imply impolite impolitic important importune imposed impotent
  imprints impromptu improper improved improvise imprudent impudence impugn
  impulse impulsion impulsive impunity impure impurity impute inability
  inactive inane inanimate inapt inaudible inboard inborn inbred incentive
  inception inceptive incessant inchmeal inchoate incidence incident
  incipient incise incisor incite inciting include included incorrect
  increment indelible indepth index indians indicant indicator indict
  indigence indigent indignant indignity indolence indolent indoors induct
  induction indulgent inebriate inedible ineffable inept inequity inert
  inertia infamous infamy infancy infected inference inferior infernal infest
  infidel infinite infinity infirm infirmary infirmity inflamed inflects
  influence influx informant infringe infuse infusion ingenious ingenuity
  ingenuous ingraft ingrate inhabited inherence inherent inhibit inhuman
  inhume inimical iniquity initial initiate inject injustice inkling inky
  inland inlay inlet inmost innards innocuous innovate innuendo inquire
  inquiry inroad inroads inscribe insecure insertion inside insidious insight
  insinuate insipid insistent insolence insolent insomnia insomniac inspect
  inspector inspiring instance instant instigate instill insular insulate
  insult insulted insure insured insurgent intake integrity intellect
  intensely intension intensive intention interact intercede intercept
  interdict interface interim interior interlude intermit intermix interplay
  interpose interpret interrupt intersect interval intervale intervene
  interview intestacy intestate intestine intimacy intrepid intricacy
  intricate intrigue intrinsic intromit introvert intrude intrusion intrusive
  intubate intuition inundate inure invades invalid invasion invective
  inveigh inventive inverse inversion invert investing investor invidious
  invitee invoke involve inward inwardly ionized iota ipods irascible irate
  ire irk irksome ironclad ironed ironing irony irradiate irrigant irrigate
  irritable irritancy irritant irritate irruption isle islet isobar isolate
  isolated issuers issuing italic itch itches itemized itinerant itinerary
  itinerate jab jacked jail jailing jangle jar jargon jarring jaundice
  jauntily jawed jazz jazzy jealousy jeans jelly jested jewel jibe jiffy
  jiggle jiggles jigs jilted jingled jingoism jinx jockey jocks jocose
  jocular jogger joggle join joining joins joke jolly jostle jot joust
  jousting jovial juche judgment judicial judiciary judicious juggle jugglery
  jugular juice juicy juke jumble jumbled jump jumpsuit junction juncture
  junior juniper junker junket junky junta juntas juridical juristic juror
  jutting juvenile juxtapose kales kaput karate karma keen keeps keepsake
  kerchief kernel kerygma keystone khaki khakis kibbles kickball killing kiln
  kiloliter kilometer kilowatt kilted kimono kind kingling kingship kinking
  kinks kinsfolk kinsman kirtle kissed kitty knavery knead kneecaps kneejerk
  knife knight knitting knocked knot knotty knower knowingly knowledge
  knuckled kumbaya labeled labelled labial laborious labyrinth lace lacerate
  lack lactation lacteal lactic laddie ladle ladybugs laggard lags laid lake
  lambast lame lance landform landlord landmark landscape languid languor lap
  lapdog lapel lapse larder larders lark lash lashed lassie lassies lately
  latency latent later lateral latish lattice laud laudable laudation
  laudatory laughably laundress laureate lave lavish law lawfully lawgiver
  lawmaker lawsuit lax laxative lay laydown layman laze laziness lazy lea
  leadeth leaflet leafy leak leaked leaker leakers leaky leapers least leaven
  leaver lebanese leech leeward leftism legacy legalize legalized legally
  legging legible legionary legislate legume leisure lend lenders leniency
  lenient lens leonine leopard leprosy less lessen lest lethargy lettered
  leukemia levee lever leverage leviathan levity levy lewd lexicon liable
  liaisons libel liberal liberate librarian library licensed licit lick
  licorice liege lien lies lieu lifeless lifelike lifelong lifes lifetime
  ligament ligature light lightbulb lighter ligneous lik like likely liken
  likened likewise liking lilt liminal limousine limp limply limpness limps
  linear liner lingered lingo lingua lingual linguist liniment linseed lip
  liquefy liqueur liquidate liquor listed listen listened listless lite
  literacy literal literally literary lithe lithesome lithotype litigant
  litigate litigious litter littoral liturgy live liven livened liver livid
  loaf loam loamy loans loath loathe lobotomy local localized located
  locative loch loci lockers lockouts locks lode lodge lodgepole lodgers
  lodgment lofty logger logic logical logically logician loiterer lollipop
  long longer longevity longingly longitude looked loosely loosen loot
  lopping lordling lore losing loss lot lotus lough lounge lounges louse
  lousy lout louts lovable lovably loveable lovelorn loving lower lowly
  loyalist loyally loyalty lubricate lucid lucrative ludicrous lug lugged
  lukewarm lull lumber luminary luminous lunacy lunar lunatic lunch lune
  lupine lupines lurid lurking luscious lustful lustrous luxuriant luxuriate
  luxury lye lying lynch lyre lyres lyric ma'am machinery machinist mackerel
  macrocosm madden maestro magenta magic magical magician maglev magnate
  magnet magnetize magnitude maharaja mailbox mailing main mainline maintain
  maize makeshift makeup malady malaria malawian malay malign malignant
  malleable mallet malt malted maltreat mambo mammoth managed mandarin
  mandate mandated mandatory mane maneuver manger mangled mangos mangy
  manhole manhunt mania maniac manifest manifesto manlike manliness manna
  manned mannerism manor mans mantel mantle manumit map mappings marble
  marbled march marchers marijuana marinade marine maritime marked markers
  markings marksman marmalade maroon married marry martial martian martinis
  martyrdom marvel marxism mascara masked masonry massacre massage masses
  masseurs massive mastery mastiffs mastoid matched material maternal
  maternity matinee matricide matrimony matrix matter mature maudlin
  mausoleum maverick mawkish maxim maximize may maze mead meager meagerly
  mean meander meanies means measured measures mechanics medallion meddling
  medial mediate medicate medicine medieval mediocre meditate medium medley
  meek melded meliorate mellow melodious melodrama melted memento memorable
  men menace menagerie mend mendicant menfolk mental mentality mentally
  menthol mention mentor mentored mercenary merciful merciless mere merge
  merited mesmerize messed messieurs messing mestizo metal metaphor mete
  metonymy metric metronome mettle micro microchip microcosm middleman midges
  midlife midline midpoint midriff midriffs midsole midsummer midwife mien
  might mignon migrant migrate migration migratory mikes mil mileage miles
  milieu militant militate militia milk milking milky millet milling
  millionth mime mimic mimics minaret minces mind mindless mined mineral
  mingle miniature minimize minion ministry minivans minority minuet minus
  minute minutia mirage misbehave miscount miscreant misdeed miser miserly
  misfire misfit mishap mishmash mislaid mislay mismanage misnomer misogamy
  misogyny misplace misplaced misrule missal missile missive mistily mistrust
  misty misuse mite miter mitigate mixed mixture mnemonics moat mobocracy
  moccasin mocha mock mockery model moderate moderator modernity modernize
  modify modish modulate moduli moistly molar molecule molehill mollify molt
  momentary momentous momentum monarch monarchy monastery monetary monger
  mongrel monied monition monitory monks monocracy monogamy monogram
  monograph monolith monologue monomania monopoly monotone monotony monsieur
  monsoon monster mood moonbeam moonlit moored mooring mop moral morale
  moralist morality moralize moray morbid mordant more moreover morgue
  moribund mormon morn morning morose morph morsel mortar mortician mortise
  mosaic moslems motley motor motorcar motorist motto mound mounted mounting
  mourn mournful mouser mouth mouthed mouthful mouton move movement mower
  muddle muddled muffle muffler mug mulatto muleteer mull mullah multiform
  multiplex multiply mundane municipal murres muscle music musicale musically
  muskie mussels mustache muster mutagens mutation mute muted mutilate
  mutilated mutiny muzzling myriad mystic mystical myth mythology nabbed
  naked nameless namibian naming nanny nap naphtha narcos narrate narration
  narrative narrator narrow narrowed narrowly nasal nascent natal national
  native natty naturally naught naughty nausea nauseate nauseous nautical
  naval nave navel navies navigable navigate nay nearing nearside neaten
  neatnik nebula necessary necessity neck necklace necktie necrology necropsy
  necrosis nectar nectarine needed needy nefarious negate negation negligee
  negligent neighbor neocracy neology neophyte nerdy nestle nestled nestling
  nests net netball nettle network neural neurology neuter neutered neutral
  newborn newcomer news newsman newsstand next nexus nicety nicked nigerian
  niggardly nightmare nihilist nil nimble nine nit nitrate nitride nobody
  nocked nocturnal noise noiseless noisome noisy nomad nomads nomic nominal
  nominate nominee nonentity nonfarm nonmember nonpareil nonsense nonstop
  noon noose nope norm normalcy normally norse northern nosegay nostalgia
  nostalgic nostrum not notch notched nothing notion notorious novelty novice
  nowadays nowhere noxious nuance nub nubbly nubians nucleon nucleus nude
  nudge nudity nugatory nuggets nuisance nuking numeracy numerical numerous
  nunnery nuptial nurse nurture nurtured nutriment nutritive nuttier oaken
  oaks oakum oar obdurate obeisance obelisk obese obesity obey obituary
  objection objective objector obligate oblique oblivion oblong obnoxious
  obsequies observant obsolete obstinacy obstruct obtrude obtrusive obtuse
  obvert obviate occasion occlude occult occupant occupied occur oceanic
  ochre octagon octave octavo octet ocular oculist oddballs oddity ode odious
  odium odorants odorous oeuvre off offed offended offensive offhand
  officiate officious offload offshoot offsides ogre oil oiled ointment okapi
  okay oke oldie oldies olfactory omega omelette omen omicron ominous
  omission once oncology onerous ongoing onion online onrush onset onslaught
  onstage onus ooze opals opaque open opened openness operant operate
  operative operator operetta opinion opinions opium opponent opportune
  opposing opposite oppress optic optician optics optimism optimist option
  optometry opulence opulent oracular oral orange orate oration orator
  oratorio oratory orb orbiting ordains ordeal order ordinal ordinary
  ordnance ore orgies origin original originate ornate ornately orphanage
  orthodox orthodoxy oscillate osculate osmosis osprey ossify ostracism
  ostracize ostrich other others otter ought oust out outback outbreak
  outburst outcast outcome outcry outdo outdoor outfit outfox outlast
  outlasts outlaw outlawed outlay outlive outpaced outpost outrage outraged
  outreach outride outrigger outright outset outside outskirt outstrip
  outward outweigh oval ovary over overcome overdo overdose overeat overhang
  overhead overjoyed overlap overleap overload overlook overlord overpass
  overpay overpower overreach overrun oversee overseer oversold overtax
  overthrow overtime overtone overtook overture overview owner pacify package
  packet pact padding paddle pagan pageant paid pain painfully painting pair
  palate palatial palest palette palinode pall pallet palliate pallid palm
  palpable palsy paly pamper pamphlet panacea pandemic panegyric panel pangs
  panic panicky panoply panoptic panorama pantheism pantomime papacy papists
  papyri papyrus par parable parabolic parachute paradise paradox paragon
  parallel paralysis paralyze paramount paramour paranoid parasite parched
  pardons pare parentage parenting pares parfaits parietal parish parisian
  parities parity parlance parlay parley parlor parody paroxysm parricide
  parrot parry parse parsing part partible partisan partition parts pass
  passible passing passive past pastoral pat patched patent paternal
  paternity pathos patiently patina patriarch patrician patrimony patriot
  patriots patronize patter patting paucity pauper pauperism pave pavilion
  pawn pawned pawnshop payable payee peaceable peaceful pearl pec peccable
  peccant pectoral pecuniary pedagogue pedagogy pedal pedant peddle peddler
  pedestal pedigree peek peeks peels peep peer peerage peerless peeve peeved
  peeves peevish peg pegboard pelagic pellagra pellucid penalty penance
  penchant pendant pendants pending pendulous pendulum penetrate penitence
  penitent pennant penned pension pentad pentagon pentagram penthouse
  penurious penury peopled per perceive percolate perennial perfidy perforate
  perform perfumery perhaps perigee perineal perjure perjury permanent
  permeate permit peroxide perp persevere persist personage personal
  personify personnel perspire persuade pertinent perturb perusal pervade
  pervasion pervasive perverse pervert pervious pesky pestilent peter petrify
  petty petulance petulant pewter pharmacy phase philander philately
  philology phonemic phonetic phonic phonogram phonology phony physicist
  physics physique pianists pianos piazzas picayune piccolo picked picket
  picky piddling piece piecemeal pier piercing piety pig pigeon pile pillage
  pillaged pillar pillbox pillory pillowy pilot pimp pimped pin pincers
  pinchers pine pinecone pinheads pinions pinker pinnacle pinochle pinot
  pinstripe pinup pioneer pious pipa pipe pipefish piping pique piracy
  piranha piss pissing piste pistils pistol piston pitch pitchers pitching
  piteous pith pitiable pitiful pitifully pitiless pitot pittance pivoting
  pizza pizzas placate placid plagued plait plan plant platitude plaudit
  plausible playback playful playfully playing plea plead pleasant pleasing
  pleated plebeian pled pledgee pledgeor plenary plenitude plenteous plenty
  plethora pleura pliant plight plod plot plotted plover plowman pluck plug
  plumb plumber plume plumed plummet plump plunder plunger plunked plural
  plurality plusses plutonium pneumatic poacher pocked pocketed poesy poet
  poetaster poetic poetics poignancy poignant point poise poison poisoned
  poke polar polarity polemics police policy polish polished politic politics
  polled pollen pollute polluter polyarchy polycracy polygamy polyglot
  polygon pommel pomposity pompous poncho ponder ponderous ponds pontiff
  pontiffs pontoon poof pooled pooping poorly populace popularly populist
  populous pored porous port portable portend portent portfolio portion pose
  posit position positive posse posses possess possessor possible possibly
  postdate poster posterior postwar potassium potency potent potentate
  potential potholed potion potted pounding powder powdered powerless
  practiced praising prancing prate prattle pray preacher preachy preamble
  precede precedent precipice precise precision preclude precursor precut
  predatory predicate predict preempt preempts preengage preexist preface
  prefatory prefect prefer prefers prefix prejudice prelacy prelate prelude
  premature premier premise premium premiums prenatal preoccupy preordain
  prepaid presage presages preschool prescient prescript preserve presided
  pretend pretender pretest pretext pretty pretzel prevalent preview prey
  prickle pride prided priests priggish prim prima primate prime primer
  primeval primitive primrose principal principle print printer priory prisms
  pristine private privateer privilege privity privy prized prizing pro
  proactive probate probation probe probes probity procedure proceed proceeds
  processed proclaim proctor prodigal prodigy producer producing profane
  professor proffer profile profiteer profs profuse progeny program project
  projector prolific prolix prologue prolong prolonged prom promenade
  prominent promise promised promoter prompting promptly prone proofread
  propagate propane propel propeller property prophecy prophesy proposed
  proposes propound propriety prorated prosaic proscribe proselyte prosody
  prospect prostrate protean protect protector protege protester protocol
  prototype protract protrude proven proverb provident provider proviso
  provokes prow prowess prowl proxy prudence prudery prudish pruned prurient
  pseudo pseudonym psychic psychotic psychs puberty pudgy puerile puffs
  puissant pullback pulley pulling pulmonary pumas punches punctual puncture
  punctured pungency pungent punish punished punishing punitive punt pupa
  pupilage purchase purchased purebred purgatory puritan purity purl purloin
  purport purpose purrs pursued pursuer purveyor push pushcart pushers puzzle
  puzzles pyre pyromania pyx quackery quad quadrant quadrate quadruple quaint
  quainter quaintly qualify qualm quandary quant quantity quarrel quarter
  quarterly quartet quarto quartz quay queerest quelled queried querulous
  query question queue quibble quick quickly quiescent quiet quietism quietly
  quietus quills quintet quirk quit quite quixotic quoted rabbis rabid
  raccoons racist racy radiance radiate radical radiology radix raffle raft
  rage ragged raging raid raillery rainy raise rake raked ram rambler
  ramified ramify ramose rampaging rampant rampart ramparts rancor range rank
  ranked rankest rankle rankled ranks rap rapacious rapid rapine rapper
  rappers rapt raptorial rapturous rarebit rasa rash rasping raspy rat rated
  rather ratified ration rational rationed ratted rattles ratty raucous
  raunchy ravage ravaged ravenous raves ravine raving ravish raw reachable
  reactant reaction readable readily readjust ready realism realist realize
  realizes realm realtime realtor reamer reaper rear rearmed rearrange
  reasoned reassign reassure reawaken rebelled rebounds rebuff rebuffs
  rebuild rebuilt rebuke rebut rec recant recapture recast recede receding
  receive recent receptive recessive reck reckless reckons reclaim recline
  recluse reclusive reclusory recognize recoil recollect recording recouped
  recourse recover recreant recreate recruit rectify rectitude recur recure
  recurrent recused redder redeploy redesign redolence redolent redound
  redress reducible redundant reef refer referable referee refereed reference
  referrer refigure refinery reflected reflector reform reformer refract
  refrains refresh refusal refused refute refutes regal regale regalia
  regality regent regicide regime regimen regiment regnant regress regretful
  regularly rehabbed rehash rehearse reign reimburse rein reindeer reinstate
  reiterate reject rejected rejection rejoin relapse relapses relaxed relay
  relaying released relegate relent relevant reliable reliance reliant relies
  relieved reliquary relish reload reluctant remanded remarry remedy remiss
  remission remodel remotely renames render rendition renege renewal renovate
  renovated rent rents reopening repaint repair repairman reparable repartee
  repeal repel repellent repertory repine replace replay replenish replete
  replica replied reply report reports reposed reprehend repress repressed
  reprieve reprimand reprisal reprise reprobate reprocess reproduce reproof
  reptilian repudiate repugnant repulse repulsed repulsive repute request
  requested requiem requisite requital requite rerun resale rescind research
  reseat resent reserved reservoir reset resettle residue residuum resilient
  resistant resistive resolved resonance resonate resource respect respects
  respite rested restored rests resulted resupply resurgent retained retake
  retaliate retarded retch retched retells retention retest retests reticence
  reticent retinue retiring retitle retort retouch retrace retraces retract
  retrench retrieve retro return reunion reunite revealed reveler revelry
  revenant revenue revere reverend reverent reverse reversed reversion revert
  reverted review reviewer revile revisal revise revive revived revoke
  revoked revolting revolved revulsion rewarm rework rezoned rhapsodic
  rhapsody rhetoric rhinitis rhyme ribald ribbed ricochet riddance ridge
  ridicule riding rife riff riffing rig rightful rights rigidity rigmarole
  rigor rigorous rilles ringworm rip ripeness ripping ripple ripplet riser
  risible rituals ritzy rivalry riverbed rivets rivulet roadblock roast robe
  robot robust robusta rockers rodeo rogue roll roller rolloff rollouts
  romanced rondo rookery roommate rooms roosted root rope ropes rose rosemary
  rotary rotate rote rotten rotting rotund roughy round roundel rounding
  roundup roused rout routed routs rowdy royal royally rubato rubber rubric
  ruching ruckus rue ruffian ruffle ruffled rugby ruled ruminant ruminate
  rumor runaway runny runs rupee rupture rural rushed rust rustic rusts rusty
  rut ruth ruthless rutting saber sabre sac sack sacred sacrifice sacrilege
  sad saddle safari safaris safeguard safest sagacious sage sahelian sailor
  sainted salable salacious salami salary salience salient saline saltine
  salutary salvage salve salvo salvos same sameness sanction sanctity sand
  sandwich sane sanguine sap sapid sapience sapient saps sarcasm sardonic
  sari saris sartorial sashay sashays satiate satire satiric satirize
  saturate satyr sauce savage savaged savagely save savior savor savour saxon
  say scabbard scabs scalawag scale scaled scamming scams scapegoat scarcely
  scarcity scarfed scarier scarily scarred scat scenery scented schemed
  scholarly school schooled schooling schools science scimitar scintilla
  scoffed scofflaw scolded scone scoop scooting scope scoped scorching score
  scorer scoring scorn scorned scottish scoundrel scourged scouted scouting
  scowls scraggly screamer screeds screened screw scribble scribe scrim
  scrimp scrimped scrip script scrod scrubbed scrunch scruple scrutiny scum
  scuttle scuttled scythe seal sealed seance seaport seaports sear search
  season seasonal seatings seaweeds sebaceous secant secede seceded secession
  seclude seclusion secondary secondly secrecy secretary secrete secretive
  sect section secure sedate sedentary sediment sedition seditious seduce
  sedulous seeking seer seethe segment seignior seize seized selective
  selfish seller semblance seminar seminary senator senile senility seniority
  sensation sense sensible sensitive sensorium sensual sensuous sentence
  sentience sentient sentinel separable separate sepulcher sequel sequence
  sequent sequester serapes serenade sergeant serial seriously servant
  service servitude set setup sever severance severely severity sewing sexist
  sextet sextuple shabbily shade shades shading shaggy shaken shakeout shaker
  shakes shaky shallot shambles shame shanks shape shapely sharing sharpener
  sheaf sheath sheer shelf shell shellfish shelling shelter sherbet shift
  shiftless shimmied shimmy shin shingled ship shipwreck shirked shocking
  shod shoehorn shoot shootout shored shoreline short shortage shortly
  shotgun shoulder shove show showcase shower showman showpiece showtime
  shred shrewd shrewdly shriek shrink shrinkage shrivel shrubbery shrug
  shrugs shrunken shucks shuffle shutdown shutouts shutters shylock shyness
  sibilance sibilant sibilate sibling sick sickle sickness sickos sickout
  sidelong sidereal sidling siege sieges sieving sift sifted sighed sight
  sightseer signup silence silenced silkworm sill silly silos silt similar
  simile simple simplify simulate sinecure sinewy sinful sinfully singe
  singeing single sinister sinuosity sinuous sinus sir siren sirocco sit site
  situate sixteen sixteenth sixth size sizzled skald skate skater skeleton
  skeptic sketch skew skewed skewness skiff skim skimmed skirmish sky skycap
  skyways slack slain slash slashed slave slayer sleaze sleazy sledge sleeps
  sleighs sleight slew slews slider slight slimmed slimy sling slippage
  slipped slipping slob slobby slosh slothful slovaks slow sluggard slugger
  slugging slum slunk slurped slurred slut sly smacks small smartly smash
  smashed smeared smell smelting smock smoke smuggled smugly snack snacked
  snags snapped snarl snatch sneak sneeze snide snipe snippet snob snook
  snooze snorer snorts snowbank snowman snowmen snowy snuggle soaked soap
  soapy sobbed soberly sobriquet sociable socialism socialist socials
  sociology sodas sodomize software soil solace solar solder soldier soldiers
  sole solecism solemnly solicitor solidity soliloquy solitary solstice
  soluble solvable solvent somatic somber somebody somnolent sonata sonic
  sonnet sonorous soot soothes sop sophism sophistry soprano sorbet sorcery
  sordid sought soulmate sound sounds sourwood southern souvenir sow space
  spaceship spacing spacious spackle spade spake span spangled spank spar
  spark sparkly sparring sparse spasm spasmodic spatula spatulas spawn spawns
  spear special specialty specie species specific specify specimen specious
  speckled spectator specter spectres spectrum speculate speedily speeds
  spending spheroid spiced spiffy spigots spike spin spinous spinster
  spiraled spires spitball splashy splotch splurge sponsor spook spooling
  spoons sporting spot spotty sprayers spraying sprightly sprinkle sprint
  sprinted sprinter spry spume spurious spurned sputter spy squabble squadron
  squalid squalled squander squared squash squashed squatter squeaks squeezed
  squirm squish squishes staccato stack stacking staff stages stagger
  stagnant stagnate stagy staid stain stainless stair stairwell stalled
  stallion stamina stampede stance stanchion standoff standout stands stanza
  star starch stark starker starkly starless starring stars starter starters
  stash stashes stat static statics statuette stature statute stayers staying
  steadies steal stealth steam steamy steeled steep steeple steeples steer
  steering stellar stem stencil steppe stepwise sterling sternum steroids
  stew stick sticking stiff stifle stifled stigma stiletto still stilts
  stimulant stimulate stimulus stinging stingy stipend stir stirs stitched
  stock stockpile stodgy stoicism stolid stomped stoners stoop stop stopped
  store storyline stout straddle strain strait strand stranded stratagem
  stratum straw stray streamlet stressed stretch strewn stricken striders
  stringent stripe striped stripling strobe stud studded studious stultify
  stumble stumbling stunners stupidest stupidly stupor styling suasion suave
  subacid subjacent subjugate submarine submerge submittal subside subsidize
  subsist subsumes subtend subtests subtle subvert succeed success successor
  succinct succulent succumb suction sudden sue suffrage suffuse suffused
  sugar suits sulfate sulfurous sulkily sultan summary summation summed
  summited sumptuous sunbeam sunburst sunflower suns sunset sunsets sunshine
  sunward super superadd superb superheat supersede supervise supine supplant
  supple supply supposed supposing suppress supremo surcharge sureness surety
  surf surface surfeit surly surmise surmount surplus surprise surrender
  surrogate surround surveyor survives suspect suspects suspense sutra suture
  swab swale swallowed swamped swarm swarmed swarthy swat swath swathe
  swathed swatting swayed swearing sweat sweeping sweeps sweets swell swelled
  swelter swerving swigs swimsuit swindle swindler swinging swipe swipes
  swirled swirling switching swivel swoop swooped sword swore sycamore
  sycophant syllabic syllable syllabus sylph symbolic symmetry symphonic
  symphony symposium synagogue syndicate syndrome syneresis synergy synod
  synonym synopsis syrupy table tableau tableaus tabloid taboo tacit taciturn
  tack tacked tackle taco tact tactful tactician tactics taffeta tahini tail
  tailspin take talcum talk talking tallest tally talmudic tamarind tamely
  tan tandem tangency tangent tangible tango tankful tanned tanners tannery
  tantalize tape tapes tapestry taping taquitos tardiness target tarnish
  tarry tart tartlets tater tattler tattoos taupe taut tax taxation taxi
  taxicab taxidermy tea teachable teacher teal tearful tearooms tears teary
  tease teaser teasingly technic technique tedium tee teem teemed teenage
  tees teetering telco telecast telegraph telemetry telepathy telephony
  telescope teletype televise telltale temblors temerity temp temple temples
  temporal temporary temporize tempt tempter temptress tenacious tenant
  tendency tender tendril tenet tenfold tennis tenor tense tensest tensions
  tentative tenting tenure termagant terminal terminate terminus terms
  terrapin terribly terrier terrify terse testament testator tested testify
  tethers teutonic thanks thaw thaws thearchy theater theirs theism then
  thence theocracy theocrasy theology theorist theorize therefor therefore
  thereupon thermal thesis they thicket thievery thigh thin think third
  thirsty thirtieth thomism thong thorn though thousand thrall thread threes
  threshed threw thrilled throb throes throne through throw thrums thrush
  thrusting thump thumped thusly thwarted thy thyroids tibias tic tick tickle
  tidying tight tightness tile tills tilted tilth timbre timeline timeout
  timorous tincture tinge tinkle tintype tipoff tipsy tirade tired tireless
  tiresome titled toddies toenail togas toggle toggling toil toilsome token
  tolerable tolerance tolerant tolerate tolling tomb tome tonic too tool toot
  toothless tootling top topics toponyms topping tops topsail torch tornados
  torpedo torpor torrid torso tortious tortuous tortured torturous toss
  tosser totaled touchy toughed toured touring touristy tousled towel towels
  towering townie toy toys trace traces trachoma tracking tractable trail
  trait trammel tramp tramped trance tranquil transact transcend transfer
  transfix transfuse transient translate transmit transmute transpire
  trashing trattoria travail traveling travesty trawl treachery treatise
  treble trebly tremor tremulous trenchant trendier trestle triad triads
  tribal tribe tribesman tribunal tribune trick trickery trickle tricolor
  tricycle trident triennial trim trimness trinity trio triple tripled tripod
  tripped trippy trisect trite triumvir trivial trombone trophies trots
  trotted troubling troupe trouper trove trowel truckload truculent truism
  trumpet truncated trundle trussed trusted trusting trusty truthful trying
  trypsin tuba tubing tuesdays tug tumble tunafish tune tuned tuneup tunisian
  turbans turbos turgid turkey turn turnabout turning turpitude tushes tussle
  tussles tutee tutelage tutelar tutorship tutsi twice twiddle twine twinge
  twirl twisting twitch twoyear tycoon typed typhus typical typified typify
  tyranny tyro ugh ugly ulterior ultimate ultimatum umbrage unable unanimity
  unanimous unbalance unbeaten unbelief unbiased unbind unblock unbounded
  unbridled uncannily uncanny uncared unclaimed uncle uncommon uncork
  uncrowded unction unctuous uncut undeceive underlie underling underman
  undermine underpaid underrate undersell undertake undertow undimmed
  undivided undo undone undue undulate undulous uneasy unfairly unfolding
  ungainly unglued ungodly unguent unharmed unhelpful unholy unhook unhooked
  unibody unify uninjured uninvited unique unison unisonant unite united
  univocal unkept unknown unlawful unlearned unlimited unnamed unnatural
  unnoticed unopposed unpeeled unplugged unpopular unproved unravel unripe
  unroofed unsay unseat unsettle unshod unsound unstuck untaxed untenable
  untended until untilled untimely untoward untreated unvaried unvarying
  unveil unveiled unwieldy unwise unyoke upbraid upcast updated upends
  upheaval upheave uplifted uploads upmarket upon upped upper uppermost
  upright uprising uproar uproot upsetting upstage upstart upstate uptick
  uptown upturn upwardly urban urbanity urchin urge urgency urgent usage used
  useful usual usurers usurious usurp usurped usury utensil utility utmost
  utter utterly vacate vaccinate vacillate vacuous vacuum vagabond vaginal
  vagrant vain vainglory valance vale valet valiant valid validate valleys
  valorous value vampire vane vanities vapid vaporizer variable variance
  variant variates variation variegate vassal vastly vastness vaulting veal
  vectors veered veering vegetal vegetate vehement veil velar veldt velocity
  velvety venal vendible vendition vendor veneer venerable venerate venereal
  vengeance vengeful venial venison venom venous ventilate veracious veracity
  veranda verbatim verbiage verbose verdant verify verily verity vermin
  vernal versatile version vertex vertical vertigo verve very vespers vessels
  vested vestige vestiges vesting vestment vet veto viability vibe vicarious
  viceroy victim videotape vie views vigilance vigilant vigilante vignette
  vilify vincible vindicate vinery vining viol viola violate violated
  violation violator viper virago virile virtu virtual virtue virtuoso
  virulence virulent visage viscera viscose viscount vision visit vista
  visual visualize vital vitality vitalize vitally vitiate vitiated vivacity
  vivify vocable vocal vocalist vocative vodka vogue voice voiceless void
  voiding voids volant volar volatile volition volitive voluble vomit vomited
  vomiting vomits voracious vortex votary voter votive vouchsafe vow voyager
  vulgarity wacko wad wadded wading wads wage waif waistcoat waistline waiter
  waiting waive wake waked walkable walker walkers walking walled wallop
  wallow waltz wampum wane waned wanes wangled wannabe wanted wanting ward
  warden warehouse warhead warheads warily wariness warlike warmed
  warning warp warpath warrior wary wash washtub waste wasteful watchful
  waterline wavelet waxy way weakens weakest weakling weal wean wear wearied
  wearisome webcams website wed wee weedy weekly weepers weigh weirdest
  weirdly welcome well welt west westward whatnot wheel wheeze whereupon
  wherever wherewith whet while whiled whimper whimsical whine whip whipping
  whippy whirr whirred whistle white whittle whiz whodunit wholly whomever
  whoop whoops whooshes wide widening widowed widower wield wielders
  wiggle wiggly wild wildcard wile wilful willowy wills wimp winced
  windage windswept wingman winsome winter wintry wipeout wiper wires wiretap
  wiry wise wisecrack wiseguy wishful withered within witless witling
  witticism wittiest wittingly wizen womanly wondered wonders wondrous
  woodland woodshed woolly woozy wordplay worklife workspace wormed worried
  worrying worthy would wouldst wound wrack wrangle wrap wrapped wreak wreath
  wrest wrestle wrestler wretch wriggle wrinkle writhe writing wrong wry yank
  yard yardage yards yarn yarns yaw yearend yearling yearning yeast yell
  yelling yellowing yells yen yielded yielding yin yogurts yoke yon you your
  yowled yowling yum zealot zeitgeist zenith zephyr zephyrs zero ziggurat
  zigs zings zionists zip zipped zodiac zooming
};

1;


# vim: ts=2 sts=2 sw=2 et:

__END__

=pod

=encoding UTF-8

=head1 NAME

Crypt::Diceware::Wordlist::Common - Crypt::Diceware wordlist from common English words

=head1 VERSION

version 0.004

=head1 SYNOPSIS

  use Crypt::Diceware 'words'; # Common is the default
  use Crypt::Diceware words => { wordlist => 'Common' };

  my @phrase = words(4);

=head1 DESCRIPTION

A Diceware word list based on common English words.  Compared to the Original
and Beale wordlists, this list has some longer words, but no nonsense words
("fs", "ga", "rrrr") or symbol words ("%%", "!!"), so everything on this list
should be familiar to a reasonable well-read English speaker and straightforward
to memorize.

The words were assembled from various free or sample lists of the most
common English words available at
L<freevocabulary.com|http://www.freevocabulary.com> and
L<wordfrequency.info|http://www.wordfrequency.info>.  It is heavily weighted
towards the first five thousand or so common words, sprinkled with additional
words taken from samples of the 100,000 most common words.

All words are between three and nine letters.  Some common profanity words have
been removed.  All words are lower case.  Any trademarked or offensive
words remaining are an oversight.

It has about 100 more words than a standard Diceware wordlist, which doesn't
change the passphrase strength in any meaningful way.

=for Pod::Coverage method_names_here

=head1 SEE ALSO

=over 4

=item *

L<Crypt::Diceware>

=back

=head1 AUTHOR

David Golden <dagolden@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2013 by David Golden.

This is free software, licensed under:

  The Apache License, Version 2.0, January 2004

=cut
